/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.collect;

import com.google.monitoring.runtime.instrumentation.common.annotations.GwtCompatible;
import com.google.monitoring.runtime.instrumentation.common.annotations.GwtIncompatible;
import com.google.monitoring.runtime.instrumentation.common.collect.AbstractMapBasedMultiset;
import com.google.monitoring.runtime.instrumentation.common.collect.Iterables;
import com.google.monitoring.runtime.instrumentation.common.collect.Multisets;
import com.google.monitoring.runtime.instrumentation.common.collect.ObjectCountHashMap;

@GwtCompatible(serializable=true, emulated=true)
public class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return HashMultiset.create(3);
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    HashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    void init(int distinctElements) {
        this.backingMap = new ObjectCountHashMap(distinctElements);
    }
}

