/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.flow;

import org.jacoco.core.internal.flow.ClassProbesVisitor;
import org.jacoco.core.internal.flow.IProbeIdGenerator;
import org.jacoco.core.internal.flow.LabelFlowAnalyzer;
import org.jacoco.core.internal.flow.MethodProbesAdapter;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.jacoco.core.internal.flow.MethodSanitizer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AnalyzerAdapter;
import org.objectweb.asm.tree.MethodNode;

public class ClassProbesAdapter
extends ClassVisitor
implements IProbeIdGenerator {
    private static final MethodProbesVisitor EMPTY_METHOD_PROBES_VISITOR = new MethodProbesVisitor(){};
    private final ClassProbesVisitor cv;
    private final boolean trackFrames;
    private int counter = 0;
    private String name;

    public ClassProbesAdapter(ClassProbesVisitor cv, boolean trackFrames) {
        super(589824, (ClassVisitor)cv);
        this.cv = cv;
        this.trackFrames = trackFrames;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodProbesVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        final MethodProbesVisitor methodProbes = mv == null ? EMPTY_METHOD_PROBES_VISITOR : mv;
        return new MethodSanitizer(null, access, name, desc, signature, exceptions){

            public void visitEnd() {
                super.visitEnd();
                LabelFlowAnalyzer.markLabels((MethodNode)this);
                MethodProbesAdapter probesAdapter = new MethodProbesAdapter(methodProbes, ClassProbesAdapter.this);
                if (ClassProbesAdapter.this.trackFrames) {
                    AnalyzerAdapter analyzer = new AnalyzerAdapter(ClassProbesAdapter.this.name, this.access, this.name, this.desc, (MethodVisitor)probesAdapter);
                    probesAdapter.setAnalyzer(analyzer);
                    methodProbes.accept((MethodNode)this, (MethodVisitor)analyzer);
                } else {
                    methodProbes.accept((MethodNode)this, probesAdapter);
                }
            }
        };
    }

    public void visitEnd() {
        this.cv.visitTotalProbeCount(this.counter);
        super.visitEnd();
    }

    @Override
    public int nextId() {
        return this.counter++;
    }
}

