/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.expression;

import com.sun.source.tree.Tree;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.checkerframework.errorprone.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.errorprone.javacutil.AnnotationProvider;

public class UnaryOperation
extends JavaExpression {
    protected final Tree.Kind operationKind;
    protected final JavaExpression operand;

    public UnaryOperation(TypeMirror type, Tree.Kind operationKind, JavaExpression operand) {
        super(operand.type);
        this.operationKind = operationKind;
        this.operand = operand;
    }

    public UnaryOperation(UnaryOperationNode node, JavaExpression operand) {
        this(node.getType(), node.getTree().getKind(), operand);
    }

    public Tree.Kind getOperationKind() {
        return this.operationKind;
    }

    public JavaExpression getOperand() {
        return this.operand;
    }

    @Override
    public boolean containsOfClass(Class<? extends JavaExpression> clazz) {
        if (this.getClass() == clazz) {
            return true;
        }
        return this.operand.containsOfClass(clazz);
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return this.operand.isDeterministic(provider);
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return this.operand.isUnassignableByOtherCode();
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return this.operand.isUnmodifiableByOtherCode();
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof UnaryOperation)) {
            return false;
        }
        UnaryOperation other = (UnaryOperation)je;
        return this.operationKind == other.getOperationKind() && this.operand.syntacticEquals(other.operand);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.operand.containsSyntacticEqualJavaExpression(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return this.operand.containsModifiableAliasOf(store, other);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationKind, this.operand});
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof UnaryOperation)) {
            return false;
        }
        UnaryOperation unOp = (UnaryOperation)other;
        return this.operationKind == unOp.getOperationKind() && this.operand.equals(unOp.operand);
    }

    public String toString() {
        String operandString = this.operand.toString();
        switch (this.operationKind) {
            case BITWISE_COMPLEMENT: {
                return "~" + operandString;
            }
            case LOGICAL_COMPLEMENT: {
                return "!" + operandString;
            }
            case POSTFIX_DECREMENT: {
                return operandString + "--";
            }
            case POSTFIX_INCREMENT: {
                return operandString + "++";
            }
            case PREFIX_DECREMENT: {
                return "--" + operandString;
            }
            case PREFIX_INCREMENT: {
                return "++" + operandString;
            }
            case UNARY_MINUS: {
                return "-" + operandString;
            }
            case UNARY_PLUS: {
                return "+" + operandString;
            }
        }
        throw new Error("Unrecognized unary operation kind " + (Object)((Object)this.operationKind));
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitUnaryOperation(this, p);
    }
}

