/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.core.rule;

import com.android.tools.build.jetifier.core.proguard.ProGuardType;
import com.android.tools.build.jetifier.core.type.JavaType;
import com.google.gson.annotations.SerializedName;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/build/jetifier/core/rule/RewriteRule;", "", "from", "", "to", "(Ljava/lang/String;Ljava/lang/String;)V", "inputPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "outputPattern", "apply", "Lcom/android/tools/build/jetifier/core/rule/RewriteRule$TypeRewriteResult;", "input", "Lcom/android/tools/build/jetifier/core/type/JavaType;", "doesThisIgnoreProGuard", "", "type", "Lcom/android/tools/build/jetifier/core/proguard/ProGuardType;", "isIgnoreRule", "isPreprocessorOnlyIgnoreRule", "isRuntimeIgnoreRule", "reverse", "toJson", "Lcom/android/tools/build/jetifier/core/rule/RewriteRule$JsonData;", "toString", "Companion", "JsonData", "TypeRewriteResult", "jetifier-core"})
public final class RewriteRule {
    private final Pattern inputPattern;
    private final String outputPattern;
    private final String from;
    private final String to;
    @NotNull
    public static final String IGNORE_RUNTIME = "ignore";
    @NotNull
    public static final String IGNORE_PREPROCESSOR_ONLY = "ignoreInPreprocessorOnly";
    public static final Companion Companion = new Companion(null);

    public final boolean isIgnoreRule() {
        return this.isRuntimeIgnoreRule() || this.isPreprocessorOnlyIgnoreRule();
    }

    public final boolean isRuntimeIgnoreRule() {
        return Intrinsics.areEqual((Object)this.to, (Object)IGNORE_RUNTIME);
    }

    public final boolean isPreprocessorOnlyIgnoreRule() {
        return Intrinsics.areEqual((Object)this.to, (Object)IGNORE_PREPROCESSOR_ONLY);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeRewriteResult apply(@NotNull JavaType input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Matcher matcher = this.inputPattern.matcher(input.getFullName());
        if (!matcher.matches()) {
            return TypeRewriteResult.Companion.getNOT_APPLIED();
        }
        if (this.isIgnoreRule()) {
            return TypeRewriteResult.Companion.getIGNORED();
        }
        String result = this.outputPattern;
        int n = 0;
        int n2 = matcher.groupCount();
        while (n < n2) {
            void i;
            String string = "" + '{' + (int)i + '}';
            String string2 = matcher.group((int)(i + true));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"matcher.group(i + 1)");
            result = StringsKt.replace$default((String)result, (String)string, (String)string2, (boolean)false, (int)4, null);
            ++i;
        }
        return new TypeRewriteResult(new JavaType(result), false, 2, null);
    }

    @NotNull
    public final RewriteRule reverse() {
        String newFrom = StringsKt.replace$default((String)this.to, (String)"{0}", (String)"(.*)", (boolean)false, (int)4, null);
        String newTo = StringsKt.replace$default((String)this.from, (String)"(.*)", (String)"{0}", (boolean)false, (int)4, null);
        return new RewriteRule(newFrom, newTo);
    }

    public final boolean doesThisIgnoreProGuard(@NotNull ProGuardType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (!this.isIgnoreRule()) {
            return false;
        }
        Matcher matcher = this.inputPattern.matcher(type.getValue());
        return matcher.matches();
    }

    @NotNull
    public String toString() {
        return this.inputPattern + " -> " + this.outputPattern + ' ';
    }

    @NotNull
    public final JsonData toJson() {
        return new JsonData(this.from, this.to);
    }

    public RewriteRule(@NotNull String from, @NotNull String to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        this.from = from;
        this.to = to;
        this.inputPattern = Pattern.compile('^' + StringsKt.replace$default((String)this.from, (String)"$", (String)"\\$", (boolean)false, (int)4, null) + '$');
        this.outputPattern = StringsKt.replace$default((String)this.to, (String)"$", (String)"$", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/build/jetifier/core/rule/RewriteRule$JsonData;", "", "from", "", "to", "(Ljava/lang/String;Ljava/lang/String;)V", "getFrom", "()Ljava/lang/String;", "getTo", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toRule", "Lcom/android/tools/build/jetifier/core/rule/RewriteRule;", "toString", "jetifier-core"})
    public static final class JsonData {
        @SerializedName(value="from")
        @NotNull
        private final String from;
        @SerializedName(value="to")
        @NotNull
        private final String to;

        @NotNull
        public final RewriteRule toRule() {
            return new RewriteRule(this.from, this.to);
        }

        @NotNull
        public final String getFrom() {
            return this.from;
        }

        @NotNull
        public final String getTo() {
            return this.to;
        }

        public JsonData(@NotNull String from, @NotNull String to) {
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
            this.from = from;
            this.to = to;
        }

        @NotNull
        public final String component1() {
            return this.from;
        }

        @NotNull
        public final String component2() {
            return this.to;
        }

        @NotNull
        public final JsonData copy(@NotNull String from, @NotNull String to) {
            Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
            Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
            return new JsonData(from, to);
        }

        @NotNull
        public static /* synthetic */ JsonData copy$default(JsonData jsonData, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = jsonData.from;
            }
            if ((n & 2) != 0) {
                string2 = jsonData.to;
            }
            return jsonData.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "JsonData(from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            String string = this.from;
            String string2 = this.to;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JsonData)) break block3;
                    JsonData jsonData = (JsonData)object;
                    if (!Intrinsics.areEqual((Object)this.from, (Object)jsonData.from) || !Intrinsics.areEqual((Object)this.to, (Object)jsonData.to)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/build/jetifier/core/rule/RewriteRule$TypeRewriteResult;", "", "result", "Lcom/android/tools/build/jetifier/core/type/JavaType;", "isIgnored", "", "(Lcom/android/tools/build/jetifier/core/type/JavaType;Z)V", "()Z", "getResult", "()Lcom/android/tools/build/jetifier/core/type/JavaType;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "jetifier-core"})
    public static final class TypeRewriteResult {
        @Nullable
        private final JavaType result;
        private final boolean isIgnored;
        @NotNull
        private static final TypeRewriteResult NOT_APPLIED;
        @NotNull
        private static final TypeRewriteResult IGNORED;
        public static final Companion Companion;

        @Nullable
        public final JavaType getResult() {
            return this.result;
        }

        public final boolean isIgnored() {
            return this.isIgnored;
        }

        public TypeRewriteResult(@Nullable JavaType result, boolean isIgnored) {
            this.result = result;
            this.isIgnored = isIgnored;
        }

        public /* synthetic */ TypeRewriteResult(JavaType javaType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(javaType, bl);
        }

        static {
            Companion = new Companion(null);
            NOT_APPLIED = new TypeRewriteResult(null, false);
            IGNORED = new TypeRewriteResult(null, true);
        }

        @Nullable
        public final JavaType component1() {
            return this.result;
        }

        public final boolean component2() {
            return this.isIgnored;
        }

        @NotNull
        public final TypeRewriteResult copy(@Nullable JavaType result, boolean isIgnored) {
            return new TypeRewriteResult(result, isIgnored);
        }

        @NotNull
        public static /* synthetic */ TypeRewriteResult copy$default(TypeRewriteResult typeRewriteResult, JavaType javaType, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                javaType = typeRewriteResult.result;
            }
            if ((n & 2) != 0) {
                bl = typeRewriteResult.isIgnored;
            }
            return typeRewriteResult.copy(javaType, bl);
        }

        @NotNull
        public String toString() {
            return "TypeRewriteResult(result=" + this.result + ", isIgnored=" + this.isIgnored + ")";
        }

        public int hashCode() {
            JavaType javaType = this.result;
            int n = (javaType != null ? ((Object)javaType).hashCode() : 0) * 31;
            int n2 = this.isIgnored ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TypeRewriteResult)) break block3;
                    TypeRewriteResult typeRewriteResult = (TypeRewriteResult)object;
                    if (!Intrinsics.areEqual((Object)this.result, (Object)typeRewriteResult.result) || !(this.isIgnored == typeRewriteResult.isIgnored)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/build/jetifier/core/rule/RewriteRule$TypeRewriteResult$Companion;", "", "()V", "IGNORED", "Lcom/android/tools/build/jetifier/core/rule/RewriteRule$TypeRewriteResult;", "getIGNORED", "()Lcom/android/tools/build/jetifier/core/rule/RewriteRule$TypeRewriteResult;", "NOT_APPLIED", "getNOT_APPLIED", "jetifier-core"})
        public static final class Companion {
            @NotNull
            public final TypeRewriteResult getNOT_APPLIED() {
                return NOT_APPLIED;
            }

            @NotNull
            public final TypeRewriteResult getIGNORED() {
                return IGNORED;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/build/jetifier/core/rule/RewriteRule$Companion;", "", "()V", "IGNORE_PREPROCESSOR_ONLY", "", "IGNORE_RUNTIME", "jetifier-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

