/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.context;

import com.google.common.flogger.context.NoOpContextDataProvider;
import com.google.common.flogger.context.ScopedLoggingContext;
import com.google.common.flogger.context.Tags;
import com.google.common.flogger.util.StaticMethodCaller;
import java.util.logging.Level;

public abstract class ContextDataProvider {
    static final String CONTEXT_PROVIDER_PROPERTY = "flogger.context";

    public static ContextDataProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    public abstract ScopedLoggingContext getContextApiSingleton();

    public abstract boolean shouldForceLogging(String var1, Level var2, boolean var3);

    public Tags getTags() {
        return Tags.empty();
    }

    private static final class LazyHolder {
        private static final ContextDataProvider INSTANCE = LazyHolder.loadContext();

        private LazyHolder() {
        }

        private static ContextDataProvider loadContext() {
            ContextDataProvider ctx = StaticMethodCaller.callGetterFromSystemProperty(ContextDataProvider.CONTEXT_PROVIDER_PROPERTY, ContextDataProvider.class);
            return ctx != null ? ctx : new NoOpContextDataProvider();
        }
    }
}

