/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.CodeAttributeEditorResetter;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ConstructorMethodFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MethodCollector;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.UniqueMemberNameFactory;

public class SimplifiedClassEditor
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final String EXTRA_INIT_METHOD_NAME = "init$";
    private static final String EXTRA_INIT_METHOD_DESCRIPTOR = "()V";
    private final ProgramClass programClass;
    private final ClassEditor classEditor;
    private final ConstantPoolEditor constantPoolEditor;
    private final NameFactory nameFactory;
    private String superClassName;
    private final List<CodeComposer> methodComposers = new ArrayList<CodeComposer>();
    private Instruction[] instructions;

    public SimplifiedClassEditor(int u2accessFlags, String className) {
        this(u2accessFlags, className, null);
    }

    public SimplifiedClassEditor(int u2accessFlags, String className, String superclassName) {
        this(new ProgramClass(0x2E0000, 1, new Constant[10], u2accessFlags, 0, 0));
        this.programClass.u2thisClass = this.constantPoolEditor.addClassConstant(className, this.programClass);
        if (superclassName != null) {
            this.programClass.u2superClass = this.constantPoolEditor.addClassConstant(superclassName, null);
            this.superClassName = superclassName;
        }
    }

    public SimplifiedClassEditor(ProgramClass programClass) {
        this.programClass = programClass;
        this.classEditor = new ClassEditor(programClass);
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
        this.nameFactory = UniqueMemberNameFactory.newInjectedMemberNameFactory(programClass);
    }

    public void finishEditing() {
        for (CodeComposer composer : this.methodComposers) {
            composer.finishEditing();
        }
    }

    public void finishEditing(ClassPool programClassPool, ClassPool libraryClassPool) {
        for (CodeComposer composer : this.methodComposers) {
            composer.finishEditing();
        }
        if (this.superClassName != null) {
            new ClassSuperHierarchyInitializer(programClassPool, libraryClassPool, null, null).visitProgramClass(this.programClass);
            new ClassSubHierarchyInitializer().visitProgramClass(this.programClass);
        }
        new ClassReferenceInitializer(programClassPool, libraryClassPool).visitProgramClass(this.programClass);
    }

    public ProgramClass getProgramClass() {
        return this.programClass;
    }

    public int addClassConstant(String name, Clazz referencedClass) {
        return this.constantPoolEditor.addClassConstant(name, referencedClass);
    }

    public SimplifiedClassEditor addField(int u2accessFlags, String fieldName, String fieldDescriptor) {
        ProgramField field = new ProgramField(u2accessFlags, this.constantPoolEditor.addUtf8Constant(fieldName), this.constantPoolEditor.addUtf8Constant(fieldDescriptor), null);
        this.classEditor.addField(field);
        return this;
    }

    public CompactCodeAttributeComposer addMethod(int u2accessFlags, String methodName, String methodDescriptor, int maxCodeFragmentLength) {
        return this.addMethod(u2accessFlags, methodName, methodDescriptor, null, maxCodeFragmentLength);
    }

    public CompactCodeAttributeComposer addMethod(int u2accessFlags, String methodName, String methodDescriptor, Clazz[] referencedClasses, int maxCodeFragmentLength) {
        ProgramMethod method = new ProgramMethod(u2accessFlags, this.constantPoolEditor.addUtf8Constant(methodName), this.constantPoolEditor.addUtf8Constant(methodDescriptor), referencedClasses);
        CodeComposer composer = new CodeComposer(method, maxCodeFragmentLength);
        this.methodComposers.add(composer);
        return composer;
    }

    public ProgramMethod addMethod(int u2accessFlags, String methodName, String methodDescriptor, Instruction[] instructions) {
        return this.addMethod(u2accessFlags, methodName, methodDescriptor, instructions, null, null);
    }

    public void addStaticInitializerInstructions(Instruction[] instructions, boolean mergeIntoExistingInitializer) {
        Method method = this.programClass.findMethod("<clinit>", EXTRA_INIT_METHOD_DESCRIPTOR);
        if (method == null) {
            this.addMethod(8, "<clinit>", EXTRA_INIT_METHOD_DESCRIPTOR, instructions, null, new SimpleInstruction(-79));
        } else {
            if (!mergeIntoExistingInitializer) {
                ProgramMethod newMethod = this.addMethod(8, this.nameFactory.nextName(), EXTRA_INIT_METHOD_DESCRIPTOR, instructions, null, new SimpleInstruction(-79));
                InstructionSequenceBuilder builder = new InstructionSequenceBuilder(this.programClass);
                builder.invokestatic(this.programClass.getName(), newMethod.getName(this.programClass), EXTRA_INIT_METHOD_DESCRIPTOR, this.programClass, newMethod);
                instructions = builder.instructions();
            }
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
            ((ProgramMethod)method).attributesAccept(this.programClass, new CodeAttributeEditorResetter(codeAttributeEditor));
            codeAttributeEditor.insertBeforeOffset(0, instructions);
            ((ProgramMethod)method).attributesAccept(this.programClass, codeAttributeEditor);
        }
    }

    public void addInitializerInstructions(Instruction[] instructions) {
        Method method = this.programClass.findMethod("<init>", null);
        if (method == null) {
            Instruction[] firstInstruction = new Instruction[]{new VariableInstruction(42), new ConstantInstruction(-73, this.constantPoolEditor.addMethodrefConstant(this.programClass.getSuperClass().getName(), "<init>", EXTRA_INIT_METHOD_DESCRIPTOR, null, null))};
            SimpleInstruction lastInstruction = new SimpleInstruction(-79);
            this.addMethod(1, "<init>", EXTRA_INIT_METHOD_DESCRIPTOR, instructions, firstInstruction, lastInstruction);
        } else {
            HashSet<Method> constructors = new HashSet<Method>();
            this.programClass.methodsAccept(new ConstructorMethodFilter(new MethodCollector(constructors), null, null));
            if (constructors.size() == 1) {
                this.instructions = instructions;
                ((Method)constructors.iterator().next()).accept(this.programClass, new AllAttributeVisitor(this));
            } else {
                ProgramMethod initMethod = (ProgramMethod)this.programClass.findMethod(EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR);
                if (initMethod == null) {
                    initMethod = this.addMethod(2, EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR, instructions, null, new SimpleInstruction(-79));
                    InstructionSequenceBuilder builder = new InstructionSequenceBuilder(this.programClass);
                    builder.aload_0();
                    builder.invokespecial(this.programClass.getName(), EXTRA_INIT_METHOD_NAME, EXTRA_INIT_METHOD_DESCRIPTOR, this.programClass, initMethod);
                    this.instructions = builder.instructions();
                    this.programClass.methodsAccept(new ConstructorMethodFilter(new AllAttributeVisitor(this), null, null));
                } else {
                    this.instructions = instructions;
                    initMethod.accept(this.programClass, (MemberVisitor)new AllAttributeVisitor(this));
                }
            }
        }
    }

    private ProgramMethod addMethod(int u2accessFlags, String methodName, String methodDescriptor, Instruction[] instructions, Instruction[] firstInstructions, Instruction lastInstruction) {
        ProgramMethod method = new ProgramMethod(u2accessFlags, this.constantPoolEditor.addUtf8Constant(methodName), this.constantPoolEditor.addUtf8Constant(methodDescriptor), null);
        CodeAttribute codeAttribute = new CodeAttribute(this.constantPoolEditor.addUtf8Constant("Code"));
        CodeAttributeComposer composer = new CodeAttributeComposer();
        composer.reset();
        composer.beginCodeFragment(0);
        composer.appendInstructions(instructions);
        if (firstInstructions != null) {
            for (Instruction instruction : firstInstructions) {
                composer.appendInstruction(instruction);
            }
        }
        if (lastInstruction != null) {
            composer.appendInstruction(lastInstruction);
        }
        composer.endCodeFragment();
        composer.visitCodeAttribute(this.programClass, method, codeAttribute);
        new AttributesEditor(this.programClass, method, false).addAttribute(codeAttribute);
        this.classEditor.addMethod(method);
        return method;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        ((ProgramMethod)method).attributesAccept(this.programClass, new CodeAttributeEditorResetter(codeAttributeEditor));
        codeAttributeEditor.insertBeforeOffset(0, this.instructions);
        codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private class CodeComposer
    extends CompactCodeAttributeComposer {
        private final ProgramMethod method;

        public CodeComposer(ProgramMethod method, int maxCodeFragmentLength) {
            super(SimplifiedClassEditor.this.programClass);
            this.method = method;
            this.beginCodeFragment(maxCodeFragmentLength);
        }

        public void finishEditing() {
            this.endCodeFragment();
            CodeAttribute codeAttribute = new CodeAttribute(SimplifiedClassEditor.this.constantPoolEditor.addUtf8Constant("Code"));
            this.visitCodeAttribute(SimplifiedClassEditor.this.programClass, this.method, codeAttribute);
            new AttributesEditor(SimplifiedClassEditor.this.programClass, this.method, false).addAttribute(codeAttribute);
            SimplifiedClassEditor.this.classEditor.addMethod(this.method);
        }
    }
}

