/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Predicate;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.refaster.AutoValue_UMatches;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import javax.annotation.Nullable;

@AutoValue
abstract class UMatches
extends UExpression {
    private transient Matcher<? super ExpressionTree> matcher;

    UMatches() {
    }

    public static UMatches create(Class<? extends Matcher<? super ExpressionTree>> matcherClass, boolean positive, UExpression expression) {
        UMatches.makeMatcher(matcherClass);
        return new AutoValue_UMatches(positive, matcherClass, expression);
    }

    abstract boolean positive();

    abstract Class<? extends Matcher<? super ExpressionTree>> matcherClass();

    abstract UExpression expression();

    @Override
    @Nullable
    protected Choice<Unifier> defaultAction(Tree target, @Nullable Unifier unifier) {
        Tree exprTarget = ASTHelpers.stripParentheses((Tree)target);
        return this.expression().unify(exprTarget, unifier).condition((Predicate<Unifier>)((Predicate)success -> this.matches(exprTarget, (Unifier)success) == this.positive()));
    }

    @Override
    public JCTree.JCExpression inline(Inliner inliner) throws CouldNotResolveImportException {
        throw new UnsupportedOperationException("@Matches should not appear in an @AfterTemplate");
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return this.expression().accept(visitor, data);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OTHER;
    }

    private boolean matches(Tree target, Unifier unifier) {
        if (this.matcher == null) {
            this.matcher = UMatches.makeMatcher(this.matcherClass());
        }
        return target instanceof ExpressionTree && this.matcher.matches((Tree)((ExpressionTree)target), UMatches.makeVisitorState(target, unifier));
    }

    static <T> T makeMatcher(Class<T> klass) {
        try {
            return klass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static VisitorState makeVisitorState(Tree target, Unifier unifier) {
        Context context = unifier.getContext();
        VisitorState state = new VisitorState(context);
        TreePath path = TreePath.getPath(context.get(JCTree.JCCompilationUnit.class), target);
        if (path != null) {
            state = state.withPath(path);
        }
        return state;
    }
}

