/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(summary="FluentLogger.forEnclosingClass should always be saved to a private static final field.", link="https://google.github.io/flogger/best_practice#modifiers", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING)
public final class FloggerRequiredModifiers
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.IdentifierTreeMatcher,
BugChecker.MemberSelectTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final String GOOGLE_LOGGER = "com.google.common.flogger.FluentLogger";
    private static final Supplier<Type> LOGGER_TYPE = Suppliers.typeFromString((String)"com.google.common.flogger.FluentLogger");
    private static final Matcher<ExpressionTree> INIT_LOGGER = MethodMatchers.staticMethod().onClass(LOGGER_TYPE).named("forEnclosingClass").withNoParameters();
    private static final ImmutableList<Modifier> EXPECTED_MODIFIERS = ImmutableList.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.FINAL));
    private static final ImmutableList<String> REASONABLE_LOGGER_NAMES = ImmutableList.of((Object)"logger", (Object)"flogger", (Object)"googleLogger", (Object)"myLogger");
    private static final String NESTED_LOGGER_CLASSNAME = "Private";
    private static final String NESTED_LOGGER_FIELDNAME = "logger";
    private static final String NESTED_LOGGER_DEFINITION = Joiner.on((char)'\n').join((Object)"/** Do not use. Exists only to hide implementation details of this interface. */", (Object)String.format("public static final class %s {", "Private"), new Object[]{String.format("  private %s() {}", "Private"), String.format("  private static final FluentLogger %s = FluentLogger.forEnclosingClass();", "logger"), "}"});
    private final Map<String, LocalLogger> localLogger = new HashMap<String, LocalLogger>();
    private static final Matcher<Tree> CONTAINS_INIT_LOGGER = Matchers.contains(ExpressionTree.class, INIT_LOGGER);
    private final Goal goal;

    @Inject
    FloggerRequiredModifiers(ErrorProneFlags flags) {
        this(flags.getEnum("FloggerRequiredModifiers:Goal", Goal.class).orElse(Goal.DEFAULT_ALL_GOALS));
    }

    FloggerRequiredModifiers(Goal goal) {
        this.goal = goal;
    }

    private boolean shouldRehomeForeignLoggers() {
        return this.goal.equals((Object)Goal.REHOME_FOREIGN_LOGGERS);
    }

    private boolean shouldHideInterfaceLoggers() {
        switch (this.goal) {
            case HIDE_LOGGERS_IN_INTERFACES: 
            case DEFAULT_ALL_GOALS: {
                return true;
            }
        }
        return false;
    }

    private boolean shouldHoistConstantExpressions() {
        switch (this.goal) {
            case DEFAULT_ALL_GOALS: 
            case HOIST_CONSTANT_EXPRESSIONS: {
                return true;
            }
        }
        return false;
    }

    private boolean shouldStandardizeModifiers() {
        switch (this.goal) {
            case DEFAULT_ALL_GOALS: 
            case ADD_FINAL: 
            case ADD_STATIC: 
            case MAKE_PRIVATE: {
                return true;
            }
        }
        return false;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!this.shouldStandardizeModifiers()) {
            return Description.NO_MATCH;
        }
        Type loggerType = (Type)LOGGER_TYPE.get(state);
        if (!ASTHelpers.isSameType((Type)loggerType, (Type)ASTHelpers.getType((Tree)tree), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (!(sym.owner instanceof Symbol.ClassSymbol)) {
            return Description.NO_MATCH;
        }
        ExpressionTree initializer = tree.getInitializer();
        if (initializer == null ? sym.isStatic() : FloggerRequiredModifiers.isConstantLogger(initializer, (Symbol.ClassSymbol)sym.owner, state)) {
            return this.fixModifier(tree, (ClassTree)state.getPath().getParentPath().getLeaf(), state);
        }
        return Description.NO_MATCH;
    }

    private static boolean isConstantLogger(ExpressionTree initializer, Symbol.ClassSymbol owner, VisitorState state) {
        if (initializer instanceof MethodInvocationTree) {
            Type loggerType = (Type)LOGGER_TYPE.get(state);
            MethodInvocationTree method = (MethodInvocationTree)initializer;
            Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodInvocationTree)method);
            if (methodSym.isStatic() && methodSym.owner.equals(owner) && ASTHelpers.isSameType((Type)loggerType, (Type)methodSym.getReturnType(), (VisitorState)state)) {
                return true;
            }
        }
        return CONTAINS_INIT_LOGGER.matches((Tree)initializer, state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSym;
        Type returnType;
        boolean isLoggerField;
        if (!this.shouldHoistConstantExpressions()) {
            return Description.NO_MATCH;
        }
        if (!INIT_LOGGER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Type loggerType = (Type)LOGGER_TYPE.get(state);
        if (loggerType == null) {
            return Description.NO_MATCH;
        }
        TreePath owner = state.findPathToEnclosing(new Class[]{ClassTree.class, MethodTree.class, VariableTree.class});
        Tree parent = owner.getLeaf();
        Tree grandparent = owner.getParentPath().getLeaf();
        boolean bl = isLoggerField = parent instanceof VariableTree && grandparent instanceof ClassTree && ASTHelpers.isSameType((Type)loggerType, (Type)ASTHelpers.getType((Tree)parent), (VisitorState)state);
        if (isLoggerField) {
            return Description.NO_MATCH;
        }
        MethodTree owningMethod = (MethodTree)state.findEnclosing(new Class[]{MethodTree.class});
        if (owningMethod != null && ASTHelpers.isSameType((Type)loggerType, (Type)(returnType = (methodSym = ASTHelpers.getSymbol((MethodTree)owningMethod)).getReturnType()), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        state.incrementCounter((BugChecker)this, parent instanceof VariableTree ? "local-variable" : "inline");
        return this.replaceWithFieldLookup(tree, state);
    }

    private boolean modifierChangesInclude(Goal g) {
        return this.goal == Goal.DEFAULT_ALL_GOALS || this.goal == g;
    }

    private Description fixModifier(VariableTree field, ClassTree owningClass, VisitorState state) {
        ImmutableSet newModifiers;
        ModifiersTree modifiers = field.getModifiers();
        Set<Modifier> flags = modifiers.getFlags();
        if (flags.containsAll((Collection<?>)EXPECTED_MODIFIERS)) {
            return Description.NO_MATCH;
        }
        this.updateModifierCounters(state, flags);
        ImmutableSet.Builder toAdd = ImmutableSet.builder();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (this.modifierChangesInclude(Goal.MAKE_PRIVATE)) {
            SuggestedFixes.removeModifiers((Tree)field, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
            toAdd.add((Object)Modifier.PRIVATE);
        }
        if (this.modifierChangesInclude(Goal.ADD_FINAL)) {
            toAdd.add((Object)Modifier.FINAL);
        }
        if (this.modifierChangesInclude(Goal.ADD_STATIC) && (flags.contains((Object)Modifier.FINAL) || this.modifierChangesInclude(Goal.ADD_FINAL)) && FloggerRequiredModifiers.canHaveStaticFields(ASTHelpers.getSymbol((ClassTree)owningClass))) {
            toAdd.add((Object)Modifier.STATIC);
        }
        if (!(newModifiers = toAdd.build()).isEmpty()) {
            SuggestedFixes.addModifiers((Tree)field, (ModifiersTree)modifiers, (VisitorState)state, (Set)newModifiers).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        }
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(field, (Fix)fix.build());
    }

    private Description replaceWithFieldLookup(ExpressionTree expr, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        LocalLogger logger = this.findOrDefineLogger(state, fix);
        if (logger.provenance == LocalLogger.Provenance.ALREADY_PRESENT && logger.sym.isPresent()) {
            Symbol target = logger.sym.get();
            Tree e = expr;
            TreePath path = state.getPath();
            do {
                AssignmentTree assignment;
                if (!(e instanceof AssignmentTree) || !ASTHelpers.getSymbol((Tree)(assignment = (AssignmentTree)e).getVariable()).equals(target)) continue;
                state.incrementCounter((BugChecker)this, "skip-self-assignment");
                return Description.NO_MATCH;
            } while ((e = (path = path.getParentPath()).getLeaf()) instanceof ExpressionTree);
        }
        String loggerName = logger.name;
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof VariableTree && ((VariableTree)parent).getName().contentEquals(loggerName)) {
            return this.describeMatch(expr, (Fix)fix.delete(parent).build());
        }
        if (loggerName.equals(state.getSourceForNode((Tree)expr))) {
            if (fix.isEmpty()) {
                return Description.NO_MATCH;
            }
            return this.describeMatch(expr, (Fix)fix.build());
        }
        return this.describeMatch(expr, (Fix)fix.replace((Tree)expr, loggerName).build());
    }

    private void updateModifierCounters(VisitorState state, Set<Modifier> flags) {
        for (Modifier modifier : ImmutableList.of((Object)((Object)Modifier.STATIC), (Object)((Object)Modifier.FINAL))) {
            if (flags.contains((Object)modifier)) continue;
            state.incrementCounter((BugChecker)this, "missing-" + modifier);
        }
        boolean explicitVisibility = false;
        for (Modifier visibility : ImmutableList.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.PROTECTED))) {
            if (!flags.contains((Object)visibility)) continue;
            state.incrementCounter((BugChecker)this, "visibility-" + visibility);
            explicitVisibility = true;
            break;
        }
        if (!explicitVisibility) {
            state.incrementCounter((BugChecker)this, "visibility-package");
        }
    }

    private LocalLogger findOrDefineLogger(VisitorState state, SuggestedFix.Builder fix) {
        return this.localLogger.computeIfAbsent(ASTHelpers.getFileName((CompilationUnitTree)state.getPath().getCompilationUnit()), s -> this.computeLocalLogger(state, fix));
    }

    private LocalLogger computeLocalLogger(VisitorState state, SuggestedFix.Builder fix) {
        Type loggerType = (Type)LOGGER_TYPE.get(state);
        if (loggerType == null) {
            throw new AssertionError((Object)"Attempting to define new logger in a file without loggers");
        }
        ImmutableSet<Symbol> ignoredFields = FloggerRequiredModifiers.fieldsToIgnore(state);
        ClassTree topLevelClassInFile = FloggerRequiredModifiers.outermostClassTree(state.getPath());
        Symbol.ClassSymbol targetClassSym = ASTHelpers.getSymbol((ClassTree)topLevelClassInFile);
        for (Tree tree : topLevelClassInFile.getMembers()) {
            Symbol memberSym = ASTHelpers.getSymbol((Tree)tree);
            if (!(memberSym instanceof Symbol.VarSymbol) || !ASTHelpers.isSubtype((Type)memberSym.type, (Type)loggerType, (VisitorState)state) || ignoredFields.contains((Object)memberSym)) continue;
            if (!targetClassSym.isInterface()) {
                state.incrementCounter((BugChecker)this, "found-existing");
                return new LocalLogger(LocalLogger.Provenance.ALREADY_PRESENT, Optional.of(memberSym), memberSym.getSimpleName().toString());
            }
            fix.delete(tree);
            return FloggerRequiredModifiers.defineNestedClassWithLogger(topLevelClassInFile, state, fix);
        }
        fix.addImport(GOOGLE_LOGGER);
        if (targetClassSym.isInterface()) {
            return FloggerRequiredModifiers.defineNestedClassWithLogger(topLevelClassInFile, state, fix);
        }
        String name = REASONABLE_LOGGER_NAMES.stream().filter(candidate -> Iterables.isEmpty(targetClassSym.members().getSymbolsByName(state.getName(candidate)))).findFirst().orElseThrow(IllegalStateException::new);
        String string = String.format("private static final FluentLogger %s = FluentLogger.forEnclosingClass();", name);
        fix.merge(SuggestedFixes.addMembers((ClassTree)topLevelClassInFile, (VisitorState)state, (SuggestedFixes.AdditionPosition)SuggestedFixes.AdditionPosition.FIRST, (String)string, (String[])new String[0]));
        return new LocalLogger(LocalLogger.Provenance.DEFINED_BY_FIX, Optional.empty(), name);
    }

    private static LocalLogger defineNestedClassWithLogger(ClassTree topLevelClassInFile, VisitorState state, SuggestedFix.Builder fix) {
        fix.merge(SuggestedFixes.addMembers((ClassTree)topLevelClassInFile, (VisitorState)state, (String)NESTED_LOGGER_DEFINITION, (String[])new String[0]));
        return new LocalLogger(LocalLogger.Provenance.DEFINED_BY_FIX, Optional.empty(), String.format("%s.%s", NESTED_LOGGER_CLASSNAME, NESTED_LOGGER_FIELDNAME));
    }

    private static ClassTree outermostClassTree(TreePath path) {
        ClassTree result = null;
        while (path != null) {
            Tree leaf = path.getLeaf();
            if (leaf instanceof ClassTree) {
                result = (ClassTree)leaf;
            }
            path = path.getParentPath();
        }
        Verify.verifyNotNull(result, (String)"No enclosing class", (Object[])new Object[0]);
        return result;
    }

    private static boolean canHaveStaticFields(Symbol.ClassSymbol enclosingClassSym) {
        return enclosingClassSym.getNestingKind() == NestingKind.TOP_LEVEL || enclosingClassSym.getNestingKind() == NestingKind.MEMBER && (enclosingClassSym.flags() & 8L) != 0L;
    }

    public Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        return this.rehomeLogger(tree, state);
    }

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        return this.rehomeLogger(tree, state);
    }

    private Description rehomeLogger(ExpressionTree tree, VisitorState state) {
        if (!this.shouldRehomeForeignLoggers() && !this.shouldHideInterfaceLoggers()) {
            return Description.NO_MATCH;
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Type type = sym.type;
        if (!ASTHelpers.isSameType((Type)type, (Type)((Type)LOGGER_TYPE.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        Symbol owner = sym.owner;
        if (!(owner instanceof Symbol.ClassSymbol)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isStatic((Symbol)sym) && !(tree instanceof IdentifierTree)) {
            return Description.NO_MATCH;
        }
        boolean needsMoveFromInterface = this.shouldHideInterfaceLoggers() && owner.isInterface();
        boolean local = false;
        Symbol outermostClassOfLogger = FloggerRequiredModifiers.findUltimateOwningClass(owner);
        ClassTree outermostClassOfFile = null;
        for (Tree parent : state.getPath()) {
            Symbol ownerSym = ASTHelpers.getSymbol((Tree)parent);
            if (outermostClassOfLogger.equals(ownerSym)) {
                if (!needsMoveFromInterface) {
                    return Description.NO_MATCH;
                }
                local = true;
            }
            if (!(parent instanceof ClassTree)) continue;
            outermostClassOfFile = (ClassTree)parent;
        }
        if (outermostClassOfFile == null) {
            state.incrementCounter((BugChecker)this, "error-no-outermost-class");
            return Description.NO_MATCH;
        }
        if (!local && !this.shouldRehomeForeignLoggers()) {
            return Description.NO_MATCH;
        }
        return this.replaceWithFieldLookup(tree, state);
    }

    private static Symbol findUltimateOwningClass(Symbol sym) {
        Symbol result = sym;
        while (sym instanceof Symbol.ClassSymbol) {
            result = sym;
            sym = sym.owner;
        }
        return result;
    }

    private static ImmutableSet<Symbol> fieldsToIgnore(VisitorState state) {
        Tree t = state.findEnclosing(new Class[]{VariableTree.class, ClassTree.class});
        return t instanceof VariableTree ? ImmutableSet.of((Object)ASTHelpers.getSymbol((Tree)t)) : ImmutableSet.of();
    }

    static enum Goal {
        REHOME_FOREIGN_LOGGERS,
        HIDE_LOGGERS_IN_INTERFACES,
        HOIST_CONSTANT_EXPRESSIONS,
        ADD_FINAL,
        ADD_STATIC,
        MAKE_PRIVATE,
        DEFAULT_ALL_GOALS;

    }

    private static final class LocalLogger {
        final Provenance provenance;
        final Optional<Symbol> sym;
        final String name;

        LocalLogger(Provenance provenance, Optional<Symbol> sym, String name) {
            this.provenance = provenance;
            this.sym = sym;
            this.name = name;
        }

        static enum Provenance {
            ALREADY_PRESENT,
            DEFINED_BY_FIX;

        }
    }
}

