/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.common.AnnotationMirrors;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;

@BugPattern(summary="Suppressing \"deprecated\" is probably a typo for \"deprecation\"", severity=BugPattern.SeverityLevel.ERROR)
public class SuppressWarningsDeprecated
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<AnnotationTree> matcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isType((String)"java.lang.SuppressWarnings"), Matchers.hasArgumentWithValue((String)"value", (Matcher)Matchers.stringLiteral((String)"deprecated"))});

    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (!matcher.matches((Tree)annotationTree, state)) {
            return Description.NO_MATCH;
        }
        AnnotationMirror mirror = ASTHelpers.getAnnotationMirror((AnnotationTree)annotationTree);
        List values = MoreAnnotations.asStrings((AnnotationValue)AnnotationMirrors.getAnnotationValue((AnnotationMirror)mirror, (String)"value")).map(v -> v.equals("deprecated") ? "deprecation" : v).map(arg_0 -> ((VisitorState)state).getConstantExpression(arg_0)).collect(Collectors.toList());
        return this.describeMatch(annotationTree, (Fix)SuggestedFixes.updateAnnotationArgumentValues((AnnotationTree)annotationTree, (VisitorState)state, (String)"value", values).build());
    }
}

