/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Set;

@BugPattern(summary="Do not extend an @AutoValue/@AutoOneOf class in non-generated code.", severity=BugPattern.SeverityLevel.ERROR)
public final class ExtendsAutoValue
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Supplier<ImmutableSet<Name>> AUTOS = VisitorState.memoize((Supplier & Serializable)s -> ImmutableSet.of((Object)s.getName("com.google.auto.value.AutoValue"), (Object)s.getName("com.google.auto.value.AutoOneOf")));

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getExtendsClause() == null) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.annotationsAmong((Symbol)ASTHelpers.getSymbol((Tree)tree.getExtendsClause()), (Set)((Set)AUTOS.get(state)), (VisitorState)state).isEmpty() && !ExtendsAutoValue.isInGeneratedCode(state)) {
            return this.buildDescription(tree).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean isInGeneratedCode(VisitorState state) {
        return !ASTHelpers.getGeneratedBy((VisitorState)state).isEmpty();
    }
}

