/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Make toString(), hashCode() and equals() final in AutoValue classes, so it is clear to readers that AutoValue is not overriding them", severity=BugPattern.SeverityLevel.WARNING)
public class AutoValueFinalMethods
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String MEMOIZED = "com.google.auto.value.extension.memoized.Memoized";
    private static final Matcher<MethodTree> METHOD_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.PUBLIC), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT)), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.FINAL)), Matchers.not((Matcher)Matchers.hasAnnotation((String)"com.google.auto.value.extension.memoized.Memoized")), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.equalsMethodDeclaration(), Matchers.toStringMethodDeclaration(), Matchers.hashCodeMethodDeclaration()})});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Tree)tree, (String)"com.google.auto.value.AutoValue", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ArrayList<String> matchedMethods = new ArrayList<String>();
        MethodTree firstMatchedMethod = null;
        for (Tree tree2 : tree.getMembers()) {
            Optional optionalSuggestedFix;
            MethodTree method;
            if (!(tree2 instanceof MethodTree) || !METHOD_MATCHER.matches((Tree)(method = (MethodTree)tree2), state) || !(optionalSuggestedFix = SuggestedFixes.addModifiers((Tree)method, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).isPresent()) continue;
            matchedMethods.add(method.getName().toString());
            fix.merge((SuggestedFix)optionalSuggestedFix.get());
            if (firstMatchedMethod != null) continue;
            firstMatchedMethod = method;
        }
        if (!fix.isEmpty()) {
            String message = String.format("Make %s final in AutoValue classes, so it is clear to readers that AutoValue is not overriding them", Joiner.on((String)", ").join(matchedMethods));
            return this.buildDescription(firstMatchedMethod).setMessage(message).addFix((Fix)fix.build()).build();
        }
        return Description.NO_MATCH;
    }
}

