#include <stdio.h>

main()
{
	char name[40];
	int next, num=0, count;

	FILE *infile = fopen("short_coeffs.h", "r");
	FILE *outfile = fopen("eval.h", "w");
	FILE *namefile = fopen("names.h", "w");

	fprintf(outfile, "/* this file is automatically generated. do not edit */\n\n");
	fprintf(outfile, "extern etype *coefficients;\n");
	fprintf(outfile, "extern etype new_coefficients[];\n");
	fprintf(outfile, "extern etype orig_coefficients[];\n\n");

	fprintf(namefile, "static struct coefficient_name {\n     char *name;\n     int index;\n} coefficient_names[] = {\n");

	while ((next = fgetc(infile)) != '{') {
	}

	while ((next = fgetc(infile)) != ';') {
		if (next == '*') {
			fscanf(infile, "%s */", name);
			fprintf(outfile, "#define %s ", name);
			fprintf(namefile, "{\"");

			count = 0;
			while ((next = fgetc(infile)) != '/' && next != '}') {
				if (next == ',') {
					++count;
				}
			}
			if (count == 1) {
				fprintf(outfile, "coefficients[%d]\n", num);
				fflush(outfile);
			} else {
				fprintf(outfile, "%d\n", num);
				fflush(outfile);
			}

			fprintf(namefile, "%s\", %d},\n", name, num);
			num += count;
		}
	} 
	
	fprintf(outfile, "#define __TOTAL_COEFFS__ %d\n", num*4);
	fprintf(namefile, "{NULL, __COEFFS_PER_STAGE__}};\n");
}





