/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "protos.h"
#include "text_ext.h"




/* SEARCH FUNCTIONS */

/* PUBLIC :
 * is_text_ext
 */
char
is_text_ext (char *EXT)
{
  return (strstr (text_ext, strupr (EXT)) != NULL);
}



/* IO FUNCTIONS */

/* PUBLIC :
 * text_ext_read 
 * STATIC :
 * text_ext_write
 */

void
text_ext_read (void)
{
  FILE *ext_file;
  char this_path[MPLEN];
  char this_line[1024];

  text_ext_path (this_path);

  if (access (this_path, R_OK))
    {
      strcpy (text_ext, ASCII_FILES_DEFAULT_EXTENSIONS);
      text_ext_write ();
    }
  else
    {
      if ((ext_file = fopen (this_path, "r")) == NULL)
	{
	  strcpy (text_ext, ASCII_FILES_DEFAULT_EXTENSIONS);
	  return;
	}

      MEM0 (text_ext);
      while (fgets (this_line, sizeof (this_line), ext_file) != NULL)
	{
	  if (this_line[strlen (this_line) - 1] == '\n')
	    this_line[strlen (this_line) - 1] = 0;

	  if (!strlen (this_line))
	    continue;

	  if (this_line[0] == '#')
	    continue;
	  strcat (text_ext, ".");
	  strcat (text_ext, this_line);
	}
    }

}


static void
text_ext_write (void)
{
  FILE *ext_file;
  char this_path[MPLEN];
  gchar *ext_buf = g_strdup (text_ext);
  gchar *ptr;

  while ((ptr = strchr (ext_buf, '.')) != NULL)
    *ptr = '\n';

  text_ext_path (this_path);

  if ((ext_file = fopen (this_path, "w")) == NULL)
    {
      g_free (ext_buf);
      return;
    }

  fprintf (ext_file, "# IglooFTP ASCII extensions configuration file.\n%s\n\n# END OF IglooFTP ASCII extensions configuration file.", ext_buf);
  fclose (ext_file);

  g_free (ext_buf);
}








/* EXTENSION FUNCTIONS */

/* PUBLIC:
 * add_ext_dialog
 * add_ext
 * delete_ext
 * edit_ext
 * edit_ext_dialog 
 */


/* ADD */
static void
add_ext (GtkWidget * widget, GtkWidget * entry)
{
  GtkWidget *alert_window = gtk_widget_get_toplevel (entry);
  char buf[256];
  char *col[] =
  {""};

  strcpy (buf, gtk_entry_get_text (GTK_ENTRY (entry)));
  gtk_widget_destroy (alert_window);

  if (strlen (buf))
    {
      col[0] = strupr (buf);
      gtk_clist_append (GTK_CLIST (clist), col);
      gtk_clist_sort (GTK_CLIST (clist));
    }
}

static void
add_ext_dialog (GtkWidget * widget, gpointer data)
{
  entry_dialog ("Add ASCII file extension", "File extension :", "Add", "", GTK_SIGNAL_FUNC (add_ext));
}


/* DELETE */
static void
delete_ext (GtkWidget * widget, gpointer data)
{
  GList *selection = GTK_CLIST (clist)->selection;
  if (selection == NULL)
    return;
  gtk_clist_remove (GTK_CLIST (clist), GPOINTER_TO_INT (selection->data));
}


/* EDIT */
static void
edit_ext (GtkWidget * widget, GtkWidget * entry)
{
  GtkWidget *alert_window = gtk_widget_get_toplevel (entry);
  char buf[256];

  strcpy (buf, gtk_entry_get_text (GTK_ENTRY (entry)));
  gtk_widget_destroy (alert_window);

  if (strlen (buf))
    {
      GList *selection = GTK_CLIST (clist)->selection;
      int row = GPOINTER_TO_INT (selection->data);
      gtk_clist_set_text (GTK_CLIST (clist), row, 0, strupr (buf));
      gtk_clist_select_row (GTK_CLIST (clist), row, 0);
      gtk_clist_sort (GTK_CLIST (clist));
      row = GPOINTER_TO_INT (selection->data);
      gtk_clist_moveto (GTK_CLIST (clist), row, 0, 0.5, 0);
    }
}

static void
edit_ext_dialog (GtkWidget * widget, gpointer data)
{
  GList *selection = GTK_CLIST (clist)->selection;
  gchar *buf = NULL;
  if (selection == NULL)
    return;
  gtk_clist_get_text (GTK_CLIST (clist), GPOINTER_TO_INT (selection->data), 0, &buf);
  entry_dialog ("Edit ASCII file extension", "File extension :", "Update", buf, GTK_SIGNAL_FUNC (edit_ext));
}







/* TEXT_EXT DIALOG */

/* PUBLIC :
 * text_ext_dialog
 * STATIC :
 * update_button_ext 
 */

static void
save_text_ext (GtkWidget * widget, gpointer data)
{
  GtkWidget *alert_window = gtk_widget_get_toplevel (widget);
  gchar *buf;
  int row = 0;

  MEM0 (text_ext);
  while (gtk_clist_get_text (GTK_CLIST (clist), row++, 0, &buf))
    {
      strcat (text_ext, ".");
      strcat (text_ext, buf);
    }
  text_ext_write ();

  gtk_widget_destroy (alert_window);
}



void
text_ext_dialog (void)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  GtkWidget *clist_window;
  GtkWidget *fixed_top;
  GtkWidget *button_ext_add;
  gchar *clist_titles[] =
  {" Extensions"};


  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, "ASCII files extensions", &alert_vbox);

  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);
  gtk_widget_set_usize (fixed_top, 300, 170);

  gtk_box_pack_start (GTK_BOX (alert_vbox), fixed_top, TRUE, TRUE, 0);

  clist = gtk_clist_new_with_titles (1, clist_titles);
  gtk_widget_show (clist);

  gtk_clist_column_titles_show (GTK_CLIST (clist));
  gtk_clist_set_row_height (GTK_CLIST (clist), 16);
  gtk_clist_set_selection_mode (GTK_CLIST (clist), GTK_SELECTION_SINGLE);
  gtk_clist_set_auto_sort (GTK_CLIST (clist), TRUE);

  gtk_signal_connect (GTK_OBJECT (clist), "select_row", GTK_SIGNAL_FUNC (update_button_ext), NULL);
  gtk_signal_connect (GTK_OBJECT (clist), "unselect_row", GTK_SIGNAL_FUNC (update_button_ext), NULL);


  clist_window = scroll_win ();
  gtk_container_add (GTK_CONTAINER (clist_window), clist);
  gtk_fixed_put (GTK_FIXED (fixed_top), clist_window, 10, 10);
  gtk_widget_set_usize (clist_window, 150, 150);


  {
    char *tmp_text_ext = g_strdup (text_ext);
    char *ptr;
    char *col[] =
    {""};
    while ((ptr = strrchr (tmp_text_ext, '.')) != NULL)
      {
	col[0] = strupr (ptr + 1);
	gtk_clist_append (GTK_CLIST (clist), col);
	*ptr = 0;
      }
    g_free (tmp_text_ext);
  }


  {
    GtkWidget *alert_frame = fixed_frame (fixed_top, 170, 10, 120, 88, NULL);
    gtk_frame_set_shadow_type (GTK_FRAME (alert_frame), GTK_SHADOW_IN);
    alert_vbox1 = v_box (alert_frame, FALSE, 0, 2);
  }

  button_ext_add = fixed_button (alert_vbox1, "Add");
  button_ext_edit = fixed_button (alert_vbox1, "Edit");
  button_ext_delete = fixed_button (alert_vbox1, "Delete");
  gtk_widget_set_sensitive (button_ext_edit, FALSE);
  gtk_widget_set_sensitive (button_ext_delete, FALSE);

  gtk_signal_connect (GTK_OBJECT (button_ext_add), "clicked", GTK_SIGNAL_FUNC (add_ext_dialog), NULL);
  gtk_signal_connect (GTK_OBJECT (button_ext_edit), "clicked", GTK_SIGNAL_FUNC (edit_ext_dialog), NULL);
  gtk_signal_connect (GTK_OBJECT (button_ext_delete), "clicked", GTK_SIGNAL_FUNC (delete_ext), NULL);


  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);


  alert_button = box_button (alert_hbox, "Save");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (save_text_ext), NULL);

  alert_button = box_button (alert_hbox, "Cancel");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (alert_window));

  gtk_widget_show_all (alert_window);

}


static void
update_button_ext (GtkWidget * this_list, gint row, gint column, GdkEventButton * event, gpointer data)
{
  GList *selection = GTK_CLIST (clist)->selection;
  gtk_widget_set_sensitive (button_ext_edit, selection != NULL);
  gtk_widget_set_sensitive (button_ext_delete, selection != NULL);

  if (event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    edit_ext_dialog (NULL, NULL);

}



/* EOF */
