/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */



#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtkstyle.h>

#include "protos.h"







/* TEXT Functions */

/* PUBLIC :
 * clear_text
 * realize_text
 * create_text_area 
 * text_copy_to_clipboard
 * text_cut_to_clipboard 
 * text_paste_from_clipboard
 */



void
clear_text (GtkWidget * this_text)
{
  gtk_text_freeze (GTK_TEXT (this_text));
  gtk_text_set_point (GTK_TEXT (this_text), 0);
  gtk_text_forward_delete (GTK_TEXT (this_text), gtk_text_get_length (GTK_TEXT (this_text)));
  gtk_text_thaw (GTK_TEXT (this_text));
}



void
realize_text (GtkWidget * this_text, gpointer data)
{
  gtk_text_freeze (GTK_TEXT (this_text));
  gtk_text_insert (GTK_TEXT (this_text), NULL, &this_text->style->black, NULL, data, -1);
  gtk_text_thaw (GTK_TEXT (this_text));
}

void
text_copy_to_clipboard (GtkWidget * widget, GtkWidget * this_text)
{
  gtk_editable_copy_clipboard (GTK_EDITABLE (this_text));
}

void
text_cut_to_clipboard (GtkWidget * widget, GtkWidget * this_text)
{
  gtk_editable_cut_clipboard (GTK_EDITABLE (this_text));
}

void
text_paste_from_clipboard (GtkWidget * widget, GtkWidget * this_text)
{
  gtk_editable_paste_clipboard (GTK_EDITABLE (this_text));
}

void
text_select_all (GtkWidget * widget, GtkWidget * this_text)
{
  gtk_editable_select_region (GTK_EDITABLE (this_text), 0, gtk_text_get_length (GTK_TEXT (this_text)));
}




void
create_text_area (GtkWidget * this_text, GtkWidget * vbox)
{
  GtkWidget *table;
  //GtkWidget *hscrollbar;
  GtkWidget *vscrollbar;


  table = gtk_table_new (2, 2, FALSE);
  gtk_table_attach (GTK_TABLE (table), this_text, 0, 1, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 0);
  gtk_widget_show (this_text);

/* hscrollbar = gtk_hscrollbar_new (GTK_TEXT (this_text)->hadj);
   gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
   GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);
   gtk_widget_show (hscrollbar);
 */

  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (this_text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show (vscrollbar);

  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
  gtk_widget_show (table);
}



/* EOF */
