/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "protos.h"


static char hex2char (char *buf);








/* STRING Functions */

/* PUBLIC :
 * strexpand
 * strupr 
 * strmode
 * MemFrob
 */


char *
strexpand (char *string, char *search_string, char *replace_string)
{
  int string_index = 0, sub_index, string_len;
  char sub_string[50], new_string[2048];

  string_len = strlen (string);
  strcpy (new_string, "");
  do
    {
      sub_index = 0;
      strcpy (sub_string, "");
      while ((string[string_index]) && (string[string_index] != 32))
	sub_string[sub_index++] = string[string_index++];
      sub_string[sub_index] = 0;
      if (!strcmp (sub_string, search_string))
	strcpy (sub_string, replace_string);
      strcat (new_string, sub_string);
      strcat (new_string, " ");
    }
  while (++string_index < string_len);

  strcpy (string, new_string);
  string[strlen (string) - 1] = 0;
  return string;
}



char *
strupr (char *string)
{
  register int f;

  for (f = 0; f < strlen (string); f++)
    if (islower (string[f]))
      string[f] = toupper (string[f]);
  return string;
}


char *
strlwr (char *string)
{
  register int f;

  for (f = 0; f < strlen (string); f++)
    if (isupper (string[f]))
      string[f] = tolower (string[f]);
  return string;
}



char *
strunlf (char *string)
{
  register int f;

  for (f = 0; f < strlen (string); f++)
    if (string[f] == '\n')
      string[f] = '|';
  return string;
}

char *
strlf (char *string)
{
  register int f;

  for (f = 0; f < strlen (string); f++)
    if (string[f] == '|')
      string[f] = '\n';
  return string;
}





char *
StrMode (char *buf, mode_t mode)
{
  strcpy (buf, "----------");

  if ((mode & S_IFMT) == S_IFDIR)
    buf[0] = 'd';
  if ((mode & S_IFMT) == S_IFLNK)
    buf[0] = 'l';
  if (mode & S_IREAD)
    buf[1] = 'r';
  if (mode & S_IWRITE)
    buf[2] = 'w';
  if (mode & S_IEXEC)
    buf[3] = 'x';
  if (mode & S_IRGRP)
    buf[4] = 'r';
  if (mode & S_IWGRP)
    buf[5] = 'w';
  if (mode & S_IXGRP)
    buf[6] = 'x';
  if (mode & S_IROTH)
    buf[7] = 'r';
  if (mode & S_IWOTH)
    buf[8] = 'w';
  if (mode & S_IXOTH)
    buf[9] = 'x';

  return buf;
}


char *
StrNumMode (char *buf_mode, char *perm)
{
  sprintf (buf_mode, "%04i", (perm[1] == 'r') * 400 + (perm[2] == 'w') * 200 + (perm[3] == 'x') * 100 + (perm[4] == 'r') * 40 + (perm[5] == 'w') * 20 + (perm[6] == 'x') * 10 + (perm[7] == 'r') * 4 + (perm[8] == 'w') * 2 + (perm[9] == 'x'));
  return buf_mode;
}


char *
MemFrob (void *buf, size_t buf_len)
{
  register char *ptr = (char *) buf;
  while (buf_len--)
    *ptr++ ^= 42;
  return buf;
}



static char
hex2char (char *buf)
{
  register char digit;

  digit = (buf[0] >= 'A' ? ((buf[0] & 0xdf) - 'A') + 10 : (buf[0] - '0'));
  digit *= 16;
  digit += (buf[1] >= 'A' ? ((buf[1] & 0xdf) - 'A') + 10 : (buf[1] - '0'));
  return (digit);
}



char *
decode_url (char *this_url)
{
  register int x, y;
  for (x = 0, y = 0; this_url[y]; ++x, ++y)
    if ((this_url[x] = this_url[y]) == '%')
      {
	this_url[x] = hex2char (&this_url[y + 1]);
	y += 2;
      }
  this_url[x] = '\0';
  return this_url;
}


char
parse_ftp_url (char *this_url, char *this_user, char *this_pass, char *this_host, char *this_port, char *this_dir, char *this_file, char *this_type)
{
  char *url_start_ptr = NULL;
  char *host_start_ptr = NULL;
  char *host_end_ptr = NULL;
  char *usr_start_ptr = NULL;
  char *port_start_ptr = NULL;
  char *dir_start_ptr = NULL;
  char *file_start_ptr = NULL;
  char *type_start_ptr = NULL;
  char *that_url = g_strdup (this_url);

  if ((strstr (that_url, "http://")) || ((url_start_ptr = strstr (that_url, "//")) == NULL))
    {
      g_free (that_url);
      return FALSE;
    }




  if ((type_start_ptr = strstr (that_url, ";type=")) != NULL)
    {
      strcpy (this_type, (char *) type_start_ptr + 6);
      *type_start_ptr = 0;
    }



  host_start_ptr = strchr (that_url, '@');

  if (host_start_ptr == NULL)
    host_start_ptr = (char *) url_start_ptr + 2;
  else
    {
      host_start_ptr++;
      usr_start_ptr = (char *) url_start_ptr + 2;
    }



  if (usr_start_ptr != NULL)
    {
      char *usr_end_ptr = (char *) host_start_ptr - 1;
      char *pass_start_ptr = strchr (usr_start_ptr, ':');

      if ((pass_start_ptr != NULL) && (pass_start_ptr < host_start_ptr))
	{
	  strncpy (this_pass, ++pass_start_ptr, (size_t) ((char *) usr_end_ptr - (char *) pass_start_ptr - 1));
	  usr_end_ptr = --pass_start_ptr;
	}

      strncpy (this_user, usr_start_ptr, (size_t) ((char *) usr_end_ptr - (char *) usr_start_ptr));
    }
  else
    {
      strcpy (this_user, "anonymous");
      strcpy (this_pass, user_rc.default_session.userpass);
    }



  if ((dir_start_ptr = strchr (host_start_ptr, '/')) != NULL)
    {
      strcpy (this_dir, dir_start_ptr + 1);
      if ((file_start_ptr = strrchr (this_dir, '/')) != NULL)
	{
	  if (strchr (file_start_ptr, '.') != NULL)
	    {
	      strcpy (this_file, file_start_ptr + 1);
	      *file_start_ptr = 0;
	    }
	}


      if ((port_start_ptr = strchr (host_start_ptr, ':')) != NULL)
	{
	  host_end_ptr = port_start_ptr;
	  strncpy (this_port, ++port_start_ptr, (size_t) ((char *) dir_start_ptr - (char *) port_start_ptr - 1));
	}
      else
	host_end_ptr = dir_start_ptr;

      strncpy (this_host, host_start_ptr, (size_t) ((char *) host_end_ptr - (char *) host_start_ptr));
    }
  else
    strcpy (this_host, host_start_ptr);


  decode_url (this_user);
  decode_url (this_pass);
  decode_url (this_host);
  decode_url (this_dir);
  decode_url (this_file);


  g_free (that_url);
  return TRUE;
}



/*
   void
   test_url_parse (char *this_url)
   {
   char this_user[256];
   char this_pass[256];
   char this_host[256];
   char this_port[256];
   char this_dir[256];
   char this_file[256];
   char this_type[256];

   MEM0 (this_user);
   MEM0 (this_pass);
   MEM0 (this_host);
   MEM0 (this_port);
   MEM0 (this_dir);
   MEM0 (this_file);
   MEM0 (this_type);

   parse_ftp_url (this_url, this_user, this_pass, this_host, this_port, this_dir, this_file, this_type);

   printf ("\n");
   _HERE (this_url);
   printf ("user: [%s]\n", this_user);
   printf ("pass: [%s]\n", this_pass);
   printf ("host: [%s]\n", this_host);
   printf ("port: [%s]\n", this_port);
   printf ("dir : [%s]\n", this_dir);
   printf ("file: [%s]\n", this_file);
   printf ("type: [%s]\n", this_type);
   }


   test_url_parse ("ftp://username:password@host:22/dir/dir");
   test_url_parse ("ftp://user_without_password@host:223/dir/file.tgz");
   test_url_parse ("ftp://host:2/dir/file");
   test_url_parse ("ftp://host/dir/file");
   test_url_parse ("ftp://ftp.littleigloo.org");
   test_url_parse ("ftp://username:@ftp.littleigloo.org;type=d");
 */


/* EOF */
