/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


static GtkWidget *site_window;
static GtkWidget *site_entry_name;
static GtkWidget *site_entry_address;
static GtkWidget *site_entry_port;
static GtkWidget *site_entry_local_dir;
static GtkWidget *site_entry_remote_dir;
static GtkWidget *site_combo_user;
#define SITE_ENTRY_USER GTK_ENTRY(GTK_COMBO (site_combo_user)->entry)
static GtkWidget *site_entry_pass;
static GtkWidget *site_text_comment;
static GtkWidget *site_check_PASV;
static GtkWidget *site_check_resolve_lnk;
static GtkWidget *site_check_use_RDC;
static GtkWidget *site_check_use_default;
static GtkWidget *site_advanced_page;
static GtkWidget *site_advanced_tab;
static GtkWidget *site_transfer_page;
static GtkWidget *site_transfer_tab;
static GtkWidget *password_optionmenu;

static GtkWidget *site_downloads_preserve_perm;
static GtkWidget *site_downloads_preserve_date;
static GtkWidget *site_uploads_preserve_perm;
static GtkWidget *site_uploads_preserve_date;

static char site_host_type;
static char site_transfert_mode;
static char site_password_type;
static char site_uploads_filename_case;
static char site_downloads_filename_case;

static void site_notebook (MANAGERsite * this_site, char *notebook_tittle);
static void set_site_password (GtkWidget * widget, gpointer data);
static void set_site_transfert_mode (GtkWidget * widget, gpointer data);
static void set_site_host_type (GtkWidget * widget, gpointer data);
static void set_site_downloads_filename_case (GtkWidget * widget, gpointer data);
static void set_site_uploads_filename_case (GtkWidget * widget, gpointer data);
static void site_notebook_show_hide_advanced_page (char FLAG);
static void site_toggle_use_default (GtkWidget * widget, MANAGERsite * this_site);
static void site_fill_combo_user (void);
static void site_combo_user_new_selection (GtkWidget * entry, MANAGERsite * this_site);
static void site_notebook_ok (GtkWidget * entry, MANAGERsite * this_site);
static void site_notebook_cancel (GtkWidget * entry, MANAGERsite * this_site);




/* SITE NOTEBOOK */

/* PUBLIC:
 * STATIC:
 * site_notebook
 * set_site_password
 * set_site_transfert_mode
 * set_site_host_type
 * set_site_uploads_filename_case
 * set_site_downloads_filename_case
 * site_notebook_show_hide_advanced_page
 * site_toggle_use_default 
 * site_fill_combo_user
 * site_combo_user_new_selection
 * site_notebook_ok 
 * site_notebook_cancel 
 */

static void
site_notebook (MANAGERsite * this_site, char *notebook_tittle)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *hbbox;
  GtkWidget *notebook;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;
  GtkWidget *button_help;
  GtkWidget *fixed_top;
  GtkWidget *optionmenu;
  GtkWidget *optionmenu_menu;
  GtkWidget *menuitem;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  gint x, y;

  gdkpixmap = man_site_pixmap (&mask);

  site_host_type = this_site->session.host_type;
  site_transfert_mode = this_site->session.tmode;

  if (!strcmp (this_site->session.userpass, SITE_DEFAULT_PASSWORD_TEXT))
    site_password_type = PASSWORD_USE_DEFAULT;
  else if (!strcmp (this_site->session.userpass, SITE_ASK_PASSWORD_TEXT))
    site_password_type = PASSWORD_ASK_ON_CONNECT;
  else
    site_password_type = PASSWORD_USE_SAVED;

  site_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_MOUSE, notebook_tittle, &vbox);
  gtk_window_set_policy (GTK_WINDOW (site_window), FALSE, FALSE, FALSE);
  gdk_window_get_origin (window->window, &x, &y);
  gtk_widget_set_uposition (site_window, x, y);

  gtk_box_set_spacing (GTK_BOX (vbox), 5);
  gtk_widget_set_usize (vbox, 450, -1);
  gtk_container_border_width (GTK_CONTAINER (vbox), 7);

  notebook = gtk_notebook_new ();
  gtk_widget_show (notebook);
  gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
  gtk_notebook_popup_enable (GTK_NOTEBOOK (notebook));


  /* -- General Settings Panel -- */

  fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);
  gtk_widget_set_usize (fixed_top, -1, 345);



  fixed_frame (fixed_top, 10, 5, 413, 150, " FTP Site :  ");

  fixed_label (fixed_top, 25, 30, "Name :");
  site_entry_name = fixed_entry (fixed_top, 160, 25, 247, 24, this_site->name);

  fixed_label (fixed_top, 25, 60, "Address / Port :");
  site_entry_address = fixed_entry (fixed_top, 160, 55, 198, 24, this_site->session.hostname);
  {
    char port_buf[10];
    sprintf (port_buf, "%i", this_site->session.port);
    site_entry_port = fixed_entry (fixed_top, 360, 55, 47, 24, port_buf);
  }

  fixed_label (fixed_top, 25, 90, "Comment :");

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_fixed_put (GTK_FIXED (fixed_top), hbox, 160, 85);
  gtk_widget_show (hbox);

  site_text_comment = gtk_text_new (NULL, NULL);
  gtk_widget_set_usize (site_text_comment, 232, 60);
  create_text_area (site_text_comment, hbox);
  gtk_text_set_editable (GTK_TEXT (site_text_comment), TRUE);
  realize_text (site_text_comment, this_site->comment);



  fixed_frame (fixed_top, 10, 160, 413, 115, " User :  ");

  fixed_label (fixed_top, 25, 185, "Name :");

  site_combo_user = gtk_combo_new ();
  gtk_widget_set_usize (site_combo_user, 247, -1);
  gtk_widget_set_usize (GTK_COMBO (site_combo_user)->entry, 247, 24);
  gtk_widget_show (site_combo_user);
  gtk_fixed_put (GTK_FIXED (fixed_top), site_combo_user, 160, 180);
  site_fill_combo_user ();
  gtk_entry_set_text (SITE_ENTRY_USER, this_site->session.username);

  gtk_signal_connect (GTK_OBJECT (SITE_ENTRY_USER), "changed",
		GTK_SIGNAL_FUNC (site_combo_user_new_selection), this_site);


  fixed_label (fixed_top, 25, 215, "Password :");
  site_entry_pass = fixed_entry (fixed_top, 160, 210, 247, 24, "");
  gtk_entry_set_visibility (GTK_ENTRY (site_entry_pass), FALSE);

  password_optionmenu = optionmenu = gtk_option_menu_new ();
  gtk_widget_show (optionmenu);
  gtk_fixed_put (GTK_FIXED (fixed_top), optionmenu, 160, 240);
  gtk_widget_set_usize (optionmenu, 249, 26);
  optionmenu_menu = gtk_menu_new ();
  menuitem = append_option_menu_item (optionmenu_menu, "Save Password");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_password), GINT_TO_POINTER (PASSWORD_USE_SAVED));
  menuitem = append_option_menu_item (optionmenu_menu, "Use Default Email Address");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_password), GINT_TO_POINTER (PASSWORD_USE_DEFAULT));
  menuitem = append_option_menu_item (optionmenu_menu, "Ask for Password on Connect");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_password), GINT_TO_POINTER (PASSWORD_ASK_ON_CONNECT));
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), optionmenu_menu);

  gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), site_password_type);

  if (site_password_type == PASSWORD_USE_SAVED)
    {
      MemFrob (this_site->session.userpass, strlen (this_site->session.userpass));
      gtk_entry_set_text (GTK_ENTRY (site_entry_pass), this_site->session.userpass);
      MemFrob (this_site->session.userpass, strlen (this_site->session.userpass));
    }
  else
    gtk_widget_set_sensitive (site_entry_pass, FALSE);







  fixed_frame (fixed_top, 10, 280, 413, 55, " Advanced Options :  ");

  site_check_use_default = fixed_check (fixed_top, 160, 300, "USE USER DEFAULTS", this_site->USE_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (site_check_use_default), "clicked", GTK_SIGNAL_FUNC (site_toggle_use_default), this_site);



  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, notebook_label (gtk_pixmap_new (gdkpixmap, mask), " General settings  "));



  /* ADVANCED TAB */

  site_advanced_page = fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);


  fixed_frame (fixed_top, 10, 5, 413, 55, " User :  ");
  fixed_label (fixed_top, 25, 30, "Account :");
  gtk_widget_set_sensitive (fixed_entry (fixed_top, 160, 25, 247, 24, ""), FALSE);



  fixed_frame (fixed_top, 10, 65, 413, 85, " Directories :  ");

  fixed_label (fixed_top, 25, 90, "Local :");
  site_entry_local_dir = fixed_dir_entry (fixed_top, 160, 85, 247, 24, this_site->session.local_dir);

  fixed_label (fixed_top, 25, 120, "Remote :");
  site_entry_remote_dir = fixed_entry (fixed_top, 160, 115, 247, 24, this_site->session.start_dir);



  fixed_frame (fixed_top, 10, 155, 413, 105, " Options :  ");

  fixed_label (fixed_top, 25, 180, "Host Type : ");
  optionmenu = gtk_option_menu_new ();
  gtk_widget_show (optionmenu);
  gtk_fixed_put (GTK_FIXED (fixed_top), optionmenu, 120, 175);
  gtk_widget_set_usize (optionmenu, 110, 24);
  optionmenu_menu = gtk_menu_new ();
  menuitem = append_option_menu_item (optionmenu_menu, "Auto Detect");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_host_type), GINT_TO_POINTER (HOST_AUTODETECT));
  menuitem = append_option_menu_item (optionmenu_menu, "Unix");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_host_type), GINT_TO_POINTER (HOST_UNIX));
  menuitem = append_option_menu_item (optionmenu_menu, "SunOS");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_host_type), GINT_TO_POINTER (HOST_SUNOS));
  menuitem = append_option_menu_item (optionmenu_menu, "Windows NT");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_host_type), GINT_TO_POINTER (HOST_WIN_NT));
  menuitem = append_option_menu_item (optionmenu_menu, "VMS");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_host_type), GINT_TO_POINTER (HOST_VMS));
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), optionmenu_menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), this_site->session.host_type);


  fixed_label (fixed_top, 25, 210, "Transfer Type : ");
  optionmenu = gtk_option_menu_new ();
  gtk_widget_show (optionmenu);
  gtk_fixed_put (GTK_FIXED (fixed_top), optionmenu, 120, 205);
  gtk_widget_set_usize (optionmenu, 110, 24);
  optionmenu_menu = gtk_menu_new ();
  menuitem = append_option_menu_item (optionmenu_menu, "Auto Detect");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_transfert_mode), GINT_TO_POINTER (TYPE_AUTODETECT));
  menuitem = append_option_menu_item (optionmenu_menu, "ASCII");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_transfert_mode), GINT_TO_POINTER (TYPE_ASCII));
  menuitem = append_option_menu_item (optionmenu_menu, "Bin/Image");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_transfert_mode), GINT_TO_POINTER (TYPE_IMAGE));
  menuitem = append_option_menu_item (optionmenu_menu, "Local");
  gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (set_site_transfert_mode), GINT_TO_POINTER (TYPE_LOCAL));
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu), optionmenu_menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (optionmenu), this_site->session.tmode);


  site_check_resolve_lnk = fixed_check (fixed_top, 260, 170, "Resolve Links", this_site->session.resolve_link);
  site_check_PASV = fixed_check (fixed_top, 260, 196, "PASV", (this_site->session.dmode == PASV_MODE));
  site_check_use_RDC = fixed_check (fixed_top, 260, 220, "Enable RDC", this_site->session.use_RDC);


  site_advanced_tab = notebook_label (gtk_pixmap_new (gdkpixmap, mask), " Advanced    ");
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, site_advanced_tab);




  /* TRANSFER TAB */

  site_transfer_page = fixed_top = gtk_fixed_new ();
  gtk_widget_show (fixed_top);

  fixed_frame (fixed_top, 10, 5, 200, 170, " Uploads :  ");
#define RADIO_ARG(a)  set_site_uploads_filename_case, GINT_TO_POINTER (a), (this_site->session.uploads_filename== a)
  {
    GtkWidget *radio = fixed_radio (fixed_top, NULL, "Preserve Filename Case", 20, 26, RADIO_ARG (XFER_FILENAME_PRESERVE));
    radio = fixed_radio (fixed_top, radio, "Force Filename Uppercase", 20, 51, RADIO_ARG (XFER_FILENAME_UPPER));
    radio = fixed_radio (fixed_top, radio, "Force Filename Lowercase", 20, 76, RADIO_ARG (XFER_FILENAME_LOWER));
  }
#undef RADIO_ARG

  site_uploads_preserve_perm = fixed_check (fixed_top, 20, 111, "Preserve Permissions", this_site->session.uploads_perm);
  site_uploads_preserve_date = fixed_check (fixed_top, 20, 136, "TimeStamp Local Files", this_site->session.uploads_date);


  fixed_frame (fixed_top, 220, 5, 200, 170, " Downloads :  ");
#define RADIO_ARG(a)  set_site_downloads_filename_case, GINT_TO_POINTER (a), (this_site->session.downloads_filename== a)
  {
    GtkWidget *radio = fixed_radio (fixed_top, NULL, "Preserve Filename Case", 230, 26, RADIO_ARG (XFER_FILENAME_PRESERVE));
    radio = fixed_radio (fixed_top, radio, "Force Filename Uppercase", 230, 51, RADIO_ARG (XFER_FILENAME_UPPER));
    radio = fixed_radio (fixed_top, radio, "Force Filename Lowercase", 230, 76, RADIO_ARG (XFER_FILENAME_LOWER));
  }
#undef RADIO_ARG

  site_downloads_preserve_perm = fixed_check (fixed_top, 230, 111, "Preserve Permissions", this_site->session.downloads_perm);
  site_downloads_preserve_date = fixed_check (fixed_top, 230, 136, "Preserve Date", this_site->session.downloads_date);


  site_transfer_tab = notebook_label (gtk_pixmap_new (gdkpixmap, mask), " Transfer    ");
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), fixed_top, site_transfer_tab);


/*--- Notebook Buttons ---*/

  hbox = h_box (vbox, FALSE, 0, 0);

  {
    GtkWidget *pixmap = smanager_pixmap (site_window);
    gtk_box_pack_start (GTK_BOX (hbox), pixmap, FALSE, FALSE, 0);
    gtk_widget_show (pixmap);
  }

  hbbox = hbutton_box (hbox);
  gtk_container_border_width (GTK_CONTAINER (hbbox), 0);

  button_ok = box_button (hbbox, "Done");
  button_cancel = box_button (hbbox, "Cancel");
  gtk_widget_set_sensitive (button_help = box_button (hbbox, "Help"), FALSE);

  gtk_signal_connect (GTK_OBJECT (button_ok), "clicked", GTK_SIGNAL_FUNC (site_notebook_ok), this_site);
  gtk_signal_connect (GTK_OBJECT (button_cancel), "clicked", GTK_SIGNAL_FUNC (site_notebook_cancel), this_site);
  gtk_signal_connect_object (GTK_OBJECT (button_help), "clicked", GTK_SIGNAL_FUNC (nop), NULL);


  gtk_widget_show (site_window);

  site_notebook_show_hide_advanced_page (!this_site->USE_DEFAULT);



  gdk_pixmap_unref (gdkpixmap);
  gdk_pixmap_unref (mask);
}


static void
set_site_password (GtkWidget * widget, gpointer data)
{
  switch ((site_password_type = (int) GPOINTER_TO_INT (data)))
    {
    default:
    case PASSWORD_USE_SAVED:
      gtk_widget_set_sensitive (site_entry_pass, TRUE);
      break;
    case PASSWORD_USE_DEFAULT:
      gtk_widget_set_sensitive (site_entry_pass, FALSE);
      gtk_entry_set_text (GTK_ENTRY (site_entry_pass), "");
      break;
    case PASSWORD_ASK_ON_CONNECT:
      gtk_widget_set_sensitive (site_entry_pass, FALSE);
      gtk_entry_set_text (GTK_ENTRY (site_entry_pass), "");
      break;
    }
}

static void
set_site_transfert_mode (GtkWidget * widget, gpointer data)
{
  site_transfert_mode = (int) GPOINTER_TO_INT (data);
}

static void
set_site_host_type (GtkWidget * widget, gpointer data)
{
  site_host_type = (int) GPOINTER_TO_INT (data);
}

static void
set_site_uploads_filename_case (GtkWidget * widget, gpointer data)
{
  site_uploads_filename_case = (int) GPOINTER_TO_INT (data);
}

static void
set_site_downloads_filename_case (GtkWidget * widget, gpointer data)
{
  site_downloads_filename_case = (int) GPOINTER_TO_INT (data);
}


static void
site_notebook_show_hide_advanced_page (char FLAG)
{
  if (FLAG)
    {
      gtk_widget_show (site_advanced_page);
      gtk_widget_show (site_transfer_page);
    }
  else
    {
      gtk_widget_hide (site_advanced_page);
      gtk_widget_hide (site_transfer_page);
    }
}

static void
site_toggle_use_default (GtkWidget * widget, MANAGERsite * this_site)
{
  this_site->USE_DEFAULT = !this_site->USE_DEFAULT;
  site_notebook_show_hide_advanced_page (!this_site->USE_DEFAULT);
}


static void
site_fill_combo_user (void)
{
  GList *combo_user_items = NULL;
  const int index_total = count_total_number_of_profiles ();
  register int index = 0;
  USERprof this_prof;

  combo_user_items = g_list_append (combo_user_items, "");
  combo_user_items = g_list_append (combo_user_items, "anonymous");

  if (index_total)
    for (index = 0; index < index_total; index++)
      {
	read_prof (index, &this_prof);
	combo_user_items = g_list_append (combo_user_items, strdup (this_prof.username));
      }
  gtk_combo_set_popdown_strings (GTK_COMBO (site_combo_user), combo_user_items);
  g_list_free (combo_user_items);
}


static void
site_combo_user_new_selection (GtkWidget * entry, MANAGERsite * this_site)
{
  gchar *ptr = gtk_entry_get_text (SITE_ENTRY_USER);

  site_password_type = PASSWORD_USE_SAVED;
  gtk_widget_set_sensitive (site_entry_pass, TRUE);
  gtk_option_menu_set_history (GTK_OPTION_MENU (password_optionmenu), site_password_type);

  if (!strcmp (ptr, "anonymous"))
    strcpy (this_site->session.userpass, SITE_DEFAULT_PASSWORD_TEXT);
  else if (!strcmp (ptr, ""))
    strcpy (this_site->session.userpass, "");
  else
    {
      const int index_total = count_total_number_of_profiles ();
      register int index = 0;
      USERprof this_prof;
      while (index < index_total)
	{
	  read_prof (index++, &this_prof);
	  if (!strcmp (ptr, this_prof.username))
	    {
	      index = index_total;
	      strcpy (this_site->session.userpass, this_prof.userpass);
	    }
	}
    }
  gtk_entry_set_text (GTK_ENTRY (site_entry_pass), this_site->session.userpass);
}


static void
site_notebook_ok (GtkWidget * entry, MANAGERsite * this_site)
{

  gchar *comment = gtk_editable_get_chars (GTK_EDITABLE (site_text_comment), 0, -1);
  gchar *password = gtk_entry_get_text (GTK_ENTRY (site_entry_pass));



  strcpy (this_site->comment, comment);
  g_free (comment);

  strcpy (this_site->name, gtk_entry_get_text (GTK_ENTRY (site_entry_name)));
  strcpy (this_site->session.hostname, gtk_entry_get_text (GTK_ENTRY (site_entry_address)));
  strcpy (this_site->session.username, gtk_entry_get_text ((SITE_ENTRY_USER)));
  strcpy (this_site->session.local_dir, gtk_entry_get_text (GTK_ENTRY (site_entry_local_dir)));
  strcpy (this_site->session.start_dir, gtk_entry_get_text (GTK_ENTRY (site_entry_remote_dir)));

  switch (site_password_type)
    {
    case PASSWORD_USE_SAVED:
      strcpy (this_site->session.userpass, password);
      MemFrob (this_site->session.userpass, strlen (this_site->session.userpass));
      break;
    case PASSWORD_USE_DEFAULT:
      strcpy (this_site->session.userpass, SITE_DEFAULT_PASSWORD_TEXT);
      break;
    case PASSWORD_ASK_ON_CONNECT:
      strcpy (this_site->session.userpass, SITE_ASK_PASSWORD_TEXT);
      break;
    }


  this_site->session.port = atoi (gtk_entry_get_text (GTK_ENTRY (site_entry_port)));
  this_site->session.host_type = site_host_type;
  this_site->session.tmode = site_transfert_mode;

  this_site->session.resolve_link = GTK_TOGGLE_BUTTON (site_check_resolve_lnk)->active;
  this_site->session.use_RDC = GTK_TOGGLE_BUTTON (site_check_use_RDC)->active;

  if (GTK_TOGGLE_BUTTON (site_check_PASV)->active)
    this_site->session.dmode = PASV_MODE;
  else
    this_site->session.dmode = SENDP_MODE;

  this_site->session.uploads_filename = site_uploads_filename_case;
  this_site->session.uploads_perm = GTK_TOGGLE_BUTTON (site_uploads_preserve_perm)->active;
  this_site->session.uploads_date = GTK_TOGGLE_BUTTON (site_uploads_preserve_date)->active;

  this_site->session.downloads_filename = site_downloads_filename_case;
  this_site->session.downloads_perm = GTK_TOGGLE_BUTTON (site_downloads_preserve_perm)->active;
  this_site->session.downloads_date = GTK_TOGGLE_BUTTON (site_downloads_preserve_date)->active;

  if (IS_SITE_EDITED)
    {
      SMAN_save_bookmarks_file ();
      SMAN_build_tree ();
    }
  else
    {
      this_site->node = SMAN_add_site_to_tree (this_site->parent_node, this_site, booksite);
      gtk_ctree_expand (sman_tree, this_site->parent_node);
      SMAN_SITE_list = g_list_append (SMAN_SITE_list, (MANAGERsite *) this_site);
      SMAN_save_bookmarks_file ();
    }


  gtk_widget_destroy (site_window);
}


static void
site_notebook_cancel (GtkWidget * entry, MANAGERsite * this_site)
{
  gtk_widget_destroy (site_window);
  if (!IS_SITE_EDITED)
    g_free (this_site);
}

/* EOF */
