/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <ctype.h>
#include <time.h>
#include <string.h>
#include <locale.h>

static gint remote_sort_by_size (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2);
static gint remote_sort_by_date (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2);
static gint remote_sort_by_perm (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2);



/* BY SIZE */


static gint
remote_sort_by_size (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{
  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  return (int) (atol (text1) - atol (text2));
}




/* BY DATE */


static gint
remote_sort_by_date (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{
  char *text1 = NULL;
  char *text2 = NULL;
  struct tm date1;
  struct tm date2;
  const char *format = REMOTE_DATE_FORMAT;
  int return_code;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  strptime (text1, format, &date1);
  strptime (text2, format, &date2);

  if ((return_code = date1.tm_year - date2.tm_year))
    return (int) return_code;

  if ((return_code = date1.tm_mon - date2.tm_mon))
    return (int) return_code;

  return (int) (date1.tm_mday - date2.tm_mday);
}



/* BY PERM */


static gint
remote_sort_by_perm (GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{
  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

#define REMOTE_SORT_BY_SIZE_MODE1 (text1[1] == 'r') * 400 + (text1[2] == 'w') * 200 + (text1[3] == 'x') * 100 + (text1[4] == 'r') * 40 + (text1[5] == 'w') * 20 + (text1[6] == 'x') * 10 + (text1[7] == 'r') * 4 + (text1[8] == 'w') * 2 + (text1[9] == 'x')

#define REMOTE_SORT_BY_SIZE_MODE2 (text2[1] == 'r') * 400 + (text2[2] == 'w') * 200 + (text2[3] == 'x') * 100 + (text2[4] == 'r') * 40 + (text2[5] == 'w') * 20 + (text2[6] == 'x') * 10 + (text2[7] == 'r') * 4 + (text2[8] == 'w') * 2 + (text2[9] == 'x')

  return (int) ((REMOTE_SORT_BY_SIZE_MODE1) - (REMOTE_SORT_BY_SIZE_MODE2));
}
