/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <string.h>

#include "protos.h"
#include "queue.h"
#include "queue_log.h"
#include "queue_dnd.h"





/* ACTIVE/SHOW functions */

/* PUBLIC:
 * show_or_hide_queue
 * active_queue 
 */

void
show_or_hide_queue (GtkWidget * widget)
{
  show_hide_widget (clist_window, GTK_CHECK_MENU_ITEM (widget)->active);
  gtk_paned_set_position (GTK_PANED (main_panel), GTK_CHECK_MENU_ITEM (widget)->active ? main_pane_pos : main_window_height);
}

void
active_queue (char FLAG)
{
  gtk_widget_set_sensitive (clist, FLAG);
}










/* CLIST functions */

/* PUBLIC:
 * create_queuelist
 * queue_selection_info
 * are_there_entries_in_queue
 * STATIC:
 * clist_event_handler
 * clist_row_select_unselect
 */

GtkWidget *
create_queuelist (void)
{
#ifdef ALT_FTP_ICONS
#include "pixmaps/alt/miniQ.xpm"
#else
#include "pixmaps/miniQ.xpm"
#endif

  gchar *clist_titles[] =
  {" Local", " Size ", " ", " Remote", " Status"};

/* DND */
  static GtkTargetEntry DND_target_table[] =
  {
    {"STRING", 0, DND_TARGET_STRING},
    {"text/uri-list", 0, DND_TARGET_URI_LIST}
  };
#define  DND_TARGETS  1


  clist = gtk_clist_new_with_titles (5, clist_titles);
  gtk_clist_set_border (GTK_CLIST (clist), GTK_SHADOW_IN);

  gtk_clist_set_row_height (GTK_CLIST (clist), 16);

  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 260);
  gtk_clist_set_column_width (GTK_CLIST (clist), 1, 70);
  gtk_clist_set_column_width (GTK_CLIST (clist), 2, 35);
  gtk_clist_set_column_width (GTK_CLIST (clist), 3, 260);
  gtk_clist_set_column_width (GTK_CLIST (clist), 4, 50);
  gtk_clist_set_column_justification (GTK_CLIST (clist), 1, GTK_JUSTIFY_RIGHT);
  gtk_clist_set_column_justification (GTK_CLIST (clist), 2, GTK_JUSTIFY_CENTER);


  gtk_clist_set_column_widget (GTK_CLIST (clist), 2, new_pixmap (window, miniQ_xpm));


  gtk_clist_set_selection_mode (GTK_CLIST (clist), GTK_SELECTION_EXTENDED);
  gtk_clist_set_reorderable (GTK_CLIST (clist), TRUE);

  gtk_widget_show (clist);
  gtk_widget_set_name (clist, "Queue");

  gtk_clist_set_hadjustment (GTK_CLIST (clist), NULL);
  gtk_clist_set_vadjustment (GTK_CLIST (clist), NULL);

  clist_window = scroll_win ();
  gtk_container_add (GTK_CONTAINER (clist_window), clist);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (clist_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_drag_dest_set (clist_window,
		     GTK_DEST_DEFAULT_ALL,
		     DND_target_table, DND_TARGETS,
		     GDK_ACTION_COPY);

  gtk_signal_connect (GTK_OBJECT (clist_window), "drag_data_received",
		      GTK_SIGNAL_FUNC (queue_drag_data_received), NULL);


  show_hide_widget (clist_window, user_rc.view_queue);

  active_queue (TRUE);
  gtk_signal_connect (GTK_OBJECT (clist), "event", GTK_SIGNAL_FUNC (clist_event_handler), NULL);
  gtk_signal_connect (GTK_OBJECT (clist), "select_row", GTK_SIGNAL_FUNC (clist_row_select_unselect), NULL);
  gtk_signal_connect (GTK_OBJECT (clist), "unselect_row", GTK_SIGNAL_FUNC (clist_row_select_unselect), NULL);

  strcpy (queue_current_name, "default");

  return clist_window;
}



static gint
clist_event_handler (GtkWidget * this_list, GdkEvent * event, gpointer data)
{
  switch (event->type)
    {
    case GDK_BUTTON_PRESS:
      switch (event->button.button)
	{
	case 3:
	  {
	    GdkEventButton *bevent = (GdkEventButton *) event;
	    queue_popup_menu_set_sensitive ();
	    gtk_menu_popup (GTK_MENU (queue_popup_menu), NULL, NULL, NULL, NULL,
			    bevent->button, bevent->time);
	  }
	  return TRUE;

	default:
	  break;
	}
      break;
/*
   case GDK_2BUTTON_PRESS:
   switch (event->button.button)
   {
   case 1:
   return TRUE;
   default:
   break;
   }
 */
    default:
      break;
    }

  return FALSE;
}

static void
clist_row_select_unselect (GtkWidget * this_list, gint row, gint column, GdkEventButton * event, gpointer data)
{
  queue_popup_menu_set_sensitive ();
}

gint
queue_selection_info (void)
{
  return (GTK_CLIST (clist)->selection == NULL) ? 0 : 1;
}

gint
are_there_entries_in_queue (void)
{
  return Qentries;
}








/* QUEUE management functions */

/* PUBLIC :
 * QUEUE_add_file
 * QUEUE_show_info
 * QUEUE_add_selection 
 * QUEUE_remove_selected
 * QUEUE_move_to_top
 * QUEUE_move_to_bottom
 * QUEUE_clear 
 * STATIC :
 * QUEUE_allocate_Qfile_struct
 */

static QUEUEfile *
QUEUE_allocate_Qfile_struct (void)
{
  QUEUEfile *Qfile;
  Qfile = g_malloc (sizeof (QUEUEfile));
  Qfile->session = this_session;
  Qfile->retry = 0;
  return Qfile;
}

void
QUEUE_add_file (char *filename, char *filesize, char IS_A_DIR, char XFER_TYPE)
{
  GdkPixmap *pixmap, *filepix;
  GdkBitmap *mask, *filemsk;
  guint8 spacing = 5;
  gchar *col[] =
  {"", "", "", "", ""};
  gint row;
  char current_local_dir[MPLEN];
  char local_buf[1024];
  char remote_buf[1024];
  QUEUEfile *Qfile = QUEUE_allocate_Qfile_struct ();

  getcwd (current_local_dir, sizeof (current_local_dir));

  Qfile->xfer_type = XFER_TYPE;
  Qfile->is_a_dir = IS_A_DIR;
  strcpy (Qfile->filename, filename);
  strcpy (Qfile->session.local_dir, current_local_dir);
  Qfile->filesize = atol (filesize);
  Qfile->status = QSTATUS_WAITING;

  sprintf (local_buf, "%s/%s", current_local_dir, filename);
  col[0] = local_buf;

  col[1] = filesize;

  sprintf (remote_buf, "//%s/%s/%s", this_session.hostname, this_session.cwd_dir, filename);
  I_want_only_one_slash_here ((char *) (remote_buf + 1));
  col[3] = remote_buf;

  row = gtk_clist_append (GTK_CLIST (clist), col);
  pixmap = (XFER_TYPE == QUEUE_UPLOAD) ? arrow_right_pixmap (&mask) : arrow_left_pixmap (&mask);
  gtk_clist_set_pixmap (GTK_CLIST (clist), row, 2, pixmap, mask);
  filepix = IS_A_DIR ? folder_pixmap (&filemsk) : default_file_pixmap (&filemsk);
  gtk_clist_set_pixtext (GTK_CLIST (clist), row, 0, col[0], spacing, filepix, filemsk);
  gtk_clist_set_pixtext (GTK_CLIST (clist), row, 3, col[3], spacing, filepix, filemsk);

  gtk_clist_set_row_data (GTK_CLIST (clist), row, (QUEUEfile *) Qfile);
  gtk_clist_moveto (GTK_CLIST (clist), row, 0, 1, 0);

  if (++Qentries == 1)
    queue_popup_menu_set_sensitive ();

  QUEUE_SAVED = FALSE;

  gdk_pixmap_unref (pixmap);
  gdk_pixmap_unref (mask);
  gdk_pixmap_unref (filepix);
  gdk_pixmap_unref (filemsk);
}


void
QUEUE_show_info (GtkWidget * widget, gpointer data)
{
  int Dfiles = 0;
  int Dfolders = 0;
  long Dsize = 0;
  int Ufiles = 0;
  int Ufolders = 0;
  long Usize = 0;
  register int f;
  QUEUEfile *Qfile = NULL;

  for (f = 0; f < Qentries; f++)
    {
      Qfile = gtk_clist_get_row_data (GTK_CLIST (clist), f);
      if (Qfile->xfer_type == QUEUE_UPLOAD)
	{
	  Usize += Qfile->filesize;
	  Qfile->is_a_dir ? Ufolders++ : Ufiles++;
	}
      else
	{
	  Dsize += Qfile->filesize;
	  Qfile->is_a_dir ? Dfolders++ : Dfiles++;
	}
    }
  queue_info_dialog (Dfiles, Dfolders, Dsize, Ufiles, Ufolders, Usize);
}


void
QUEUE_add_selection (GtkWidget * widget, gpointer data)
{
  (PANEL_FOCUS == LOCAL_FOCUS) ? queue_selection_for_upload () : queue_selection_for_download ();
}


void
QUEUE_remove_selected (GtkWidget * widget, gpointer data)
{
  GList *selection = GTK_CLIST (clist)->selection;
  QUEUEfile *Qfile = NULL;
  int row;

  while (selection)
    {
      row = GPOINTER_TO_INT (selection->data);
      selection = selection->next;
      Qfile = gtk_clist_get_row_data (GTK_CLIST (clist), row);
      g_free (Qfile);
      gtk_clist_remove (GTK_CLIST (clist), row);
      --Qentries;
    }
  if (Qentries == 0)
    queue_popup_menu_set_sensitive ();
  QUEUE_SAVED = FALSE;
}


void
QUEUE_move_to_top (GtkWidget * widget, gpointer data)
{
  GList *selection = GTK_CLIST (clist)->selection;
  while (selection)
    {
      gtk_clist_row_move (GTK_CLIST (clist), GPOINTER_TO_INT (selection->data), 0);
      selection = selection->next;
    }
  QUEUE_SAVED = FALSE;
}

void
QUEUE_move_to_bottom (GtkWidget * widget, gpointer data)
{
  GList *selection = GTK_CLIST (clist)->selection;
  while (selection)
    {
      gtk_clist_row_move (GTK_CLIST (clist), GPOINTER_TO_INT (selection->data), Qentries - 1);
      selection = selection->next;
    }
  QUEUE_SAVED = FALSE;
}


void
QUEUE_clear (GtkWidget * widget, gpointer data)
{
  QUEUEfile *Qfile = NULL;

  register int f;

  if (!Qentries)
    return;

  for (f = 0; f < Qentries; f++)
    {
      Qfile = gtk_clist_get_row_data (GTK_CLIST (clist), f);
      g_free (Qfile);
    }
  gtk_clist_clear (GTK_CLIST (clist));
  Qentries = 0;
  queue_popup_menu_set_sensitive ();
  QUEUE_SAVED = FALSE;
  QUEUE_xfer_erase_log ();
}








/* QUEUE IO functions */

/* PUBLIC :
 * QUEUE_save_current
 * QUEUE_save_as_dialog
 * QUEUE_load
 * QUEUE_load_current
 * QUEUE_load_dialog
 * STATIC :
 * QUEUE_save
 * QUEUE_save_as
 * QUEUE_load_ok
 */

/* SAVE */
static void
QUEUE_save (char *queuename)
{
  QUEUEfile *Qfile = NULL;
  char this_path[MPLEN];
  int file_handle;
  register int f;

  queue_path (this_path, queuename);

  if ((file_handle = open (this_path, O_CREAT | O_TRUNC | O_WRONLY, RC_PERM)) == -1)
    {
      alert_ok ("Error", "Can't save queue.", "Ok");
      return;
    }

  write (file_handle, QUEUE_HEADER, sizeof (QUEUE_HEADER));

  if (Qentries)
    for (f = 0; f < Qentries; f++)
      {
	Qfile = gtk_clist_get_row_data (GTK_CLIST (clist), f);
	MemFrob (Qfile, sizeof (QUEUEfile));
	write (file_handle, Qfile, sizeof (QUEUEfile));
	MemFrob (Qfile, sizeof (QUEUEfile));
      }

  close (file_handle);
  QUEUE_SAVED = TRUE;
}


void
QUEUE_save_current (void)
{
  if (!QUEUE_SAVED)
    if (alert_ok_cancel_modal ("Save Queue?", "Current queue has been modified.\nDo you want to save it ?", "Save") == 1)
      QUEUE_save (queue_current_name);
}


static void
QUEUE_save_as (GtkWidget * widget, GtkWidget * entry)
{
  GtkWidget *alert_window = gtk_widget_get_toplevel (entry);
  char buf[1024];

  strcpy (buf, gtk_entry_get_text (GTK_ENTRY (entry)));
  gtk_widget_destroy (alert_window);

  if (!strlen (buf))
    alert_ok ("Error", "No name specified", "Ok");
  else
    {
      QUEUE_save (buf);
      alert_ok ("Save Queue", "Queue saved", "Ok");
      strcpy (queue_current_name, buf);
    }
}

void
QUEUE_save_as_dialog (GtkWidget * widget, gpointer data)
{
  entry_dialog ("Save Queue", "Save queue as :", "Save", queue_current_name, GTK_SIGNAL_FUNC (QUEUE_save_as));
}


/* LOAD */
static void
QUEUE_load (char *queuename, char VERBOSE)
{
  QUEUEfile *Qfile = QUEUE_allocate_Qfile_struct ();
  char this_path[MPLEN];
  int file_handle;
  GdkPixmap *pixmap = NULL, *filepix = NULL;
  GdkBitmap *mask = NULL, *filemsk = NULL;
  guint8 spacing = 5;
  gchar *col[] =
  {"", "", "", "", ""};
  gint row = 0;
  char local_buf[1024];
  char remote_buf[1024];
  char size_buf[128];
  char header_buf[sizeof (QUEUE_HEADER)];

  queue_path (this_path, queuename);

  if ((file_handle = open (this_path, O_RDONLY, RC_PERM)) == -1)
    {
      if (VERBOSE)
	alert_ok ("Error", "File does not exist,\nor is not a valid queue file.", "Ok");
      g_free (Qfile);
      return;
    }

  read (file_handle, header_buf, sizeof (QUEUE_HEADER));
  if (strcmp (header_buf, QUEUE_HEADER))
    {
      alert_ok ("Error", "Invalid queue file format.", "Ok");
      close (file_handle);
      g_free (Qfile);
      return;
    }

  Qentries = 0;
  gtk_clist_freeze (GTK_CLIST (clist));
  gtk_clist_clear (GTK_CLIST (clist));

  while (read (file_handle, Qfile, sizeof (QUEUEfile)) == sizeof (QUEUEfile))
    {
      MemFrob (Qfile, sizeof (QUEUEfile));

      sprintf (local_buf, "%s/%s", Qfile->session.local_dir, Qfile->filename);
      col[0] = local_buf;
      sprintf (size_buf, "%ld", Qfile->filesize);
      col[1] = size_buf;
      sprintf (remote_buf, "//%s/%s/%s", Qfile->session.hostname, Qfile->session.cwd_dir, Qfile->filename);
      I_want_only_one_slash_here ((char *) (remote_buf + 1));
      col[3] = remote_buf;

      row = gtk_clist_append (GTK_CLIST (clist), col);
      pixmap = (Qfile->xfer_type == QUEUE_UPLOAD) ? arrow_right_pixmap (&mask) : arrow_left_pixmap (&mask);
      gtk_clist_set_pixmap (GTK_CLIST (clist), row, 2, pixmap, mask);
      filepix = Qfile->is_a_dir ? folder_pixmap (&filemsk) : default_file_pixmap (&filemsk);
      gtk_clist_set_pixtext (GTK_CLIST (clist), row, 0, col[0], spacing, filepix, filemsk);
      gtk_clist_set_pixtext (GTK_CLIST (clist), row, 3, col[3], spacing, filepix, filemsk);

      gtk_clist_set_row_data (GTK_CLIST (clist), row, (QUEUEfile *) Qfile);

      Qentries++;
      Qfile = QUEUE_allocate_Qfile_struct ();

      gdk_pixmap_unref (pixmap);
      gdk_pixmap_unref (mask);
      gdk_pixmap_unref (filepix);
      gdk_pixmap_unref (filemsk);
    }

  close (file_handle);
  g_free (Qfile);

  gtk_clist_thaw (GTK_CLIST (clist));
  QUEUE_xfer_erase_log ();
  QUEUE_SAVED = TRUE;
  if (strcmp (queue_current_name, queuename))
    strcpy (queue_current_name, queuename);
  queue_popup_menu_set_sensitive ();
}


void
QUEUE_load_current (void)
{
  QUEUE_load (queue_current_name, FALSE);
  queue_popup_menu_set_sensitive ();
}


static void
QUEUE_load_ok (GtkWidget * widget, gpointer data)
{
  GtkWidget *fs_window = gtk_widget_get_toplevel (widget);
  char buf[1024];
  char *ptr;
  char *queuename;

  strcpy (buf, gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs_window)));
  gtk_widget_destroy (fs_window);

  queuename = ((ptr = strrchr (buf, '/')) != NULL) ? ++ptr : buf;

  if ((ptr = strstr (queuename, QUEUE_EXT)) != NULL)
    *ptr = 0;

  QUEUE_load (queuename, TRUE);
}

void
QUEUE_load_dialog (GtkWidget * widget, gpointer data)
{
  char this_path[MPLEN];
  queue_path (this_path, "*");
  create_file_select (window, "Load Queue", this_path, GTK_SIGNAL_FUNC (QUEUE_load_ok), NULL);
}






/* QUEUE XFER functions */

/* PUBLIC :
 * QUEUE_xfer
 */

void
QUEUE_xfer (void)
{
  QUEUEfile *Qfile = NULL;
  int compt = Qentries;
  char LAST_CONNECT_SUCCEED = TRUE;
  char current_local_dir[MPLEN];

  active_queue (FALSE);
  active_dir_panel (FALSE);
  active_ftp_panel (FALSE);
  toolbar_xfer_buttons_set_sensitive (FALSE);

  want_abort = FALSE;
  xfer_abort = FALSE;
  xfer_skip = FALSE;


  gtk_clist_unselect_all (GTK_CLIST (clist));

  IDLE_END;
  CHECK_CONNEXION_VOID;

  info_message ("Transfering Queued Files...");

  QUEUE_XFER_init_log ();
  QUEUE_XFER_log ("CURRENT QUEUE:", queue_current_name);
  QUEUE_XFER_log ("CURRENT HOST:", this_session.hostname);
  QUEUE_XFER_log ("CURRENT USER:", this_session.username);
  QUEUE_XFER_log_new_line ();

  while (compt)
    {
      char QENTRY_SKIP = FALSE;

      if (want_abort)
	continue;

      gtk_clist_select_row (GTK_CLIST (clist), 0, 0);
      gtk_clist_set_text (GTK_CLIST (clist), 0, 4, "Finding ...");
      Qfile = gtk_clist_get_row_data (GTK_CLIST (clist), 0);

      Qfile->retry++;
      xfer_overwrite = (Qfile->retry == 1);
      xfer_resume = !xfer_overwrite;

      QUEUE_XFER_log_Qentry (Qfile);

      if (
	   !this_connexion.is_connected
	   || strcmp (this_session.hostname, Qfile->session.hostname)
	   || strcmp (this_session.username, Qfile->session.username)
	)
	{

	  if (this_connexion.is_connected)
	    IGLOO_logoff (TRUE);

	  this_session = Qfile->session;
	  QUEUE_XFER_log ("CONNECTING TO", this_session.hostname);
	  LAST_CONNECT_SUCCEED = IGLOO_connect ();
	  if (!LAST_CONNECT_SUCCEED)
	    {
	      QSTATUS_ERROR;
	      QENTRY_SKIP = TRUE;
	      QUEUE_XFER_log_error ("CAN'T CONNECT", "", Qfile->status);
	    }
	  else
	    {
	      if (is_smanager_visible)
		switch_smanager_panel ();

	      RDC_create_site_root ();
	      update_connectbar (&this_session);
	      IGLOO_pwd ();
	    }
	}
      else
	{
	  if (!LAST_CONNECT_SUCCEED)
	    {
	      QSTATUS_ERROR;
	      QENTRY_SKIP = TRUE;
	      QUEUE_XFER_log_error ("NOT CONNECTED", "", Qfile->status);
	    }
	}


      getcwd (current_local_dir, sizeof (current_local_dir));

      if (!QENTRY_SKIP && strcmp (current_local_dir, Qfile->session.local_dir))
	{
	  QUEUE_XFER_log ("LOCAL CHDIR TO", Qfile->session.local_dir);
	  if (chdir (Qfile->session.local_dir) == -1)
	    {
	      QSTATUS_ERROR;
	      QENTRY_SKIP = TRUE;
	      QUEUE_XFER_log_error ("CAN'T CD TO", Qfile->session.local_dir, Qfile->status);
	    }
	  else
	    refresh_dirlist ();
	}

      if (!QENTRY_SKIP && strcmp (this_session.cwd_dir, Qfile->session.cwd_dir) && strlen (Qfile->session.cwd_dir))
	{
	  QUEUE_XFER_log ("REMOTE CHDIR TO", Qfile->session.cwd_dir);
	  if (!IGLOO_cwd (Qfile->session.cwd_dir))
	    {
	      QSTATUS_ERROR;
	      QENTRY_SKIP = TRUE;
	      QUEUE_XFER_log_error ("CAN'T CD TO", Qfile->session.cwd_dir, Qfile->status);
	    }
	  else
	    update_ftplist (this_session.cwd_dir);
	}

      if (!QENTRY_SKIP)
	{
	  if (Qfile->xfer_type == QUEUE_DOWNLOAD)
	    {
	      char Qstatus_msg[128];
	      sprintf (Qstatus_msg, "DOWNLOADING ... Attempt #%i", (char) Qfile->retry);
	      QUEUE_XFER_log (Qstatus_msg, NULL);
	      gtk_clist_set_text (GTK_CLIST (clist), 0, 4, Qstatus_msg);
	      if (queue_download_selection (Qfile->filename, Qfile->is_a_dir))
		Qfile->status = QSTATUS_DONE;
	      else
		Qfile->status = QSTATUS_CANCELLED;
	    }
	  else
	    {
	      char Qstatus_msg[128];
	      sprintf (Qstatus_msg, "UPLOADING ... Attempt #%i", (char) Qfile->retry);
	      QUEUE_XFER_log (Qstatus_msg, NULL);
	      gtk_clist_set_text (GTK_CLIST (clist), 0, 4, Qstatus_msg);
	      if (queue_upload_selection (Qfile->filename, Qfile->is_a_dir))
		Qfile->status = QSTATUS_DONE;
	      else
		Qfile->status = QSTATUS_CANCELLED;
	    }

	  if (Qfile->status != QSTATUS_DONE)
	    QUEUE_XFER_log_error ("XFER ERROR", NULL, Qfile->status);
	}


      switch (Qfile->status)
	{
	case QSTATUS_CANCELLED:
	  gtk_clist_set_text (GTK_CLIST (clist), 0, 4, "Cancelled");
	  QUEUE_XFER_log ("[CANCELLED]", NULL);
	  gtk_clist_row_move (GTK_CLIST (clist), 0, Qentries - 1);
	  Qfile->status = QSTATUS_DONE;
	  Qfile->retry = 0;
	  compt--;
	  break;

	case QSTATUS_DELAYED:
	  gtk_clist_set_text (GTK_CLIST (clist), 0, 4, "Delayed");
	  QUEUE_XFER_log ("[DELAYED]", NULL);
	  gtk_clist_row_move (GTK_CLIST (clist), 0, Qentries - 1);
	  break;

	case QSTATUS_DONE:
	default:
	  QUEUE_XFER_log ("[DONE]", NULL);
	  gtk_clist_remove (GTK_CLIST (clist), 0);
	  compt--;
	  Qentries--;
	  break;
	}

      QUEUE_XFER_log_new_line ();
    }


  QUEUE_XFER_close_log ();
  info_message ("End of Queue Transfert.");
  QUEUE_save (queue_current_name);

  want_abort = FALSE;
  xfer_overwrite = FALSE;
  xfer_resume = FALSE;
  default_status_message ();
  IDLE_START;

  active_queue (TRUE);
  active_dir_panel (TRUE);
  active_ftp_panel (TRUE);

  refresh_dirlist ();
  if (this_connexion.is_connected)
    refresh_ftplist ();
  queue_popup_menu_set_sensitive ();
}



/* EOF */
