/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <dirent.h>

#include "defines.h"
#include "typedef.h"
#include "FTP.h"





/* DEFINES - DEBUG */
#include "debug.h"



/* GLOBAL - WIDGET */
GtkWidget *window;
GtkWidget *startup_window;
GtkWidget *startup_label;
GtkWidget *remote_popup_menu;
GtkWidget *local_popup_menu;
GtkWidget *queue_popup_menu;
GtkWidget *this_handle_box;

GtkWidget *main_panel;
GtkWidget *top_panel;
GtkWidget *clist_panel;

GtkWidget *DIR_clist;
GtkWidget *FTP_clist;



extern GdkColor LICE;
extern GdkColor LBLUE;
extern GdkColor BLUE;
extern GdkColor LCYAN;
extern GdkColor WHITE;
extern GdkColor LRED;
extern GdkColor RED;
extern GdkColor CYAN;
extern GdkColor YELLOW;
extern GdkColor LYELLOW;
extern GdkColor LGREEN;
extern GdkColor GREEN;
extern GdkColor BLACK;
extern GdkColor GREY;
extern GdkColor SGREY;
extern GdkColor LGREY;
extern GdkColor SLGREY;
extern GdkColor GREYCYAN;



/* GLOBAL - FTP related */
FTPsession this_session;
FTP this_connexion;

char xfer_abort;
char xfer_skip;
char xfer_overwrite;
char xfer_resume;
char anti_idle;
int recv_buf_len;
int send_buf_len;
gint download_stat_timeout;
gint anti_idle_timeout;
int next_noop_delay;
char want_abort;
char USER_WAS_CONNECTED;
char MUST_SHOW_FTP_DIRECTORY_MESSAGE;
char USER_CONNECT_VIA_SITE_MANAGER;
char USER_CONNECT_VIA_URL;
char DOS_FILESYSTEM;


/* GLOBAL - LAYOUT */
char layout_autosave;
GtkWidget *check_layout_autosave;
gint main_window_x;
gint main_window_y;
gint main_window_height;
gint main_window_width;
gint main_pane_pos;
gint top_pane_pos;
gint clist_pane_pos;






/* GLOBAL - OTHERS */
FILE *REXEC;
gint REXEC_TAG;
char dirlist_hide_hidden;
char ftplist_hide_hidden;
char is_smanager_visible;
char local_clist_sort;
char local_clist_sort_type;
char remote_clist_sort;
char remote_clist_sort_type;
char home_path[MPLEN];
char prg_path[MPLEN];
char prg_start_dir[MPLEN];

char PANEL_FOCUS;





/* EXTERN */
extern char *strptime __P ((__const char *__s, __const char *__fmt, struct tm * __tp));



/* MAIN - main.c  */
void main_quit (GtkWidget * widget, int *data);
void set_main_title (void);
void startup_message (char *this_message);



/* EDITOR */
#define IglooEdit(a) IGLOO_EDIT (a, FALSE)
#define IglooEdit_remote(a) IGLOO_EDIT (a, TRUE)
void IGLOO_EDIT (char *filename, char IS_REXEC);



/* LAYOUT - layout.c  */
void layout_set_defaults (void);
void layout_realize (void);
void layout_save (char RESET);
void layout_save_from_widget (void);
void layout_set_autosave (GtkWidget * widget);
void layout_reload (void);
void layout_reset (void);
void layout_load (void);



/* PATH FUNTIONS - path_functions.c  */
int delete_dir (char *dirname);
void init_user_folders (void);
void init_user_configuration_files (void);

void clean_user_folders (void);

void I_want_only_one_slash_here (char *buf);
char *sites_manager_path (char *buf);
char *preference_dir (char *buf);
char *preferences_path (char *buf);
char *queue_path (char *buf, char *queuename);
char *queue_log_path (char *buf, char *queuename);
char *queue_dir (char *buf);
char *layout_path (char *buf);
char *text_ext_path (char *buf);
char *files_assoc_dir (char *buf);
char *files_assoc_path (char *buf);
char *host_history_path (char *buf);
char *spaw_session_path (char *buf);
char *bookmarks_dir (char *buf);
char *bookmarks_path (char *buf);
char *bookmarks_default_path (char *buf);
char *tmp_cache_path (char *buf);
char *REXEC_path (char *buf);
char *RDC_main_dir (char *buf);
char *RDC_site_root_dir (char *buf);
char *RDC_site_dir_dir (char *buf, char *this_dir);
char *RDC_site_dir_listing (char *buf, char *this_dir);
char *RDC_welcome_message_path (char *buf);
char *RDC_welcome_message_tmp_path (char *buf);
char *RDC_directory_message_path (char *buf);
char *RDC_directory_message_tmp_path (char *buf);



/* DIR - dir.c */
typedef char (*DirRecurseFunc) (char *filename);
char is_a_dir (char *filename);
char recurse_dir (char *this_pathname, DirRecurseFunc files_func, DirRecurseFunc dirs_func);
void create_dir (char *dirname, mode_t this_mode);



/* GTK_MISC - GTKmisc.c */
void show_hide_widget (GtkWidget * widget, char flag);
void set_default_drag_icon (void);
GtkWidget *append_option_menu_item (GtkWidget * optionmenu, char *text);
GtkWidget *fixed_entry (GtkWidget * fixed, gint x, gint y, gint w, gint h, char *text);
GtkWidget *fixed_button_browser (GtkWidget * fixed, gint x, gint y);
GtkWidget *fixed_dir_entry (GtkWidget * fixed, gint x, gint y, gint w, gint h, char *text);
GtkWidget *fixed_file_entry (GtkWidget * fixed, gint x, gint y, gint w, gint h, char *text);
GtkWidget *fixed_check (GtkWidget * fixed, gint x, gint y, char *text, char this_state);
GtkWidget *fixed_radio (GtkWidget * fixed, GtkWidget * last_radio, gchar * label, gint x, gint y,
	 GtkSignalFunc this_func, gpointer this_func_data, char this_state);
GtkWidget *fixed_button (GtkWidget * box, char *text);
GtkWidget *fixed_spin (GtkWidget * fixed, gint x, gint y, gfloat value, gfloat max_value, gfloat min_value, int increment);
GtkWidget *fixed_frame (GtkWidget * fixed, gint x, gint y, gint w, gint h, char *text);
//void custom_pixmap (GtkWidget * this_window, GtkWidget * this_box);
GtkWidget *fixed_hseparator (GtkWidget * fixed, gint x, gint y, gint w);
GtkWidget *fixed_label (GtkWidget * fixed, gint x, gint y, char *text);
GtkWidget *create_frame (GtkWidget * parent, char *title, char h_expand, char w_expand, GtkShadowType shadow_type);
GtkWidget *h_box (GtkWidget * parent, char homogene, gint spacing, gint border);
GtkWidget *v_box (GtkWidget * parent, char homogene, gint spacing, gint border);
GtkWidget *scroll_win (void);
GtkWidget *create_check_button (GtkWidget * box, char *label, char FLAG);
GtkWidget *create_entry (GtkWidget * box, char *default_text);
GtkWidget *hbutton_box (GtkWidget * box);
GtkWidget *box_button (GtkWidget * box, char *label);
void box_button_cancel_destroy_window (GtkWidget * this_box, GtkWidget * this_window);
void hseparator (GtkWidget * this_box);
void create_label (GtkWidget * box, char *labelname, GtkJustification jtype, int x_pad, int y_pad);
GtkWidget *notebook_label (GtkWidget * pixmap, char *label_text);
GtkWidget *clist_title_with_arrow (GtkWidget * clist, char col, char *label_text);
void clist_title_with_arrow_set_up_dow (GtkWidget * arrow, char IS_UP);
GtkWidget *browser_button (char is_open);
GtkWidget *cdup_button (void);
GtkWidget *shell_button (void);
void create_file_select (GtkWidget * parent_window, char *label, char *filename, GtkSignalFunc this_func, gpointer this_func_data);


/* CURSORS - cursor.c */
void CURSOR_MAIN_busy (void);
void CURSOR_MAIN_default (void);
void CURSOR_busy (void);
void CURSOR_default (void);

/* TEXT - text.c */
void create_text_area (GtkWidget * this_text, GtkWidget * vbox);
void clear_text (GtkWidget * this_text);
void text_copy_to_clipboard (GtkWidget * widget, GtkWidget * this_text);
void text_cut_to_clipboard (GtkWidget * widget, GtkWidget * this_text);
void text_paste_from_clipboard (GtkWidget * widget, GtkWidget * this_text);
void text_select_all (GtkWidget * widget, GtkWidget * this_text);
void realize_text (GtkWidget * this_text, gpointer data);



/* DOCS - docs.c */
void doc_show_text_file (int this_doc);
void doc_show_text_file_from_widget (GtkWidget * widget, gpointer data);



/* CUSTOM - custom.c */
USERrc user_rc;

void init_rc (void);
void check_new_prog_version (void);
void custom_notebook (void);
int count_total_number_of_profiles (void);
void retrieve_local_dir_from_user_profile (void);
void read_prof (int profile_number, USERprof * this_prof);



/* TEXT EXTENSIONS - text_ext.c */
char is_text_ext (char *EXT);
void text_ext_dialog (void);
void text_ext_read (void);



/* MENUS - menu.c  */
void nop (void);
void menu_separator (GtkWidget * menu);
void menu_tearoff (GtkWidget * menu);
GtkWidget *create_sub_menu (GtkWidget * menu_bar, char *label, char RIGTH_JUSTIFY);
GtkWidget *create_menu_item (GtkWidget * menu, gchar * label, gint sensitive_flag,
			  GtkSignalFunc this_func, gpointer this_func_data);

void create_main_menu (GtkWidget * vbox);
GtkWidget *create_sman_popup_menu (void);
void sman_popup_menu_set_sensitive (char IS_ROOT, char IS_GROUP, char IS_SITE);
GtkWidget *create_console_popup_menu (void);
void console_popup_menu_set_sensitive (void);
GtkWidget *create_queue_popup_menu (void);
void queue_popup_menu_set_sensitive (void);
void update_local_popup_menu (gint selected_items);
void update_local_popup_menu_execute (char FLAG);
void local_popup_menu_set_sensitive (char FLAG);
void update_local_popup_menu_sort (void);
void update_local_popup_menu_sort_type (void);
void update_remote_popup_menu (gint selected_items);
void remote_popup_menu_set_sensitive (char FLAG);
void update_remote_popup_menu_sort (void);
void update_remote_popup_menu_sort_type (void);
void bookmark_menu_set_sensitive (void);
void update_view_local_remote_menu (void);

void menu_set_check_idle (char this_state);
void menu_set_connect (void);
void menu_set_smanager (char FLAG);
void menu_set_toolbar_style (char FLAG);



/* PIXMAPS - pixmaps.c */
GtkWidget *new_pixmap (GtkWidget * widget, char **data);
void set_window_icon (GtkWidget * this_window);
GtkWidget *make_program_icon (void);
void program_icon (GtkWidget * this_box);
void exclam_icon (GtkWidget * this_box);
void inter_icon (GtkWidget * this_box);
GtkWidget *preferences_pixmap (GtkWidget * widget);
GtkWidget *smanager_pixmap (GtkWidget * widget);
GdkPixmap *computer_pixmap (GdkBitmap ** mask);
GdkPixmap *arrow_down_pixmap (GdkBitmap ** mask);
GdkPixmap *default_file_pixmap (GdkBitmap ** mask);
GdkPixmap *text_file_pixmap (GdkBitmap ** mask);
GdkPixmap *folder_pixmap (GdkBitmap ** mask);
GdkPixmap *folder_open_pixmap (GdkBitmap ** mask);
GdkPixmap *folder_open_l_pixmap (GdkBitmap ** mask);
GdkPixmap *folder_l_pixmap (GdkBitmap ** mask);
#define browser_pixmap(x) folder_open_pixmap (x)
#define browser_close_pixmap(x) folder_pixmap (x)
GdkPixmap *parent_pixmap (GdkBitmap ** mask);
GdkPixmap *dlink_pixmap (GdkBitmap ** mask);
GdkPixmap *flink_pixmap (GdkBitmap ** mask);
GdkPixmap *man_grp_pixmap (GdkBitmap ** mask);
GdkPixmap *man_grp_open_pixmap (GdkBitmap ** mask);
GdkPixmap *man_site_pixmap (GdkBitmap ** mask);
GdkPixmap *preferences_node (GdkBitmap ** mask);
GdkPixmap *arrow_left_pixmap (GdkBitmap ** mask);
GdkPixmap *arrow_right_pixmap (GdkBitmap ** mask);
void give_a_nice_icon_to_this_file (char *filename, GtkWidget * this_list, int row);



/* TOOLBARS - toolbar.c */
GtkWidget *create_toolbar (GtkWidget * window, GtkWidget * vbox);
GtkWidget *create_mini_toolbar (GtkWidget * window, GtkWidget * vbox);
GtkWidget *create_sman_toolbar (GtkWidget * window, GtkWidget * vbox);
void show_or_hide_toolbar (GtkWidget * widget);
void toolbar_set_style (GtkWidget * widget, GtkToolbarStyle style);
void toolbar_buttons_set_sensitive (void);
void toolbar_xfer_buttons_set_sensitive (char FLAG);
void toolbar_queue_buttons_set_sensitive (char FLAG);


/* CONNECT_BAR - connectbar.c */
GtkWidget *create_connect_bar (GtkWidget * vbox);
void show_or_hide_connectbar (GtkWidget * widget);
void update_connectbar (FTPsession * that_session);
char was_connectbar_modified (void);
char can_connect (void);
void fill_combo_user (void);
void update_combo_host_history (char *this_host);
void save_combo_host_history (void);


/* STATUS_BAR - statustbar.c */
GtkWidget *create_status_bar (void);
void status_message (char *this_message);
void status_message_with_arg (char *this_message, char *this_arg);
void default_status_message (void);
void update_file_transfert_status_idle (void);
void init_file_transfert_status (char *this_filename, long this_filesize, long resume_offset, char IS_IT_A_DOWNLOAD);
void clear_file_transfert_status (void);
gint update_file_transfert_status (gpointer data);
void idle_message (char *this_message);



/* DIALOGS - dialog.c  */
GtkWidget *create_alert_label (GtkWidget * box, char *this_text, gfloat xalignement, gfloat yalignement);
void create_startup_window (void);
GtkWidget *create_dialog_window (GtkWindowType win_TYPE, GtkWindowPosition win_POS, char *win_title, GtkWidget ** this_box);
void create_about_window (void);
void alert_ok (gchar * title, gchar * alert_message, gchar * alert_button_label);
int alert_overwrite_modal (gchar * title, gchar * dialog_message);
#define entry_dialog(a,b,c,d,e)  entry_dialog_common(a,b,c,d,e, FALSE)
#define entry_dialog_with_browser(a,b,c,d,e)  entry_dialog_common(a,b,c,d,e, TRUE)
void entry_dialog_common (gchar * title, gchar * dialog_message, gchar * first_button,
gchar * default_entry_text, GtkSignalFunc this_function, char with_browser);
#define entry_dialog_modal(a,b,c,d)  entry_dialog_modal_common (a,b,c,d, TRUE)
#define password_entry_dialog_modal(a,b,c,d)  entry_dialog_modal_common (a,b,c,d, FALSE)
char *entry_dialog_modal_common (gchar * title, gchar * dialog_message, gchar * first_button, gchar * default_entry_text, char IS_VISIBLE);
void entry_text_dialog (gchar * title, gchar * entry_label, gchar * text_label, gchar * first_button,
			gchar * default_entry_text, gchar * default_textarea_text, GtkSignalFunc this_function);
void resizable_text_dialog (gchar * title, char *this_text, int width, int height);
void alert_ok_cancel (gchar * title, gchar * dialog_message, gchar * first_button, GtkSignalFunc this_function);

#define alert_ok_cancel_modal(a,b,c) alert_yes_no_cancel_modal(a,b,c,NULL)
int alert_yes_no_cancel_modal (gchar * title, gchar * dialog_message, gchar * first_button, gchar * second_button);

int duplicate_dialog (gchar * title, gchar * resume_label, gchar * filename, gchar * local_fileinfo, gchar * remote_fileinfo, char may_resume);
void find_dialog (gchar * title, gchar * search_text, GtkSignalFunc this_function);
void group_select_dialog (gchar * title, GtkSignalFunc this_function, char SELECT);
void filter_dialog (gchar * title, gchar * filter_mask, GtkSignalFunc this_function, char FILTER_DIRECTORIES);
void dir_info_dialog (char *current_dir, char IS_LOCAL, int all_files, long all_files_size, int all_dirs, int all_links,
		      int selected_files, long selected_files_size, int selected_dirs, int selected_links);
void queue_info_dialog (int Dfiles, int Dfolders, long Dsize, int Ufiles, int Ufolders, long Usize);
void dir_browser (GtkWidget * widget, GtkWidget * return_entry);



/* CHMOD - chmod.c */
void chmod_dialog (gchar * title, gchar * default_entry_text, GtkSignalFunc this_function);



/* DIRECTORIES BROWSER */
GtkWidget *DIR_TREE_create (GtkCTree ** Ctree, GtkWidget ** Entry, char show_hidden);
GtkCTreeNode *DIR_TREE_show_path (GtkCTree * ctree, char *pathname);
void DIR_TREE_init (GtkCTree * ctree, char *pathname, char *rootname);



/* DIR PANEL - dirlist.c */
GtkWidget *create_dirlist (void);
void show_or_hide_dir_panel (GtkWidget * widget);
void active_dir_panel (char FLAG);
void local_popup_menu_enable_disable (char FLAG);
#define local_popup_menu_enable() local_popup_menu_enable_disable (TRUE);
#define local_popup_menu_disable() local_popup_menu_enable_disable (FALSE);
void local_toolbar_enable_disable (char FLAG);
#define local_toolbar_enable()  local_toolbar_enable_disable(TRUE);
#define local_toolbar_disable()  local_toolbar_enable_disable(FALSE);
void show_or_hide_shell_prompt (GtkWidget * widget);
void refresh_dirlist (void);
void toggle_local_hidden (void);
void toggle_local_columns_visibility (void);
void local_sort_from_menu (GtkWidget * widget, gint column);
void local_sort_type_from_menu (GtkWidget * widget, int data);
gint local_selection_info (void);
char local_get_fileinfo (char *search_filename, FILEINFO * file_info);

void local_focus_update (void);
void local_select_all (GtkWidget * widget, gpointer data);
void local_select_all_files (GtkWidget * widget, gpointer data);
void local_unselect_all (GtkWidget * widget, gpointer data);
void local_invert_selection (GtkWidget * widget, gpointer data);
void local_undo_last_selection (GtkWidget * widget, gpointer data);

void local_find_dialog (GtkWidget * widget, gpointer data);
void local_find_next_dialog (GtkWidget * widget, gpointer data);
void local_group_select_dialog (GtkWidget * widget, gpointer data);
void local_group_deselect_dialog (GtkWidget * widget, gpointer data);
void local_filter_dialog (GtkWidget * widget, gpointer data);
void local_dir_info (GtkWidget * widget, gpointer data);
void local_compare_directories (GtkWidget * widget, gpointer data);

void local_file_view (void);
void local_file_edit (void);
void local_exec (void);
void local_create_directory_dialog (GtkWidget * widget, gpointer data);
void local_change_directory_dialog (GtkWidget * widget, gpointer data);
void local_rename_dialog (GtkWidget * widget, gpointer data);
void local_delete_dialog (GtkWidget * widget, gpointer data);
void local_chmod_dialog (GtkWidget * widget, gpointer data);
void local_move_dialog (GtkWidget * widget, gpointer data);

void upload_selection (GtkWidget * widget, gpointer data);
void queue_selection_for_upload (void);
char queue_upload_selection (char *search_filename, char IS_DIR);

/* FTP PANEL - ftplist.c */
GtkWidget *create_ftplist (void);
void show_or_hide_ftp_panel (GtkWidget * widget);
void active_ftp_panel (char FLAG);
void hide_ftp_panel (char FLAG);
void remote_popup_menu_enable_disable (char FLAG);
#define remote_popup_menu_enable() remote_popup_menu_enable_disable (TRUE);
#define remote_popup_menu_disable() remote_popup_menu_enable_disable (FALSE);
void remote_toolbar_enable_disable (char FLAG);
#define remote_toolbar_enable()   remote_toolbar_enable_disable(TRUE);
#define remote_toolbar_disable()   remote_toolbar_enable_disable(FALSE);
void show_or_hide_ftp_prompt (GtkWidget * widget);
void reset_ftp_sort_options (void);
void update_ftplist (char *pathname);
void refresh_ftplist (void);
void show_progress_list (void);
void toggle_remote_hidden (void);
void toggle_remote_columns_visibility (void);
void toggle_resolve_links (void);
void remote_sort_from_menu (GtkWidget * widget, gint column);
void remote_sort_type_from_menu (GtkWidget * widget, int data);
void clear_ftplist (void);
gint remote_selection_info (void);
void remote_focus_update (void);

void remote_select_all (GtkWidget * widget, gpointer data);
void remote_select_all_files (GtkWidget * widget, gpointer data);
void remote_unselect_all (GtkWidget * widget, gpointer data);
void remote_invert_selection (GtkWidget * widget, gpointer data);
void remote_undo_last_selection (GtkWidget * widget, gpointer data);

void remote_find_dialog (GtkWidget * widget, gpointer data);
void remote_find_next_dialog (GtkWidget * widget, gpointer data);
void remote_group_select_dialog (GtkWidget * widget, gpointer data);
void remote_group_deselect_dialog (GtkWidget * widget, gpointer data);
void remote_filter_dialog (GtkWidget * widget, gpointer data);
void remote_dir_info (GtkWidget * widget, gpointer data);
void remote_compare_directories (GtkWidget * widget, gpointer data);

void remote_file_view (void);
void remote_file_edit (void);
void remote_change_directory_dialog (GtkWidget * widget, gpointer data);
void remote_create_directory_dialog (GtkWidget * widget, gpointer data);
void remote_rename_dialog (GtkWidget * widget, gpointer data);
void remote_chmod_dialog (GtkWidget * widget, gpointer data);
void remote_delete_dialog (GtkWidget * widget, gpointer data);
void remote_move_dialog (GtkWidget * widget, gpointer data);
char remote_get_fileinfo (char *search_filename, FILEINFO * file_info);

void download_selection (GtkWidget * widget, gpointer data);
void queue_selection_for_download (void);
char queue_download_selection (char *search_filename, char IS_DIR);


/* LIST SHARE - list_share.c */
void FOCUS_LIST_view_file (GtkWidget * widget, gpointer data);
void FOCUS_LIST_edit_file (GtkWidget * widget, gpointer data);
void FOCUS_LIST_exec (GtkWidget * widget, gpointer data);
void FOCUS_LIST_rename (GtkWidget * widget, gpointer data);
void FOCUS_LIST_delete (GtkWidget * widget, gpointer data);
void FOCUS_LIST_move (GtkWidget * widget, gpointer data);
void FOCUS_LIST_chdir (GtkWidget * widget, gpointer data);
void FOCUS_LIST_mkdir (GtkWidget * widget, gpointer data);
void FOCUS_LIST_find (GtkWidget * widget, gpointer data);
void FOCUS_LIST_find_next (GtkWidget * widget, gpointer data);
void FOCUS_LIST_invert_selection (GtkWidget * widget, gpointer data);
void FOCUS_LIST_group_select (GtkWidget * widget, gpointer data);
void FOCUS_LIST_group_deselect (GtkWidget * widget, gpointer data);
void FOCUS_LIST_group_deselect (GtkWidget * widget, gpointer data);
void FOCUS_LIST_filter (GtkWidget * widget, gpointer data);
void FOCUS_LIST_dir_info (GtkWidget * widget, gpointer data);
void FOCUS_LIST_compare_windows (GtkWidget * widget, gpointer data);
void FOCUS_LIST_refresh (GtkWidget * widget, gpointer data);

void list_share_group_select_deselect (GtkWidget * widget, GRPSELECTwidgets * grp_widgets,
     GtkWidget * this_clist, int this_last_dir_row, int this_last_file_row);


/* LIST FILTER - list_filter.c */
char FILTER_determine_search_type (char *search_buf, char **search_ptr);
char FILTER_is_string_match (char search_type, char *this_string, char *search_ptr);



/* RDC - RDC.c */
void RDC_DOS2UNIX (char *buf);
void RDC_create_site_root (void);
void RDC_create_site_dir (char *this_dir);
void RDC_clear (void);
void RDC_clean_now (GtkWidget * widget, gpointer data);
void RDC_regular_clean (void);
void toggle_RDC (void);
void RDC_close_all_dirs (void);

#define RDC_TREE_BROWSED_FLAG 0
#define RDC_TREE_OPEN_FLAG 1

#define RDC_mark_tree_open(x) RDC_flag_status(x, RDC_TREE_OPEN_FLAG, TRUE)
#define RDC_mark_tree_closed(x) RDC_flag_status(x, RDC_TREE_OPEN_FLAG, FALSE)
#define RDC_mark_tree_browsed(x) RDC_flag_status(x, RDC_TREE_BROWSED_FLAG, TRUE)
#define RDC_mark_tree_unbrowsed(x) RDC_flag_status(x, RDC_TREE_BROWSED_FLAG, FALSE)
void RDC_flag_status (char *this_path, int what_flag, char FLAG);

#define RDC_is_tree_open(x) RDC_return_flag_status(x, RDC_TREE_OPEN_FLAG, TRUE)
#define RDC_is_tree_browsed(x) RDC_return_flag_status(x, RDC_TREE_BROWSED_FLAG, TRUE)
#define RDC_is_tree_unbrowsed(x) RDC_return_flag_status(x, RDC_TREE_BROWSED_FLAG, FALSE)
char RDC_return_flag_status (char *this_path, int what_flag, char FLAG);


/* QUEUE - queue.c */
GtkWidget *create_queuelist (void);
void show_or_hide_queue (GtkWidget * widget);
void active_queue (char FLAG);
gint queue_selection_info (void);
gint are_there_entries_in_queue (void);
void QUEUE_add_file (char *filename, char *filesize, char IS_A_DIR, char XFER_TYPE);
void QUEUE_show_info (GtkWidget * widget, gpointer data);
void QUEUE_add_selection (GtkWidget * widget, gpointer data);
void QUEUE_remove_selected (GtkWidget * widget, gpointer data);
void QUEUE_move_to_top (GtkWidget * widget, gpointer data);
void QUEUE_move_to_bottom (GtkWidget * widget, gpointer data);
void QUEUE_clear (GtkWidget * widget, gpointer data);
void QUEUE_save_current (void);
void QUEUE_save_as_dialog (GtkWidget * widget, gpointer data);
void QUEUE_load_current (void);
void QUEUE_load_dialog (GtkWidget * widget, gpointer data);
void QUEUE_xfer (void);
char QUEUE_xfer_has_log (void);
void QUEUE_xfer_show_log (GtkWidget * widget, gpointer data);


/* CONSOLE - console.c */
GtkWidget *create_consolelist (void);
void show_or_hide_console (GtkWidget * widget);
void ftp_copyright (void);
void ftp_message (char *this_message);
void host_message (char *this_message);
void local_message (char *this_message);
void info_message (char *this_message);
void error_message (char *this_message);
void show_last_connexion_log (GtkWidget * widget, gpointer data);



/* MESSAGES - messages.c */
void close_host_welcome (void);
void host_welcome_message (char *this_message, char MUST_APPEND);
void move_welcome_message (void);
void close_host_dir_content (void);
void host_dir_content_message (char *this_message);
void move_dir_content_message (void);
#define popup_window_host_welcome_message() show_popup_window_message (TRUE)
#define popup_window_host_directory_message() show_popup_window_message (FALSE)
void show_popup_window_message (char IS_WELCOME);
void show_popup_window_message_from_widget (GtkWidget * widget, gpointer data);


/* LOG - log.c  */
void close_user_lastlog (void);
void lastlog (char *from_who, char *this_message);



/* EXECUTE - execute.c */
void execute_program (char *program, char *arg);
#define local_execute_view_or_edit_file(a,b) execute_view_or_edit_file(a,b,FALSE)
#define remote_execute_view_or_edit_file(a,b) execute_view_or_edit_file(a,b,TRUE)
void execute_view_or_edit_file (char *filename, char WANT_EDIT, char IS_REMOTE);
void REXEC_end (void);
void TXT_show (char *filename);
void TXT_edit (char *filename);
void text_edit_from_widget (GtkWidget * widget, gpointer data);
void Xterm (void);
void execute_usr_command_dialog (GtkWidget * widget, gpointer data);
void open_URL (char *this_url);
void open_URL_from_widget (GtkWidget * widget, gpointer data);
void open_mail_client (void);
void open_new_message (void);
void open_news_client (void);



/* VERSION - version.c */
char *many_version_infos (char *buf);
char *a_parano_version_infos (char *buf);
char *http_version_infos (char *buf);
char *a_little_version_infos (char *buf);
char *a_little_more_infos (char *buf);
char *yet_a_little_more_infos (char *buf);
char *what_is_this_stupid_programm_that_have_crashed (char *buf);
char *version (char *buf);
char is_it_a_new_prog_version (char *buf);
char *compile_host (char *buf);



/* STRINGS - string.c */
char *strexpand (char *string, char *search_string, char *replace_string);
char *strupr (char *string);
char *strlwr (char *string);
char *strunlf (char *string);
char *strlf (char *string);
char *StrMode (char *buf, mode_t mode);
char *StrNumMode (char *buf_mode, char *perm);
char *MemFrob (void *buf, size_t buf_len);
char *decode_url (char *this_url);
char parse_ftp_url (char *this_url, char *this_user, char *this_pass, char *this_host, char *this_port, char *this_dir, char *this_file, char *this_type);



/* SITE MANAGER -  smanager.c */
void SMAN_bookmark_path_dialog (GtkWidget * widget, gpointer data);
void SMAN_bookmark_site_dialog (GtkWidget * widget, gpointer data);
void SMAN_bookmark_site_edit (void);
void SMAN_bookmark_save_local_dir (void);
void SMAN_bookmark_save_remote_dir (void);
void switch_smanager_panel (void);
GtkWidget *create_smanager (void);
void SMAN_parse_bookmarks_file (void);
void SMAN_save_bookmarks_file (void);
void SMAN_group_add_dialog (GtkWidget * widget, gpointer data);
void SMAN_group_edit_dialog (GtkWidget * widget, gpointer data);
void SMAN_group_delete_dialog (void);
void SMAN_site_add (void);
void SMAN_site_edit (void);
void SMAN_site_duplicate (void);
void SMAN_site_delete_dialog (void);



/* SESSION - session.c */
char load_session (void);
void spawn_session_from_widget (GtkWidget * widget, gpointer data);
void new_session_from_widget (GtkWidget * widget, gpointer data);


/* IGLOOFTP -  IGLOOftp.c */
#define  CHECK_CONNEXION if(this_connexion.connexion_lost) return  IGLOO_connexion_lost();
#define  CHECK_CONNEXION_VOID if(this_connexion.connexion_lost) {IGLOO_connexion_lost();return;}

//void test_timeout (void);
void IGLOO_init_session (FTPsession * that_session);
void IGLOO_default_session (void);
int IGLOO_connect (void);
int IGLOO_login (void);
void IGLOO_connect_or_reconnect (void);
void IGLOO_load_session_and_connect (void);
void IGLOO_connect_from_site_manager (MANAGERsite * this_site);
void IGLOO_connect_from_URL (char *this_url);
void IGLOO_abort (void);
char IGLOO_logoff (char CLOSE_ALL);
int IGLOO_connexion_lost (void);
int IGLOO_pwd (void);
int IGLOO_cwd (char *path);
#define IGLOO_chmod(x,y) FTP_CHMOD(&this_connexion, x, y)
#define IGLOO_mkd(x) FTP_MKD (&this_connexion, x)
#define IGLOO_rmd(x) FTP_RMD (&this_connexion, x)
#define IGLOO_delete(x) FTP_DELETE (&this_connexion, x)
#define IGLOO_rename(x,y) FTP_RENAME (&this_connexion, x, y)
#define IGLOO_rest(x)  FTP_REST (&this_connexion, x)

#define IGLOO_download(a,b,c,d) IGLOO_download_from(a,a,b,c,d)
int IGLOO_download_from (char *src_filename, char *dest_filename, char *filesize, char *filedate, char *fileperm);
#define IGLOO_upload(a,b,c,d) IGLOO_upload_from(a,a,b,c,d)
int IGLOO_upload_from (char *src_filename, char *dest_filename, char *filesize, char *filedate, char *fileperm);
void IGLOO_start_idle (void);
void IGLOO_end_idle (void);
#define IDLE_START  if(anti_idle && !anti_idle_timeout) IGLOO_start_idle()
#define IDLE_END  if(anti_idle) IGLOO_end_idle()
void toggle_anti_idle (GtkWidget * widget);



/* EOF */
