/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "protos.h"






void
I_want_only_one_slash_here (char *buf)
{
  char *tmp_buf = g_strdup (buf);
  register int pos = 0;
  char last_char = 0;
  char *ptr = buf;
  char *tmp_ptr = tmp_buf;
  for (pos = 0; pos < strlen (buf); pos++)
    {
      if (*tmp_ptr != '/')
	*(ptr++) = *tmp_ptr;
      else if (last_char != '/')
	*(ptr++) = *tmp_ptr;

      last_char = *(tmp_ptr++);
    }
  *ptr = 0;

  g_free (tmp_buf);
}



static char
file_copy (char *src_filename, char *dest_filename)
{
  FILE *in;
  FILE *out;
  char buf[1024];
  size_t buf_len;

  if ((in = fopen (src_filename, "r")) == NULL)
    return FALSE;

  if ((out = fopen (dest_filename, "w")) == NULL)
    return FALSE;

  while ((buf_len = fread (buf, 1, sizeof (buf), in)) > 0)
    fwrite (buf, 1, buf_len, out);

  fclose (in);
  fclose (out);

  return TRUE;
}



char *
preference_dir (char *buf)
{
  sprintf (buf, "%s/%s", home_path, PREFERENCES_PATH);
  return buf;
}



char *
layout_path (char *buf)
{
  sprintf (buf, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_LAYOUT);
  return buf;
}


char *
text_ext_path (char *buf)
{
  sprintf (buf, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_TEXT_EXT);
  return buf;
}




char *
preferences_path (char *buf)
{
  sprintf (buf, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_PREFERENCES);
  return buf;
}


char *
queue_dir (char *buf)
{
  sprintf (buf, "%s/%s/%s", home_path, PREFERENCES_PATH, QUEUE_DIR);
  return buf;
}

char *
queue_path (char *buf, char *queuename)
{
  sprintf (buf, "%s/%s/%s/%s%s", home_path, PREFERENCES_PATH, QUEUE_DIR, queuename, QUEUE_EXT);
  return buf;
}

char *
queue_log_path (char *buf, char *queuename)
{
  sprintf (buf, "%s/%s/%s/%s.xfer_log", home_path, PREFERENCES_PATH, QUEUE_DIR, queuename);
  return buf;
}

char *
files_assoc_dir (char *buf)
{
  sprintf (buf, "%s/%s/%s", home_path, PREFERENCES_PATH, USER_FILES_ASSOC_DIR);
  return buf;
}


char *
files_assoc_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s", home_path, PREFERENCES_PATH, USER_FILES_ASSOC_DIR, USER_FILES_ASSOC);
  return buf;
}


char *
host_history_path (char *buf)
{
  sprintf (buf, "%s/%s/%s", home_path, PREFERENCES_PATH, HOST_HISTORY);
  return buf;
}


char *
spaw_session_path (char *buf)
{
  sprintf (buf, "%s/%s/%s", home_path, PREFERENCES_PATH, SPAWN_TMP);
  return buf;
}


char *
bookmarks_dir (char *buf)
{
  sprintf (buf, "%s/%s/%s", home_path, PREFERENCES_PATH, BMK_DIR);
  return buf;
}


char *
bookmarks_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s", home_path, PREFERENCES_PATH, BMK_DIR, USER_BMK);
  return buf;
}


char *
bookmarks_default_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s", home_path, PREFERENCES_PATH, BMK_DIR, DEFAULT_BMK);
  return buf;
}


char *
tmp_cache_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/tmp", home_path, PREFERENCES_PATH, CACHE_DIR);
  return buf;
}


char *
REXEC_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/tmp/REXEC", home_path, PREFERENCES_PATH, CACHE_DIR);
  return buf;
}



char *
RDC_welcome_message_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s/%s-%s/welcome", home_path, PREFERENCES_PATH, CACHE_DIR, RDC_DIR,
	   RDC_SITE_DIR, this_session.username);
  return buf;
}

char *
RDC_welcome_message_tmp_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s/welcome", home_path, PREFERENCES_PATH, CACHE_DIR, RDC_DIR);
  return buf;
}


char *
RDC_directory_message_tmp_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s/message", home_path, PREFERENCES_PATH, CACHE_DIR, RDC_DIR);
  return buf;
}


char *
RDC_directory_message_path (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s/%s-%s/%s/message", home_path, PREFERENCES_PATH, CACHE_DIR, RDC_DIR,
	   RDC_SITE_DIR, this_session.username, this_session.cwd_dir);
  I_want_only_one_slash_here (buf);
  RDC_DOS2UNIX (buf);
  return buf;
}



char *
RDC_main_dir (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s", home_path, PREFERENCES_PATH, CACHE_DIR, RDC_DIR);
  return buf;
}

char *
RDC_site_root_dir (char *buf)
{
  sprintf (buf, "%s/%s/%s/%s/%s-%s", home_path, PREFERENCES_PATH, CACHE_DIR, RDC_DIR,
	   RDC_SITE_DIR, this_session.username);
  return buf;
}

char *
RDC_site_dir_dir (char *buf, char *this_dir)
{
  sprintf (buf, "%s/%s/%s/%s/%s-%s/%s", home_path, PREFERENCES_PATH, CACHE_DIR, RDC_DIR,
	   RDC_SITE_DIR, this_session.username, this_dir);
  I_want_only_one_slash_here (buf);

  RDC_DOS2UNIX (buf);
  return buf;
}

char *
RDC_site_dir_listing (char *buf, char *this_dir)
{
  sprintf (buf, "%s/%s/%s/%s/%s-%s/%s/%s", home_path, PREFERENCES_PATH, CACHE_DIR, RDC_DIR,
	   RDC_SITE_DIR, this_session.username, this_dir, RDC_LIST);
  I_want_only_one_slash_here (buf);

  if (this_connexion.resolve_link)
    strcat (buf, ".R");

  RDC_DOS2UNIX (buf);
  return buf;
}



void
init_user_folders (void)
{
  char this_path[MPLEN];
  create_dir (preference_dir (this_path), RC_FOLDER_PERM);
  create_dir (bookmarks_dir (this_path), RC_FOLDER_PERM);
  create_dir (files_assoc_dir (this_path), RC_FOLDER_PERM);
  create_dir (queue_dir (this_path), RC_FOLDER_PERM);
  create_dir (RDC_main_dir (this_path), RC_FOLDER_PERM);
  create_dir (tmp_cache_path (this_path), RC_FOLDER_PERM);
}


void
init_user_configuration_files (void)
{
  char src_path[MPLEN];
  char dest_path[MPLEN];
  char assoc_path[MPLEN];
  char *app_ass_ext[] =
  {"GNOME", "KDE", "default"};
  int f;
#define MAX_EXT 3

  /* bookmarks */
  bookmarks_default_path (dest_path);
  if (access (dest_path, F_OK) == -1)
    {
      sprintf (src_path, "%s/%s/%s", SHARE_PATH, BMK_DIR, DEFAULT_BMK);
      file_copy (src_path, dest_path);
    }

  strcpy (src_path, dest_path);
  bookmarks_path (dest_path);

  if (access (dest_path, F_OK) == -1)
    symlink (src_path, dest_path);


  /* app_ass */
  files_assoc_path (assoc_path);

  for (f = 0; f < MAX_EXT; f++)
    {
      sprintf (dest_path, "%s.%s", assoc_path, app_ass_ext[f]);
      sprintf (src_path, "%s/%s/%s.%s", SHARE_PATH, USER_FILES_ASSOC_DIR, USER_FILES_ASSOC, app_ass_ext[f]);
      if (access (dest_path, F_OK) == -1)
	file_copy (src_path, dest_path);
    }

  if (access (assoc_path, F_OK) == -1)
    symlink (dest_path, assoc_path);

}



void
clean_user_folders (void)
{
  char this_path[MPLEN];
  delete_dir (tmp_cache_path (this_path));
  RDC_regular_clean ();
}


/* EOF */
