/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "protos.h"
#include "messages.h"





/*
   * WELCOME MESSAGE functions
   * PUBLIC :
   * close_host_welcome
   * host_welcome_message
   * STATIC :
   * open_host_welcome
   * reopen_host_welcome
 */

void
close_host_welcome (void)
{
  if (FILE_host_welcome != NULL)
    {
      fprintf (FILE_host_welcome, "\n\n");
      fflush (FILE_host_welcome);
      fclose (FILE_host_welcome);
      FILE_host_welcome = NULL;
    }
}

static void
open_host_welcome (void)
{
  char buf[1024];
  close_host_welcome ();
  FILE_host_welcome = fopen (RDC_welcome_message_tmp_path (buf), "w");
}

static void
reopen_host_welcome (void)
{
  char buf[1024];
  close_host_welcome ();
  RDC_welcome_message_tmp_path (buf);
  FILE_host_welcome = fopen (buf, (access (buf, F_OK)) ? "w" : "a");
}

void
host_welcome_message (char *this_message, char MUST_APPEND)
{
  if (!strlen (this_message))
    return;

  if (FILE_host_welcome == NULL)
    MUST_APPEND ? reopen_host_welcome () : open_host_welcome ();

  if (FILE_host_welcome == NULL)
    return;

  fprintf (FILE_host_welcome, " %s%s", (char *) this_message + 4, (this_message[strlen (this_message) - 1] != '\n') ? "\n" : "");
}


void
move_welcome_message (void)
{
  char buf[1024];
  char new_buf[1024];
  RDC_welcome_message_tmp_path (buf);
  if (!access (buf, F_OK))
    rename (buf, RDC_welcome_message_path (new_buf));
}




/*
   * DIRECTORY MESSAGE functions
   * PUBLIC :
   * close_host_dir_content
   * host_host_dir_content
   * move_dir_content_message
   * STATIC :
   * host_dir_content_message
 */

void
close_host_dir_content (void)
{
  if (FILE_host_dir_content != NULL)
    {
      fprintf (FILE_host_dir_content, "\n\n");
      fflush (FILE_host_dir_content);
      fclose (FILE_host_dir_content);
      FILE_host_dir_content = NULL;
    }
}

static void
open_host_dir_content (void)
{
  char buf[1024];
  close_host_dir_content ();
  FILE_host_dir_content = fopen (RDC_directory_message_tmp_path (buf), "w");
}

void
host_dir_content_message (char *this_message)
{
  if (!strlen (this_message))
    return;

  if (FILE_host_dir_content == NULL)
    open_host_dir_content ();

  if (FILE_host_dir_content == NULL)
    return;

  fprintf (FILE_host_dir_content, " %s%s", (char *) this_message + 4, (this_message[strlen (this_message) - 1] != '\n') ? "\n" : "");
}

void
move_dir_content_message (void)
{
  char buf[1024];
  char new_buf[1024];
  RDC_directory_message_tmp_path (buf);
  if (!access (buf, F_OK))
    rename (buf, RDC_directory_message_path (new_buf));
}









/*
   * WINDOW functions
   * PUBLIC :
   * show_popup_window_message 
   * show_popup_window_message_from_widget 
 */


void
show_popup_window_message (char IS_WELCOME)
{
  FILE *in;
  struct stat stat_buf;
  gchar *message_buf;
  char path_buf[1024];


  IS_WELCOME ? RDC_welcome_message_path (path_buf) : RDC_directory_message_path (path_buf);

  if (access (path_buf, F_OK) || stat (path_buf, &stat_buf))
    return;

#define MESSAGE_LEN (off_t) stat_buf.st_size

  if (!MESSAGE_LEN)
    return;

  if ((message_buf = (char *) g_malloc (MESSAGE_LEN + 1)) == NULL)
    return;

  memset (message_buf, 0, sizeof (message_buf));

  in = fopen (path_buf, "r");
  fread (message_buf, MESSAGE_LEN, 1, in);
  fclose (in);
  message_buf[MESSAGE_LEN] = 0;

  resizable_text_dialog ((IS_WELCOME) ? "Host Welcome Message" : "Host Directory Message", message_buf, 600, 300);

  g_free (message_buf);
}


void
show_popup_window_message_from_widget (GtkWidget * widget, gpointer data)
{
  show_popup_window_message ((int) GPOINTER_TO_INT (data));
}

/* EOF */
