/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


static int local_sort_by_name_down (const void *a, const void *b);
static int local_sort_by_name_up (const void *a, const void *b);
static int local_sort_by_size_down (const void *a, const void *b);
static int local_sort_by_size_up (const void *b, const void *a);
static int local_sort_by_date_down (const void *a, const void *b);
static int local_sort_by_date_up (const void *b, const void *a);
static int local_sort_by_perm_down (const void *a, const void *b);
static int local_sort_by_perm_up (const void *b, const void *a);
static int local_sort_by_uid (const void *a, const void *b);
static int local_sort_by_gid (const void *a, const void *b);





/* SORT BY NAME */

static int
local_sort_by_name_down (const void *a, const void *b)
{
  return strcmp ((*(const struct dirent **) a)->d_name, (*(const struct dirent **) b)->d_name);
}

static int
local_sort_by_name_up (const void *a, const void *b)
{
  return strcmp ((*(const struct dirent **) b)->d_name, (*(const struct dirent **) a)->d_name);
}



/* SORT BY SIZE */

static int
local_sort_by_size_down (const void *a, const void *b)
{
  struct stat a_stat_buf;
  struct stat b_stat_buf;
  lstat ((*(const struct dirent **) a)->d_name, &a_stat_buf);
  lstat ((*(const struct dirent **) b)->d_name, &b_stat_buf);
  return a_stat_buf.st_size - b_stat_buf.st_size;
}

static int
local_sort_by_size_up (const void *b, const void *a)
{
  struct stat a_stat_buf;
  struct stat b_stat_buf;
  lstat ((*(const struct dirent **) a)->d_name, &a_stat_buf);
  lstat ((*(const struct dirent **) b)->d_name, &b_stat_buf);
  return a_stat_buf.st_size - b_stat_buf.st_size;
}



/* SORT BY DATE */

static int
local_sort_by_date_down (const void *a, const void *b)
{
  struct stat a_stat_buf;
  struct stat b_stat_buf;
  stat ((*(const struct dirent **) a)->d_name, &a_stat_buf);
  stat ((*(const struct dirent **) b)->d_name, &b_stat_buf);
  return a_stat_buf.st_mtime - b_stat_buf.st_mtime;
}

static int
local_sort_by_date_up (const void *b, const void *a)
{
  struct stat a_stat_buf;
  struct stat b_stat_buf;
  stat ((*(const struct dirent **) a)->d_name, &a_stat_buf);
  stat ((*(const struct dirent **) b)->d_name, &b_stat_buf);
  return a_stat_buf.st_mtime - b_stat_buf.st_mtime;
}



/* SORT BY PERM */

static int
local_sort_by_perm_down (const void *a, const void *b)
{
  struct stat a_stat_buf;
  struct stat b_stat_buf;
  lstat ((*(const struct dirent **) a)->d_name, &a_stat_buf);
  lstat ((*(const struct dirent **) b)->d_name, &b_stat_buf);
  return a_stat_buf.st_mode - b_stat_buf.st_mode;
}

static int
local_sort_by_perm_up (const void *b, const void *a)
{
  struct stat a_stat_buf;
  struct stat b_stat_buf;
  lstat ((*(const struct dirent **) a)->d_name, &a_stat_buf);
  lstat ((*(const struct dirent **) b)->d_name, &b_stat_buf);
  return a_stat_buf.st_mode - b_stat_buf.st_mode;
}



/* SORT BY UID */

static int
local_sort_by_uid (const void *a, const void *b)
{
  struct stat stat_buf;
  struct passwd *pwd_buf;
  char a_owner[128];
  char b_owner[128];

  stat ((*(const struct dirent **) a)->d_name, &stat_buf);
  if ((pwd_buf = getpwuid (stat_buf.st_uid)) == NULL)
    sprintf (a_owner, "%20d", stat_buf.st_uid);
  else
    strcpy (a_owner, pwd_buf->pw_name);

  stat ((*(const struct dirent **) b)->d_name, &stat_buf);
  if ((pwd_buf = getpwuid (stat_buf.st_uid)) == NULL)
    sprintf (b_owner, "%20d", stat_buf.st_uid);
  else
    strcpy (b_owner, pwd_buf->pw_name);

  if (local_clist_sort_type == SORT_DOWN)
    return strcmp (a_owner, b_owner);
  return strcmp (b_owner, a_owner);
}



/* SORT BY GID */

static int
local_sort_by_gid (const void *a, const void *b)
{
  struct stat stat_buf;
  struct group *grp_buf;
  char a_group[128];
  char b_group[128];

  stat ((*(const struct dirent **) a)->d_name, &stat_buf);
  if ((grp_buf = getgrgid (stat_buf.st_gid)) == NULL)
    sprintf (a_group, "%20d", stat_buf.st_gid);
  else
    strcpy (a_group, grp_buf->gr_name);

  stat ((*(const struct dirent **) b)->d_name, &stat_buf);
  if ((grp_buf = getgrgid (stat_buf.st_gid)) == NULL)
    sprintf (b_group, "%20d", stat_buf.st_gid);
  else
    strcpy (b_group, grp_buf->gr_name);

  if (local_clist_sort_type == SORT_DOWN)
    return strcmp (a_group, b_group);
  return strcmp (b_group, a_group);
}


/* EOF */
