/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include "protos.h"



static void
layout_get (void)
{
  gdk_window_get_size (window->window, &main_window_width, &main_window_height);
  gdk_window_get_origin (window->window, &main_window_x, &main_window_y);
  main_pane_pos = GTK_PANED (main_panel)->child1_size;
  top_pane_pos = GTK_PANED (top_panel)->child1_size;

  clist_pane_pos = GTK_PANED (clist_panel)->child1_size;

}


void
layout_set_defaults (void)
{
  layout_autosave = FALSE;
  main_window_x = 0;
  main_window_y = 0;
  main_window_height = 550;
  main_window_width = 750;

  main_pane_pos = 352;
  top_pane_pos = 54;
  clist_pane_pos = 327;

}



void
layout_realize (void)
{
  if (main_window_x && main_window_y)
    gtk_widget_set_uposition (GTK_WIDGET (window), main_window_x, main_window_y);
  PROCESS_EVENTS;

  gdk_window_resize (window->window, main_window_width, main_window_height);
  PROCESS_EVENTS;


  gtk_paned_set_position (GTK_PANED (main_panel), user_rc.view_queue ? main_pane_pos : main_window_height);
  PROCESS_EVENTS;
  if (!user_rc.view_console)
    gtk_paned_set_position (GTK_PANED (top_panel), 0);
  PROCESS_EVENTS;
  gtk_paned_set_position (GTK_PANED (clist_panel), clist_pane_pos);
  PROCESS_EVENTS;


  gtk_window_set_default_size (GTK_WINDOW (window), main_window_width, main_window_height);
  PROCESS_EVENTS;
}






void
layout_save (char RESET)
{
  FILE *layout_file;
  char this_path[1024];

  layout_path (this_path);
  if ((layout_file = fopen (this_path, "w")) == NULL)
    {
      alert_ok ("Error", "Can't save layout ini file.", "Ok");
      return;
    }

  RESET ? layout_set_defaults () : layout_get ();

  fprintf (layout_file, "# IglooFTP layout configuration file.\n\n");

  fprintf (layout_file, "AUTO_SAVE=%i\n", layout_autosave ? 1 : 0);
  fprintf (layout_file, "MAIN_WINDOW_X=%i\nMAIN_WINDOW_Y=%i\nMAIN_WINDOW_HEIGHT=%i\nMAIN_WINDOW_WIDTH=%i\n",
       main_window_x, main_window_y, main_window_height, main_window_width);

  fprintf (layout_file, "MAIN_PANE_POS=%i\n", main_pane_pos);
  fprintf (layout_file, "TOP_PANE_POS=%i\n", top_pane_pos);

  fprintf (layout_file, "CLIST_PANE_POS=%i\n", clist_pane_pos);

  fprintf (layout_file, "\n# END OF IglooFTP layout configuration file.");
  fflush (layout_file);
  fclose (layout_file);
}


void
layout_reset (void)
{
  layout_save (TRUE);
  gtk_check_menu_item_set_state (GTK_CHECK_MENU_ITEM (check_layout_autosave), FALSE);
  layout_realize ();
}


void
layout_reload (void)
{
  layout_load ();
  layout_realize ();
}


void
layout_save_from_widget (void)
{
  layout_save (FALSE);
}



void
layout_set_autosave (GtkWidget * widget)
{
  layout_autosave = GTK_CHECK_MENU_ITEM (widget)->active;
  layout_save (FALSE);
}




#define FIELD_INT (int) atoi(strchr(this_line,'=')+1)
#define LOAD_LAYOUT(a,b);  if (strstr (this_line, a)) {b = FIELD_INT;continue;}

void
layout_load (void)
{
  FILE *layout_file;
  char this_path[1024];
  char this_line[256];
  int this_line_number = 0;

  layout_path (this_path);
  window == NULL ? layout_set_defaults () : layout_get ();

  if (access (this_path, F_OK))
    return;

  if ((layout_file = fopen (this_path, "r")) == NULL)
    return;


  while (fgets (this_line, sizeof (this_line), layout_file) != NULL)
    {
      this_line_number++;

      if (this_line[strlen (this_line) - 1] == '\n')
	this_line[strlen (this_line) - 1] = 0;

      if (!strlen (this_line))
	continue;

      if (this_line[0] == '#')
	continue;

      if (strstr (this_line, "AUTO_SAVE="))
	{
	  layout_autosave = (FIELD_INT == 1);
	  continue;
	}

      LOAD_LAYOUT ("MAIN_WINDOW_X=", main_window_x);
      LOAD_LAYOUT ("MAIN_WINDOW_Y=", main_window_y);

      LOAD_LAYOUT ("MAIN_WINDOW_HEIGHT=", main_window_height);
      LOAD_LAYOUT ("MAIN_WINDOW_WIDTH=", main_window_width);

      LOAD_LAYOUT ("MAIN_PANE_POS=", main_pane_pos);
      LOAD_LAYOUT ("TOP_PANE_POS=", top_pane_pos);


      LOAD_LAYOUT ("CLIST_PANE_POS=", clist_pane_pos);
      if (strstr (this_line, "BOTTOM_PANE_POS="))
	continue;


      printf ("IglooFTP : Syntax error in %s\n", this_path);
      printf ("Line %i : %s\n", this_line_number, this_line);
    }

  fclose (layout_file);
}

/* EOF */
