/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

static GtkWidget *ftplist_box;
static GtkWidget *clist;
static GtkWidget *ftp_panel_box;
static GtkWidget *sort_arrow[8];
static GtkWidget *clist_window;
static GtkWidget *browser_box;
static GtkWidget *browser_window = NULL;
static GtkWidget *combo;
static GtkWidget *label_info;
static GtkWidget *frame_info;
static GtkWidget *prompt_entry;
static GtkWidget *button_browser_open;
static GtkWidget *button_browser_close;
static GtkWidget *button_cdup;
static GList *combo_items;
#define FTP_COMBO_ENTRY GTK_ENTRY(GTK_COMBO (combo)->entry)
#define FTP_COMBO_LIST GTK_LIST(GTK_COMBO(combo)->list)

static int last_dir_row;
static int last_file_row;
static int search_row;
static long total_size;
static char clist_col_sort;
static char label_info_text[100];
static char directory_search_string[128];
static char filter_search_type;
static char *filter_search_ptr = NULL;



static char UPDATE_POPUP_MENU = TRUE;
static char UPDATE_POPUP_MENU_SORT = TRUE;
static char UPDATE_POPUP_MENU_SORT_TYPE = TRUE;
static char UPDATE_TOOLBAR = TRUE;
static char WANT_REFRESH = FALSE;
static char WANT_RESORT = FALSE;

#define RECURSIVE_CHMOD 1
#define RECURSIVE_DELETE 2

#define MAX_FTP_COL 7


typedef struct
  {
    char name[1024];
    struct stat stat_buf;
  }
EDITfileinfo;



static void ftplist_cdup (GtkWidget * widget, gpointer data);

static void ftplist_selection_made (GtkWidget * this_list, gint row, gint column, GdkEventButton * event, gpointer data);
static gint clist_event_handler (GtkWidget * this_list, GdkEvent * event, gpointer data);
static void clist_button_clicked (GtkCList * clist, gint column);

static long remote_selection_size (void);


static void clear_combo (void);
static void update_combo (char *pathname);
static void ftp_combo_new_selection (GtkWidget * entry);


static void execute_user_command (GtkWidget * entry, GdkEventKey * event, gpointer data);

static void perfom_recursive_command_on_selection (char recursive_command, char *optionnal_arg, char IS_TOP_DIR);
static void remote_chmod (GtkWidget * widget, GtkWidget * entry);
static void remote_delete (GtkWidget * widget, GtkWidget * entry);
static void remote_rename (GtkWidget * widget, GtkWidget * entry);
static void remote_move (GtkWidget * widget, GtkWidget * entry);
static void remote_create_directory (GtkWidget * widget, GtkWidget * entry);
static void remote_change_directory (GtkWidget * widget, GtkWidget * entry);

static char download_selection_recursive (void);
/* EOF */
