/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */


#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "protos.h"


static int dup_selected;
static char modal_entry_buf[256];
static GtkWidget *modal_entry;
static GtkWidget *dir_browser_window = NULL;

typedef struct
  {
    GtkWidget *label;
    GtkWidget *entry;
  }
DIRbrowser;



GtkWidget *
create_alert_label (GtkWidget * box, char *this_text, gfloat xalignement, gfloat yalignement)
{
  GtkWidget *alert_label = gtk_label_new (this_text);
  gtk_misc_set_alignment (GTK_MISC (alert_label), xalignement, yalignement);
  gtk_box_pack_start (GTK_BOX (box), alert_label, FALSE, FALSE, 0);
  gtk_widget_show (alert_label);
  return alert_label;
}



GtkWidget *
create_dialog_window (GtkWindowType win_TYPE, GtkWindowPosition win_POS, char *win_title, GtkWidget ** this_box)
{
  GtkWidget *alert_window;
  GtkWidget *alert_frame;

  alert_window = gtk_window_new (win_TYPE);
  if (win_TYPE != GTK_WINDOW_POPUP)
    gtk_window_set_title (GTK_WINDOW (alert_window), win_title);
  gtk_window_position (GTK_WINDOW (alert_window), win_POS);
  gtk_widget_realize (alert_window);
  gdk_window_set_decorations (alert_window->window, GDK_DECOR_BORDER | GDK_DECOR_TITLE);
  gtk_window_set_transient_for (GTK_WINDOW (alert_window), GTK_WINDOW (window));

  alert_frame = gtk_frame_new (NULL);
  gtk_widget_show (alert_frame);
  gtk_container_add (GTK_CONTAINER (alert_window), alert_frame);
  gtk_frame_set_shadow_type (GTK_FRAME (alert_frame), user_rc.view_3D_borders ? GTK_SHADOW_OUT : GTK_SHADOW_NONE);

  if (this_box != NULL)
    *this_box = v_box (alert_frame, FALSE, 0, 0);

  return alert_window;
}



/* STARTUP WINDOW */



void
create_startup_window (void)
{
  GtkWidget *alert_frame;
  GtkWidget *alert_frame1;
  GtkWidget *fixed_top;
  GtkWidget *igloo_pixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  char pixmap_path[1024];

  startup_window = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_window_position (GTK_WINDOW (startup_window), GTK_WIN_POS_CENTER);
  gtk_widget_realize (startup_window);

  alert_frame1 = gtk_frame_new (NULL);
  gtk_widget_show (alert_frame1);
  gtk_container_add (GTK_CONTAINER (startup_window), alert_frame1);
  gtk_frame_set_shadow_type (GTK_FRAME (alert_frame1), GTK_SHADOW_OUT);


  alert_frame = gtk_frame_new (NULL);
  gtk_widget_show (alert_frame);
  gtk_container_add (GTK_CONTAINER (alert_frame1), alert_frame);
  gtk_frame_set_shadow_type (GTK_FRAME (alert_frame), GTK_SHADOW_IN);
  gtk_container_border_width (GTK_CONTAINER (alert_frame), 3);

  fixed_top = gtk_fixed_new ();
  gtk_container_add (GTK_CONTAINER (alert_frame), fixed_top);
  gtk_widget_set_usize (fixed_top, 353, 225);

  sprintf (pixmap_path, "%s/xpm/iglooftp.xpm", SHARE_PATH);
  pixmap = gdk_pixmap_create_from_xpm (startup_window->window, &mask, &startup_window->style->bg[GTK_STATE_NORMAL], pixmap_path);
  igloo_pixmap = gtk_pixmap_new (pixmap, mask);

  gtk_fixed_put (GTK_FIXED (fixed_top), igloo_pixmap, 0, 0);

  startup_label = fixed_label (fixed_top, 10, 205, " ");
  gtk_widget_set_usize (startup_label, 300, 24);

  gtk_widget_show (startup_label);
  gtk_widget_show (fixed_top);

  gtk_widget_show_all (startup_window);

  PROCESS_EVENTS;
  gdk_pixmap_unref (pixmap);
  gdk_pixmap_unref (mask);
}



/* ABOUT WINDOW */


void
create_about_window (void)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  GtkWidget *igloo_pixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  char buf[128];
  char author_buf[128];
  char pixmap_path[1024];
  char *ptr;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, "About IglooFTP", &alert_vbox);
  alert_hbox = h_box (alert_vbox, FALSE, 10, 10);

  gtk_misc_set_padding (GTK_MISC (igloo_pixmap = make_program_icon ()), 0.0, 0.0);
  gtk_box_pack_start (GTK_BOX (alert_hbox), igloo_pixmap, FALSE, FALSE, 0);
  gtk_widget_show (igloo_pixmap);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);

  a_little_version_infos (buf);
  ptr = strchr (buf, '-');
  *(ptr++) = 0;
  create_alert_label (alert_vbox1, buf, 0, 0);
  create_alert_label (alert_vbox1, ++ptr, 0, 0);
  create_alert_label (alert_vbox1, "All Rights Reserved.", 0, 0);

  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 0, 0);

  sprintf (pixmap_path, "%s/xpm/little_igloo.xpm", SHARE_PATH);
  pixmap = gdk_pixmap_create_from_xpm (alert_window->window, &mask, &alert_window->style->bg[GTK_STATE_NORMAL], pixmap_path);
  igloo_pixmap = gtk_pixmap_new (pixmap, mask);

  alert_button = gtk_button_new ();
  gtk_button_set_relief (GTK_BUTTON (alert_button), GTK_RELIEF_NONE);

  gtk_container_add (GTK_CONTAINER (alert_button), igloo_pixmap);
  gtk_widget_show (igloo_pixmap);
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_button, TRUE, TRUE, 0);
  gtk_widget_show (alert_button);
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (open_URL_from_widget), strdup (HOME_URL));


  hseparator (alert_vbox);

  alert_hbox = hbutton_box (alert_vbox);

  alert_button = box_button (alert_hbox, "Close");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (alert_window));

  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);

  gtk_widget_show (alert_window);

  gdk_pixmap_unref (pixmap);
  gdk_pixmap_unref (mask);
}





/* ALERT OK */



void
alert_ok (gchar * title, gchar * alert_message, gchar * alert_button_label)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_MOUSE, title, &alert_vbox);
  if (strlen (alert_message) < 40)
    gtk_widget_set_usize (GTK_WIDGET (alert_window), 250, -1);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 10);

  exclam_icon (alert_hbox);

  create_alert_label (alert_hbox, alert_message, 0, 0.5);

  hseparator (alert_vbox);

  alert_hbox = hbutton_box (alert_vbox);

  alert_button = box_button (alert_hbox, alert_button_label);
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (alert_window));

  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);

  gtk_widget_show (alert_window);
}





/* ALERT OK_CANCEL */



void
alert_ok_cancel (gchar * title, gchar * dialog_message, gchar * first_button, GtkSignalFunc this_function)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);
  //if (strlen (dialog_message) < 40)
  //gtk_widget_set_usize (GTK_WIDGET (alert_window), 250, 125);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 10);

  inter_icon (alert_hbox);

  alert_vbox1 = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (alert_hbox), alert_vbox1);
  gtk_container_border_width (GTK_CONTAINER (alert_vbox1), 10);
  gtk_widget_show (alert_vbox1);

  create_alert_label (alert_vbox1, dialog_message, 0, 0.5);

  hseparator (alert_vbox);

  alert_hbox = hbutton_box (alert_vbox);

  alert_button = box_button (alert_hbox, first_button);
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (this_function), GTK_OBJECT (alert_button));

  box_button_cancel_destroy_window (alert_hbox, alert_window);

  gtk_widget_show (alert_window);
}



/* MODAL ALERT OK_CANCEL */



static void
alert_modal_first_button_clicked (GtkWidget * widget, int *data)
{
  *data = 1;
  gtk_main_quit ();
}

static void
alert_modal_second_button_clicked (GtkWidget * widget, int *data)
{
  *data = 2;
  gtk_main_quit ();
}



#define alert_ok_cancel_modal(a,b,c) alert_yes_no_cancel_modal(a,b,c,NULL)

int
alert_yes_no_cancel_modal (gchar * title, gchar * dialog_message, gchar * first_button, gchar * second_button)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  int return_value = 0;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 10);

  inter_icon (alert_hbox);

  alert_vbox1 = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (alert_hbox), alert_vbox1);
  gtk_container_border_width (GTK_CONTAINER (alert_vbox1), 10);
  gtk_widget_show (alert_vbox1);

  create_alert_label (alert_vbox1, dialog_message, 0, 0.5);

  hseparator (alert_vbox);

  alert_hbox = hbutton_box (alert_vbox);

  alert_button = box_button (alert_hbox, first_button);
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (alert_modal_first_button_clicked), (int *) &return_value);


  if (second_button != NULL)
    {
      alert_button = box_button (alert_hbox, second_button);
      gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (alert_modal_second_button_clicked), (int *) &return_value);
    }


  alert_button = box_button (alert_hbox, "Cancel");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);


  gtk_widget_show (alert_window);

  gtk_grab_add (alert_window);
  gtk_main ();
  gtk_grab_remove (alert_window);
  gtk_widget_destroy (alert_window);

  return return_value;
}



/*OVERWRITE DIALOG BOX */



static void
alert_overwrite_overwrite_button_clicked (GtkWidget * widget, int *data)
{
  *data = DUP_overwrite;
  gtk_main_quit ();
}
static void
alert_overwrite_overwrite_all_button_clicked (GtkWidget * widget, int *data)
{
  *data = DUP_overwrite_all;
  gtk_main_quit ();
}
static void
alert_overwrite_skip_button_clicked (GtkWidget * widget, int *data)
{
  *data = DUP_skip;
  gtk_main_quit ();
}


int
alert_overwrite_modal (gchar * title, gchar * dialog_message)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  int return_value = DUP_abort;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 10);

  inter_icon (alert_hbox);

  alert_vbox1 = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (alert_hbox), alert_vbox1);
  gtk_container_border_width (GTK_CONTAINER (alert_vbox1), 10);
  gtk_widget_show (alert_vbox1);

  create_alert_label (alert_vbox1, dialog_message, 0, 0.5);

  hseparator (alert_vbox);

  alert_hbox = hbutton_box (alert_vbox);

  alert_button = box_button (alert_hbox, "Overwrite");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (alert_overwrite_overwrite_button_clicked), (int *) &return_value);

  alert_button = box_button (alert_hbox, "Overwrite All");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (alert_overwrite_overwrite_all_button_clicked), (int *) &return_value);

  alert_button = box_button (alert_hbox, "Skip");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (alert_overwrite_skip_button_clicked), (int *) &return_value);

  alert_button = box_button (alert_hbox, "Cancel");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);


  gtk_widget_show (alert_window);

  gtk_grab_add (alert_window);
  gtk_main ();
  gtk_grab_remove (alert_window);
  gtk_widget_destroy (alert_window);

  return return_value;
}



/* ENTRY DIALOG */



void
entry_dialog_common (gchar * title, gchar * dialog_message, gchar * first_button, gchar * default_entry_text, GtkSignalFunc this_function, char with_browser)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  GtkWidget *alert_entry;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);
  gtk_widget_set_usize (GTK_WIDGET (alert_window), 250, -1);

  alert_vbox1 = v_box (alert_vbox, FALSE, 5, 10);

  create_alert_label (alert_vbox1, dialog_message, 0, 0.5);

  alert_entry = gtk_entry_new ();
  gtk_widget_show (alert_entry);
  gtk_entry_set_text (GTK_ENTRY (alert_entry), default_entry_text);

  if (!with_browser)
    gtk_box_pack_start (GTK_BOX (alert_vbox1), alert_entry, FALSE, TRUE, 0);
  else
    {
      GtkWidget *alert_hbox1 = gtk_hbox_new (FALSE, 0);
      GtkWidget *alert_frame;
      GtkWidget *button = browser_button (TRUE);
      char path_buf[1024];
      getcwd (path_buf, sizeof (path_buf) - 1);
      gtk_entry_set_text (GTK_ENTRY (alert_entry), path_buf);
      gtk_widget_set_usize (GTK_WIDGET (alert_window), 275, -1);

      gtk_box_pack_start (GTK_BOX (alert_vbox1), alert_hbox1, FALSE, TRUE, 0);
      gtk_widget_show (alert_hbox1);
      gtk_box_pack_start (GTK_BOX (alert_hbox1), alert_entry, TRUE, TRUE, 0);
      alert_frame = create_frame (alert_hbox1, NULL, 30, 24, GTK_SHADOW_IN);
      gtk_widget_set_usize (GTK_WIDGET (alert_entry), 220, -1);
      gtk_container_add (GTK_CONTAINER (alert_frame), button);
      gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (dir_browser), alert_entry);
    }

  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);


  alert_button = box_button (alert_hbox, first_button);
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (this_function), alert_entry);

  box_button_cancel_destroy_window (alert_hbox, alert_window);

  gtk_widget_show (alert_window);

}



/* ENTRY TEXT DIALOG */

void
entry_text_dialog (gchar * title, gchar * entry_label, gchar * text_label, gchar * first_button,
		   gchar * default_entry_text, gchar * default_textarea_text,
		   GtkSignalFunc this_function)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  GtkWidget *alert_entry;
  GtkWidget *alert_text;


  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);
  gtk_widget_set_usize (GTK_WIDGET (alert_window), 350, -1);


  alert_vbox1 = v_box (alert_vbox, FALSE, 5, 10);

  create_alert_label (alert_vbox1, entry_label, 0, 0.5);

  alert_entry = gtk_entry_new ();
  gtk_widget_show (alert_entry);
  gtk_entry_set_text (GTK_ENTRY (alert_entry), default_entry_text);
  gtk_box_pack_start (GTK_BOX (alert_vbox1), alert_entry, FALSE, TRUE, 0);

  create_alert_label (alert_vbox1, "", 0, 0.5);
  create_alert_label (alert_vbox1, text_label, 0, 0.5);

  alert_text = gtk_text_new (NULL, NULL);
  create_text_area (alert_text, alert_vbox1);
  gtk_text_set_editable (GTK_TEXT (alert_text), TRUE);
  gtk_object_set_data (GTK_OBJECT (alert_window), "text", alert_text);
  gtk_widget_set_usize (alert_text, -1, 100);
  realize_text (alert_text, default_textarea_text);

  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);



  alert_button = box_button (alert_hbox, first_button);
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (this_function), GTK_OBJECT (alert_entry));

  box_button_cancel_destroy_window (alert_hbox, alert_window);

  gtk_widget_show (alert_window);

}



/* RESIZABLE TEXT DIALOG */

void
resizable_text_dialog (gchar * title, char *this_text, int width, int height)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  GtkWidget *alert_text;


  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);
  gdk_window_set_decorations (alert_window->window, GDK_DECOR_BORDER | GDK_DECOR_TITLE | GDK_DECOR_RESIZEH);

  alert_vbox1 = v_box (alert_vbox, FALSE, 5, 10);

  alert_text = gtk_text_new (NULL, NULL);
  gtk_widget_set_name (alert_text, "ViewText");
  create_text_area (alert_text, alert_vbox1);
  gtk_text_set_editable (GTK_TEXT (alert_text), FALSE);
  gtk_widget_set_usize (alert_text, width, height);

  realize_text (alert_text, this_text);

  gtk_widget_show (alert_vbox1);

  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 0, 5);

  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);

  alert_button = box_button (alert_hbox, "Close");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (alert_window));
  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);

  gtk_widget_show (alert_window);
}




/* MODAL ENTRY DIALOG */



static void
entry_dialog_modal_button_clicked (GtkWidget * widget, GtkWidget * this_widget)
{
  GtkWidget *alert_window;
  alert_window = gtk_widget_get_toplevel (widget);

  if (widget == this_widget)
    {
      strcpy (modal_entry_buf, gtk_entry_get_text (GTK_ENTRY (modal_entry)));
    }

  gtk_grab_remove (alert_window);
  gtk_widget_destroy (alert_window);
  gtk_main_quit ();

}




char *
entry_dialog_modal_common (gchar * title, gchar * dialog_message, gchar * first_button, gchar * default_entry_text, char IS_VISIBLE)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;

  strcpy (modal_entry_buf, "");

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);
  gtk_widget_set_usize (GTK_WIDGET (alert_window), 250, 150);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 10);

  program_icon (alert_hbox);

  alert_vbox1 = v_box (alert_hbox, FALSE, 5, 10);

  create_alert_label (alert_vbox1, dialog_message, 0, 0.5);

  modal_entry = gtk_entry_new ();
  gtk_entry_set_visibility (GTK_ENTRY (modal_entry), IS_VISIBLE);
  gtk_widget_show (modal_entry);
  gtk_box_pack_start (GTK_BOX (alert_vbox1), modal_entry, FALSE, TRUE, 0);
  gtk_entry_set_text (GTK_ENTRY (modal_entry), default_entry_text);


  hseparator (alert_vbox);

  alert_hbox = hbutton_box (alert_vbox);

  alert_button = box_button (alert_hbox, first_button);
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (entry_dialog_modal_button_clicked), GTK_OBJECT (alert_button));

  alert_button = box_button (alert_hbox, "Cancel");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (entry_dialog_modal_button_clicked), GTK_OBJECT (alert_window));

  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);


  gtk_widget_show (alert_window);
  gtk_widget_grab_focus (alert_window);


  gtk_grab_add (alert_window);

  gtk_main ();

  return modal_entry_buf;
}






/* DUPLICATE  DIALOG (transfert) */



static void
duplicate_dialog_button_clicked (GtkWidget * widget, int data)
{
  GtkWidget *alert_window;
  alert_window = gtk_widget_get_toplevel (widget);
  dup_selected = data;
  gtk_grab_remove (alert_window);
  gtk_widget_destroy (alert_window);
  gtk_main_quit ();
}


static GtkWidget *
create_button (char *label, GtkWidget * this_box, int data)
{
  GtkWidget *alert_button;
  alert_button = gtk_button_new_with_label (label);
  gtk_box_pack_start (GTK_BOX (this_box), alert_button, TRUE, TRUE, 0);
  gtk_widget_show (alert_button);
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (duplicate_dialog_button_clicked), GINT_TO_POINTER (data));
  return alert_button;
}



int
duplicate_dialog (gchar * title, gchar * resume_label, gchar * filename, gchar * local_fileinfo, gchar * remote_fileinfo, char may_resume)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  char buf[256];

  dup_selected = DUP_abort;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);
  gtk_widget_set_usize (GTK_WIDGET (alert_window), 300, 250);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 10);

  exclam_icon (alert_hbox);

  alert_vbox1 = v_box (alert_hbox, FALSE, 5, 10);

  create_alert_label (alert_vbox1, filename, 0, 0.3);

  sprintf (buf, "Local : %s", local_fileinfo);
  create_alert_label (alert_vbox1, buf, 0, 0.3);

  sprintf (buf, "Remote : %s", remote_fileinfo);
  create_alert_label (alert_vbox1, buf, 0, 0.3);

  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  alert_vbox1 = v_box (alert_hbox, FALSE, 5, 0);

  alert_button = create_button ("Overwrite", alert_vbox1, DUP_overwrite);
  alert_button = create_button (resume_label, alert_vbox1, DUP_resume);
  gtk_widget_set_sensitive (alert_button, may_resume);
  if (!this_connexion.can_resume)
    gtk_widget_set_sensitive (alert_button, FALSE);
  create_button ("Skip", alert_vbox1, DUP_skip);
  create_button ("Rename", alert_vbox1, DUP_rename);

  alert_vbox1 = v_box (alert_hbox, FALSE, 5, 0);

  create_button ("Overwrite All", alert_vbox1, DUP_overwrite_all);
  create_button ("Skip All", alert_vbox1, DUP_skip_all);
  gtk_widget_set_sensitive (create_button (" ", alert_vbox1, 0), FALSE);
  create_button ("Cancel", alert_vbox1, DUP_abort);

  gtk_widget_show (alert_window);

  gtk_grab_add (alert_window);
  gtk_main ();

  return dup_selected;
}










/* FIND DIALOG */

static void
find_dialog_cancel (GtkWidget * widget, FINDwidgets * find_widgets)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (widget));
  g_free (find_widgets);
}

void
find_dialog (gchar * title, gchar * search_text, GtkSignalFunc this_function)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_button;
  GtkWidget *alert_hbox;
  FINDwidgets *find_widgets = g_malloc0 (sizeof (FINDwidgets));

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_MOUSE, title, &alert_vbox);

  alert_vbox1 = v_box (alert_vbox, FALSE, 5, 10);

  create_alert_label (alert_vbox1, "Search for :", 0, 0.5);

  find_widgets->entry = create_entry (alert_vbox1, search_text);
  find_widgets->check_case = create_check_button (alert_vbox1, "Case sensitive", FALSE);

  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);

  alert_button = box_button (alert_hbox, "Find Next");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (this_function), (FINDwidgets *) find_widgets);

  alert_button = box_button (alert_hbox, "Cancel");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (find_dialog_cancel), (FINDwidgets *) find_widgets);

  gtk_widget_show (alert_window);
}




/* GROUP SELECT/DESELECT  DIALOG */

static void
group_select_dialog_cancel (GtkWidget * widget, GRPSELECTwidgets * grp_widgets)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (widget));
  g_free (grp_widgets);
}

void
group_select_dialog (gchar * title, GtkSignalFunc this_function, char SELECT)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_hbox1;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_button;
  GtkWidget *alert_hbox;
  GRPSELECTwidgets *grp_widgets = g_malloc0 (sizeof (GRPSELECTwidgets));

  grp_widgets->select = SELECT;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_MOUSE, title, &alert_vbox);

  alert_vbox1 = v_box (alert_vbox, FALSE, 5, 10);

  create_alert_label (alert_vbox1, "Filter Mask :", 0, 0.5);
  grp_widgets->entry = create_entry (alert_vbox1, NULL);

  alert_hbox1 = h_box (alert_vbox1, FALSE, 10, 0);
  grp_widgets->check_mask = create_check_button (alert_hbox1, "Mask directories", TRUE);
  grp_widgets->check_remove = create_check_button (alert_hbox1, "Remove selection", SELECT);
  gtk_widget_set_sensitive (grp_widgets->check_remove, SELECT);

  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);

  alert_button = box_button (alert_hbox, SELECT ? "Select" : "Deselect");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (this_function), (GRPSELECTwidgets *) grp_widgets);

  alert_button = box_button (alert_hbox, "Cancel");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (group_select_dialog_cancel), (GRPSELECTwidgets *) grp_widgets);

  gtk_widget_show (alert_window);
}




/* FILTER DIALOG */

static void
filter_dialog_cancel (GtkWidget * widget, FILTERwidgets * filter_widgets)
{
  gtk_widget_destroy (gtk_widget_get_toplevel (widget));
  g_free (filter_widgets);
}

void
filter_dialog (gchar * title, gchar * filter_mask, GtkSignalFunc this_function, char FILTER_DIRECTORIES)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_button;
  GtkWidget *alert_hbox;
  FILTERwidgets *filter_widgets = g_malloc0 (sizeof (FILTERwidgets));

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_MOUSE, title, &alert_vbox);

  alert_vbox1 = v_box (alert_vbox, FALSE, 5, 10);

  create_alert_label (alert_vbox1, "Filter mask :", 0, 0.5);

  filter_widgets->entry = create_entry (alert_vbox1, filter_mask);
  filter_widgets->check_dir = create_check_button (alert_vbox1, "Filter Directories", FALSE);
  gtk_widget_set_sensitive (filter_widgets->check_dir, FILTER_DIRECTORIES);
  hseparator (alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);

  alert_button = box_button (alert_hbox, "Apply");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (this_function), (FILTERwidgets *) filter_widgets);

  alert_button = box_button (alert_hbox, "Cancel");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (filter_dialog_cancel), (FILTERwidgets *) filter_widgets);

  gtk_widget_show (alert_window);
}





/* DIR INFO dialog */


void
dir_info_dialog (char *current_dir, char IS_LOCAL,
	    int all_files, long all_files_size, int all_dirs, int all_links,
		 int selected_files, long selected_files_size, int selected_dirs, int selected_links)
{
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_frame;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_button;
  GtkWidget *alert_hbox;
  char label_buf[128];

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_MOUSE, "Directory Information", &alert_vbox);

  alert_frame = create_frame (alert_vbox, IS_LOCAL ? " Local directory : " : " Remote directory : ", FALSE, TRUE, GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (alert_frame), 5);
  alert_vbox1 = v_box (alert_frame, FALSE, 0, 0);
  gtk_container_border_width (GTK_CONTAINER (alert_vbox1), 5);
  create_alert_label (alert_vbox1, current_dir, 0, 0.5);


  alert_frame = create_frame (alert_vbox, " All entries : ", FALSE, TRUE, GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (alert_frame), 5);
  alert_hbox = h_box (alert_frame, FALSE, 5, 5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  create_alert_label (alert_vbox1, " Files", 0, 0.5);
  create_alert_label (alert_vbox1, " Sub-directories ", 0, 0.5);
  create_alert_label (alert_vbox1, " Symbolic links ", 0, 0.5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  sprintf (label_buf, "%i (%ld Bytes)", all_files, all_files_size);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%i", all_dirs);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%i", all_links);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);




  alert_frame = create_frame (alert_vbox, " Selected entries : ", FALSE, TRUE, GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (alert_frame), 5);
  alert_hbox = h_box (alert_frame, FALSE, 5, 5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  create_alert_label (alert_vbox1, " Files", 0, 0.5);
  create_alert_label (alert_vbox1, " Sub-directories ", 0, 0.5);
  create_alert_label (alert_vbox1, " Symbolic links ", 0, 0.5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  sprintf (label_buf, "%i (%ld Bytes)", selected_files, selected_files_size);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%i", selected_dirs);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%i", selected_links);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);



  hseparator (alert_vbox);
  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);

  alert_button = box_button (alert_hbox, "Close");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (alert_window));
  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);

  gtk_widget_show (alert_window);
}





/* QUEUE INFO */


void
queue_info_dialog (int Dfiles, int Dfolders, long Dsize, int Ufiles, int Ufolders, long Usize)
{
  GtkWidget *alert_window;
  GtkWidget *alert_frame;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_button;
  GtkWidget *alert_hbox;
  char label_buf[128];

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, "Queue Information", &alert_vbox);
  gtk_widget_set_usize (GTK_WIDGET (alert_window), 250, -1);

  alert_frame = create_frame (alert_vbox, " All Files : ", FALSE, TRUE, GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (alert_frame), 5);
  alert_hbox = h_box (alert_frame, FALSE, 5, 5);


  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  create_alert_label (alert_vbox1, " Files", 0, 0.5);
  create_alert_label (alert_vbox1, " Folders ", 0, 0.5);
  create_alert_label (alert_vbox1, " Size ", 0, 0.5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  sprintf (label_buf, "%i", Dfiles + Ufiles);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%i", Dfolders + Ufolders);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%ld Kbytes", (Dsize + Usize) / 1024);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);


  alert_frame = create_frame (alert_vbox, " Downloads : ", FALSE, TRUE, GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (alert_frame), 5);
  alert_hbox = h_box (alert_frame, FALSE, 5, 5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  create_alert_label (alert_vbox1, " Files", 0, 0.5);
  create_alert_label (alert_vbox1, " Folders ", 0, 0.5);
  create_alert_label (alert_vbox1, " Size ", 0, 0.5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  sprintf (label_buf, "%i", Dfiles);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%i", Dfolders);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%ld Kbytes", Dsize / 1024);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);



  alert_frame = create_frame (alert_vbox, " Uploads : ", FALSE, TRUE, GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (alert_frame), 5);
  alert_hbox = h_box (alert_frame, FALSE, 5, 5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  create_alert_label (alert_vbox1, " Files", 0, 0.5);
  create_alert_label (alert_vbox1, " Folders ", 0, 0.5);
  create_alert_label (alert_vbox1, " Size ", 0, 0.5);

  alert_vbox1 = v_box (alert_hbox, FALSE, 0, 0);
  sprintf (label_buf, "%i", Ufiles);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%i", Ufolders);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);
  sprintf (label_buf, "%ld Kbytes", Usize / 1024);
  create_alert_label (alert_vbox1, label_buf, 0, 0.5);




  hseparator (alert_vbox);
  alert_hbox = h_box (alert_vbox, FALSE, 10, 5);
  program_icon (alert_hbox);
  alert_hbox = hbutton_box (alert_hbox);

  alert_button = box_button (alert_hbox, "Close");
  gtk_signal_connect_object (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (alert_window));
  GTK_WIDGET_SET_FLAGS (alert_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (alert_button);

  gtk_widget_show (alert_window);
}




/* DIR BROWSER DIALOG */



static void
dir_browser_button_clicked (GtkWidget * widget, DIRbrowser * browser)
{
  if (browser != NULL)
    {
      gchar *path_buf;
      gtk_label_get (GTK_LABEL (browser->label), &path_buf);
      gtk_entry_set_text (GTK_ENTRY (browser->entry), path_buf);
    }

  gtk_grab_remove (dir_browser_window);
  gtk_widget_destroy (dir_browser_window);
  dir_browser_window = NULL;
  gtk_main_quit ();
}


void
dir_browser (GtkWidget * widget, GtkWidget * return_entry)
{
  GtkWidget *alert_vbox;
  GtkCTree *alert_ctree = NULL;
  GtkWidget *DIR_TREE;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;
  DIRbrowser browser;
  char entry_buf[1024];
  char *ptr;
  if (dir_browser_window != NULL)
    {
      gdk_window_raise (dir_browser_window->window);
      return;
    }

  dir_browser_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, "Directories Browser", &alert_vbox);
  gtk_widget_set_usize (GTK_WIDGET (dir_browser_window), 300, 300);

  gtk_container_border_width (GTK_CONTAINER (alert_vbox), 5);
  gtk_box_set_spacing (GTK_BOX (alert_vbox), 5);

  DIR_TREE = DIR_TREE_create (&alert_ctree, &browser.label, FALSE);
  gtk_box_pack_start (GTK_BOX (alert_vbox), DIR_TREE, TRUE, TRUE, 0);

  browser.entry = return_entry;

  strcpy (entry_buf, gtk_entry_get_text (GTK_ENTRY (return_entry)));
  if (!strlen (entry_buf))
    gtk_entry_set_text (GTK_ENTRY (return_entry), "/");
  if ((ptr = strchr (entry_buf, '~')) != NULL)
    {
      char this_path[1024];
      sprintf (this_path, "%s%s", home_path, ptr + 1);
      strcpy (entry_buf, this_path);
      gtk_entry_set_text (GTK_ENTRY (return_entry), entry_buf);
    }

  hseparator (alert_vbox);

  alert_hbox = hbutton_box (alert_vbox);
  alert_button = box_button (alert_hbox, "Select");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (dir_browser_button_clicked), &browser);

  alert_button = box_button (alert_hbox, "Cancel");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (dir_browser_button_clicked), NULL);

  gtk_widget_show (dir_browser_window);

  PROCESS_EVENTS;

  DIR_TREE_init (alert_ctree, gtk_entry_get_text (GTK_ENTRY (return_entry)), "Root");
  gdk_window_raise (dir_browser_window->window);

  gtk_grab_add (dir_browser_window);
  gtk_main ();
}


/* EOF */
