/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "protos.h"


static char WANT_CURSOR_BUSY = FALSE;

static void CURSOR_set_busy (void);
static void CURSOR_set_default (void);




/* CURSORS functions */

/* PUBLIC :
 * CURSOR_MAIN_busy
 * CURSOR_MAIN_default
 * CURSOR_busy
 * CURSOR_default 
 * STATIC :
 * CURSOR_set_busy
 * CURSOR_set_default
 */

void
CURSOR_MAIN_busy (void)
{
  if (!WANT_CURSOR_BUSY)
    {
      WANT_CURSOR_BUSY = TRUE;
      CURSOR_set_busy ();
    }
}

void
CURSOR_MAIN_default (void)
{
  WANT_CURSOR_BUSY = FALSE;
  CURSOR_set_default ();
}

void
CURSOR_busy (void)
{
  if (!WANT_CURSOR_BUSY)
    CURSOR_set_busy ();
}

void
CURSOR_default (void)
{
  if (!WANT_CURSOR_BUSY)
    CURSOR_set_default ();
}


static void
CURSOR_set_busy (void)
{
  GdkCursor *cursor = gdk_cursor_new (GDK_WATCH);
  gdk_window_set_cursor (window->window, cursor);
  gdk_cursor_destroy (cursor);
}


/*
   static void
   CURSOR_set_busy (void)
   {
   GdkPixmap * busy_pixmap;
   GdkPixmap * busy_mask;
   GdkCursor *cursor ;
   GdkColor fg  =
   {0, 0x0000, 0x0000, 0x0000};
   GdkColor bg =
   {0, 0xffff, 0xffff, 0xffff};
   #include "pixmaps/chrono.xpm"

   busy_pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, gtk_widget_get_colormap (window), &busy_mask, NULL, chrono_xpm);
   cursor = gdk_cursor_new_from_pixmap ( busy_pixmap, busy_mask, &fg, &bg, 0, 0);
   gdk_window_set_cursor (window->window, cursor);
   //    gdk_cursor_destroy (cursor);
   }
 */

static void
CURSOR_set_default (void)
{
  GdkCursor *cursor = gdk_cursor_new (GDK_LEFT_PTR);
  gdk_window_set_cursor (window->window, cursor);
  gdk_cursor_destroy (cursor);
}

/* EOF */
