/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdio.h>

#include "protos.h"
#include "console.h"





/* PUBLIC
 * show_or_hide_console
 * create_consolelist
 * ftp_copyright
 * info_message
 * error_message
 * local_message
 * host_message
 * show_last_connexion_log 
 * STATIC
 * clist_event_handler 
 * aff_message
 */


void
show_or_hide_console (GtkWidget * widget)
{
  show_hide_widget (clist_window, GTK_CHECK_MENU_ITEM (widget)->active);
  gtk_paned_set_position (GTK_PANED (top_panel), GTK_CHECK_MENU_ITEM (widget)->active ? top_pane_pos : 0);
}



GtkWidget *
create_consolelist (void)
{
  clist = gtk_clist_new (1);
  gtk_widget_set_name (clist, "Console");
  gtk_clist_set_selection_mode (GTK_CLIST (clist), GTK_SELECTION_SINGLE);
  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 400);

  gtk_widget_show (clist);

  gtk_clist_set_hadjustment (GTK_CLIST (clist), NULL);
  gtk_clist_set_vadjustment (GTK_CLIST (clist), NULL);
  clist_window = scroll_win ();
  gtk_container_add (GTK_CONTAINER (clist_window), clist);

  show_hide_widget (clist_window, user_rc.view_console);

  console_popup_menu = create_console_popup_menu ();

  gtk_signal_connect (GTK_OBJECT (clist), "event", GTK_SIGNAL_FUNC (clist_event_handler), NULL);

  return clist_window;
}


static gint
clist_event_handler (GtkWidget * this_list, GdkEvent * event, gpointer data)
{

  switch (event->type)
    {
    case GDK_BUTTON_PRESS:
      switch (event->button.button)
	{
	case 3:
	  {
	    GdkEventButton *bevent = (GdkEventButton *) event;
	    console_popup_menu_set_sensitive ();
	    gtk_menu_popup (GTK_MENU (console_popup_menu), NULL, NULL, NULL, NULL,
			    bevent->button, bevent->time);
	  }
	  return TRUE;

	default:
	  break;
	}
      break;

    case GDK_2BUTTON_PRESS:
      switch (event->button.button)
	{
	case 1:
	  show_last_connexion_log (NULL, NULL);
	  return TRUE;
	default:
	  break;
	}

    default:
      break;
    }

  return FALSE;
}



static void
aff_message (char *this_message, GdkColor fg_color)
{
  console_last_row = gtk_clist_append (GTK_CLIST (clist), &this_message);
  gtk_clist_set_foreground (GTK_CLIST (clist), console_last_row, &fg_color);
  gtk_clist_set_selectable (GTK_CLIST (clist), console_last_row, FALSE);
  gtk_clist_moveto (GTK_CLIST (clist), console_last_row, 0, 1, 0);

  if (console_last_row > user_rc.console_max_lines)
    {
      gtk_clist_remove (GTK_CLIST (clist), 0);
      gtk_clist_moveto (GTK_CLIST (clist), --console_last_row, 0, 1, 0);
    }

  PROCESS_EVENTS;
}




void
ftp_copyright (void)
{
  char buf[250];
  gtk_clist_clear (GTK_CLIST (clist));
  aff_message (a_parano_version_infos (buf), LBLUE);
  aff_message (a_little_more_infos (buf), BLUE);
  aff_message (yet_a_little_more_infos (buf), BLUE);
}



void
info_message (char *this_message)
{
  if (strstr (this_message, "Connected."))
    default_status_message ();
  aff_message (this_message, LBLUE);
  if (user_rc.lastlog_on)
    lastlog ("LOCAL INF", this_message);
}



void
error_message (char *this_message)
{
  aff_message (this_message, LRED);
  if (user_rc.lastlog_on)
    lastlog ("LOCAL DBG", this_message);
}



void
local_message (char *this_message)
{

  if (strstr (this_message, "PASS"))
    {
      register char f;
      for (f = 5; f < strlen (this_message); f++)
	this_message[f] = 'x';
    }

  aff_message (this_message, GREEN);
  if (user_rc.lastlog_on)
    lastlog ("LOCAL CMD", this_message);
}



void
host_message (char *this_message)
{
  if (!strlen (this_message))
    return;

  switch (this_message[0])
    {
    case '2':

      if (this_message[2] == '0')
	switch (this_message[1])
	  {
	  case '2':
	    host_welcome_message (this_message, FALSE);
	    if (this_message[3] != '-')
	      close_host_welcome ();
	    break;
	  case '3':
	    host_welcome_message (this_message, TRUE);
	    if (this_message[3] != '-')
	      close_host_welcome ();
	    return;
	    break;
	  case '5':
	    if (this_message[3] == '-')
	      {
		host_dir_content_message (this_message);
		MUST_SHOW_FTP_DIRECTORY_MESSAGE = TRUE;
		return;
	      }
	    else
	      close_host_dir_content ();
	    break;
	  default:
	    break;
	  }
      aff_message (this_message, BLACK);
      break;
    case '1':
    case 32:
    case '3':
      aff_message (this_message, BLUE);
      break;
    default:
      aff_message (this_message, RED);
    }
  if (user_rc.lastlog_on)
    lastlog ("HOST  RPL", this_message);
}


void
show_last_connexion_log (GtkWidget * widget, gpointer data)
{
  TXT_edit (user_rc.lastlog_path);
}

/* EOF */
