/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>

#include "protos.h"
#include "chmod.h"



/* PUBLIC :
 * chmod_dialog 
 * STATIC :
 * new_mode_entered
 * check_button_callback
 * chmod_check_button 
 * chmod_frame
 */

static void
new_mode_entered (GtkWidget * entry)
{
  char mode_buf[5];
  int perm;
  int this_fileperm;

  if (BUTTON_CALLBACK)
    return;
  ENTRY_CALLBACK = TRUE;

  strcpy (mode_buf, gtk_entry_get_text (GTK_ENTRY (alert_entry)));
  switch (strlen (mode_buf))
    {
    case 2:
      this_fileperm = atoi (mode_buf) * 100;
      break;
    case 3:
      this_fileperm = atoi (mode_buf) * 10;
      break;
    case 4:
      this_fileperm = atoi (mode_buf);
      break;
    case 0:
    default:
      this_fileperm = 0;
    }

  perm = this_fileperm / 100;
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (user_read), perm & (1 << 2));
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (user_write), perm & (1 << 1));
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (user_exec), perm & 1);

  perm = (this_fileperm % 100) / 10;
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (group_read), perm & (1 << 2));
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (group_write), perm & (1 << 1));
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (group_exec), perm & 1);

  perm = (this_fileperm % 100) % 10;
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (other_read), perm & (1 << 2));
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (other_write), perm & (1 << 1));
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (other_exec), perm & 1);

  ENTRY_CALLBACK = FALSE;
}


static void
check_button_callback (GtkWidget * widget, int data)
{
  char mode_buf[5];

  BUTTON_CALLBACK = TRUE;
  if (GTK_TOGGLE_BUTTON (widget)->active)
    fileperm = fileperm | data;
  else
    fileperm = fileperm & (~data);

  if (ENTRY_CALLBACK)
    {
      BUTTON_CALLBACK = FALSE;
      return;
    }

  sprintf (mode_buf, "%04o", fileperm);
  gtk_entry_set_text (GTK_ENTRY (alert_entry), mode_buf);
  BUTTON_CALLBACK = FALSE;
}



static GtkWidget *
chmod_check_button (GtkWidget * this_vbox, char *this_label, int this_mode)
{
  GtkWidget *check_button;
  check_button = gtk_check_button_new_with_label (this_label);
  gtk_widget_show (check_button);
  gtk_box_pack_start (GTK_BOX (this_vbox), check_button, TRUE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (check_button), "toggled", GTK_SIGNAL_FUNC (check_button_callback), GINT_TO_POINTER (this_mode));
  return check_button;
}


static GtkWidget *
chmod_frame (GtkWidget * this_hbox, char *this_label)
{
  GtkWidget *frame = create_frame (this_hbox, this_label, TRUE, FALSE, GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (frame), 5);
  return frame;
}



void
chmod_dialog (gchar * title, gchar * default_entry_text, GtkSignalFunc this_function)
{
#define chmod_vbox(x)  v_box ( x, FALSE, 5, 5);
  GtkWidget *alert_window;
  GtkWidget *alert_vbox;
  GtkWidget *alert_vbox1;
  GtkWidget *alert_hbox;
  GtkWidget *alert_button;

  fileperm = 0;
  BUTTON_CALLBACK = FALSE;
  ENTRY_CALLBACK = FALSE;

  alert_window = create_dialog_window (GTK_WINDOW_DIALOG, GTK_WIN_POS_CENTER, title, &alert_vbox);

  alert_hbox = h_box (alert_vbox, FALSE, 5, 5);

  alert_vbox1 = chmod_vbox (chmod_frame (alert_hbox, " User  "));
  user_read = chmod_check_button (alert_vbox1, "Read", 256);
  user_write = chmod_check_button (alert_vbox1, "Write", 128);
  user_exec = chmod_check_button (alert_vbox1, "Execute", 64);

  alert_vbox1 = chmod_vbox (chmod_frame (alert_hbox, " Group  "));
  group_read = chmod_check_button (alert_vbox1, "Read", 32);
  group_write = chmod_check_button (alert_vbox1, "Write", 16);
  group_exec = chmod_check_button (alert_vbox1, "Execute", 8);

  alert_vbox1 = chmod_vbox (chmod_frame (alert_hbox, " Other  "));
  other_read = chmod_check_button (alert_vbox1, "Read", 4);
  other_write = chmod_check_button (alert_vbox1, "Write", 2);
  other_exec = chmod_check_button (alert_vbox1, "Execute", 1);

  alert_hbox = h_box (alert_vbox, FALSE, 5, 0);

  program_icon (alert_hbox);

  alert_entry = gtk_entry_new_with_max_length (4);
  gtk_widget_show (alert_entry);
  gtk_box_pack_start (GTK_BOX (alert_hbox), alert_entry, TRUE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (alert_entry), "changed", GTK_SIGNAL_FUNC (new_mode_entered), NULL);

  hseparator (alert_vbox);

  alert_hbox = hbutton_box (alert_vbox);

  alert_button = box_button (alert_hbox, "Chmod");
  gtk_signal_connect (GTK_OBJECT (alert_button), "clicked", GTK_SIGNAL_FUNC (this_function), GTK_OBJECT (alert_entry));

  box_button_cancel_destroy_window (alert_hbox, alert_window);

  gtk_widget_show (alert_window);

  gtk_entry_set_text (GTK_ENTRY (alert_entry), default_entry_text);
}



/* EOF */
