/* IglooFTP - Graphical and User Friendly FTP Client.
 * Copyright (c) 1998-1999 Jean-Marc Jacquet. 
 * All rights reserved.
 * 
 * THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE
 *
 * IglooFTP Original Packages, information and support,  
 * can be obtained at :
 *                              http://www.littleigloo.org
 * 
 *
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/utsname.h>

#include "protos.h"



static char RDC_recurse_delete_old_files (char *filename);
//static char RDC_recurse_close_dir (char *filename);







/* RDC ENABLE/DISABLE FUNCTIONS */

/* PUBLIC :
 * toggle_RDC
 */

void
toggle_RDC (void)
{
  info_message ((this_session.use_RDC = !this_session.use_RDC) ? "RDC Enabled" : "RDC Disabled");
}





/* FLAG STATUS FUNCTIONS */

/* PUBLIC :
 * RDC_flag_status 
 * RDC_return_flag_status
 * STATIC :
 * RDC_read_status
 * RDC_write_status
 */
#define RDC_TREE_BROWSED_FLAG 0
#define RDC_TREE_OPEN_FLAG 1


static void
RDC_read_status (char *this_path, RDCstatus * this_status)
{
  int file_handle;
  char status_path[MPLEN];

  RDC_site_dir_dir (status_path, this_path);
  I_do_not_want_a_terminal_slash_here (this_path);
  strcat (status_path, RDC_STATUS);

  if ((file_handle = open (status_path, O_RDONLY, RC_PERM)) == -1)
    {
      memset (this_status, 0, sizeof (RDCstatus));
      return;
    }
  read (file_handle, this_status, sizeof (RDCstatus));
  close (file_handle);
}

static void
RDC_write_status (char *this_path, RDCstatus * this_status)
{
  int file_handle;
  char status_path[MPLEN];

  RDC_site_dir_dir (status_path, this_path);
  I_do_not_want_a_terminal_slash_here (this_path);
  strcat (status_path, RDC_STATUS);

  file_handle = open (status_path, O_CREAT | O_TRUNC | O_WRONLY, RC_PERM);
  write (file_handle, this_status, sizeof (RDCstatus));
  close (file_handle);
}

void
RDC_flag_status (char *this_path, int what_flag, char FLAG)
{
  RDCstatus this_status;
  RDC_read_status (this_path, &this_status);
  this_status.flags[what_flag] = FLAG;
  RDC_write_status (this_path, &this_status);
}

char
RDC_return_flag_status (char *this_path, int what_flag, char FLAG)
{
  RDCstatus this_status;
  RDC_read_status (this_path, &this_status);
  return (this_status.flags[what_flag] == FLAG);
}






/* FILESYSTEM CONVERSION FUNCTIONS */

/* PUBLIC:
 * RDC_DOS2UNIX
 */

void
RDC_DOS2UNIX (char *buf)
{
  char *ptr;
  if (strrchr (buf, '\\') != NULL)
    {
      DOS_FILESYSTEM = TRUE;
      while ((ptr = strrchr (buf, '\\')) != NULL)
	*ptr = '/';
    }
}






/* CREATE DIR FUNCTIONS */

/* PUBLIC :
   * RDC_create_site_root
   * RDC_create_site_dir
 */

void
RDC_create_site_root (void)
{
  char buf[MPLEN];
  create_dir (RDC_site_root_dir (buf), RC_FOLDER_PERM);
}

void
RDC_create_site_dir (char *this_dir)
{
  char buf[MPLEN];
  create_dir (RDC_site_dir_dir (buf, this_dir), RC_FOLDER_PERM);
}







/* CLEAN FUNCTIONS */

/* PUBLIC :
   * RDC_clean_now
   * RDC_regular_clean
   * RDC_close_all_dirs
   * STATIC :
   * RDC_recurse_delete_old_files
   * RDC_recurse_close_dir
 */

void
RDC_clean_now (GtkWidget * widget, gpointer data)
{
  char buf[1024];
  delete_dir (RDC_main_dir (buf));
  create_dir (RDC_main_dir (buf), RC_FOLDER_PERM);

  if (this_connexion.is_connected)
    {
      RDC_create_site_root ();
      RDC_create_site_dir (this_session.cwd_dir);
    }

  if (widget != NULL)
    alert_ok ("RDC clean", "Cache cleaned.", "Ok");
}


void
RDC_regular_clean (void)
{
  struct stat stat_buf;
  time_t timep;
  struct tm *this_tm;
  struct tm *file_tm;
  char buf[MPLEN];
  char last_clean_buf[MPLEN];
  int file_handle;

  RDC_main_dir (buf);
  sprintf (last_clean_buf, "%s/%s", buf, RDC_LAST_CLEAN);

  if (stat (last_clean_buf, &stat_buf) == 0 && user_rc.RDC_max_days)
    {
      timep = time (NULL);
      this_tm = localtime (&timep);
      file_tm = localtime (&stat_buf.st_mtime);
      if (this_tm->tm_yday == file_tm->tm_yday)
	return;
    }

  status_message ("Cleaning Remote Directories Cache ...");
  PROCESS_EVENTS;
  unlink (last_clean_buf);

  recurse_dir (buf, RDC_recurse_delete_old_files, RDC_recurse_delete_old_files);

  file_handle = open (last_clean_buf, O_CREAT | O_TRUNC | O_WRONLY, RC_PERM);
  close (file_handle);
}


static char
RDC_recurse_delete_old_files (char *filename)
{
  struct stat stat_buf;
  time_t timep;
  struct tm *this_tm;
  struct tm *file_tm;

#define DAYS_OLD this_tm->tm_yday - file_tm->tm_yday
  if (stat (filename, &stat_buf) == 0)
    {
      timep = time (NULL);
      this_tm = localtime (&timep);
      file_tm = localtime (&stat_buf.st_mtime);

      if (DAYS_OLD >= user_rc.RDC_max_days)
	(stat_buf.st_mode & S_IFMT) == S_IFDIR ? rmdir (filename) : unlink (filename);

      else if ((stat_buf.st_mode & S_IFMT) != S_IFDIR)
	{
	  if (strstr (filename, RDC_STATUS) != NULL)
	    {
	      int file_handle;
	      RDCstatus this_status;

	      if ((file_handle = open (filename, O_RDWR, RC_PERM)) == -1)
		return FALSE;
	      read (file_handle, &this_status, sizeof (RDCstatus));
	      this_status.flags[RDC_TREE_OPEN_FLAG] = FALSE;
	      lseek (file_handle, 0L, SEEK_SET);
	      write (file_handle, &this_status, sizeof (RDCstatus));
	      close (file_handle);
	    }
	}

    }

  return TRUE;
}


/* EOF */
