# Contributing

Thank you for considering contributing to HexPatch! All contributions are welcome and appreciated.
There are many ways to contribute, including reporting bugs, improving documentation, submitting feature requests, and writing code.

## How to Contribute

### Reporting Bugs

- Check if the bug has already been reported by searching the [issues](https://github.com/Etto48/HexPatch/issues).
- If the bug has already been reported, you can add more information by commenting on the existing issue.
- If the bug has not been reported, open a new issue with a descriptive title and detailed description of the bug.

### Improving Documentation

- If you find an error in the documentation or would like to suggest improvements, you can open an issue or submit a pull request.
- If you want to edit the GitHub Pages site, please test your changes locally with Jekyll before submitting a pull request (I learned this the hard way).

### Submitting Feature Requests

- If you have an idea for a new feature, you can open an issue to discuss it.
- If you would like to implement the feature yourself, it is recommended to open an issue first to discuss the implementation. Please follow the [coding guidelines](#coding-guidelines).

### Writing Code

- Pick an issue from the [issue tracker](https://github.com/Etto48/HexPatch/issues) and leave a comment to let others know you are working on it.
- Please follow the [coding guidelines](#coding-guidelines).

## Coding Guidelines

- Run `cargo make ci` before submitting a pull request. It's not mandatory, however it may save you time to do so instead of waiting for GitHub to run the checks.
- Please avoid using `unsafe` code.
- Remember to link to any related issue in your pull request.

Thank you for contributing to HexPatch!
