///////////////////////////////////////////////////////////////////////////
/*
  Copyright 2002 Ronald S. Burkey

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	MagicFile.c
  Purpose:	Replaces some of the standard file operations with 
  		similar operations that transparently use other file 
		formats such as gzipped files or zipped files.
  Mods:		01/14/02 RSB	Began.
*/
///////////////////////////////////////////////////////////////////////////

#include "MagicFile.h"
#include <string.h>

//-----------------------------------------------------------------------
// First, assumes the filename represents a zipfile containing a single
// file.  If this turns out not to be true, tries it as a gzipped file.
// If not, then just assumes a regular file.

MagicFILE *MagicOpen (const char *Filename, const char *Mode)
{
  MagicFILE *NewFile;
  zzip_error_t ZipError;
  ZZIP_DIRENT ZzipDirent, ZzipDirent2;
  NewFile = calloc (sizeof (MagicFILE));
  if (NewFile == NULL)
    return (NULL);
  // Try as zip file.
  NewFile->Type = MagicZip;
  NewFile->ZipDir = zzip_dir_open (Filename, &ZipError);
  if (NewFile->ZipDir != NULL)
    {
      if (0 == zzip_dir_read (NewFile->ZipDir, &ZzipDirent) ||
          0 != zzip_dir_read (NewFile->ZipDir, &ZzipDirent2))
        {
	  zzip_dir_close (NewFile->Zipdir);
	  free (NewFile);
	  return (NULL);
	}
      // At this point, we know that the zipfile contains a single
      // file.
      	
    }
  // Try as gzip/normal file.
  NewFile->Type = MagicGzip;
  NewFile->GzipFile = gzopen (Filename, Mode);
  if (NewFile->GzipFile == NULL)
    {
      free (NewFile);
      return (NULL);
    }
  return (NewFile);    
}

//-----------------------------------------------------------------------

int MagicClose (MagicFile *);

//-----------------------------------------------------------------------

int MagicSeek (MagicFFILE *, long, int);

//-----------------------------------------------------------------------

void *MagicGets (char *, long, MagicFILE *);

//-----------------------------------------------------------------------

int MagicGetc (MagicFILE *);

