///////////////////////////////////////////////////////////////////////////
/*
  Copyright 2001 Ronald S. Burkey

  This file is part of GutenMark.

  GutenMark is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  GutenMark is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GutenMark; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	hk2_deutsch.c
  Purpose:	Converts Martin Schulz's German ispell dictionary
  		(ftp.informatik.uni-kiel.de/pub/kiel/dicts/hk2-deutsch.tar.gz), 
		as updated by  Heinz Knutzen (hk@informatik.uni-kiel.d400.de) 
		et al., into the fully-expanded one-word-per-line wordlist 
		format needed by GutenMark.  I am unable to determine the
		copyright and licensing from the available documentation.
		I do note, however, that this dictionary happens to be
		included in the SuSE Linux PPC 7.1 distribution, so I
		guess I'm on reasonable grounds in supposing that it's 
		free.
  Mods:		11/09/01 RSB	Began.
*/
///////////////////////////////////////////////////////////////////////////

/*
  This is just a simple thing I threw together to filter some 7-bit escape
  sequences in the hk2_deutsch ispell dictionary.  I've no doubt that some
  standard utility like SED can do it, but I've already spent far more time
  trying to figure it out than the 5 minutes it will cost to write this
  program.
*/

#include <stdio.h>

int
main (void)
{
  int ch, next;
  while (EOF != (ch = getchar ()))
    {
    Next:
      if (ch == 's')
	{
	  next = getchar ();
	  if (next == EOF)
	    putchar (ch);
	  else if (next == 'S')
	    putchar (223);
	  else
	    {
	      putchar (ch);
	      ch = next;
	      goto Next;
	    }
	}
      else if (ch == 'a' || ch == 'A' || ch == 'o' || ch == 'O' || ch == 'u'
	       || ch == 'U')
	{
	  next = getchar ();
	  if (next == EOF)
	    putchar (ch);
	  else if (next != '\"')
	    {
	      putchar (ch);
	      ch = next;
	      goto Next;
	    }
	  else if (ch == 'a')
	    putchar (228);
	  else if (ch == 'A')
	    putchar (196);
	  else if (ch == 'o')
	    putchar (246);
	  else if (ch == 'O')
	    putchar (214);
	  else if (ch == 'u')
	    putchar (252);
	  else if (ch == 'U')
	    putchar (220);
	  else
	    {
	      putchar (ch);
	      ch = next;
	      goto Next;
	    }
	}
      else
	putchar (ch);
    }
  return (0);
}
