.TH SAMPLE1D l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
sample1d \- Resampling of 1-D data sets
.SH SYNOPSIS
\fBsample1d\fP \fIinfile\fP [ \fB\-Fl\fP|\fBa\fP|\fBc\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-I\fP\fIxinc\fP ] 
[ \fB\-M\fP[\fBi\fP|\fBo\fP][\fIflag\fP] ] [ \fB\-N\fP\fIknotfile\fP ] [ \fB\-S\fP\fIxstart\fP ] [ \fB\-T\fP\fIx_col\fP] 
[ \fB\-V\fP ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fIcolinfo\fP ]
.SH DESCRIPTION
\fBsample1d\fP reads a multi-column ASCII [or binary] data set from file [or standard input] and interpolates the
timeseries/profile at locations where the user needs the values.  The user must provide
the column number of the independent (monotonically increasing \fBor\fP decreasing) variable.  Equidistant or arbitrary sampling can
be selected.  All columns are resampled based on the new sampling interval.
Several interpolation schemes are available.  Extrapolation outside the range of the input data is not supported.
.TP
\fIinfile\fP
This is a multi-column ASCII [of binary, see \fB\-b\fP] file with one column containing the independent variable (which must
be monotonically in/de-creasing) and the remaining columns holding misc. data values.
If no file is provided, \fBsample1d\fP reads from standard input.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-F
Choose from \fBl\fP (Linear), \fBa\fP (Akima spline), and \fBc\fP (natural cubic spline) [Default is \fB\-Fa\fP].
You may change the default interpolant; see \fBINTERPOLANT\fP in your \.gmtdefaults4 file.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
\fIxinc\fP defines the sampling interval. [Default is the separation between the first and
second abscissa point in the \fIinfile\fP]
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
\fIknotfile\fP is an optional ASCII file with the x locations where the data set will be resampled in the first column
.TP
.B \-S
For equidistant sampling, \fIxstart\fP indicates the location of the first output value. [Default
is the smallest even multiple of \fIxinc\fP inside the range of \fIinfile\fP]
.TP
.B \-T
Sets the column number of the independent variable [Default is 0 (first)].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 (or at least the number of columns implied by \fB\-T\fP)].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is same as input].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH EXAMPLES
To resample the file profiles.tdgmb, which contains (time,distance,gravity,magnetics,bathymetry) records,
at 1km equidistant intervals using Akima's spline, use\"'
.br
.sp
\fBsample1d\fP profiles.tdgmb \fB\-I\fP1 \fB\-Fa\fP \fB\-T\fP1 > profiles_equi_d.tdgmb
.br
.sp
To resample the file depths.dt at positions listed in the file grav_pos.dg, using a cubic spline
for the interpolation, use
.br
.sp
\fBsample1d\fP depths.dt \fB\-N\fPgrav_pos.dg \fB\-Fc\fP > new_depths.dt
.SH "SEE ALSO"
.IR GMT (l),
.IR filter1d (l)
