.TH MAPPROJECT l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
mapproject \- Forward and Inverse map transformation of 2-D coordinates 
.SH SYNOPSIS
\fBmapproject\fP \fIinfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] 
[ \fB\-Ab\fP|\fBB\fP|\fBf\fP|\fBF\fP\fIlon0\fP/\fIlat0\fP ] [ \fB\-C\fP[\fIdx\fP/\fIdy\fP] ] [ \fB\-Dc\fP|\fBi\fP|\fBm\fP|\fBp\fP ] [ \fB\-E\fP[\fIdatum\fP] ] 
[ \fB\-F\fP[\fBk\fP|\fBm\fP|\fBn\fP|\fBi\fP|\fBc\fP|\fBp\fP] ] [ \fB\-G\fP[\fIx0\fP/\fIy0\fP][/\fIunit\fP] ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-I\fP ] 
[ \fB\-L\fPline.xy\fP[/\fIunit\fP] ] [ \fB\-M\fP[\fBi\fP|\fBo\fP][\fIflag\fP] ] [ \fB\-Q\fP[\fBd\fP|\fBe\fP] [ \fB\-S\fP ] [ \fB\-T\fP[\fBh\fP]\fIfrom\fP[/\fIto\fP] ] 
[ \fB\-V\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fIcolinfo\fP ]
.SH DESCRIPTION
\fBmapproject\fP reads (longitude, latitude) positions from \fIinfiles\fP [or standard input] and
computes (x,y) coordinates using the specified map projection and scales.
Optionally, it can read (x,y) positions and compute (longitude, latitude) values
doing the inverse transformation.  This can be used to transform linear (x,y) points
obtained by digitizing a map of known projection to geographical coordinates.  May also
calculate distances along track, to a fixed point, or closest approach to a line.
Finally, can be used to perform various datum conversions.
Additional data fields are permitted after the first 2 columns which must have (longitude,latitude) or (x,y).
See option \fB\-:\fP on how to read (latitude,longitude) files.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfiles\fP
Data file(s) to be transformed.  If not given, standard input is read.
.TP
.B \-J
Selects the map projection. The following character determines the projection. If the
character is upper case then the argument(s) supplied as scale(s) is interpreted to be
the map width (or axis lengths), else the scale argument(s) is the map scale (see its
definition for each projection). UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP
setting in .gmtdefaults4, but this can be overridden on the command line by appending
\fBc\fP, \fBi\fP, or \fBm\fP to the scale/width values.  Append \fBh\fP, \fB+\fP, or \fB-\fP
to the given \fIwidth\fP if you instead want to set map height, the maximum dimension, or
the minimum dimension, respectively [Default is \fBw\fP for width].
.br
The ellipsoid used in the map projections is user-definable by editing the .gmtdefaults4 file
in your home directory. 63 commonly used ellipsoids and a spheroid are currently
supported, and users may also specify their own ellipsoid parameters (see man gmtdefaults for more details).
\fBGMT\fP default is WGS-84. Several GMT parameters can affect the projection: \fBELLIPSOID\fP, \fBINTERPOLANT\fP,
\fBMAP_SCALE_FACTOR\fP, and \fBMEASURE_UNIT\fP; see the \fBgmtdefaults\fP man page for details.
.br
Choose one of the following projections (The \fBE\fP or \fBC\fP after projection names
stands for Equal-Area and Conformal, respectively):
.RS
.PP
\fBCYLINDRICAL PROJECTIONS:\fP
.TP
\fB\-Jc\fP\fIlon0/lat0/scale\fP or \fB\-JC\fP\fIlon0/lat0/width\fP (Cassini).
Give projection center and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jc\fP\fIlon0/lat0/scale\fP or \fB\-JC\fP\fIlon0/lat0/width\fP (Cassini).
Give projection center and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jj\fP\fIlon0/scale\fP or \fB\-JJ\fP\fIlon0/width\fP (Miller Cylindrical Projection).
Give the central meridian and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jm\fP\fIparameters\fP (Mercator \fB[C]\fP).
Specify one of:
.RS
.TP
\fB\-Jm\fP\fIscale\fP or \fB\-JM\fP\fIwidth\fP
Give scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jm\fP\fIlon0/lat0/scale\fP or \fB\-JM\fP\fIlon0/lat0/width\fP
Give central meridian, standard latitude and scale along parallel (1:xxxx or UNIT/degree).
.RE
.TP
\fB\-Jo\fP\fIparameters\fP (Oblique Mercator \fB[C]\fP).
Specify one of:
.RS
.TP
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP or \fB\-JOa\fP\fIlon0/lat0/azimuth/width\fP
Set projection center, azimuth of oblique equator, and scale.
.TP
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP or \fB\-JOb\fP\fIlon0/lat0/lon1/lat1/scale\fP
Set projection center, another point on the oblique equator, and scale.
.TP
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP or \fB\-JOc\fP\fIlon0/lat0/lonp/latp/scale\fP
Set projection center, pole of oblique projection, and scale.
.PP
Give scale along oblique equator (1:xxxx or UNIT/degree).
.RE
.TP
\fB\-Jq\fP\fIlon0/scale\fP or \fB\-JQ\fP\fIlon0/width\fP (Equidistant Cylindrical Projection (Plate Carree)).
Give the central meridian and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jt\fP\fIparameters\fP (Transverse Mercator \fB[C]\fP).
Specify one of:
.RS
.TP
\fB\-Jt\fP\fIlon0/scale\fP or \fB\-JT\fP\fIlon0/width\fP
Give the central meridian and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jt\fP\fIlon0/lat0/scale\fP or \fB\-JT\fP\fIlon0/lat0/width\fP
Give projection center and scale (1:xxxx or UNIT/degree).
.RE
.TP
\fB\-Ju\fP\fIzone/scale\fP or \fB\-JU\fP\fIzone/width\fP (UTM - Universal Transverse Mercator \fB[C]\fP).
Give the zone number (1-60) and scale (1:xxxx or UNIT/degree).
.br
Zones: prepend - or + to enforce southern or northern hemisphere conventions [northern if south > 0].
.TP
\fB\-Jy\fP\fIlon0/lats/scale\fP or \fB\-JY\fP\fIlon0/lats/width\fP (Basic Cylindrical Projections \fB[E]\fP).
Give the central meridian, standard parallel, and scale (1:xxxx or UNIT/degree).
The standard parallel is typically one of these (but can be any value):
.RS
.RS
45 - The Peters projection
.br
37.4 - The Trystan Edwards projection
.br
30 - The Behrman projection
.br
0 - The Lambert projection
.RE
.RE
.PP
\fBAZIMUTHAL PROJECTIONS:\fP
.sp
Except for polar aspects, \fB\-R\fPw/e/s/n will be reset to \fB\-Rg\fP.  Use \fB\-R\fP<...>\fBr\fP for smaller regions.
.TP
\fB\-Ja\fP\fIlon0/lat0/scale\fP or \fB\-JA\fP\fIlon0/lat0/width\fP (Lambert \fB[E]\fP).
\fIlon0/lat0\fP specifies the projection center.
Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
in UNIT from origin to the oblique latitude \fIlat\fP.
.TP
\fB\-Je\fP\fIlon0/lat0/scale\fP or \fB\-JE\fP\fIlon0/lat0/width\fP (Equidistant).
\fIlon0/lat0\fP specifies the projection center.
Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
in UNIT from origin to the oblique latitude \fIlat\fP.
.TP
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP or \fB\-JF\fP\fIlon0/lat0/horizon/width\fP (Gnomonic).
\fIlon0/lat0\fP specifies the projection center.
\fIhorizon\fP specifies the max distance from projection center (in degrees, < 90).
Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
in UNIT from origin to the oblique latitude \fIlat\fP.
.TP
\fB\-Jg\fP\fIlon0/lat0/scale\fP or \fB\-JG\fP\fIlon0/lat0/width\fP (Orthographic).
\fIlon0/lat0\fP specifies the projection center.
Give scale as 1:xxxx or \fIradius/lat\fP, where \fIradius\fP is distance
in UNIT from origin to the oblique latitude \fIlat\fP.
.TP
\fB\-Js\fP\fIlon0/lat0/scale\fP or \fB\-JS\fP\fIlon0/lat0/width\fP (General Stereographic \fB[C]\fP).
\fIlon0/lat0\fP specifies the projection center.
Give scale as 1:xxxx (true at pole) or \fIslat\fP/1:xxxx (true at standard parallel \fIslat\fP)
or \fIradius/lat\fP (\fIradius\fP in UNIT from origin to the oblique latitude \fIlat\fP).
.PP
\fBCONIC PROJECTIONS:\fP
.TP
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JB\fP\fIlon0/lat0/lat1/lat2/width\fP (Albers \fB[E]\fP).
Give projection center, two standard parallels, and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JD\fP\fIlon0/lat0/lat1/lat2/width\fP (Equidistant)
Give projection center, two standard parallels, and scale (1:xxxx or UNIT/degree).
.TP
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP or \fB\-JL\fP\fIlon0/lat0/lat1/lat2/width\fP (Lambert \fB[C]\fP)
Give origin, 2 standard parallels, and scale along these (1:xxxx or UNIT/degree).
.PP
\fBMISCELLANEOUS PROJECTIONS:\fP
.TP
\fB\-Jh\fP\fIlon0/scale\fP or \fB\-JH\fP\fIlon0/width\fP (Hammer \fB[E]\fP).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Ji\fP\fIlon0/scale\fP or \fB\-JI\fP\fIlon0/width\fP (Sinusoidal \fB[E]\fP).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP or \fB\-JK\fP[\fBf|s\fP]\fIlon0/width\fP (Eckert IV (f) and VI (s) \fB[E]\fP).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jn\fP\fIlon0/scale\fP or \fB\-JN\fP\fIlon0/width\fP (Robinson).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jr\fP\fIlon0/scale\fP \fB\-JR\fP\fIlon0/width\fP (Winkel Tripel).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jv\fP\fIlon0/scale\fP or \fB\-JV\fP\fIlon0/width\fP (Van der Grinten).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.TP
\fB\-Jw\fP\fIlon0/scale\fP or \fB\-JW\fP\fIlon0/width\fP (Mollweide \fB[E]\fP).
Give the central meridian and scale along equator (1:xxxx or UNIT/degree).
.PP
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.TP
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] or \fB\-JP\fP[\fBa\fP]\fIwidth\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
Optionally insert \fBa\fP after \fB\-Jp\fP [ or \fB\-JP\fP] for
azimuths CW from North instead of directions CCW from East [default].
Optionally append /\fIorigin\fP in degrees to indicate an angular offset [0]).
Finally, append \fBr\fP if r is elevations in degrees (requires s >= 0 and n <= 90)
or \fBz\fP if you want to annotate depth rather than radius [Default].
Give scale in UNIT/r-unit.
.TP
\fB\-Jx\fP\fIx-scale\fP[\fI/y-scale\fP] or \fB\-JX\fP\fIwidth\fP[\fI/height\fP] (Linear, log, and power scaling)
Give \fIx-scale\fP in UNIT/x-unit and/or \fIy-scale\fP in UNIT/y-unit; or
specify \fIwidth\fP and/or \fIheight\fP in UNIT
(\fIy-scale\fP=\fIx-scale\fP if not specified separately).
Use negative scale(s) to reverse the direction of an axis (e.g., to have y be positive down).
Optionally, append to \fIx-scale\fP, \fIy-scale\fP, \fIwidth\fP or \fIheight\fP one of the following:
.RS
.TP
.B d
Data are geographical coordinates (in degrees).
.TP
.B l
Take log10 of values before scaling.
.TP
\fBp\fP\fIpower\fP
Raise values to \fIpower\fP before scaling.
.TP
.B t
Input coordinates are time relative to \fBTIME_EPOCH\fP.
.TP
.B T
Input coordinates are absolute time.
.PP
Default axis lengths (see gmtdefaults) can be invoked
using \fB\-JXh\fP (for landscape); \fB\-JXv\fP (for portrait) will swap the x- and y-axis lengths.
The \fBGMT\fP default unit for this installation is UNIT. However, you may
change this by editing your .gmtdefaults4 file(s) (run gmtdefaults to create one
if you do not have it).
.RE
.RE
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
.TP
\fIinfile(s)\fP
input file(s) with 2 or more columns. If no file(s) is given, \fBmapproject\fP will read the standard input.
.TP
\fB\-A\fP[\fBf\fP|\fBb\fP]
\fB\-Af\fP calculates the (forward) azimuth from fixed point \fIlon/lat\fP to each data point.  Use \fB\-Ab\fP to get
back-azimuth from data points to fixed point.  Upper case \fBF\fP or \fBB\fP will convert from geodetic to
geocentric latitudes and estimate azimuth of geodesics (assuming the current ellipsoid is not a sphere).
.TP
.B \-C
Set center of projected coordinates to be at map projection center [Default is lower left corner].
Optionally, add offsets in the projected units to be added (or subtracted when \fB\-I\fP is set) to (from)
the projected coordinates, such as false eastings and northings for particular projection zones [0/0].
The unit used for the offsets is the plot distance unit in effect (see \fBMEASURE_UNIT\fP) unless \fB\-F\fP is used,
in which case the offsets are in meters.
.TP
.B \-D
Temporarily override \fBMEASURE_UNIT\fP and use \fBc\fP (cm), \fBi\fP (inch),
\fBm\fP (meter), or \fBp\fP (points) instead.  Cannot be used with \fB\-F\fP.
.TP
.B \-E
Convert from geodetic (lon, lat, height) to Earth Centered Earth Fixed (ECEF) (x,y,z) coordinates (add \fB\-I\fP for the
inverse conversion).  Append datum ID (see \fB\-Qd\fP) or give \fIellipsoid\fP:\fIdx,dy,dz\fP
where \fIellipsoid\fP may be an ellipsoid ID (see \fB\-Qe\fP) or given as \fIa,1/f\fP.  If \fIdatum\fP is - or not
given we assume WGS-84.
.TP
.B \-F
Force 1:1 scaling, i.e., output (or input, see \fB\-I\fP) data are in actual projected meters.  To specify other units,
append \fBk\fP (km), \fBm\fP (mile), \fBn\fP (nautical mile), \fBi\fP (inch), \fBc\fP (cm), or \fBp\fP (points).
Without \fB\-F\fP, the output (or input, see \fB\-I\fP) are in the units specified by \fBMEASURE_UNIT\fP (but see \fB\-D\fP).
.TP
.B \-G
Calculate distances along track OR to the optional point set with \fB\-G\fP\fIx0/y0\fP.  Append the distance unit;
choose among \fBe\fP (m), \fBk\fP (km), \fBm\fP (mile), \fBn\fP (nautical mile), \fBd\fP (spherical degree),
\fBc\fP (Cartesian distance using input coordinates) or \fBC\fP (Cartesian distance using projected coordinates).  The
last unit requires \fB\-R\fP and \fB\-J\fP to be set.  Upper case  \fBE\fP, \fBK\fP, \fBM\fP, \fBN\fP, or \fBD\fP
will use exact methods for geodesic distances (Rudoe's method for distances in length units and emplying geocentric\"'
latitudes in degree calculations, assuming the current ellipsoid is not a sphere).
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Do the Inverse transformation, i.e. get (longitude,latitude) from (x,y) data.
.TP
.B \-L
Determine the shortest distance from the input data points to the line(s) given in the ASCII multi-segment file \fIline.xy\fP.
The distance and the coordinates of the nearest point will be appended to the output as three new columns.
Append the distance unit; choose among \fBe\fP (m), \fBk\fP (km), \fBm\fP (mile), \fBn\fP (nautical mile), \fBd\fP (spherical degree),
\fBc\fP (Cartesian distance using input coordinates) or \fBC\fP (Cartesian distance using projected coordinates).  The
last unit requires \fB\-R\fP and \fB\-J\fP to be set.  A spherical approximation is used for geographic data.
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-Q
List all projection parameters.  To only list datums, use \fB\-Qd\fP.  To only list ellipsoids, use \fB\-Qe\fP.
.TP
.B \-S
Suppress points that fall outside the region.
.TP
.B \-T
Coordinate conversions between datums \fIfrom\fP and \fIto\fP.  Use \fB\-Th\fP if 3rd input column has
height above ellipsoid [Default assumes height = 0, i.e., on the ellipsoid].  Specify datums using the
ID (see \fB\-Qd\fP) or give \fIellipsoid\fP:\fIdx,dy,dz\fP, where \fIellipsoid\fP may be an ellipsoid
ID (see \fB\-Qe\fP) or given as \fIa,1/f\fP.  If \fIdatum\fP is - or not given we use WGS-84.
\fB\-T\fP may be used in conjunction with \fB\-R \-J\fP to change the datum before coordinate projection
(add \fB\-I\fP to apply the datum conversion after the inverse projection).  Make sure that the
\fBELLIPSOID\fP setting is correct for your case.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is same as input].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH EXAMPLES
To transform a file with (longitude,latitude) into (x,y) positions in cm on
a Mercator grid for a given scale of 0.5 cm per degree, run
.br
.sp
\fBmapproject\fP lonlatfile \fB\-R\fP20/50/12/25 \fB\-Jm\fP0.5\fBc\fP > xyfile
.br
.sp
To transform several 2-column, binary, double precision files with (latitude,longitude) into (x,y) positions in inch on
a Transverse Mercator grid (central longitude 75W) for scale = 1:500000 and suppress those points
that would fall outside the map area, run
.br
.sp
\fBmapproject\fP tracks.* \fB\-R\fP-80/-70/20/40 \fB\-Jt\fP-75/1:500000 \fB\-:\fP \fB\-S \-Di \-bo \-bi\fP\fI2\fP > tmfile.b
.br
.sp
To convert the geodetic coordinates (lon, lat, height) in the file old.dat from the NAD27 CONUS datum
(Datum ID 131 which uses the Clarke-1866 ellipsoid) to WGS 84, run
.br
.sp
\fBmapproject\fP old.dat \fB\-Th\fP131 > new.dat
.br
.sp
To compute the closest distance (in km) between each point in the input file quakes.dat and the
line segments given in the multi-segment ASCII file coastline.xy, run
.br
.sp
\fBmapproject\fP quakes.dat \fB\-L\fPcoastline.xy/k > quake_dist.dat
.SH RESTRICTIONS
The rectangular input region set with \fB\-R\fP will in general be mapped into a
non-rectangular grid.  Unless \fB\-C\fP is set, the leftmost point on this grid has xvalue = 0.0, and the
lowermost point will have yvalue = 0.0. Thus, before you digitize a map, run the
extreme map coordinates through \fBmapproject\fP using the appropriate scale and see
what  (x,y) values they are mapped onto.  Use these values when setting up for
digitizing in order to have the inverse transformation work correctly, or alternatively,
use \fBawk\fP to scale and shift the (x,y) values before transforming.
.SH ELLIPSOIDS AND SPHEROIDS
\fBGMT\fP will use ellipsoidal formulae if they are implemented and the user have
selected an ellipsoid as the reference shape (see \fBELLIPSOID\fP in \fBgmtdefaults\fP).  The user
needs to be aware of a few potential pitfalls: (1)  For some projections,
such as Transverse Mercator, Albers, and Lamberts conformal conic we use the
ellipsoidal expressions when the areas mapped are small, and switch to the
spherical expressions (and substituting the appropriate auxiliary latitudes)
for larger maps.  The ellipsoidal formulae are used as follows: (a) Transverse
Mercator: When all points are within 10 degrees of central meridian, (b) Conic
projections when longitudinal range is less than 90 degrees, (c) Cassini
projection when all points are within 4 degrees of central meridian. (2) When
you are trying to match some historical data (e.g., coordinates obtained with
a certain projection and a certain reference ellipsoid) you may find that \fBGMT\fP
gives results that are slightly different.  One likely source of this mismatch
is that older calculations often used less significant digits.  For instance,
Snyder's examples often use the Clarke 1866 ellipsoid (defined by him as\"'
having a flattening f = 1/294.98).  From f we get the eccentricity squared to
be 0.00676862818 (this is what \fBGMT\fP uses), while Snyder rounds off and uses
0.00676866.  This difference can give discrepancies of several tens of cm.
If you need to reproduce coordinates projected with this slightly different
eccentricity, you should specify your own ellipsoid with the same parameters
as Clarke 1866, but with f = 1/294.97861076.  Also, be aware that older data
may be referenced to different datums, and unless you know which datum was
used and convert all data to a common datum you may experience mismatches of
tens to hundreds of meters. (3) Finally, be aware that \fBMAP_SCALE_FACTOR\fP
have certain default values for some projections so you may have to override
the setting in order to match results produced with other settings.
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR GMT (l),
.IR project (l)
.SH REFERENCES
Bomford, G., 1952, Geodesy, Oxford U. Press.
.br
Snyder, J. P., 1987, Map Projections \- A Working Manual, U.S. Geological Survey Prof. Paper 1395.
.br
Vanicek, P. and Krakiwsky, E, 1982, Geodesy \- The Concepts, North-Holland Publ., ISBN: 0 444 86149 1.
.br
