 # MIPS Make68K - V0.30 - Copyright 2005, Manuel Geran (bdiamond@free.fr)
 #   based on Make68K - Copyright 1998, Mike Coates (mame@btinternet.com)
 #                                    & Darren Olafson (deo@mail.island.net)
		 .set arch=allegrex

		 .set noreorder
		 .set nomacro
		 .set nobopt
 #		 .set noat

		 .globl M68000_RUN
		 .globl M68000_RESET
		 .globl M68000_regs
		 .globl M68000_OPCODETABLE
		 .globl a68k_memory_intf


 # Vars Mame declares / needs access to

		 .extern m68k_ICount,4
		 .extern OP_ROM,4
		 .extern OP_RAM,4
		 .extern mem_amask,4
		 .extern mame_debug,4
		 .extern illegal_op,4
		 .extern illegal_pc,4
		 .extern opcode_entry,4
		 .extern cur_mrhard,4



		 .text

	 .ent   M68000_RESET
M68000_RESET:
		 .frame $29, 0, $31
		 jr    $31
		 nop			 # Delay slot

	 .end   M68000_RESET


	 .ent   M68000_RUN
M68000_RUN:
		 addiu $29,$29,-112
		 .frame $29, 112, $31

		 sw    $16,0x48($29)
		 sw    $17,0x4C($29)
		 sw    $18,0x50($29)
		 sw    $19,0x54($29)
		 sw    $20,0x58($29)
		 sw    $21,0x5C($29)
		 sw    $22,0x60($29)
		 sw    $23,0x64($29)
		 sw    $30,0x68($29)
		 sw    $31,0x6C($29)
		 la    $21,M68000_regs
		 lbu   $8,0x50($21)
		 xori  $9,$8,0x80
		 lw    $15,m68k_ICount
		 beq   $9,$0,MC68Kexit
		 movz  $15,$0,$9		 # Delay slot
		 la    $30,M68000_OPCODETABLE
		 lw    $22,OP_ROM
		 lw    $23,0x4C($21)
		 lw    $2,0x48($21)
		 addu  $23,$22,$23
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
 # Check for Interrupt waiting

		 andi  $8,$8,0x07
		 bne   $8,$0,interrupt

		 nop			 # Delay slot

IntCont:
		 bltz  $15,MainExit
		 lhu   $24,0x00($23)		 # Delay slot

		 sll   $7,$24,2
		 addu  $7,$7,$30

		 lw    $7,0x00($7)

		 jr    $7
		 nop			 # Delay slot

MainExit:
		 subu  $23,$23,$22
		 sw    $23,0x4C($21)		 # Save PC
		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 lw    $8,0x44($21)
		 sw    $2,0x48($21)
		 andi  $8,$8,0x20
		 bne   $8,$0,ME1		 # Mode ?
		 lw    $2,0x3C($21)		 # Delay slot - Get A7
		 bgez  $0,MC68Kexit
		 sw    $2,0x68($21)		 # Delay slot - Save in USP
ME1:
		 sw    $2,0x40($21)		 # Save in ISP
MC68Kexit:
		 sw    $15,m68k_ICount
		 lw    $16,0x48($29)
		 lw    $17,0x4C($29)
		 lw    $18,0x50($29)
		 lw    $19,0x54($29)
		 lw    $20,0x58($29)
		 lw    $21,0x5C($29)
		 lw    $22,0x60($29)
		 lw    $23,0x64($29)
		 lw    $30,0x68($29)
		 lw    $31,0x6C($29)
		 jr    $31
		 addiu $29,$29,112		 # Delay slot
	 .end   M68000_RUN


 # Interrupt check

interrupt:
		 lbu   $9,0x50($21)
		 andi  $2,$9,0x07
		 xori  $8,$2,0x07		 # Always take 7
		 beq   $8,$0,procint
		 nop			 # Delay slot

		 lbu   $3,0x44($21)		 # int mask
		 andi  $3,$3,0x07
		 subu  $8,$2,$3
		 blez  $8,IntCont
		 nop			 # Delay slot

procint:
		 andi  $9,$9,0x7f		 # remove stop
		 sb    $9,0x50($21)

		 lw    $25,0x54($21)
		 sw    $2,0x44($29)		 # save level

		 sw    $2,0x40($29)
		 sw    $15,m68k_ICount
		 jalr  $25	 # get the IRQ level
		 or    $4,$0,$2		 # irq line #		    Delay slot
		 lw    $15,m68k_ICount
		 bgez  $2,AUTOVECTOR
		 lw    $3,0x40($29)		 # Delay slot
		 addiu $2,$3,24		 # Vector

AUTOVECTOR:

		 jal   Exception
		 nop                    	 # Delay slot

		 lbu   $3,0x44($21)		 # set Int mask
		 lw    $2,0x44($29)
		 andi  $3,$3,0xF8
		 or    $3,$3,$2
		 bgez  $0,IntCont
		 sb    $3,0x44($21)		 # Delay slot

	 .ent   Exception
Exception:
		 addiu $29,$29,-48
		 .frame $29, 48, $31

		 sw    $31,0x2C($29)
		 sb    $2,0x28($29)		 # Save IRQ Vector for Later
		 la    $8,exception_cycles
		 addu  $2,$2,$8
		 lbu   $2,0x00($2)		 # Get Cycles
		 subu  $15,$15,$2		 # Decrement ICount
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 andi  $25,$2,0x2000			 # Which Mode ?
		 bne   $25,$0,ExSuperMode		 # Supervisor
		 lw    $4,0x3C($21)			 # Delay slot - Get A7
		 srl   $25,$2,8
		 ori   $25,$25,0x20
		 sb    $25,0x44($21)			 # Set Supervisor Mode
		 sw    $4,0x68($21)			 # Save in USP
		 lw    $4,0x40($21)			 # Get ISP
ExSuperMode:
		 addiu $4,$4,-6
		 sw    $4,0x3C($21)			 # Put in A7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $4,0x24($29)
		 or    $5,$0,$2
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $4,0x24($29)
		 lw    $15,m68k_ICount
		 subu  $5,$23,$22
		 addiu $4,$4,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 lbu   $2,0x28($29)		 # Level
		 lw    $25,0x6C($21)
		 sll   $2,$2,2
		 addu  $4,$2,$25
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x01
		 beq   $25,$0,2f
		 addu  $23,$22,$2     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $2,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$2,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 lw    $31,0x2C($29)
		 jr    $31
		 addiu $29,$29,48		 # Delay slot

	 .end   Exception




OP0_1000:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1010:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1018:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_101f:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1020:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1027:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1028:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1030:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1038:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1039:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_103a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_103b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_103c:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1080:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1090:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1098:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_109f:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10a0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10a7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10a8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10b0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10b8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10b9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10ba:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10bb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10bc:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_10fc:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1100:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1110:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1118:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_111f:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1120:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1127:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1128:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1130:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1138:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1139:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_113a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_113b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_113c:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1140:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1150:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1158:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_115f:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1160:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1167:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1168:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1170:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1178:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1179:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_117a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_117b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_117c:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1180:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1190:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1198:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_119f:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11a0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11a7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11a8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11b0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11b8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11b9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11ba:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11bb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11bc:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_11fc:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_13fc:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ec0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ed0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ed8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1edf:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ee0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ee7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ee8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ef0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ef8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1ef9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1efa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1efb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1efc:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f00:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f10:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f18:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f1f:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f20:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f27:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f28:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f30:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f38:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f39:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f3a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f3b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_1f3c:				#:
		 addiu $23,$23,2

		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,7         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2000:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2010:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2018:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2020:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2028:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2030:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2038:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2039:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_203a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_203b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_203c:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2040:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2050:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2058:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2060:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2068:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2070:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2078:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2079:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_207a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_207b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_207c:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2080:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2090:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2098:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20a0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20a8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20b0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20b8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20b9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20ba:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20bb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20bc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_20fc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2100:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2110:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2118:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2120:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2128:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2130:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2138:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2139:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_213a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_213b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_213c:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $2,0x44($29)
		 sw    $14,0x40($29)
		 addiu $14,$14,2
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $25,0x8C($21)
		 lw    $4,0x40($29)
		 lw    $5,0x44($29)
		 jalr  $25
		 srl   $5,$5,16         	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2140:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2150:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2158:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2160:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2168:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2170:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2178:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2179:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_217a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_217b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_217c:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2180:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2190:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_2198:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21a0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21a8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21b0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21b8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21b9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21ba:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21bb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21bc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_21fc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-36
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_23fc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3000:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3010:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3018:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3020:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3028:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3030:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3038:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3039:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_303a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_303b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_303c:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3040:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3050:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3058:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3060:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3068:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3070:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3078:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3079:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_307a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_307b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_307c:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 seh   $2,$2
		 addu  $24,$24,$21
		 sw    $2,0x20($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3080:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3090:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3098:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30a0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30a8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30b0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30b8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30b9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30ba:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30bb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30bc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_30fc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3100:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3110:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3118:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3120:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3128:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3130:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3138:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3139:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_313a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_313b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_313c:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3140:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3150:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3158:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3160:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3168:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3170:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3178:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3179:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_317a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_317b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_317c:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lh    $7,0x00($23)
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3180:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3190:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_3198:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31a0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31a8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31b0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31b8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31b9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31ba:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31bb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31bc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_31fc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33c0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x0f
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lhu   $2,0x00($8)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33d0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33d8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33e0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33e8:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33f0:				#:
		 addiu $23,$23,2

		 and   $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_33fc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,15         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0000:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lb    $2,0x00($24)
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sb    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0010:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0018:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_001f:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0020:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0027:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0028:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0030:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0038:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0039:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_003c:				#:
		 addiu $23,$23,2

		 lbu   $8,0x00($23)
		 addiu $23,$23,2
		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 or    $2,$2,$8
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0040:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lh    $2,0x00($24)
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sh    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0050:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0058:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0060:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0068:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0070:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0078:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0079:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_007c:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 bne   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 lhu   $8,0x00($23)
		 addiu $23,$23,2
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 or    $2,$2,$8
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0080:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $2,0x00($24)
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sw    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0090:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0098:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_00a0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_00a8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_00b0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_00b8:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_00b9:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-36
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0200:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lb    $2,0x00($24)
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sb    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0210:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0218:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_021f:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0220:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0227:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0228:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0230:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0238:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0239:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_023c:				#:
		 addiu $23,$23,2

		 lbu   $8,0x00($23)
		 addiu $23,$23,2
		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 and   $2,$2,$8
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0240:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lh    $2,0x00($24)
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sh    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0250:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0258:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0260:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0268:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0270:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0278:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0279:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_027c:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 bne   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 lhu   $8,0x00($23)
		 addiu $23,$23,2
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 and   $2,$2,$8
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0280:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $2,0x00($24)
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sw    $2,0x00($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0290:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0298:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_02a0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_02a8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_02b0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_02b8:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_02b9:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 and   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-36
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0400:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 sb    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0410:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0418:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_041f:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0420:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0427:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0428:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0430:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0438:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0439:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0440:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 sh    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0450:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0458:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0460:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0468:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0470:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0478:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0479:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0480:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 sw    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0490:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0498:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_04a0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_04a8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_04b0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_04b8:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_04b9:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $2,$9,$8
		 sltu  $16,$9,$8       	 # Set Carry
		 xor   $17,$9,$8
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-36
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0600:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 sb    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0610:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0618:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_061f:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0620:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0627:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0628:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0630:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0638:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0639:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0640:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 sh    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0650:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0658:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0660:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0668:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0670:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0678:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0679:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0680:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 sw    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0690:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0698:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_06a0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_06a8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_06b0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_06b8:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_06b9:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $2,$9,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$9,$8
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-36
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a00:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lb    $2,0x00($24)
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sb    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a10:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a18:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a1f:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a20:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a27:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a28:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a30:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a38:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a39:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a3c:				#:
		 addiu $23,$23,2

		 lbu   $8,0x00($23)
		 addiu $23,$23,2
		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 xor   $2,$2,$8
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a40:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lh    $2,0x00($24)
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sh    $2,0x00($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a50:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a58:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a60:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a68:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a70:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a78:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a79:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a7c:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 bne   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 lhu   $8,0x00($23)
		 addiu $23,$23,2
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 xor   $2,$2,$8
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a80:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $2,0x00($24)
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 sw    $2,0x00($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a90:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0a98:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0aa0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0aa8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0ab0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0ab8:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0ab9:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 xor   $2,$2,$8
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-36
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c00:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lb    $2,0x00($24)
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c10:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c18:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c1f:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c20:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c27:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c28:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c30:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c38:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c39:				#:
		 addiu $23,$23,2

		 lb    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c40:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lh    $2,0x00($24)
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c50:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c58:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c60:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c68:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c70:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c78:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c79:				#:
		 addiu $23,$23,2

		 lh    $8,0x00($23)
		 addiu $23,$23,2
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$9
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c80:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $2,0x00($24)
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$9,$0        	 # Set Sign
		 sltiu $18,$9,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c90:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$9,$0        	 # Set Sign
		 sltiu $18,$9,1         	 # Set Zero
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0c98:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,4
		 sw    $25,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$9,$0        	 # Set Sign
		 sltiu $18,$9,1         	 # Set Zero
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0ca0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-4
		 sw    $14,0x20($24)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$9,$0        	 # Set Sign
		 sltiu $18,$9,1         	 # Set Zero
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0ca8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$9,$0        	 # Set Sign
		 sltiu $18,$9,1         	 # Set Zero
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0cb0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$9,$0        	 # Set Sign
		 sltiu $18,$9,1         	 # Set Zero
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0cb8:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$9,$0        	 # Set Sign
		 sltiu $18,$9,1         	 # Set Zero
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0cb9:				#:
		 addiu $23,$23,2

		 lhu   $8,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $8,$8,16
		 or    $8,$8,$25
		 addiu $23,$23,4
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $9,$2,$8
		 sltu  $16,$2,$8       	 # Set Carry
		 xor   $17,$2,$8
		 xor   $25,$9,$2
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$9,$0        	 # Set Sign
		 sltiu $18,$9,1         	 # Set Zero
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0100:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-6
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0110:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0118:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_011f:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0120:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0127:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0128:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0130:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0138:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0139:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_013a:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_013b:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_013c:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lbu   $2,0x00($23)
		 addiu $23,$23,2
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0140:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 sw    $2,0x00($8)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0150:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0158:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_015f:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0160:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0167:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0168:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0170:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0178:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0179:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0180:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 sw    $2,0x00($8)
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0190:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0198:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_019f:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01a0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01a7:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01a8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01b0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01b8:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01b9:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01c0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 sw    $2,0x00($8)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01d0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01d8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01df:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01e0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01e7:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01e8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01f0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01f8:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01f9:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $18,0x00($24)
		 ori   $10,$0,1
		 andi  $18,$18,0x07
		 sllv  $9,$10,$18
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0108:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 sll   $8,$2,8
		 addiu $14,$14,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$8,$2
		 sh    $8,0x00($24)
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0148:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 sll   $8,$2,8
		 addiu $14,$14,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$8,$2
		 addiu $14,$14,2
		 sll   $8,$2,16
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 sll   $9,$2,8
		 addiu $14,$14,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$8,$9
		 or    $8,$8,$2
		 sw    $8,0x00($24)
		 addiu $15,$15,-36
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0188:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $24,0x00($24)
		 sll   $5,$24,8
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $14,$14,2
		 or    $5,$0,$24
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_01c8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $24,0x00($24)
		 sll   $5,$24,24
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $14,$14,2
		 sll   $5,$24,16
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $14,$14,2
		 sll   $5,$24,8
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $14,$14,2
		 or    $5,$0,$24
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-36
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0800:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0810:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0818:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_081f:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0820:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0827:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0828:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0830:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0838:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0839:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_083a:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_083b:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0840:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 sw    $2,0x00($8)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0850:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0858:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_085f:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0860:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0867:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0868:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0870:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0878:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0879:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 xor   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0880:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 sw    $2,0x00($8)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0890:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_0898:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_089f:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08a0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08a7:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08a8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08b0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08b8:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08b9:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 nor   $9,$0,$9
		 and   $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08c0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 sw    $2,0x00($8)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08d0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08d8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08df:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08e0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08e7:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08e8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08f0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08f8:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_08f9:				#:
		 addiu $23,$23,2

		 lhu   $18,0x00($23)
		 addiu $23,$23,2
		 and   $18,$18,0x07
		 ori   $10,$0,1
		 sllv  $9,$10,$18
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 and   $10,$9,$2
		 srlv  $18,$10,$18
		 xori  $18,$18,1        	 # Set Zero Flag
		 or    $2,$2,$9
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_41d0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 sw    $14,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_41e8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 sw    $14,0x20($24)
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_41f0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 sw    $14,0x20($24)
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_41f8:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 sw    $14,0x20($24)
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_41f9:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 sw    $14,0x20($24)
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_41fa:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 sw    $14,0x20($24)
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_41fb:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 sw    $14,0x20($24)
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_4850:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_4868:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_4870:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-34
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_4878:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_4879:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-32
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_487a:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_487b:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-30
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_40c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-6
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_40d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_40d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_40e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_40e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_40f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_40f8:				#:
		 addiu $23,$23,2

		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_40f9:				#:
		 addiu $23,$23,2

		 lbu   $2,0x44($21)
		 sll   $2,$2,4
		 or    $2,$2,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_42c0:				#:
		 addiu $23,$23,2

		 lw    $25,0x70($21)
		 bne   $25,$0,0f
		 andi  $24,$24,0x07     	 # Delay slot
		 j     ILLEGAL
	0:
		 nop                    	 # Delay slot

		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sh    $2,0x00($24)
		 addiu $15,$15,-6
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_42d0:				#:
		 addiu $23,$23,2

		 lw    $25,0x70($21)
		 bne   $25,$0,0f
		 andi  $24,$24,0x07     	 # Delay slot
		 j     ILLEGAL
	0:
		 nop                    	 # Delay slot

		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_42d8:				#:
		 addiu $23,$23,2

		 lw    $25,0x70($21)
		 bne   $25,$0,0f
		 andi  $24,$24,0x07     	 # Delay slot
		 j     ILLEGAL
	0:
		 nop                    	 # Delay slot

		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_42e0:				#:
		 addiu $23,$23,2

		 lw    $25,0x70($21)
		 bne   $25,$0,0f
		 andi  $24,$24,0x07     	 # Delay slot
		 j     ILLEGAL
	0:
		 nop                    	 # Delay slot

		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_42e8:				#:
		 addiu $23,$23,2

		 lw    $25,0x70($21)
		 bne   $25,$0,0f
		 andi  $24,$24,0x07     	 # Delay slot
		 j     ILLEGAL
	0:
		 nop                    	 # Delay slot

		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_42f0:				#:
		 addiu $23,$23,2

		 lw    $25,0x70($21)
		 bne   $25,$0,0f
		 andi  $24,$24,0x07     	 # Delay slot
		 j     ILLEGAL
	0:
		 nop                    	 # Delay slot

		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_42f8:				#:
		 addiu $23,$23,2

		 lw    $25,0x70($21)
		 bne   $25,$0,0f
		 nop                    	 # Delay slot
		 j     ILLEGAL
	0:
		 nop                    	 # Delay slot

		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_42f9:				#:
		 addiu $23,$23,2

		 lw    $25,0x70($21)
		 bne   $25,$0,0f
		 nop                    	 # Delay slot
		 j     ILLEGAL
	0:
		 nop                    	 # Delay slot

		 or    $2,$0,$20
		 sll   $2,$2,1
		 or    $2,$2,$19
		 sll   $2,$2,1
		 or    $2,$2,$18
		 sll   $2,$2,1
		 or    $2,$2,$17
		 sll   $2,$2,1
		 or    $2,$2,$16
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $2,0x00($24)
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44fa:				#:
		 addiu $23,$23,2

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44fb:				#:
		 addiu $23,$23,2

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_44fc:				#:
		 addiu $23,$23,2

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46c0:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $2,0x00($24)
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46d0:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-16
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46d8:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,2
		 sw    $25,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-16
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46e0:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-2
		 sw    $14,0x20($24)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-18
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46e8:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46f0:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-22
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46f8:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46f9:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-24
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46fa:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-20
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46fb:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-22
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_46fc:				#:
		 lbu   $8,0x44($21)
		 andi  $8,$8,0x20       	 # Supervisor Mode ?
		 beq   $8,$0,9f
		 addiu $23,$23,2        	 # Delay slot

		 lhu   $2,0x00($23)
		 addiu $23,$23,2
		 andi  $25,$2,0x2000    	 # User Mode ?
		 bne   $25,$0,0f
		 or    $18,$0,$2       	 # Delay slot
		 lw    $16,0x3C($21)
		 lw    $17,0x68($21)
		 sw    $16,0x40($21)
		 sw    $17,0x3C($21)
	0:
		 srl   $18,$18,8
		 sb    $18,0x44($21)    	 # T, S & I
		 or    $20,$0,$2
		 or    $19,$0,$2
		 or    $18,$0,$2
		 or    $17,$0,$2
		 or    $16,$0,$2
		 andi  $20,$20,0x10
		 andi  $19,$19,0x08
		 andi  $18,$18,0x04
		 andi  $17,$17,0x02
		 andi  $16,$16,0x01
		 srl   $20,$20,4
		 srl   $19,$19,3
		 srl   $18,$18,2
		 srl   $17,$17,1
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,8

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lbu   $7,0x50($21)     	 # Delay slot
		 j     MainExit
	3:
 # Check for Interrupt waiting

		 andi  $7,$7,0x07       	 # Delay slot
		 beq   $7,$0,3f
		 nop                    	 # Delay slot
		 j     interrupt
	3:
		 lhu   $24,0x00($23)    	 # Delay slot
		 sll   $7,$24,2
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5000:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lb    $9,0x00($16)
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sb    $2,0x00($16)
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5088:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $9,0x20($8)
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sw    $2,0x20($8)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5010:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5018:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $25,$14,1
		 sw    $25,0x20($16)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_501f:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5020:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $14,$14,-1
		 sw    $14,0x20($16)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5027:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5028:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 lh    $7,0x00($23)
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5030:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5038:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5039:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5040:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lh    $9,0x00($16)
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sh    $2,0x00($16)
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5050:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5058:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $25,$14,2
		 sw    $25,0x20($16)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5060:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $14,$14,-2
		 sw    $14,0x20($16)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5068:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 lh    $7,0x00($23)
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5070:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5078:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5079:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5080:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $9,0x00($16)
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sw    $2,0x00($16)
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5090:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5098:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $25,$14,4
		 sw    $25,0x20($16)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50a0:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $14,$14,-4
		 sw    $14,0x20($16)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50a8:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 lh    $7,0x00($23)
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50b0:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50b8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50b9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 addu  $2,$9,$24
		 sltu  $16,$2,$24       	 # Set Carry
		 xor   $17,$9,$24
		 nor   $17,$0,$17
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 addiu $2,$0,-1
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50c8:				#:
		 bgez  $0,1f
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_50f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 addiu $2,$0,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5100:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lb    $9,0x00($16)
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sb    $2,0x00($16)
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5188:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $9,0x20($8)
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sw    $2,0x20($8)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5110:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5118:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $25,$14,1
		 sw    $25,0x20($16)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_511f:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5120:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $14,$14,-1
		 sw    $14,0x20($16)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5127:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5128:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 lh    $7,0x00($23)
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5130:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5138:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5139:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5140:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lh    $9,0x00($16)
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sh    $2,0x00($16)
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5150:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5158:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $25,$14,2
		 sw    $25,0x20($16)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5160:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $14,$14,-2
		 sw    $14,0x20($16)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5168:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 lh    $7,0x00($23)
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5170:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5178:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5179:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $9,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5180:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $9,0x00($16)
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sw    $2,0x00($16)
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5190:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5198:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $25,$14,4
		 sw    $25,0x20($16)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51a0:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $14,$14,-4
		 sw    $14,0x20($16)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51a8:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 lh    $7,0x00($23)
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51b0:				#:
		 addiu $23,$23,2

		 andi  $16,$24,0x07
		 sll   $16,$16,2
		 addu  $16,$16,$21
		 lw    $14,0x20($16)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51b8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51b9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $14,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $14,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 srl   $24,$24,9
		 addiu $24,$24,-1       	 # Move range down
		 andi  $24,$24,0x07     	 # Mask out lower bits
		 addiu $24,$24,1        	 # correct range
		 subu  $2,$9,$24
		 sltu  $16,$9,$24       	 # Set Carry
		 xor   $17,$9,$24
		 xor   $25,$2,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 and   $2,$0,$0
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51c8:				#:
		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_51f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 and   $2,$0,$0
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52c8:				#:
		 nor   $25,$16,$18
		 andi  $25,$25,1
		 bne   $25,$0,1f
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_52f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 nor   $2,$16,$18
		 andi  $2,$2,1
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53c8:				#:
		 or   $25,$16,$18
		 bne   $25,$0,1f
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_53f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 or    $2,$16,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54c8:				#:
		 beq   $16,$0,1f        	 # check carry
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_54f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 xori  $2,$16,1         	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55c8:				#:
		 bne   $16,$0,1f        	 # check carry
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_55f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 or    $2,$0,$16        	 # Check Carry
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56c8:				#:
		 beq   $18,$0,1f        	 # Check zero
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_56f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 xori  $2,$18,1         	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57c8:				#:
		 bne   $18,$0,1f        	 # Check zero
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_57f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 or    $2,$0,$18        	 # Check Zero
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58c8:				#:
		 beq   $17,$0,1f        	 # Check Overflow
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_58f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 xori  $2,$17,1         	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59c0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59c8:				#:
		 bne   $17,$0,1f        	 # Check Overflow
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59d0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59d8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59df:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59e0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59e7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59e8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59f0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59f8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_59f9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 or    $2,$0,$17        	 # Check Overflow
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ac0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ac8:				#:
		 beq   $19,$0,1f        	 # Check Sign
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ad0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ad8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5adf:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ae0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ae7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ae8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5af0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5af8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5af9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 xori  $2,$19,1         	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5bc0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5bc8:				#:
		 bne   $19,$0,1f        	 # Check Sign
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5bd0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5bd8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5bdf:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5be0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5be7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5be8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5bf0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5bf8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5bf9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 or    $2,$0,$19        	 # Check Sign
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5cc0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5cc8:				#:
		 beq   $19,$17,1f
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5cd0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5cd8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5cdf:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ce0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ce7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ce8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5cf0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5cf8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5cf9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 xor   $2,$19,$17
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5dc0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5dc8:				#:
		 bne   $19,$17,1f
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5dd0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5dd8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ddf:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5de0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5de7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5de8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5df0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5df8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5df9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 xor   $2,$19,$17
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ec0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ec8:				#:
		 xor    $25,$19,$17
		 or     $25,$25,$18
		 beq   $25,$0,1f
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ed0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ed8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5edf:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ee0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ee7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ee8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ef0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ef8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ef9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 addiu $2,$2,-1
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5fc0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 sb    $2,0x00($24)
		 andi  $2,$2,0x02
		 addiu $15,$15,-4
		 subu  $15,$15,$2
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5fc8:				#:
		 xor    $25,$19,$17
		 or     $25,$25,$18
		 bne   $25,$0,1f
		 andi  $24,$24,0x07     	 # Delay slot
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lhu   $8,0x00($24)
		 addiu $9,$8,-1
		 beq   $8,$0,9f         	 # Is it -1
		 sh    $9,0x00($24)     	 # Delay slot

		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	9:
	1:
		 addiu $23,$23,4

		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5fd0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5fd8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $25,$14,1
		 sw    $25,0x20($24)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5fdf:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5fe0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5fe7:				#:
		 addiu $23,$23,2

		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5fe8:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 lh    $7,0x00($23)
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ff0:				#:
		 addiu $23,$23,2

		 andi  $24,$24,0x07
		 sll   $24,$24,2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ff8:				#:
		 addiu $23,$23,2

		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_5ff9:				#:
		 addiu $23,$23,2

		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 xor   $2,$19,$17
		 or    $2,$2,$18
		 subu  $2,$0,$2
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6000:				#:
		 addiu $23,$23,2

		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6001:				#:
		 addiu $23,$23,2

		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6100:				#:
		 addiu $23,$23,2

		 lh    $24,0x00($23)
		 addu  $24,$23,$24
		 addiu $23,$23,2
		 lw    $5,0x74($21)
		 lui   $25,0xFF00
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 and   $5,$5,$25
		 subu  $25,$23,$22
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 or    $5,$5,$25
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $23,$0,$24

		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6101:				#:
		 addiu $23,$23,2

		 lw    $5,0x74($21)
		 lui   $25,0xFF00
		 lw    $4,0x3C($21)     	 # Push onto Stack
		 and   $5,$5,$25
		 subu  $25,$23,$22
		 addiu $4,$4,-4
		 sw    $4,0x3C($21)
		 or    $5,$5,$25
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6200:				#:
		 nor   $25,$16,$18
		 andi  $25,$25,1
		 bne   $25,$0,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6201:				#:
		 nor   $25,$16,$18
		 andi  $25,$25,1
		 bne   $25,$0,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6300:				#:
		 or   $25,$16,$18
		 bne   $25,$0,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6301:				#:
		 or   $25,$16,$18
		 bne   $25,$0,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6400:				#:
		 beq   $16,$0,1f        	 # check carry
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6401:				#:
		 beq   $16,$0,1f        	 # check carry
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6500:				#:
		 bne   $16,$0,1f        	 # check carry
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6501:				#:
		 bne   $16,$0,1f        	 # check carry
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6600:				#:
		 beq   $18,$0,1f        	 # Check zero
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6601:				#:
		 beq   $18,$0,1f        	 # Check zero
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6700:				#:
		 bne   $18,$0,1f        	 # Check zero
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6701:				#:
		 bne   $18,$0,1f        	 # Check zero
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6800:				#:
		 beq   $17,$0,1f        	 # Check Overflow
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6801:				#:
		 beq   $17,$0,1f        	 # Check Overflow
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6900:				#:
		 bne   $17,$0,1f        	 # Check Overflow
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6901:				#:
		 bne   $17,$0,1f        	 # Check Overflow
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6a00:				#:
		 beq   $19,$0,1f        	 # Check Sign
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6a01:				#:
		 beq   $19,$0,1f        	 # Check Sign
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6b00:				#:
		 bne   $19,$0,1f        	 # Check Sign
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6b01:				#:
		 bne   $19,$0,1f        	 # Check Sign
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6c00:				#:
		 beq   $19,$17,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6c01:				#:
		 beq   $19,$17,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6d00:				#:
		 bne   $19,$17,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6d01:				#:
		 bne   $19,$17,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6e00:				#:
		 xor    $25,$19,$17
		 or     $25,$25,$18
		 beq   $25,$0,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6e01:				#:
		 xor    $25,$19,$17
		 or     $25,$25,$18
		 beq   $25,$0,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6f00:				#:
		 xor    $25,$19,$17
		 or     $25,$25,$18
		 bne   $25,$0,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $23,$23,2
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 lh    $2,0x00($23)
		 addu  $23,$23,$2
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_6f01:				#:
		 xor    $25,$19,$17
		 or     $25,$25,$18
		 bne   $25,$0,1f
		 addiu $23,$23,2        	 # Delay slot

		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	1:
		 seb   $24,$24
		 addu  $23,$23,$24
		 andi  $25,$23,0x01
		 beq   $25,$0,2f
		 subu  $5,$23,$22     	 # Delay slot
		 addiu $23,$23,-2
		 jal   Exception
		 ori   $2,$0,3

		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

	2:
		 sw    $5,0x74($21)
		 lw    $6,mem_amask
		 lw    $25,0x94($21)
		 and   $23,$5,$6
		 sw    $15,m68k_ICount
		 jalr  $25
		 or    $4,$0,$23   	 # Delay slot
		 lw    $15,m68k_ICount
		 lw    $22,OP_ROM
		 addu  $23,$23,$22
 # End of Banking code:
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_7000:				#:

		 addiu $23,$23,2

		 seb   $2,$24
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 srl   $19,$2,31         	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 addu  $24,$24,$21
		 sw    $2,0x00($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8100:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $8,0x00($8)
		 addu  $24,$24,$21
		 lbu   $9,0x00($24)
		 subu  $17,$9,$8
		 subu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 subu  $11,$11,$10
		 subu  $11,$11,$20
		 subu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 addu  $2,$2,$12
		 sll   $12,$12,2
		 addu  $2,$2,$12
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7        	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 sb    $2,0x00($24)
		 addiu $15,$15,-6
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8108:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$0,$2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $17,$9,$8
		 subu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 subu  $11,$11,$10
		 subu  $11,$11,$20
		 subu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 addu  $2,$2,$12
		 sll   $12,$12,2
		 addu  $2,$2,$12
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7        	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_810f:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$0,$2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $17,$9,$8
		 subu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 subu  $11,$11,$10
		 subu  $11,$11,$20
		 subu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 addu  $2,$2,$12
		 sll   $12,$12,2
		 addu  $2,$2,$12
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7        	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8f08:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$0,$2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $17,$9,$8
		 subu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 subu  $11,$11,$10
		 subu  $11,$11,$20
		 subu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 addu  $2,$2,$12
		 sll   $12,$12,2
		 addu  $2,$2,$12
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7        	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8f0f:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$0,$2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 subu  $17,$9,$8
		 subu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 subu  $11,$11,$10
		 subu  $11,$11,$20
		 subu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 sll   $12,$12,1
		 subu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 addu  $2,$2,$12
		 sll   $12,$12,2
		 addu  $2,$2,$12
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7        	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_c100:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lbu   $8,0x00($8)
		 addu  $24,$24,$21
		 lbu   $9,0x00($24)
		 addu  $17,$9,$8
		 addu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 addu  $11,$11,$10
		 addu  $11,$11,$20
		 addu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 subu  $2,$2,$12
		 sll   $12,$12,2
		 subu  $2,$2,$12
		 nor   $17,$0,$17
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 sb    $2,0x00($24)
		 addiu $15,$15,-6
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_c108:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$0,$2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $17,$9,$8
		 addu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 addu  $11,$11,$10
		 addu  $11,$11,$20
		 addu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 subu  $2,$2,$12
		 sll   $12,$12,2
		 subu  $2,$2,$12
		 nor   $17,$0,$17
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_c10f:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$0,$2
		 addu  $24,$24,$21
		 lw    $14,0x20($24)
		 addiu $14,$14,-1
		 sw    $14,0x20($24)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $17,$9,$8
		 addu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 addu  $11,$11,$10
		 addu  $11,$11,$20
		 addu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 subu  $2,$2,$12
		 sll   $12,$12,2
		 subu  $2,$2,$12
		 nor   $17,$0,$17
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_cf08:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$0,$2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $17,$9,$8
		 addu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 addu  $11,$11,$10
		 addu  $11,$11,$20
		 addu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 subu  $2,$2,$12
		 sll   $12,$12,2
		 subu  $2,$2,$12
		 nor   $17,$0,$17
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_cf0f:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $24,0x44($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x44($29)
		 lw    $15,m68k_ICount
		 or    $8,$0,$2
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $8,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $8,0x44($29)
		 lw    $15,m68k_ICount
		 or    $9,$0,$2
		 addu  $17,$9,$8
		 addu  $17,$17,$20
		 andi  $17,$17,0xFF
		 andi  $10,$8,0x0F
		 andi  $11,$9,0x0F
		 andi  $8,$8,0xF0
		 andi  $9,$9,0xF0
		 addu  $11,$11,$10
		 addu  $11,$11,$20
		 addu  $9,$9,$8
		 sltiu $12,$11,10
		 xori  $12,$12,1
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 sll   $12,$12,1
		 addu  $11,$11,$12
		 addu  $2,$9,$11
		 sltiu $16,$2,0x9a
		 xori  $16,$16,1        	 # Set Carry
		 sll   $12,$16,5
		 subu  $2,$2,$12
		 sll   $12,$12,2
		 subu  $2,$2,$12
		 nor   $17,$0,$17
		 xor   $19,$17,$2
		 and   $17,$17,$19
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 sltiu $25,$2,1
		 and   $18,$18,$25       	 # Set Zero
		 srl   $19,$2,7         	 # Set Sign
		 or    $20,$0,$16       	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8000:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lb    $2,0x00($8)
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8010:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8018:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_801f:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8020:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8027:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8028:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8030:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8038:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8039:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_803a:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_803b:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_803c:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lb    $2,0x00($23)
		 addiu $23,$23,2
		 or   $10,$9,$2
		 sb    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8040:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lh    $2,0x00($8)
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8050:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8058:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8060:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8068:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8070:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8078:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8079:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_807a:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_807b:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_807c:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $2,0x00($23)
		 addiu $23,$23,2
		 or   $10,$9,$2
		 sh    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8080:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8090:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8098:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_80a0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_80a8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_80b0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_80b8:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_80b9:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_80ba:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_80bb:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_80bc:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 or   $10,$9,$2
		 sw    $10,0x00($24)
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 addiu $15,$15,-6
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8110:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8118:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_811f:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8120:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8127:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8128:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8130:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8138:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8139:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8150:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8158:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8160:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8168:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8170:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8178:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8179:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8190:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_8198:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_81a0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_81a8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_81b0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_81b8:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_81b9:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 or   $2,$10,$9
		 and   $16,$0,$0        	 # Clear Carry
		 and   $17,$0,$0        	 # Clear Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9000:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lb    $2,0x00($8)
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9010:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9018:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_901f:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9020:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9027:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9028:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9030:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9038:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9039:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_903a:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_903b:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x98($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $2,$2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_903c:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lb    $2,0x00($23)
		 addiu $23,$23,2
		 subu  $10,$9,$2
		 sb    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9040:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x0f
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lh    $2,0x00($8)
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9050:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9058:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9060:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9068:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9070:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9078:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9079:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_907a:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_907b:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_907c:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $2,0x00($23)
		 addiu $23,$23,2
		 subu  $10,$9,$2
		 sh    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$10
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9080:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x0f
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9090:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9098:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90a0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90a8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90b0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90b8:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90b9:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90ba:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90bb:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0xA0($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90bc:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lhu   $2,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $2,$2,16
		 or    $2,$2,$25
		 addiu $23,$23,4
		 subu  $10,$9,$2
		 sw    $10,0x00($24)
		 sltu  $16,$9,$2       	 # Set Carry
		 xor   $17,$9,$2
		 xor   $25,$10,$9
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$10,$0        	 # Set Sign
		 sltiu $18,$10,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 addiu $15,$15,-6
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9110:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9118:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,1
		 sw    $25,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_911f:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $25,$14,2
		 sw    $25,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9120:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-1
		 sw    $14,0x20($8)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9127:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lw    $14,0x3C($21)    	 # Get A7
		 addiu $14,$14,-2
		 sw    $14,0x3C($21)
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9128:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9130:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9138:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9139:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lb    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x7C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seb   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,7
		 andi  $17,$17,0x01     	 # Set Overflow
		 seb  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x88($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9150:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9158:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9160:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9168:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9170:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-18
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9178:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9179:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lh    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $10,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,15
		 andi  $17,$17,0x01     	 # Set Overflow
		 seh  $25,$2
		 slt   $19,$25,$0        	 # Set Sign
		 sltiu $18,$25,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x8C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9190:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_9198:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,4
		 sw    $25,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-20
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_91a0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-4
		 sw    $14,0x20($8)
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-22
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_91a8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_91b0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-26
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_91b8:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-24
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_91b9:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x00($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x84($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 or    $10,$0,$2
		 subu  $2,$10,$9
		 sltu  $16,$10,$9       	 # Set Carry
		 xor   $17,$10,$9
		 xor   $25,$2,$10
		 and   $17,$17,$25
		 srl   $17,$17,31        	 # Set Overflow
		 slt   $19,$2,$0        	 # Set Sign
		 sltiu $18,$2,1         	 # Set Zero
		 or    $20,$0,$16      	 # Copy Carry to X
		 lw    $25,0x90($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $14,0x40($29)
		 sw    $24,0x3C($29)
		 or    $5,$0,$2
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x3C($29)
		 lw    $14,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 addiu $15,$15,-28
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90c0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x0f
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lh    $2,0x00($8)
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90d0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90d8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $25,$14,2
		 sw    $25,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-8
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90e0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $14,$14,-2
		 sw    $14,0x20($8)
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-10
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90e8:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 lh    $7,0x00($23)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 addiu $23,$23,2
		 addu  $14,$14,$7
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90f0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x07
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $14,0x20($8)
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90f8:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 lh    $14,0x00($23)
		 addiu $23,$23,2
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90f9:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 lhu   $14,0x00($23)
		 lhu   $25,0x02($23)
		 sll   $14,$14,16
		 or    $14,$14,$25
		 addiu $23,$23,4
		 lw    $25,0x80($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-16
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90fa:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 lh    $7,0x00($23)
		 subu  $25,$23,$22
		 addu  $14,$25,$7       	 # Add Offset to PC
		 addiu $23,$23,2
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-12
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90fb:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 subu  $14,$23,$22       	 # Get PC
		 lhu   $7,0x00($23)
		 addiu $23,$23,2
		 seb   $6,$7
		 or    $25,$0,$7
		 srl   $7,$7,12
		 andi  $25,$25,0x0800
		 sll   $7,$7,2
		 addu  $7,$7,$21
		 bne   $25,$0,0f
		 lw    $25,0x00($7)      	 # Delay slot
		 seh   $25,$25
	0:
		 addu  $25,$14,$25
		 addu  $14,$25,$6
		 lw    $25,0x9C($21)
		 sw    $15,m68k_ICount
		 sw    $9,0x44($29)
		 sw    $24,0x40($29)
		 or    $4,$0,$14
		 jalr  $25
		 sw    $23,0x4C($21)    	 # Delay slot
		 lw    $24,0x40($29)
		 lw    $9,0x44($29)
		 lw    $15,m68k_ICount
		 seh   $2,$2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-14
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_90fc:				#:
		 addiu $23,$23,2

		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 lh    $2,0x00($23)
		 addiu $23,$23,2
		 subu  $10,$9,$2
		 sw    $10,0x20($24)
		 addiu $15,$15,-4
		 bgez  $15,3f
		 lhu   $24,0x00($23)    	 # Delay slot
		 j     MainExit
	3:
		 sll   $7,$24,2         	 # Delay slot
		 addu  $7,$7,$30
		 lw    $7,0x00($7)
		 jr    $7
		 nop                    	 # Delay slot

OP0_91c0:				#:
		 addiu $23,$23,2

		 andi  $8,$24,0x0f
		 srl   $24,$24,7
		 andi  $24,$24,0x1C
		 addu  $24,$24,$21
		 lw    $9,0x20($24)
		 sll   $8,$8,2
		 addu  $8,$8,$21
		 lw    $2,0x00($8)
		