//SDL_inprint (c) driedfruit https://github.com/driedfruit/SDL_inprint
// modified for use in FBNeo

#include "burner.h"

#define inline_font_width     128
#define inline_font_height    64
static unsigned char inline_font_bits[] = {
   0x01, 0x66, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0x39, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x39, 0x18, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x39,
   0x18, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0x19, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0xa5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x66, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xbf,
   0xe7, 0x99, 0x01, 0x83, 0xff, 0xe7, 0xe7, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xf8, 0x8f, 0xc3, 0x99, 0x24, 0x39, 0xff, 0xc3, 0xc3, 0xe7, 0xe7, 0xf3,
   0xff, 0xff, 0xff, 0xff, 0xe0, 0x83, 0x81, 0x99, 0x24, 0xe3, 0xff, 0x81, 0x81,
   0xe7, 0xcf, 0xf9, 0xff, 0xff, 0xff, 0xff, 0x80, 0x80, 0xe7, 0x99, 0x21, 0xc9,
   0xff, 0xe7, 0xe7, 0xe7, 0x80, 0x80, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x83, 0xe7,
   0x99, 0x27, 0xc9, 0x81, 0x81, 0xe7, 0x81, 0xcf, 0xf9, 0xff, 0xff, 0xff, 0xff,
   0xf8, 0x8f, 0x81, 0xff, 0x27, 0xe3, 0x81, 0xc3, 0xe7, 0xc3, 0xe7, 0xf3, 0xff,
   0xff, 0xff, 0xff, 0xfe, 0xbf, 0xc3, 0x99, 0x27, 0xcc, 0x81, 0xe7, 0xe7, 0xe7,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xe1, 0xff,
   0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xc9, 0xc9,
   0xf3, 0xff, 0xe3, 0xf9, 0xe7, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff,
   0xe1, 0xc9, 0xc9, 0xc1, 0x9c, 0xc9, 0xf9, 0xf3, 0xf3, 0x99, 0xf3, 0xff, 0xff,
   0xff, 0xcf, 0xff, 0xe1, 0xc9, 0x80, 0xfc, 0xcc, 0xe3, 0xfc, 0xf9, 0xe7, 0xc3,
   0xf3, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xf3, 0xff, 0xc9, 0xe1, 0xe7, 0x91, 0xff,
   0xf9, 0xe7, 0x00, 0xc0, 0xff, 0xc0, 0xff, 0xf3, 0xff, 0xf3, 0xff, 0x80, 0xcf,
   0xf3, 0xc4, 0xff, 0xf9, 0xe7, 0xc3, 0xf3, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff,
   0xff, 0xc9, 0xe0, 0x99, 0xcc, 0xff, 0xf3, 0xf3, 0x99, 0xf3, 0xf3, 0xff, 0xf3,
   0xfc, 0xff, 0xf3, 0xff, 0xc9, 0xf3, 0x9c, 0x91, 0xff, 0xe7, 0xf9, 0xff, 0xff,
   0xf3, 0xff, 0xf3, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xc1, 0xf3, 0xe1, 0xe1, 0xc7, 0xc0,
   0xe3, 0xc0, 0xe1, 0xe1, 0xff, 0xff, 0xe7, 0xff, 0xf9, 0xe1, 0x9c, 0xf1, 0xcc,
   0xcc, 0xc3, 0xfc, 0xf9, 0xcc, 0xcc, 0xcc, 0xf3, 0xf3, 0xf3, 0xff, 0xf3, 0xcc,
   0x8c, 0xf3, 0xcf, 0xcf, 0xc9, 0xe0, 0xfc, 0xcf, 0xcc, 0xcc, 0xf3, 0xf3, 0xf9,
   0xc0, 0xe7, 0xcf, 0x84, 0xf3, 0xe3, 0xe3, 0xcc, 0xcf, 0xe0, 0xe7, 0xe1, 0xc1,
   0xff, 0xff, 0xfc, 0xff, 0xcf, 0xe7, 0x90, 0xf3, 0xf9, 0xcf, 0x80, 0xcf, 0xcc,
   0xf3, 0xcc, 0xcf, 0xff, 0xff, 0xf9, 0xff, 0xe7, 0xf3, 0x98, 0xf3, 0xcc, 0xcc,
   0xcf, 0xcc, 0xcc, 0xf3, 0xcc, 0xe7, 0xf3, 0xf3, 0xf3, 0xc0, 0xf3, 0xff, 0xc1,
   0xc0, 0xc0, 0xe1, 0x87, 0xe1, 0xe1, 0xf3, 0xe1, 0xf1, 0xf3, 0xf3, 0xe7, 0xff,
   0xf9, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xf9, 0xff, 0xff, 0xff, 0xff, 0xc1, 0xf3, 0xc0, 0xc3, 0xe0, 0x80, 0x80, 0xc3,
   0xcc, 0xe1, 0x87, 0x98, 0xf0, 0x9c, 0x9c, 0xe3, 0x9c, 0xe1, 0x99, 0x99, 0xc9,
   0xb9, 0xb9, 0x99, 0xcc, 0xf3, 0xcf, 0x99, 0xf9, 0x88, 0x98, 0xc9, 0x84, 0xcc,
   0x99, 0xfc, 0x99, 0xe9, 0xe9, 0xfc, 0xcc, 0xf3, 0xcf, 0xc9, 0xf9, 0x80, 0x90,
   0x9c, 0x84, 0xcc, 0xc1, 0xfc, 0x99, 0xe1, 0xe1, 0xfc, 0xc0, 0xf3, 0xcf, 0xe1,
   0xf9, 0x80, 0x84, 0x9c, 0x84, 0xc0, 0x99, 0xfc, 0x99, 0xe9, 0xe9, 0x8c, 0xcc,
   0xf3, 0xcc, 0xc9, 0xb9, 0x94, 0x8c, 0x9c, 0xfc, 0xcc, 0x99, 0x99, 0xc9, 0xb9,
   0xf9, 0x99, 0xcc, 0xf3, 0xcc, 0x99, 0x99, 0x9c, 0x9c, 0xc9, 0xe1, 0xcc, 0xc0,
   0xc3, 0xe0, 0x80, 0xf0, 0x83, 0xcc, 0xe1, 0xe1, 0x98, 0x80, 0x9c, 0x9c, 0xe3,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xcc, 0xcc, 0x9c, 0x9c, 0xcc,
   0x80, 0xe1, 0xfc, 0xe1, 0xf7, 0xff, 0x99, 0xcc, 0x99, 0xcc, 0xd2, 0xcc, 0xcc,
   0x9c, 0x9c, 0xcc, 0x9c, 0xf9, 0xf9, 0xe7, 0xe3, 0xff, 0x99, 0xcc, 0x99, 0xf8,
   0xf3, 0xcc, 0xcc, 0x9c, 0xc9, 0xcc, 0xce, 0xf9, 0xf3, 0xe7, 0xc9, 0xff, 0xc1,
   0xcc, 0xc1, 0xf1, 0xf3, 0xcc, 0xcc, 0x94, 0xe3, 0xe1, 0xe7, 0xf9, 0xe7, 0xe7,
   0x9c, 0xff, 0xf9, 0xc4, 0xc9, 0xc7, 0xf3, 0xcc, 0xcc, 0x80, 0xe3, 0xf3, 0xb3,
   0xf9, 0xcf, 0xe7, 0xff, 0xff, 0xf9, 0xe1, 0x99, 0xcc, 0xf3, 0xcc, 0xe1, 0x88,
   0xc9, 0xf3, 0x99, 0xf9, 0x9f, 0xe7, 0xff, 0xff, 0xf0, 0xc7, 0x98, 0xe1, 0xe1,
   0xc0, 0xf3, 0x9c, 0x9c, 0xe1, 0x80, 0xe1, 0xbf, 0xe1, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0x00, 0xf3, 0xff, 0xf8, 0xff, 0xc7, 0xff, 0xe3, 0xff, 0xf8, 0xf3, 0xcf, 0xf8,
   0xf1, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xf9, 0xff, 0xcf, 0xff, 0xc9, 0xff, 0xf9,
   0xff, 0xff, 0xf9, 0xf3, 0xff, 0xff, 0xff, 0xe7, 0xe1, 0xf9, 0xe1, 0xcf, 0xe1,
   0xf9, 0x91, 0xc9, 0xf1, 0xcf, 0x99, 0xf3, 0xcc, 0xe0, 0xe1, 0xff, 0xcf, 0xc1,
   0xcc, 0xc1, 0xcc, 0xf0, 0xcc, 0x91, 0xf3, 0xcf, 0xc9, 0xf3, 0x80, 0xcc, 0xcc,
   0xff, 0xc1, 0x99, 0xfc, 0xcc, 0xc0, 0xf9, 0xcc, 0x99, 0xf3, 0xcf, 0xe1, 0xf3,
   0x80, 0xcc, 0xcc, 0xff, 0xcc, 0x99, 0xcc, 0xcc, 0xfc, 0xf9, 0xc1, 0x99, 0xf3,
   0xcc, 0xc9, 0xf3, 0x94, 0xcc, 0xcc, 0xff, 0x91, 0xc4, 0xe1, 0x91, 0xe1, 0xf0,
   0xcf, 0x98, 0xe1, 0xcc, 0x98, 0xe1, 0x9c, 0xcc, 0xe1, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xe7, 0xf8,
   0x91, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
   0xf3, 0xe7, 0xf3, 0xc4, 0xf7, 0xc4, 0x91, 0xc4, 0xc1, 0xc1, 0xcc, 0xcc, 0x9c,
   0x9c, 0xcc, 0xc0, 0xf3, 0xe7, 0xf3, 0xff, 0xe3, 0x99, 0xcc, 0x91, 0xfc, 0xf3,
   0xcc, 0xcc, 0x94, 0xc9, 0xcc, 0xe6, 0xf8, 0xff, 0xc7, 0xff, 0xc9, 0x99, 0xcc,
   0x99, 0xe1, 0xf3, 0xcc, 0xcc, 0x80, 0xe3, 0xcc, 0xf3, 0xf3, 0xe7, 0xf3, 0xff,
   0x9c, 0xc1, 0xc1, 0xf9, 0xcf, 0xd3, 0xcc, 0xe1, 0x80, 0xc9, 0xc1, 0xd9, 0xf3,
   0xe7, 0xf3, 0xff, 0x9c, 0xf9, 0xcf, 0xf0, 0xe0, 0xe7, 0x91, 0xf3, 0xc9, 0x9c,
   0xcf, 0xc0, 0xc7, 0xe7, 0xf8, 0xff, 0x80, 0xf0, 0x87, 0xff, 0xff, 0xff, 0xff,
   0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#define CHARACTERS_PER_ROW       16 /* I like 16 x 8 fontsets. */
#define CHARACTERS_PER_COLUMN    8  /* 128 x 1 is another popular format. */

static SDL_Renderer* selected_renderer = NULL;
static SDL_Texture* inline_font = NULL;
static SDL_Texture* selected_font = NULL;
static Uint16        selected_font_w, selected_font_h;

void prepare_inline_font()
{
	Uint32* pix_ptr, tmp;
	int          i, len, j;
	SDL_Surface* surface;
	Uint32       colors[2];

	selected_font_w = inline_font_width;
	selected_font_h = inline_font_height;

	if (inline_font != NULL)
	{
		selected_font = inline_font; return;
	}

	surface = SDL_CreateRGBSurface(0, inline_font_width, inline_font_height, 32,
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
		0xff000000, 0x00ff0000, 0x0000ff00, 0x000000ff
#else
		0x000000ff, 0x0000ff00, 0x00ff0000, 0xff000000
#endif
	);
	colors[0] = SDL_MapRGBA(surface->format, 0xFF, 0xFF, 0xFF, 0xFF);
	colors[1] = SDL_MapRGBA(surface->format, 0x00, 0x00, 0x00, 0x00 /* or 0xFF, to have bg-color */);

	/* Get pointer to pixels and array length */
	pix_ptr = (Uint32*)surface->pixels;
	len = surface->h * surface->w / 8;

	/* Copy */
	for (i = 0; i < len; i++)
	{
		tmp = (Uint8)inline_font_bits[i];
		for (j = 0; j < 8; j++)
		{
			Uint8 mask = (0x01 << j);
			pix_ptr[i * 8 + j] = colors[(tmp & mask) >> j];
		}
	}

	inline_font = SDL_CreateTextureFromSurface(selected_renderer, surface);
	SDL_FreeSurface(surface);

	selected_font = inline_font;
}

void kill_inline_font(void)
{
	SDL_DestroyTexture(inline_font); inline_font = NULL;
}

void inrenderer(SDL_Renderer* renderer)
{
	selected_renderer = renderer;
}

void infont(SDL_Texture* font)
{
	Uint32 format;
	int    access;
	int    w, h;

	if (font == NULL)
	{
		prepare_inline_font(); return;
	}

	SDL_QueryTexture(font, &format, &access, &w, &h);

	selected_font = font;
	selected_font_w = w;
	selected_font_h = h;
}

void incolor1(SDL_Color* color)
{
	SDL_SetTextureColorMod(selected_font, color->r, color->g, color->b);
}

void incolor(Uint32 fore, Uint32 unused) /* Color must be in 0x00RRGGBB format ! */
{
	SDL_Color pal[1];

	pal[0].r = (Uint8)((fore & 0x00FF0000) >> 16);
	pal[0].g = (Uint8)((fore & 0x0000FF00) >> 8);
	pal[0].b = (Uint8)((fore & 0x000000FF));
	SDL_SetTextureColorMod(selected_font, pal[0].r, pal[0].g, pal[0].b);
}

void inprint(SDL_Renderer* dst, const char* str, Uint32 x, Uint32 y)
{
	SDL_Rect s_rect;
	SDL_Rect d_rect;

	if (str == NULL)
	{
		return;
	}

	d_rect.x = x;
	d_rect.y = y;
	s_rect.w = selected_font_w / CHARACTERS_PER_ROW;
	s_rect.h = selected_font_h / CHARACTERS_PER_COLUMN;
	d_rect.w = s_rect.w;
	d_rect.h = s_rect.h;

	if (dst == NULL)
	{
		dst = selected_renderer;
	}

	for (; *str; str++)
	{
		int id = (int)*str;
#if (CHARACTERS_PER_COLUMN != 1)
		int row = id / CHARACTERS_PER_ROW;
		int col = id % CHARACTERS_PER_ROW;
		s_rect.x = col * s_rect.w;
		s_rect.y = row * s_rect.h;
#else
		s_rect.x = id * s_rect.w;
		s_rect.y = 0;
#endif
		if (id == '\n')
		{
			d_rect.x = x;
			d_rect.y += s_rect.h;
			continue;
		}
		SDL_RenderCopy(dst, selected_font, &s_rect, &d_rect);
		d_rect.x += s_rect.w;
	}
}

void inprint_shadowed(SDL_Renderer* dst, const char* str, Uint32 x, Uint32 y)
{
	SDL_Color pal[1];

	SDL_GetTextureColorMod(selected_font, &pal[0].r, &pal[0].g, &pal[0].b);
	incolor(0x000000, 0);
	inprint(dst, str, x + 2, y + 2);
	SDL_SetTextureColorMod(selected_font, pal[0].r, pal[0].g, pal[0].b);
	inprint(dst, str, x, y);
}

SDL_Texture* get_inline_font(void)
{
	return selected_font;
}
