static char     operator_rcsid[] = "$Id";
/***********************************************************
 * globals.h - include file for qmon
 *
 * Version 3.3 by Jeff Snyder
 * Date: 6/24/92
 *
 * Versions 3.4 & 3.5 by Lakhamraju R. Raju
 * Date: 11/02/93
 *
 * Major modifications: Removed motif calls and replaced 
 *	               with athena widget set calls.
 *
 * Copyright 1992, 1993, 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  operator.c,v
 * Revision 1.2  1994/11/28  16:55:18  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/21  02:58:34  raju
 * *** empty log message ***
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           operator_popup;
static Widget           widget_operatorrc;
static Widget           widget_operatorlabel;
static Widget           widget_operatorframe;
static Widget           widget_operatormenu;
static Widget           widget_operatormain;
static Widget           widget_operatorexec;
static Widget           widget_operatorclear;
static Widget           widget_operatorclose;
static Widget           widget_operatorseparator;
static Widget           widget_operatoropt;

struct optionstruct operatormenu[]={
  0,"Cell         ","-cell",MENUTYPE,NULL,NULL,
  0,"Add             ","-ao",ACTIONTYPE,NULL,NULL,
  0,"Delete          ","-do",ACTIONTYPE,NULL,NULL,
  0,"Operator Name",NULL,MENUTYPE,NULL,NULL,
  0,"Show Operators  ","-so",ACTIONTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_operatorexec - Activate callback for exec
 */
XtCallbackProc pb_operatorexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  char          command[MAX_STRING_SIZE];
  
  sprintf(command,"%s -cell %s",QCONF_BINARY,current_cell);
  buildcommand(command,operatormenu,0);

}


/***********************************************************
 * pb_operatorclear - Activate callback for clear
 */
XtCallbackProc pb_operatorclear(Widget w, caddr_t client_data, caddr_t call_data)
{
   int ii;
  Arg args[5];

  QmonTextSetString(operatormenu[0].widgetid ,current_cell );
  if(operator_list) 
  	QmonTextSetString(operatormenu[3].widgetid ,operator_list->name );
/*
  clearsubmenu(operatormenu);
*/
}


/***********************************************************
 * pb_operatorclose - Activate callback for close
 */
XtCallbackProc pb_operatorclose()
{
  closesubmenuwin();
}


/***********************************************************
 * operatoraction - Activate callback for action type menu
 */
XtCallbackProc operatoraction(Widget w, caddr_t client_data, caddr_t call_data)
{
  int             ii;
  char            command[MAX_STRING_SIZE];
  char            *ptr=NULL;
  char            *ptr1=NULL;

  ptr=QmonTextGetString(operatormenu[3].widgetid);
  ptr1=QmonTextGetString(operatormenu[0].widgetid);

  if(w==operatormenu[1].widgetid) {
    sprintf(command,"%s -cell %s %s %s &",QCONF_BINARY,ptr1,operatormenu[1].flag,ptr);
  }
  else if(w==operatormenu[2].widgetid) {
    sprintf(command,"%s -cell %s %s %s &",QCONF_BINARY,ptr1,operatormenu[2].flag,ptr);
  }
  else if(w==operatormenu[4].widgetid) {
    sprintf(command,"%s -cell %s %s &",QCONF_BINARY,ptr1,operatormenu[4].flag);
  }

  execit(command);
}


/***********************************************************
 * create_operator_dialog - Create widgets used for the operator menu
 */
int create_operator_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        operator_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec,clear,close;

  operatormenu[0].list = cell_list;
  operatormenu[3].list = operator_list;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  operator_popup = XtCreatePopupShell("operatorpop", transientShellWidgetClass, w,
                             args, ii);
    ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  operator_form = XtCreateManagedWidget("form", formWidgetClass, operator_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_operatorlabel=
        XtCreateManagedWidget("Configure Operator",labelWidgetClass,operator_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_operatorlabel); ii++;
  widget_operatormain=XtCreateManagedWidget("box",formWidgetClass,operator_form,
                                        args,ii);

/*
 exec=QmonAddButtonN(widget_operatormain,NULL,"Exec",pb_operatorexec,NULL);
*/
 clear=QmonAddButtonN(widget_operatormain,NULL,"Reset",(XtCallbackProc)pb_operatorclear,NULL);
 close=QmonAddButtonN(widget_operatormain,clear,"Close",(XtCallbackProc)pb_operatorclose,NULL);

  widget_operatoropt=createmenuoptions(operator_form,widget_operatormain,operatormenu,(XtCallbackProc)operatoraction);
  
}


/***********************************************************
 * openwidget_operatorsub - Open the operator menu
 */
int openwidget_operatorsub()
{
  pb_operatorclear(NULL,NULL,NULL);
  XtPopup(operator_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_operatorsub - Close the operator menu
 */
int closewidget_operatorsub()
{
  XtPopdown(operator_popup);
}
