static char dqs_setup_rcsid[]="$Id: dqs_setup.c,v 1.7 2000/12/11 02:59:49 chuck Exp $";

/*----------------------------------------------------
 * dqs_setup.c Tom Green Mon Jan 31 10:43:04 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_setup.c,v $
 * Revision 1.7  2000/12/11 02:59:49  chuck
 * Fix for another memory leak in TID linked list.
 *
 * Revision 1.6  2000/10/01 22:56:13  chuck
 * Modified dqs_setup_qmaster to call dqs_add_job with a non-NULL pointer
 * to keep an ERROR message from being posted.
 *
 * Revision 1.5  2000/04/21 22:20:44  chuck
 * Backward compatability between 3.3.1 and 3.2.7 only.
 *
 * Revision 1.4  2000/03/09 04:15:45  chuck
 * dqs_setup_qmaster() was reading Unitialized memory when in debug
 * mode.  A debug statement was being printed before the list element
 * used by the debug statement was allocated.
 *
 * dqs_setup_dqs_execd() failed to insure that a 2K string pointer was
 * not already assinged before overwriting it with a new address.
 *
 * Revision 1.3  1999/05/20 18:35:31  green
 * added support for REAPED_ON_RESTART and DEFAULT_RESTART
 *
 * Revision 1.2  1999/05/12 14:14:17  green
 * added support for per job cpu hard/soft max parameters
 *
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.32  1997/03/20 19:12:36  nrl
 * inserted a test for zero me.ngroups to prevent a
 * dqs_execd crash during bootup.
 *
 * Revision 3.31  1996/11/20 23:04:26  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.30  1996/06/27  01:56:05  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.29  1996/06/26  14:03:33  nrl
 * Added pvmcleanup.sh to install.. added osf2.3 detection
 *
 * Revision 3.28  1996/03/22  04:21:22  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.27  1996/03/14  03:16:36  nrl
 * merge in subordinate queues and consumable resource changes
 *
 * Revision 3.26  1996/03/12  17:12:37  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.25  1996/01/19  23:37:48  nrl
 * Fixed bootup failure of dqs_exec/qmaster startup on AIX machines.
 * Courtesy of Peter Buchenau.
 *
 * Revision 3.23  1995/07/12  20:13:17  nrl
 * changed direct calls to getpgrp to macro GETPGRP
 *
 * Revision 3.22  1995/06/21  16:57:55  nrl
 * Major scheduling changes... added a subpriority field to manage
 * things within the user submitted priority. Added priority info to the
 * accounting file.
 *
 * Revision 3.21  1995/05/29  18:08:56  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.20  1995/02/23  23:14:01  nrl
 * Cleaned up some dangling pointers which were causing memory
 * corruption.
 *
 * Revision 3.19  1995/02/22  14:29:40  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.18  1995/02/16  20:34:28  nrl
 * Force cleared job structure to prevent garbage from fouling things up.
 * Added SIGCHLD to iomask to keep "mailer" from messing up
 * socket transfers.
 *
 * Revision 3.17  1995/02/15  23:24:00  nrl
 * The primary name used for hostname in all handshaking and
 * in the hostshash and queue stuff is now the "official"
 * name delivered by gethostbyname. This should eliminate name
 * confusion between queues and hosts reporting in
 *
 * Revision 3.16  1995/02/09  12:49:19  nrl
 * Added "delete complex" and "modify complex"
 *
 * Revision 3.15  1995/02/01  23:17:46  nrl
 * Tidied up and hopefully bulletproofed "tid" management. Reversed
 * tid file naming to sort by time.
 *
 * Revision 3.14  1995/01/27  14:09:56  nrl
 * Changed Supspend on completion to continue beyond an unsuspend operation
 * so that jobs can be "stepped" thru the queues. Increased timout
 * retries for connect to make the system more tolerant of network delyas.
 *
 * Revision 3.13  1995/01/24  21:05:06  nrl
 * made changes to plug memory leaks and to complete the suspend
 * on completion function.
 *
 * Revision 3.12  1994/06/24  21:15:24  green
 * more life with Solaris...
 *
 * Revision 3.11  1994/06/15  12:49:08  green
 * fixed line 973 which the ULTRIX compiler couldn't seem to dijest
 *
 * Revision 3.10  1994/06/13  21:49:37  green
 * disallow if someone defines DEFAULT_HOST as "NONE"
 *
 * Revision 3.9  1994/06/12  23:36:44  green
 * added "setup()" for dsh
 *
 * Revision 3.8  1994/06/12  04:45:39  green
 * yanked conf.dqs_dshd_service
 *
 * Revision 3.7  1994/06/05  16:53:54  green
 * added DQS_DSHD_SERVICE and dqs_dshd_service to required support files
 *
 * forced a SIGQUIT to children on death of parent(eg: "master") in
 * dqs_sig_handlers.c
 *
 * Revision 3.6  1994/06/04  17:45:06  green
 * fixed bug in "qconf -dh host_list"
 *
 * added additional error logging
 *
 * Revision 3.5  1994/06/03  00:25:51  green
 * replaced "DQSX_STR12" with "master_queue_exec_str" in support of MPI
 * mods
 *
 * Revision 3.4  1994/05/31  00:52:41  green
 * added dsh.c dshd.c to Makefile.proto
 *
 * added MAXNAMELEN and NCARGS to def.h
 *
 * type casting in dqs_reauth.c, dqs_sec.c, dqs_setup.c to hush gcc
 * warnings
 *
 * added jmp_buf to globals.h, changed Revision number in globals.h
 *
 * added dsh and dshd tp prognames.h
 *
 * Revision 3.3  1994/03/26  16:33:36  green
 * added "-srl" support.
 *
 * dqs_resolve.c:dqs_read_resolve_file() now returns the primary qmaster
 * name for fields marked as "none"
 *
 * Revision 3.2  1994/03/26  15:29:17  green
 * allowed for "qconf -sq [dest_id_list]" vs "qconf -sq dest_id_list"
 *
 * write generic queue configuration in common_dir
 *
 * Revision 3.1  1994/03/22  21:49:28  green
 * added dqs_get_cwd() to dqs_resolve.c<this is a temporary fix>
 *
 * minor DPRINTF(()) format change in dqs_setup.c
 *
 * Revision 3.0  1994/03/07  04:14:35  green
 * 3.0 freeze
 *
 * Revision 1.13  1994/03/05  20:20:10  green
 * had a DEFAULT_MANAGER2 where a DEFAULT_MANAGER should have been
 *
 * Revision 1.12  1994/03/04  16:04:37  green
 * all calls to setenv() now funnel through dqs_setenv() to verify they
 * are strlen() < MAX_STRING_SIZE
 *
 * Revision 1.11  1994/03/01  19:23:39  green
 * removed "test" from the default dependancy list in Makefile.proto.
 *
 * changed dqs_show_all_cofigurations() to dqs_show_all_configurations()
 * in dqs_execd.c, qmaster.c and dqs_utility.c.
 *
 * fixed the broken comment exclusion feature in dqs_resolve.c.
 *
 * fixed bug in me.default_cell in dqs_setup.c where conf_file
 * default_cell was not updating me.default_cell.
 *
 * getenv(DQS_CELL) mved out of dqs_getme() into dqs_setup()
 * to allow dqs_getme() to be called on forks.
 *
 * remade func.h.
 *
 * pulled garbage out of test.c.
 *
 * added syntax instructions to resolve_file
 *
 * Revision 1.10  1994/02/28  20:06:51  green
 * added DEFAULT_HOST to dqs.h to take care of gw'ed machines.
 *
 * added DEFAULT_HOST to dqs_setup.c to take care of gw'ed machines.
 *
 * Revision 1.9  1994/02/28  15:57:29  green
 * forgot to check credentials on some "qconf" options - fixed
 *
 * had hard coded "ibm11.scri.fsu.edu" and "localhost" into dqs_setup.c - removed
 *
 * Revision 1.8  1994/02/28  03:03:07  green
 * added DEFAULT_MANAGER(2) to allow installs without root access.
 *
 * special character in def MAINPROGRAM causing some compilers to choke -
 * removed.
 *
 * Revision 1.7  1994/02/25  23:13:22  green
 * added "PID_FILE" to def.h to log process id.
 *
 * modified dqs_execd.c and qmaster.c to log pids to a file
 *
 * added dqs_log_pid() to dqs_utility.c
 *
 * remade func.h
 *
 * forced insertion of "green" into Man_head  -- this needs to be removed
 * and a def in dqs.h if running as non-root.
 *
 * Revision 1.6  1994/02/24  18:11:29  green
 * added dqs_show_all_cofigurations() to dqs_execd.c an qmaster.c
 *
 * modified dqs_execd.c and dqs_load_avg.c to use me.default_cell rather than
 * conf.default_cell
 *
 * previous message about errant pointer reference was incorrect.
 * dqs_sig_handlers.c put back like it was previously
 *
 * there was however a point problem with dusage->master in dqs_setup.c.
 *
 * added dqs_show_all_cofigurations() to dqs_utility.c
 *
 * remade func.h
 *
 * activated the "-cell cell_name" option for dqs_execd in globals.h
 *
 * changed fscanf() to fgets() in qsub.c to fix problems on SV machines
 * and to avoid byte-stuffing problems.
 *
 * Revision 1.5  1994/02/24  14:29:21  green
 * added code to nuke jobs at machine reboot
 *
 * still need to ad "restart" code
 *
 * patched a potential memory reference bug in dqs_sig_handlers.c
 *
 * Revision 1.4  1994/02/17  17:38:22  green
 * moved dqs_daemonize() out of dqs_setup_dqs_execd() and dqs_setup_qmaster()
 * and into dqs_execd.c and qmaster.c respectively to allow the "-passwd"
 * and "-verify" options to function properly.
 *
 * Revision 1.3  1994/02/09  19:48:15  green
 * syncing source with docs
 *
 * Revision 1.2  1994/02/02  20:22:19  green
 * cleaned up "qconf.c" to sync with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:47  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/*******************************************************************/
void dqs_mini_setup(prog_name)
     char *prog_name;
     
{
  struct hostent *hent;     
  bzero((char *)&me,sizeof(me));
  
  me.dqs_formal_prog_name=(char *)malloc(MAX_STRING_SIZE);
  if (!me.dqs_formal_prog_name)
    {
      perror("malloc() failure");
      exit(-1);
    }
  strcpy(me.dqs_formal_prog_name,prog_name);
  
  me.qualified_prog_name=(char *)malloc(MAX_STRING_SIZE);
  if (!me.qualified_prog_name)
    {
      perror("malloc() failure");
      exit(-1);
    }
  strcpy(me.qualified_prog_name,prog_name);
  
  me.unqualified_prog_name=(char *)malloc(MAX_STRING_SIZE);
  if (!me.unqualified_prog_name)
    {
      perror("malloc() failure");
      exit(-1);
    }
  strcpy(me.unqualified_prog_name,prog_name);
  
  
  me.unqualified_hostname=(char *)malloc(MAX_STRING_SIZE);
  if (!me.unqualified_hostname)
    {
      perror("malloc() failure");
      exit(-1);
    }
  if (gethostname(me.unqualified_hostname,MAX_STRING_SIZE))
    {
      perror("malloc() failure");
      exit(-1);
    }
  
  hent= gethostbyname(me.unqualified_hostname);  /*  may be an alias */
  
  if(!hent){
    perror(" host name error ");
    exit(-1);
  }
  
  me.qualified_hostname=(char *)malloc(MAX_STRING_SIZE);
  if (!me.qualified_hostname)
    {
      perror("malloc() failure");
      exit(-1);
    }
  strcpy(me.qualified_hostname,hent->h_name);    /* official name */
  
  return;
  
}

/*******************************************************************/
void dqs_setup(dqs_formal_prog_name,qualified_prog_name)
     u_long32 dqs_formal_prog_name;
     char *qualified_prog_name;
     
{
  
  char          *cp;
  struct passwd *paswd;
  
  DENTER((DQS_EVENT,"dqs_setup"));
  
  dqs_getme(dqs_formal_prog_name,qualified_prog_name);
  
  dqs_set_defined_defaults();
  
  dqs_read_in_conf_file();
  
  me.default_cell=dqs_string_insert(me.default_cell,conf.default_cell);
  cp=dqs_getenv("DQS_CELL");
  if (cp) 
    me.default_cell=dqs_string_insert(me.default_cell,cp);
  
  dqs_show_conf(); /* side effect of validation */
  
  dqs_read_resolve_file();
  
  DPRINTF((DQS_EVENT,"***Resolver_head======================"));
  dqs_showlist(Resolver_head,DQS_DEBUG|DQS_STR0|DQS_STR1|DQS_STR2|DQS_STR3|DQS_CHAIN,8);
  
  if (dqs_formal_prog_name==QMASTER)
    hash_bucket_size=QMASTER_HASH_BUCKET_SIZE;
  else
    hash_bucket_size=HASH_BUCKET_SIZE;
  
  if (dqs_formal_prog_name==QMASTER) 
    dqs_setup_qmaster();       
  
  if (dqs_formal_prog_name==DQS_EXECD)
    dqs_setup_dqs_execd();
  
  DEXIT;
  return;
  
}

/*******************************************************************/
void dqs_getme(dqs_formal_prog_name,qualified_prog_name)
     u_long32  dqs_formal_prog_name;
     char *qualified_prog_name;
     
{
  
  char          *cp;
  string        tmp_str;
  struct passwd *paswd;
  struct hostent *hent;
  
  DENTER((DQS_EVENT,"dqs_getme"));
  
  me.daemonized=FALSE;
  
  /* get program info */
  me.who=dqs_formal_prog_name;
  me.dqs_formal_prog_name=dqs_string_insert(me.dqs_formal_prog_name,prognames[me.who]);
  
  DQS_ASSERT((strlen(qualified_prog_name)<MAX_STRING_SIZE));
  me.qualified_prog_name=dqs_string_insert(me.qualified_prog_name,qualified_prog_name);
  me.unqualified_prog_name=dqs_dequalify_path(me.unqualified_prog_name,qualified_prog_name);
  
  /* Fetch hostnames */
  DQS_ASSERT((gethostname(tmp_str,sizeof(tmp_str))==0));
  DQS_ASSERT(((hent=gethostbyname(tmp_str))!=NULL));
  
  me.qualified_hostname=dqs_string_insert(me.qualified_hostname,hent->h_name);
  me.unqualified_hostname=dqs_dequalify_hostname(me.unqualified_hostname,me.qualified_hostname);
  
  /* get user/process info */
  DQS_ASSERT(((me.pid=getpid())>0));
  DQS_ASSERT(((me.ppid=getppid())>=0));
  if (me.who!=DSH)
    {
      SETPGRP;
    }
  DQS_ASSERT(((me.pgrp=GETPGRP)>=0));
  DQS_ASSERT(((me.uid=getuid())>=0));
  DQS_ASSERT(((me.euid=geteuid())>=0));
  DQS_ASSERT(((me.gid=getgid())>=0));
  DQS_ASSERT(((me.egid=getegid())>=0));
  
#if NGROUPS_MAX < 1
  DPRINTF((DQS_EVENT,"supplementary group IDs are not supported"));
  me.ngroups=0;
  me.grpptr=NULL;
#else
#ifdef __GNUC__
  DQS_ASSERT(((me.ngroups=getgroups(0,NULL))!=-1));
  if(!me.ngroups) {
    DQS_ASSERT(((me.grpptr=(void *)calloc(1,sizeof(gid_t)))!=NULL));
  }
  else{
    DQS_ASSERT(((me.grpptr=(void *)calloc(me.ngroups,sizeof(gid_t)))!=NULL));
  }         
  DQS_ASSERT((getgroups(me.ngroups,(void *)me.grpptr)!=-1));
#else
  DQS_ASSERT(((me.ngroups=getgroups(0,(void *) NULL))!=-1));
  if(!me.ngroups) {
    DQS_ASSERT(((me.grpptr=(void *)calloc(1,sizeof(gid_t)))!=NULL));
  }
  else{
    DQS_ASSERT(((me.grpptr=(void *)calloc(me.ngroups,sizeof(gid_t)))!=NULL));
  }         
  DQS_ASSERT((getgroups(me.ngroups,(void *)me.grpptr)!=-1));
#endif
#endif
  
  DQS_ASSERT(((paswd=(struct passwd *)getpwuid(me.uid))!=NULL));
  me.user_name=dqs_string_insert(me.user_name,paswd->pw_name);
  if (!me.default_cell)
    me.default_cell=dqs_string_insert( (char *)NULL,DEFAULT_CELL);
  
  /* Note: get $DEFAULT_CELL env in dqs_setup() as dqs_getme() could be called again... */
  
  cp=dqs_getenv("EDITOR");
  if (cp) 
    {
      me.default_editor=dqs_string_insert(me.default_editor,cp);
    }
  else 
    {
      me.default_editor=dqs_string_insert(me.default_editor,DEFAULT_EDITOR);
    }
  
  /* Get system-specific data */
#ifdef POSIX
  me.arg_max       = sysconf (_SC_ARG_MAX);
  me.child_max     = sysconf (_SC_CHILD_MAX);
  me.clock_tick    = sysconf (_SC_CLK_TCK);
  me.job_control   = sysconf (_SC_JOB_CONTROL);
  me.ngroup_max    = sysconf (_SC_NGROUPS_MAX);
  me.open_max      = sysconf (_SC_OPEN_MAX);
  me.saved_ids     = sysconf (_SC_SAVED_IDS);
  me.posix_version = sysconf (_SC_VERSION);
#endif     
  
  me.clock_tick    = sysconf (_SC_CLK_TCK);
  if (!me.clock_tick)
    me.clock_tick = 1;

  dqs_show_me();
  
  DEXIT;
  return;
  
}

/*******************************************************************/
void dqs_show_me()
     
{
  
  int    i;
  gid_t  gid;
  gid_t  *grpptr;
  
  DENTER((DQS_EVENT,"dqs_show_me"));
  
  DQS_ASSERT((me.who));
  DPRINTF((DQS_EVENT,"me.who\t\t\t\t>%d<",me.who));
  
  DQS_ASSERT((me.dqs_formal_prog_name));
  DPRINTF((DQS_EVENT,"me.dqs_formal_prog_name\t\t>%s<",me.dqs_formal_prog_name));
  
  DQS_ASSERT((me.qualified_prog_name));
  DPRINTF((DQS_EVENT,"me.qualified_prog_name\t\t>%s<",me.qualified_prog_name));
  
  DQS_ASSERT((me.unqualified_prog_name));
  DPRINTF((DQS_EVENT,"me.unqualified_prog_name\t\t>%s<",me.unqualified_prog_name));
  
  DQS_ASSERT((me.qualified_hostname));
  DPRINTF((DQS_EVENT,"me.qualified_hostname\t\t>%s<",me.qualified_hostname));
  
  DQS_ASSERT((me.unqualified_hostname));
  DPRINTF((DQS_EVENT,"me.unqualified_hostname\t\t>%s<",me.unqualified_hostname));
  
  DPRINTF((DQS_EVENT,"me.pid\t\t\t\t>%d<",me.pid));
  DPRINTF((DQS_EVENT,"me.ppid\t\t\t\t>%d<",me.ppid));
  DPRINTF((DQS_EVENT,"me.pgrp\t\t\t\t>%d<",me.pgrp));
  DPRINTF((DQS_EVENT,"me.uid\t\t\t\t>%d<",me.uid));
  DPRINTF((DQS_EVENT,"me.euid\t\t\t\t>%d<",me.euid));
  DPRINTF((DQS_EVENT,"me.gid\t\t\t\t>%d<",me.gid));
  
#if NGROUPS_MAX < 1
  DPRINTF((DQS_EVENT,"supplementary group IDs are not supported"));
#else
  grpptr=(gid_t *)me.grpptr;
  for (i=1;i<=me.ngroups;i++) {
    gid = *grpptr++;
    dqs_print_group(gid);
  }
#endif
  
  DPRINTF((DQS_EVENT,"me.ngroups\t\t\t>%d<",me.ngroups));
  DPRINTF((DQS_EVENT,"me.daemonized\t\t\t>%d<",me.daemonized));
  
  
  DQS_ASSERT((me.user_name));
  DPRINTF((DQS_EVENT,"me.user_name\t\t\t>%s<",me.user_name));
  
  DPRINTF((DQS_EVENT,"me.default_cell\t\t\t>%s<",me.default_cell));
  
  DPRINTF((DQS_EVENT,"me.arg_max\t\t\t>%u<",me.arg_max)); 
  DPRINTF((DQS_EVENT,"me.child_max\t\t\t>%u<",me.child_max));
  DPRINTF((DQS_EVENT,"me.clock_tick\t\t\t>%u<",me.clock_tick));
  DPRINTF((DQS_EVENT,"me.job_control\t\t\t>%u<",me.job_control));
  DPRINTF((DQS_EVENT,"me.ngroup_max\t\t\t>%u<",me.ngroup_max));
  DPRINTF((DQS_EVENT,"me.open_max\t\t\t>%u<",me.open_max));
  DPRINTF((DQS_EVENT,"me.saved_ids\t\t\t>%u<",me.saved_ids));
  DPRINTF((DQS_EVENT,"me.posix_version\t\t\t>%u<",me.posix_version));
  DPRINTF((DQS_EVENT,"me.pid_max\t\t\t>%u<",me.pid_max));
  DPRINTF((DQS_EVENT,"me.uid_max\t\t\t>%u<",me.uid_max));
  
  DEXIT;
  
}

/*******************************************************************/
void dqs_set_defined_defaults()
     
{
  
  DENTER_EXT((DQS_EVENT,"dqs_set_defined_defaults"));
  
  conf.qmaster_spool_dir=dqs_string_insert(conf.qmaster_spool_dir,QMASTER_SPOOL_DIR);
  conf.execd_spool_dir=dqs_string_insert(conf.execd_spool_dir,EXECD_SPOOL_DIR);
  conf.default_cell=dqs_string_insert(conf.default_cell,DEFAULT_CELL);
  conf.reserved_port=RESERVED_PORT;
  conf.qmaster_service=dqs_string_insert(conf.qmaster_service,QMASTER_SERVICE);
  conf.dqs_execd_service=dqs_string_insert(conf.dqs_execd_service,DQS_EXECD_SERVICE);
  conf.intercell_service=dqs_string_insert(conf.intercell_service,INTERCELL_SERVICE);
  conf.klog=dqs_string_insert(conf.klog,KLOG);
  conf.reauth_time=REAUTH_TIME;
  conf.mailer=dqs_string_insert(conf.mailer,MAILER);
  conf.dqs_bin=dqs_string_insert(conf.dqs_bin,DQS_BIN);
  conf.administrator=dqs_string_insert(conf.administrator,ADMINISTRATOR);
  conf.default_account=dqs_string_insert(conf.default_account,DEFAULT_ACCOUNT);
  conf.min_gid=MIN_GID;
  conf.min_uid=MIN_UID;
  conf.maxujobs=MAXUJOBS;
  conf.output_handling= LEAVE_OUTPUT_FILES;
  conf.addon_script= NULL;
  conf.addon_info= NULL;
  conf.user_access=USER_ACCESS;
  conf.default_rerun=DEFAULT_RERUN;
  conf.sort_seq_no=DEFAULT_SORT_SEQ_NO;
  conf.sync_io=SYNC_IO;
  conf.loglevel=LOGLEVEL;
  conf.logfacility=LOGFACILITY;
  conf.load_log_time=  LOAD_LOG_TIME;
  conf.stat_log_time=STAT_LOG_TIME;
  conf.schedule_time=SCHEDULE_TIME;
  conf.max_unheard=MAX_UNHEARD;
  conf.logmail=LOGMAIL;
  conf.alarms=ALARMS;
  conf.alarmm=ALARMM;
  conf.alarml=ALARML;
  
  DEXIT;
  return;
  
}

/*******************************************************************/
void dqs_show_conf()
     
{
  DENTER((DQS_EVENT,"dqs_show_conf"));
  
  DQS_ASSERT((conf.qmaster_spool_dir));
  DPRINTF((DQS_EVENT,"conf.qmaster_spool_dir                 >%s<",conf.qmaster_spool_dir));
  
  DQS_ASSERT((conf.execd_spool_dir));
  DPRINTF((DQS_EVENT,"conf.execd_spool_dir           >%s<",conf.execd_spool_dir));
  
  DQS_ASSERT((conf.default_cell));
  DPRINTF((DQS_EVENT,"conf.default_cell              >%s<",conf.default_cell));
  
  DPRINTF((DQS_EVENT,"conf.reserved_port     >%s<",true_false[conf.reserved_port]));
  
  DQS_ASSERT((conf.qmaster_service));
  DPRINTF((DQS_EVENT,"conf.qmaster_service           >%s<",conf.qmaster_service));
  
  DQS_ASSERT((conf.dqs_execd_service));
  DPRINTF((DQS_EVENT,"conf.dqs_execd_service         >%s<",conf.dqs_execd_service));
  
  DQS_ASSERT((conf.intercell_service));
  DPRINTF((DQS_EVENT,"conf.intercell_service         >%s<",conf.intercell_service));
  
  DQS_ASSERT((conf.klog));
  DPRINTF((DQS_EVENT,"conf.klog           >%s<",conf.klog));
  
  DPRINTF((DQS_EVENT,"conf.reauth_time         >%d<",conf.reauth_time));
  
  DQS_ASSERT((conf.mailer));
  DPRINTF((DQS_EVENT,"conf.mailer                    >%s<",conf.mailer));
  
  DQS_ASSERT((conf.dqs_bin));
  DPRINTF((DQS_EVENT,"conf.dqs_bin                   >%s<",conf.dqs_bin));
  
  DQS_ASSERT((conf.administrator));
  DPRINTF((DQS_EVENT,"conf.administrator             >%s<",conf.administrator));
  
  DQS_ASSERT((conf.default_account));
  DPRINTF((DQS_EVENT,"conf.default_account           >%s<",conf.default_account));
  
  DPRINTF((DQS_EVENT,"conf.min_gid                   >%u<",conf.min_gid));
  DPRINTF((DQS_EVENT,"conf.min_uid                   >%u<",conf.min_uid));
  DPRINTF((DQS_EVENT,"conf.maxujobs                  >%u<",conf.maxujobs));
  DPRINTF((DQS_EVENT,"conf.output_handling           >%u<",conf.output_handling));
  DPRINTF((DQS_EVENT,"conf.user_access\t             >%u<",conf.user_access));
  DPRINTF((DQS_EVENT,"conf.default_rerun             >%u<",conf.default_rerun));
  DPRINTF((DQS_EVENT,"conf.sort_seq_no               >%u<",conf.sort_seq_no));
  DPRINTF((DQS_EVENT,"conf.sync_io                   >%u<",conf.sync_io));
  DPRINTF((DQS_EVENT,"conf.loglevel                  >%u<",conf.loglevel));
  DPRINTF((DQS_EVENT,"conf.logfacility\t             >%u<",conf.logfacility));
  DPRINTF((DQS_EVENT,"conf.load_log_time             >%u<",conf.load_log_time));
  DPRINTF((DQS_EVENT,"conf.stat_log_time             >%u<",conf.stat_log_time));
  DPRINTF((DQS_EVENT,"conf.schedule_time             >%u<",conf.schedule_time));
  DPRINTF((DQS_EVENT,"conf.max_unheard\t             >%u<",conf.max_unheard));
  DPRINTF((DQS_EVENT,"conf.logmail                   >%u<",conf.logmail));
  DPRINTF((DQS_EVENT,"conf.alarms                    >%u<",conf.alarms));
  DPRINTF((DQS_EVENT,"conf.alarmm                    >%u<",conf.alarmm));
  DPRINTF((DQS_EVENT,"conf.alarml                    >%u<",conf.alarml));
  
  DEXIT;
  return;
  
}

/*******************************************************************/
void dqs_read_in_conf_file()
     
{
  
  FILE   *fp;
  int    status;
  string descriptor;
  string value;
  string err_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_read_in_conf_file"));
  
  if (STATIC_CONFIGURATION) {
    DPRINTF((DQS_EVENT,"STATIC_CONFIGURATION - do not attempt to read CONF_FILE"));
    DEXIT;
    return;
  }
  
  fp=fopen(CONF_FILE,"r");
  
  if (!fp) {
    DPRINTF((DQS_EVENT,"%s not found - creating",CONF_FILE));
    dqs_write_conf_file(FALSE,&conf);
    /* just for the hell of it we will go ahead and read it */
    /* JIC */
  }
  
  if (!fp)
    fp=fopen(CONF_FILE,"r");
  
  if (!fp) {
    /* if we can't read it now - we are in trouble */
    CRITICAL((DQS_EVENT,"DQS_ERROR_0472 %s could not be opened for reading",CONF_FILE));
    abort();
  }
  
  for (;;) {
    status=dqs_fgetstring(fp,descriptor,sizeof(descriptor));
    if (status==EOF)
      break;
    status=dqs_fgetstring(fp,value,sizeof(value));
    if (status==EOF) {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0473 an error has been detected in the configuration file >%s<",CONF_FILE));
      abort();
    }
    dqs_update_qconf(descriptor,value);
  }
  
  fclose(fp);
  
  DEXIT;
  return;
  
}

/************************************************************************************/
void dqs_update_qconf(descriptor,value)
     char *descriptor;
     char *value;
     
{
  
  DENTER_EXT((DQS_EVENT,"dqs_update_qconf"));
  
  if (!dqs_strcasecmp("qmaster_spool_dir",descriptor)) 
    conf.qmaster_spool_dir=dqs_string_insert(conf.qmaster_spool_dir,value);
  else if (!dqs_strcasecmp("execd_spool_dir",descriptor)) 
    conf.execd_spool_dir=dqs_string_insert(conf.execd_spool_dir,value);
  else if (!dqs_strcasecmp("default_cell",descriptor)) 
    conf.default_cell=dqs_string_insert(conf.default_cell,value);
  else if (!dqs_strcasecmp("qmaster_service",descriptor))
    conf.qmaster_service=dqs_string_insert(conf.qmaster_service,value);
  else if (!dqs_strcasecmp("dqs_execd_service",descriptor))
    conf.dqs_execd_service=dqs_string_insert(conf.dqs_execd_service,value);
  else if (!dqs_strcasecmp("intercell_service",descriptor))
    conf.intercell_service=dqs_string_insert(conf.intercell_service,value);
  else if (!dqs_strcasecmp("klog",descriptor))
    conf.klog=dqs_string_insert(conf.klog,value);
  else if (!dqs_strcasecmp("mailer",descriptor)) 
    conf.mailer=dqs_string_insert(conf.mailer,value);
  else if (!dqs_strcasecmp("dqs_bin",descriptor))
    conf.dqs_bin=dqs_string_insert(conf.dqs_bin,value);
  else if (!dqs_strcasecmp("administrator",descriptor))
    conf.administrator=dqs_string_insert(conf.administrator,value);
  else if (!dqs_strcasecmp("default_account",descriptor))
    conf.default_account=dqs_string_insert(conf.default_account,value);
  else if (!dqs_strcasecmp("logmail",descriptor)) {
    if (!dqs_strcasecmp("true",value))
      conf.logmail=TRUE;
    else if (!dqs_strcasecmp("false",value))
      conf.logmail=FALSE;
    else {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0474 invalid configuration line \"%s\t\t%s",descriptor,value));
      DEXITE;
      abort();
    }
  }
  else if (!dqs_strcasecmp("default_rerun",descriptor)) {
    if (!dqs_strcasecmp("true",value))
      conf.default_rerun=TRUE;
    else if (!dqs_strcasecmp("false",value))
      conf.default_rerun=FALSE;
    else {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0475 invalid configuration line \"%s\t\t%s",descriptor,value));
      DEXITE;
      abort();
    }
  }
  else if (!dqs_strcasecmp("default_sort_seq_no",descriptor)) {
    if (!dqs_strcasecmp("true",value))
      conf.sort_seq_no=TRUE;
    else if (!dqs_strcasecmp("false",value))
      conf.sort_seq_no=FALSE;
    else {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0476 invalid configuration line \"%s\t\t%s",descriptor,value));
      DEXITE;
      abort();
    }
  }
  else if (!dqs_strcasecmp("sync_io",descriptor)) {
    if (!dqs_strcasecmp("true",value))
      conf.sync_io=TRUE;
    else if (!dqs_strcasecmp("false",value))
      conf.sync_io=FALSE;
    else {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0477 invalid configuration line \"%s\t\t%s",descriptor,value));
      DEXITE;
      abort();
    }
  }
  else if (!dqs_strcasecmp("reserved_port",descriptor)) {
    if (!dqs_strcasecmp("true",value))
      conf.reserved_port=TRUE;
    else if (!dqs_strcasecmp("false",value))
      conf.reserved_port=FALSE;
    else {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0478 invalid configuration line \"%s\t\t%s",descriptor,value));
      DEXITE;
      abort();
    }
  }
  else if (!dqs_strcasecmp("user_access",descriptor)) {
    if (!dqs_strcasecmp("access_free",value))
      conf.user_access=ACCESS_FREE;
    else if (!dqs_strcasecmp("access_open",value))
      conf.user_access=ACCESS_OPEN;
    else if (!dqs_strcasecmp("access_restricted",value))
      conf.user_access=ACCESS_RESTRICTED;
    else {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0479 invalid configuration line \"%s\t\t%s",descriptor,value));
      DEXITE;
      abort();
    }
  }
  else if (!dqs_strcasecmp("logfacility",descriptor)) {
    if (!dqs_strcasecmp("log_via_syslog",value))
      conf.logfacility=LOG_VIA_SYSLOG;
    else if (!dqs_strcasecmp("log_via_file",value))
      conf.logfacility=LOG_VIA_FILE;
    else if (!dqs_strcasecmp("log_via_combo",value))
      conf.logfacility=LOG_VIA_COMBO;
    else {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0480 invalid configuration line \"%s\t\t%s",descriptor,value));
      DEXITE;
      abort();
    }
  }
  else if (!dqs_strcasecmp("loglevel",descriptor)) {
    if (!dqs_strcasecmp("LOG_CRIT",value))
      conf.loglevel=LOG_CRIT;
    else if (!dqs_strcasecmp("LOG_ERR",value))
      conf.loglevel=LOG_ERR;
    else if (!dqs_strcasecmp("LOG_WARNING",value))
      conf.loglevel=LOG_WARNING;
    else if (!dqs_strcasecmp("LOG_NOTICE",value))
      conf.loglevel=LOG_NOTICE;
    else if (!dqs_strcasecmp("LOG_INFO",value))
      conf.loglevel=LOG_INFO;
    else if (!dqs_strcasecmp("LOG_DEBUG",value))
      conf.loglevel=LOG_DEBUG;
    else if (!dqs_strcasecmp("LOG_EXTDEBUG",value))
      conf.loglevel=LOG_EXTDEBUG;
    else {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0481 invalid configuration line \"%s\t\t%s",descriptor,value));
      DEXITE;
      abort();
    }
  }
  else if (!dqs_strcasecmp("min_gid",descriptor)) 
    conf.min_gid=dqs_atoi(value);
  else if (!dqs_strcasecmp("min_uid",descriptor))
    conf.min_uid=dqs_atoi(value);
  else if (!dqs_strcasecmp("maxujobs",descriptor))
    conf.maxujobs=dqs_atoi(value);
  else if (!dqs_strcasecmp("output_handling",descriptor)){
    if (!dqs_strcasecmp("link_output_files",value))
      conf.output_handling=LINK_OUTPUT_FILES;
    else if (!dqs_strcasecmp("copy_output_files",value))
      conf.output_handling=COPY_OUTPUT_FILES;
    else {
      conf.output_handling= LEAVE_OUTPUT_FILES;
    }
    
  }
  else if (!dqs_strcasecmp("addon_script",descriptor)){
    if (!dqs_strcasecmp("NONE",value))
      conf.addon_script= NULL;
    else  conf.addon_script=dqs_string_insert(conf.addon_script,value);
  }
  else if (!dqs_strcasecmp("addon_info",descriptor)){
    if (!dqs_strcasecmp("none",value))
      conf.addon_info= NULL;
    else  conf.addon_info=dqs_string_insert(conf.addon_info,value);
  }
  else if (!dqs_strcasecmp("load_log_time",descriptor))
    conf.load_log_time=dqs_atoi(value);
  else if (!dqs_strcasecmp("schedule_time",descriptor))
    conf.schedule_time=dqs_atoi(value);
  else if (!dqs_strcasecmp("stat_log_time",descriptor))
    conf.stat_log_time=dqs_atoi(value);
  else if (!dqs_strcasecmp("max_unheard",descriptor))
    conf.max_unheard=dqs_atoi(value);
  else if (!dqs_strcasecmp("alarms",descriptor))
    conf.alarms=dqs_atoi(value);
  else if (!dqs_strcasecmp("alarmm",descriptor))
    conf.alarmm=dqs_atoi(value);
  else if (!dqs_strcasecmp("alarml",descriptor))
    conf.alarml=dqs_atoi(value);
  else if (!dqs_strcasecmp("reauth_time",descriptor))
    conf.reauth_time=dqs_atoi(value);
  else {
    CRITICAL((DQS_EVENT,"DQS_ERROR_0482 unknown descriptor \"%s\" in conf_file",descriptor));
    DEXITE;
    abort();
  }
  
  DEXIT;
  return;
  
}

/*******************************************************************/
void dqs_write_conf_file(write_2_stdout,mconf)
     int           write_2_stdout;
     dqs_conf_type *mconf;
     
{
  
  FILE   *fp;
  int    status;
  string descriptor;
  string value;
  string err_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_write_conf_file"));
  
  if (write_2_stdout)
    {
      fp=stdout;
    }
  else
    {
      if (STATIC_CONFIGURATION) {
	DPRINTF((DQS_EVENT,"STATIC_CONFIGURATION - do not attempt to write CONF_FILE"));
	DEXIT;
	return;
      }
      
      close(creat(CONF_FILE,0644));
      
      fp=fopen(CONF_FILE,"w");
      
      if (!fp) {
	CRITICAL((DQS_EVENT,"DQS_ERROR_0483 could not open >%s< for writing",CONF_FILE));
	abort();
      }
      
    }
  
  DQS_ASSERT((fprintf(fp,"QMASTER_SPOOL_DIR        %s\n",mconf->qmaster_spool_dir)>0));
  DQS_ASSERT((fprintf(fp,"EXECD_SPOOL_DIR          %s\n",mconf->execd_spool_dir)>0));
  DQS_ASSERT((fprintf(fp,"DEFAULT_CELL             %s\n",mconf->default_cell)>0));
  DQS_ASSERT((fprintf(fp,"RESERVED_PORT            %s\n",true_false[mconf->reserved_port])>0));
  DQS_ASSERT((fprintf(fp,"QMASTER_SERVICE          %s\n",mconf->qmaster_service)>0));
  DQS_ASSERT((fprintf(fp,"DQS_EXECD_SERVICE        %s\n",mconf->dqs_execd_service)>0));
  DQS_ASSERT((fprintf(fp,"INTERCELL_SERVICE        %s\n",mconf->intercell_service)>0));
  DQS_ASSERT((fprintf(fp,"KLOG                     %s\n",mconf->klog)>0));
  DQS_ASSERT((fprintf(fp,"REAUTH_TIME              %d\n",mconf->reauth_time)>0));
  DQS_ASSERT((fprintf(fp,"MAILER                   %s\n",mconf->mailer)>0));
  DQS_ASSERT((fprintf(fp,"DQS_BIN                  %s\n",mconf->dqs_bin)>0));
  DQS_ASSERT((fprintf(fp,"ADMINISTRATOR            %s\n",mconf->administrator)>0));
  DQS_ASSERT((fprintf(fp,"DEFAULT_ACCOUNT          %s\n",mconf->default_account)>0));
  
  if (mconf->logmail) {
    DQS_ASSERT((fprintf(fp,"LOGMAIL                  TRUE\n")>0));
  }
  else {
    DQS_ASSERT((fprintf(fp,"LOGMAIL                  FALSE\n")>0));
  }
  
  
  if (mconf->default_rerun) {
    DQS_ASSERT((fprintf(fp,"DEFAULT_RERUN            TRUE\n")>0));
  }
  else {
    DQS_ASSERT((fprintf(fp,"DEFAULT_RERUN            FALSE\n")>0));
  }
  
  if (mconf->sort_seq_no) {
    DQS_ASSERT((fprintf(fp,"DEFAULT_SORT_SEQ_NO      TRUE\n")>0));
  }
  else {
    DQS_ASSERT((fprintf(fp,"DEFAULT_SORT_SEQ_NO      FALSE\n")>0));
  }
  
  if (mconf->sync_io) {
    DQS_ASSERT((fprintf(fp,"SYNC_IO                  TRUE\n")>0));
  } 
  else {
    DQS_ASSERT((fprintf(fp,"SYNC_IO                  FALSE\n")>0));
  }
  
  
  if (mconf->user_access==ACCESS_FREE) {
    DQS_ASSERT((fprintf(fp,"USER_ACCESS              ACCESS_FREE\n")>0));
  }
  else if (mconf->user_access==ACCESS_OPEN) {
    DQS_ASSERT((fprintf(fp,"USER_ACCESS              ACCESS_OPEN\n")>0));
  }
  else {
    DQS_ASSERT((fprintf(fp,"USER_ACCESS              ACCESS_RESTRICTED\n")>0));
  }
  
  if (mconf->logfacility==LOG_VIA_SYSLOG) {
    DQS_ASSERT((fprintf(fp,"LOGFACILITY              LOG_VIA_SYSLOG\n")>0));
  }
  else if (mconf->logfacility==LOG_VIA_FILE){
    DQS_ASSERT((fprintf(fp,"LOGFACILITY              LOG_VIA_FILE\n")>0));
  } 
  else {
    DQS_ASSERT((fprintf(fp,"LOGFACILITY              LOG_VIA_COMBO\n")>0));
  }
  
  DQS_ASSERT(((mconf->loglevel>=LOG_CRIT)&&mconf->loglevel<=LOG_EXTDEBUG));
  DQS_ASSERT((fprintf(fp,"LOGLEVEL                 %s\n",
		      log_levels[mconf->loglevel])>0));
  
  DQS_ASSERT((fprintf(fp,"MIN_GID                  %u\n",mconf->min_gid)>0));
  DQS_ASSERT((fprintf(fp,"MIN_UID                  %u\n",mconf->min_uid)>0));
  DQS_ASSERT((fprintf(fp,"MAXUJOBS                 %u\n",mconf->maxujobs)>0));
  if (mconf->output_handling==LEAVE_OUTPUT_FILES) {
    DQS_ASSERT((fprintf(fp,"OUTPUT_HANDLING       LEAVE_OUTPUT_FILES\n")>0));
  }
  else if (mconf->output_handling==COPY_OUTPUT_FILES) {
    DQS_ASSERT((fprintf(fp,"OUTPUT_HANDLING       COPY_OUTPUT_FILES\n")>0));
  }
  else if (mconf->output_handling==LINK_OUTPUT_FILES) {
    DQS_ASSERT((fprintf(fp,"OUTPUT_HANDLING       LINK_OUTPUT_FILES\n")>0));
  }
  
  if (mconf->addon_script==NULL){
    DQS_ASSERT((fprintf(fp,"ADDON_SCRIPT       NONE\n")>0));
  }
  else   DQS_ASSERT((fprintf(fp,"ADDON_SCRIPT        %s\n",mconf->addon_script)>0));
  
  if(mconf->addon_info==NULL){
    DQS_ASSERT((fprintf(fp,"ADDON_INFO       NONE\n")>0));
  }
  
  else   DQS_ASSERT((fprintf(fp,"ADDON_INFO        %s\n",mconf->addon_info)>0));
  
  DQS_ASSERT((fprintf(fp,"LOAD_LOG_TIME            %u\n",mconf->load_log_time)>0));
  DQS_ASSERT((fprintf(fp,"STAT_LOG_TIME            %u\n",mconf->stat_log_time)>0));
  DQS_ASSERT((fprintf(fp,"SCHEDULE_TIME            %u\n",mconf->schedule_time)>0));
  DQS_ASSERT((fprintf(fp,"MAX_UNHEARD              %u\n",mconf->max_unheard)>0));
  DQS_ASSERT((fprintf(fp,"ALARMS                   %u\n",mconf->alarms)>0));
  DQS_ASSERT((fprintf(fp,"ALARMM                   %u\n",mconf->alarmm)>0));
  DQS_ASSERT((fprintf(fp,"ALARML                   %u\n",mconf->alarml)>0));
  fclose(fp);
  
  DEXIT;
  
}

/*********************************************************************/
void dqs_setup_qmaster()
     
{
  
  string         str;
  dqs_list_type  listel;
  dqs_list_type  *listel_ptr;
  dqs_list_type  *tmp,*tmp2;
  dqs_hash_type  *hashel_ptr;
  dqs_queue_type *queue_ptr;
  char verchk[4];
  
  DENTER((DQS_EVENT,"dqs_setup_qmaster"));
  
  umask(0);
  DPRINTF((DQS_EVENT,"chdir(\"/\")----------------------------"));
  dqs_chdir("/");
  DPRINTF((DQS_EVENT,"Making directories----------------------------"));
  dqs_mkdir(conf.qmaster_spool_dir,me.uid,me.gid,0755);
  DPRINTF((DQS_EVENT,"chdir(\"%s\")----------------------------",conf.qmaster_spool_dir));
  dqs_chdir(conf.qmaster_spool_dir);
  dqs_mkdir("qmaster",me.uid,me.gid,0755);
  DPRINTF((DQS_EVENT,"chdir(\"qmaster\")----------------------------"));
  dqs_chdir("qmaster");
  dqs_mkdir(me.unqualified_hostname,me.uid,me.gid,0755);
  DPRINTF((DQS_EVENT,"chdir(\"%s\",me.unqualified_hostname)----------------------------",
	   me.unqualified_hostname));
  dqs_chdir(me.unqualified_hostname);
  DPRINTF((DQS_EVENT,"Making directories----------------------------"));
  dqs_mkdir(COMMON_DIR,me.uid,me.gid,0755);
  dqs_mkdir(JOB_DIR,me.uid,me.gid,0755);
  dqs_mkdir(QUEUE_DIR,me.uid,me.gid,0755);
  dqs_mkdir(TID_DIR,me.uid,me.gid,0755);
  
  
  DPRINTF((DQS_EVENT,"Acl_head----------------------------"));
  Acl_head=dqs_read_list_from_disk(NULL,ACL_FILE);
  if (!Acl_head)
    {
      DPRINTF((DQS_EVENT,"%s not found",ACL_FILE));
    }
  Acl_hash=dqs_hash_init();
  tmp=Acl_head;
  while (tmp)
    {
      dqs_hash_add(tmp->str0,Acl_hash);
      tmp=tmp->next;
    }
  dqs_showlist(Acl_head,DQS_DEBUG|DQS_STR1|DQS_STR2,4);
  
  
  DPRINTF((DQS_EVENT,"Complex_head----------------------------"));
  tmp=dqs_read_list_from_disk(NULL,COMPLEX_FILE);
  Complex_hash=dqs_hash_init();
  while (tmp)
    {
      dqs_add_complex(tmp);
      tmp->chain=NULL;
      tmp=dqs_delete_head(tmp);
    }
  DPRINTF((DQS_EVENT,"***Complex_head***************************"));
  dqs_showlist(Complex_head,DQS_DEBUG|DQS_STR0|DQS_INT0|DQS_CHAIN,4);
  
  DPRINTF((DQS_EVENT,"Consumable_head----------------------------"));
  tmp=dqs_read_list_from_disk(NULL,CONSUMABLE_FILE);
  Consumable_hash=dqs_hash_init();
  while (tmp)
    {
      dqs_add_consumable(tmp);
      tmp->chain=NULL;
      tmp=dqs_delete_head(tmp);
    }
  DPRINTF((DQS_EVENT,"***Consumable_head***************************"));
  dqs_showlist(Consumable_head,DQS_DEBUG|DQS_STR0|DQS_INT0|DQS_CHAIN,4);
  
  DPRINTF((DQS_EVENT,"Host_head----------------------------"));
  Host_hash=dqs_hash_init();
  tmp=dqs_read_list_from_disk(NULL,HOST_FILE);
  if (!tmp)
    {
      INFO((DQS_EVENT,"DQS_ERROR_0484 %s not found - making",HOST_FILE));
    }
  
  if (!dqs_locate_str0(tmp,me.qualified_hostname))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0485 \"%s\" not found in HOST_LIST - adding",me.qualified_hostname));
      bzero((char *)&listel,sizeof(listel));
      listel.str0=dqs_string_insert( (char *)NULL,me.qualified_hostname);
      tmp=dqs_insert(DQS_STR0,ASCENDING,tmp,&listel);
    }
  
#ifdef DEFAULT_HOST
  if ((dqs_strcasecmp(DEFAULT_HOST,"NONE"))&&(!dqs_locate_str0(tmp,DEFAULT_HOST)))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0486 \"%s\" not found in HOST_LIST - adding",DEFAULT_HOST));
      bzero((char *)&listel,sizeof(listel));
      listel.str0=dqs_string_insert( (char *)NULL,DEFAULT_HOST);
      tmp=dqs_insert(DQS_STR0,ASCENDING,tmp,&listel);
    }
#endif
  
  while (tmp)
    {
      dqs_add_host(tmp->str0);
      tmp=dqs_delete_head(tmp);
    }
  dqs_write_list_to_disk(NULL,HOST_FILE,Host_head,ALL);
  DPRINTF((DQS_EVENT,"***Host_head***************************"));
  dqs_showlist(Host_head,DQS_DEBUG|DQS_STR0|DQS_CHAIN,4);
  
  DPRINTF((DQS_EVENT,"Man_head----------------------------"));
  Man_head=dqs_read_list_from_disk(NULL,MAN_FILE);
  if (!Man_head)
    {
      INFO((DQS_EVENT,"DQS_ERROR_0487 %s not found - making",MAN_FILE));
      bzero((char *)&listel,sizeof(listel));
      listel.str0=dqs_string_insert( (char *)NULL,"root");
      Man_head=dqs_insert(DQS_STR0,ASCENDING,Man_head,&listel);
      dqs_write_list_to_disk(NULL,MAN_FILE,Man_head,ALL);
    }
  if (!dqs_locate_str0(Man_head,DEFAULT_MANAGER))
    {
      INFO((DQS_EVENT,"DQS_ERROR_0488 \"%s\" not found in MAN_LIST - adding",DEFAULT_MANAGER));
      bzero((char *)&listel,sizeof(listel));
      listel.str0=dqs_string_insert( (char *)NULL,DEFAULT_MANAGER);
      Man_head=dqs_insert(DQS_STR0,ASCENDING,Man_head,&listel);
      dqs_write_list_to_disk(NULL,MAN_FILE,Man_head,ALL);
    }
  
#ifdef DEFAULT_MANAGER2
  if (!dqs_locate_str0(Man_head,DEFAULT_MANAGER2))
    {
      INFO((DQS_EVENT,"DQS_ERROR_0489 \"%s\" not found in MAN_LIST - adding",DEFAULT_MANAGER2));
      bzero((char *)&listel,sizeof(listel));
      listel.str0=dqs_string_insert( (char *)NULL,DEFAULT_MANAGER2);
      Man_head=dqs_insert(DQS_STR0,ASCENDING,Man_head,&listel);
      dqs_write_list_to_disk(NULL,MAN_FILE,Man_head,ALL);
    }
#endif
  
  Man_hash=dqs_hash_init();
  tmp=Man_head;
  while (tmp)
    {
      dqs_hash_add(tmp->str0,Man_hash);
      tmp=tmp->next;
    }
  DPRINTF((DQS_EVENT,"***Man_head***************************"));
  dqs_showlist(Man_head,DQS_DEBUG|DQS_STR0|DQS_CHAIN,4);
  
  
  DPRINTF((DQS_EVENT,"Op_head----------------------------"));
  Op_head=dqs_read_list_from_disk(NULL,OP_FILE);
  if (!Op_head)
    {
      INFO((DQS_EVENT,"DQS_ERROR_0490 %s not found - making",OP_FILE));
      bzero((char *)&listel,sizeof(listel));
      listel.str0=dqs_string_insert( (char *)NULL,"root");
      Op_head=dqs_insert(DQS_STR0,ASCENDING,Op_head,&listel);
      dqs_write_list_to_disk(NULL,OP_FILE,Op_head,ALL);
    }
  Op_hash=dqs_hash_init();
  tmp=Op_head;
  while (tmp)
    {
      dqs_hash_add(tmp->str0,Op_hash);
      tmp=tmp->next;
    }
  DPRINTF((DQS_EVENT,"***Op_head***************************"));
  dqs_showlist(Op_head,DQS_DEBUG|DQS_STR0|DQS_CHAIN,4);
  
  
  DPRINTF((DQS_EVENT,"Queue_head----------------------------"));
  Queue_hash=dqs_hash_init();
  tmp=dqs_get_dirents(QUEUE_DIR);
  while (tmp)
    {
      DPRINTF((DQS_EVENT,"reading in queue >%s<",tmp->str0));
      listel_ptr=dqs_read_list_from_disk(QUEUE_DIR,tmp->str0);
      if (!listel_ptr)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0491 error reading in %s/%s",QUEUE_DIR,tmp->str0));
	  listel_ptr=dqs_free_list(listel_ptr); 
	  tmp=dqs_delete_head(tmp);
	  continue;
	}
      verchk[0] = listel_ptr->queue->Version[10]; verchk[1] = (char)NULL;
      verchk[2] = listel_ptr->queue->Version[12]; verchk[3] = (char)NULL;
      if ((atoi(&verchk[0]) < 3) || ((atoi(&verchk[0]) == 3) && (atoi(&verchk[2]) < 3)))
	{
	  listel_ptr->queue->Version=dqs_string_insert(listel_ptr->queue->Version, DQS_VERSION);
	  dqs_write_queue_to_disk(listel_ptr->queue);
	}
      (void) dqs_add_queue(listel_ptr->queue);
      tmp->queue=NULL;
      tmp=dqs_delete_head(tmp);
      
      listel_ptr->chain=dqs_free_list(listel_ptr->chain);
      listel_ptr->next=dqs_free_list(listel_ptr->next);  
      listel_ptr->tid=dqs_free_list(listel_ptr->tid);    
      
      FREE(listel_ptr->user);
      FREE(listel_ptr->str0);
      FREE(listel_ptr->str1);
      FREE(listel_ptr->str2);
      FREE(listel_ptr->str3);
      FREE(listel_ptr->buf);
      
      listel_ptr->rusage=dqs_free_rusage(listel_ptr->rusage);
      listel_ptr->conf=dqs_free_conf(listel_ptr->conf);      
      listel_ptr->job=dqs_free_job(listel_ptr->job);         
      listel_ptr->me=dqs_free_me(listel_ptr->me);            
      
      FREE(listel_ptr);
      
      
    }
  
  listel_ptr= NULL;   /*   JIC   */
  
  dqs_update_queue_state();
  
  DPRINTF((DQS_EVENT,"***Queue_head***************************"));
  dqs_showlist(Queue_head,DQS_DEBUG|DQS_STR0|DQS_CHAIN,4);
  
  
  DPRINTF((DQS_EVENT,"Job_head----------------------------"));
  Job_hash=dqs_hash_init();
  tmp=dqs_get_dirents(JOB_DIR);
  while (tmp)
    {
      DPRINTF((DQS_EVENT,"reading in job >%s<",tmp->str0));
      listel_ptr=dqs_read_list_from_disk(JOB_DIR,tmp->str0);
      if (!listel_ptr)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0492 error reading in %s/%s",JOB_DIR,tmp->str0));
	  listel_ptr=dqs_free_list(listel_ptr);
	  tmp=dqs_delete_head(tmp);
	  continue;
	}
      if (listel_ptr->job) (void) dqs_add_job(listel_ptr->job);
      tmp->job=NULL;
      tmp=dqs_delete_head(tmp);
      jobs_to_start=TRUE;       /* make sure we kickoff queue restart */
      
      listel_ptr->chain=dqs_free_list(listel_ptr->chain);
      listel_ptr->next=dqs_free_list(listel_ptr->next);  
      listel_ptr->tid=dqs_free_list(listel_ptr->tid);
      
      FREE(listel_ptr->user);
      FREE(listel_ptr->str0);
      FREE(listel_ptr->str1);
      FREE(listel_ptr->str2);
      FREE(listel_ptr->str3);
      FREE(listel_ptr->buf);
      
      listel_ptr->rusage=dqs_free_rusage(listel_ptr->rusage);
      listel_ptr->conf=dqs_free_conf(listel_ptr->conf);       
      listel_ptr->queue=dqs_free_queue(listel_ptr->queue);         
      listel_ptr->me=dqs_free_me(listel_ptr->me);            
      
      FREE(listel_ptr);
      
    }
  
  listel_ptr=NULL; /* JIC */
  
  DPRINTF((DQS_EVENT,"***Queue_head***************************"));
  dqs_showlist(Queue_head,DQS_DEBUG|DQS_STR0|DQS_CHAIN,4);
  
  DPRINTF((DQS_EVENT,"Tid_head----------------------------"));
  tmp=dqs_get_dirents(TID_DIR);
  while (tmp)
    {
      listel_ptr=dqs_read_list_from_disk(TID_DIR,tmp->str0);
      DPRINTF((DQS_EVENT,"read in tid >%s<",tmp->str0));
      if (!listel_ptr)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0493 error reading in %s/%s",RUSAGE_DIR,tmp->str0));
	  listel_ptr=dqs_free_list(listel_ptr);
	  tmp=dqs_delete_head(tmp);
	  continue;
	}
      Tid_head=dqs_insert(DQS_STR0,ASCENDING,Tid_head,listel_ptr);
      FREE(listel_ptr);
      tmp=dqs_delete_head(tmp);
      
    }
  dqs_showlist(Tid_head,DQS_DEBUG|DQS_STR0|DQS_INT0|DQS_INT1,4);
  
  /* if current genric queue definition is not DQS 3.1.3  */
  /* dqs_read_in_qconf will return a NULL and force the   */
  /* writing of the new version                           */
  
  queue_ptr=dqs_read_in_qconf( (char*)NULL,GENERIC_QUEUE);
  if (!queue_ptr)
    {
      INFO((DQS_EVENT,"DQS_ERROR_0494 writing generic queue configuration \"%s\"",
	    GENERIC_QUEUE));
      dqs_write_generic_qconf(NULL,GENERIC_QUEUE);
      queue_ptr=dqs_read_in_qconf( (char*)NULL,GENERIC_QUEUE);
    }
  if (!queue_ptr)
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0495 terminal error: dqs_read_in_qconf() failed"));
      DEXITE;
      abort();
    }
  queue_ptr=dqs_free_queue(queue_ptr);
  
  
  DEXIT;
  return;
  
}

/****************************************************************/
void dqs_setup_dqs_execd()
     
{
  
  string        str;
  dqs_list_type listel;
  dqs_list_type *listel_ptr;
  dqs_list_type *tmp,*tmp2;
  dqs_hash_type *hashel_ptr;
  dqs_rusage_type *dusage;
  char *acct_tmp;
  int  acct_int;
  
  DENTER((DQS_EVENT,"dqs_setup_dqs_execd"));
  
  umask(0);
  DPRINTF((DQS_EVENT,"chdir(\"/\")----------------------------"));
  dqs_chdir("/");
  DPRINTF((DQS_EVENT,"Making directories----------------------------"));
  dqs_mkdir(conf.execd_spool_dir,me.uid,me.gid,0755);
  DPRINTF((DQS_EVENT,"chdir(\"%s\")----------------------------",conf.execd_spool_dir));
  dqs_chdir(conf.execd_spool_dir);
  dqs_mkdir("dqs_execd",me.uid,me.gid,0755);
  DPRINTF((DQS_EVENT,"chdir(\"dqs_execd\")----------------------------"));
  dqs_chdir("dqs_execd");
  dqs_mkdir(me.unqualified_hostname,me.uid,me.gid,0755);
  DPRINTF((DQS_EVENT,"chdir(\"%s\",me.unqualified_hostname)----------------------------",
	   me.unqualified_hostname));
  dqs_chdir(me.unqualified_hostname);
  DPRINTF((DQS_EVENT,"Making directories----------------------------"));
  dqs_mkdir(EXEC_DIR,me.uid,me.gid,0755);
  dqs_mkdir(JOB_DIR,me.uid,me.gid,0755);
  dqs_mkdir(RUSAGE_DIR,me.uid,me.gid,0755);
  dqs_mkdir(TID_DIR,me.uid,me.gid,0755);
  
  DPRINTF((DQS_EVENT,"Cleaning %s----------------------------",EXEC_DIR));
  tmp=dqs_get_dirents(EXEC_DIR);
  while (tmp)
    {
      sprintf(str,"%s/%s",EXEC_DIR,tmp->str0);
      unlink(str);
      tmp=dqs_delete_head(tmp);
    }
  
  DPRINTF((DQS_EVENT,"Cleaning %s----------------------------",JOB_DIR));
  tmp=dqs_get_dirents(JOB_DIR);
  while (tmp)
    {
      sprintf(str,"%s/%s",JOB_DIR,tmp->str0);
      
      
      /* got to reap children that died when machine crapped */
      tmp2=dqs_read_list_from_disk(JOB_DIR,tmp->str0);
      
      
      if (tmp2)
	{
	  
	  dusage=(dqs_rusage_type *)dqs_malloc(sizeof(dqs_rusage_type));
	  dusage->qname=dqs_string_insert( (char *)NULL,tmp2->job->master_queue_exec_str);
	  dusage->hostname=dqs_string_insert( (char *)NULL,me.qualified_hostname);
	  dusage->group=dqs_string_insert( (char *)NULL,"NA");
	  dusage->master=TRUE; /*???*/
	  dusage->owner=dqs_string_insert( (char *)NULL,tmp2->job->owner);
	  dusage->job_name=dqs_string_insert( (char *)NULL,tmp2->job->job_name);
	  dusage->dqs_job_name=dqs_string_insert( dusage->dqs_job_name,tmp2->job->dqs_job_name);
	  if(tmp2->job->account_list){
	    if(tmp2->job->account_list->str0){
	      acct_int= strlen(tmp2->job->account_list->str0);
	      if(tmp2->job->account_list->str1){
		acct_int=acct_int + strlen(tmp2->job->account_list->str1);  
	      }
	    }
            acct_tmp= (char *) dqs_malloc( acct_int +2);
            strcpy(acct_tmp,tmp2->job->account_list->str0);
            if(tmp2->job->account_list->str1){
	      strcat(acct_tmp,"@");
	      strcat(acct_tmp,tmp2->job->account_list->str1);
            }
            dusage->account= dqs_string_insert(NULL,acct_tmp);
            free(acct_tmp);
	  }
	  
	  dusage->priority=tmp2->job->priority;           
	  dusage->job_number=tmp2->job->job_number;
	  dusage->submission_time=tmp2->job->submission_time;
	  dusage->start_time=tmp2->job->start_time;
	  dusage->end_time=dqs_get_gmt();
	  dusage->exit_status=0;
	  dusage->ru_wallclock=dusage->end_time-dusage->start_time;
	  dusage->job_to_be_restarted=TRUE;
	  DPRINTF((DQS_EVENT,"reaped tmp2->job->dqs_job_name***>%s<***",dusage->dqs_job_name));
	  
	  bzero((char *)&listel,sizeof(listel));
	  listel.type=DQS_EXECD;
	  listel.int0=JOB_EXIT;
	  listel.str0=dqs_string_insert( (char *)NULL,dusage->dqs_job_name);
	  listel.rusage=dusage;
	  listel.tid=dqs_get_tid();
	  unlink(str);
	  sprintf(str,"%s.%d",dusage->dqs_job_name,dusage->pid);
	  listel.str1=dqs_string_insert( (char *)NULL,str);
	  dqs_write_list_to_disk(RUSAGE_DIR,listel.str1,&listel,ALL);
	  ERROR((DQS_EVENT,"DQS_ERROR_0496 job \"%s\" reaped at machine startup",dusage->dqs_job_name));
	  Rusage_head=dqs_insert(DQS_STR0,ASCENDING,Rusage_head,&listel);
	  
	  tmp2=dqs_free_list(tmp2);
	}
      tmp=dqs_delete_head(tmp);          
    }
  
  DPRINTF((DQS_EVENT,"Rusage_head----------------------------"));
  tmp=dqs_get_dirents(RUSAGE_DIR);
  while (tmp)
    {
      DPRINTF((DQS_EVENT,"reading in rusage >%s<",tmp->str0));
      listel_ptr=dqs_read_list_from_disk(RUSAGE_DIR,tmp->str0);
      if (!listel_ptr)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0497 error reading in %s/%s",RUSAGE_DIR,tmp->str0));
	  listel_ptr=dqs_free_list(listel_ptr);
	  tmp=dqs_delete_head(tmp);
	  continue;
	}
      Rusage_head=dqs_insert(DQS_STR0,ASCENDING,Rusage_head,listel_ptr);
      tmp=dqs_delete_head(tmp);
    }
  dqs_showlist(Rusage_head,DQS_DEBUG|DQS_STR0,4);
  
  DPRINTF((DQS_EVENT,"Tid_head----------------------------"));
  tmp=dqs_get_dirents(TID_DIR);
  while (tmp)
    {
      DPRINTF((DQS_EVENT,"reading in tid >%s<",tmp->str0));
      listel_ptr=dqs_read_list_from_disk(TID_DIR,tmp->str0);
      if (!listel_ptr)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0498 error reading in %s/%s",RUSAGE_DIR,tmp->str0));
	  listel_ptr=dqs_free_list(listel_ptr);
	  tmp=dqs_delete_head(tmp);
	  continue;
	}
      Tid_head=dqs_insert(DQS_STR0,ASCENDING,Tid_head,listel_ptr);
      tmp=dqs_delete_head(tmp);
      FREE(listel_ptr);
      listel_ptr= NULL;
    }
  dqs_showlist(Tid_head,DQS_DEBUG|DQS_STR0|DQS_INT0,4);
  
  dqs_get_loadavg(); /* needs 2 calls at start!! */
  
  DEXIT;
  return;
  
}

/****************************************************************/
dqs_list_type *dqs_get_dirents(path)
     char *path;
     
{
  
  dqs_list_type listel;
  dqs_list_type *head=NULL;
  DIR *cwd,*opendir();
  struct DIRENT *dent;
  
  DENTER_EXT((DQS_EVENT,"dqs_get_dirents"));
  
  cwd=opendir(path);
  
  if (cwd==(DIR*)0) 
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0499 cannot opendir %s",path));
      return(NULL);
    }
  
  while ((dent=readdir(cwd)) != NULL) 
    {
      if (!dent->d_name)
	continue; /* just for you Slotharis... */
      if (!dent->d_name[0])
	continue; /* just for you Slotharis... */
      bzero((char *)&listel,sizeof(listel));
      if (strcmp(dent->d_name,"..")==0 || strcmp(dent->d_name,".")==0 )
	continue;
      listel.str0=dqs_string_insert( (char *)NULL,dent->d_name);
      head=dqs_insert(DQS_STR0,TAIL,head,&listel);
    }
  
  closedir(cwd);
  
  
  DEXIT;
  return(head);
  
}

/****************************************************************/
void dqs_chdir(path)
     char *path;
     
{
  
  DENTER_EXT((DQS_EVENT,"dqs_chdir"));
  
  if (chdir(path))
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0500 cannot chdir() to %s",path));
      abort();
    }
  
  DEXIT;
  return;
  
}

/*********************************************************/
void dqs_mkdir(path,owner,group,fmode)
     char    *path;
     int     owner;
     int     group;
     int     fmode;
     
{
  
  int i=0;
  string path_;
  string err_str;
  
  DENTER_EXT((DQS_EVENT,"dqs_mkdir"));
  if (!path) 
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0501 null path passed to dqs_mkdir()"));
      DEXITE;
      abort();
    }
  
  bzero((char *)path_,sizeof(path_));
  while ((unsigned char)path[i]) 
    {
      path_[i]=path[i];
      if ((path[i]=='/') && (i!=0))
	{
	  path_[i]=(unsigned char)0;
	  dqs_domkdir(path_,(pid_t)owner,(gid_t)group,(mode_t)fmode);
	}
      path_[i]=path[i];
      i++;
    }
  
  dqs_domkdir(path_,owner,group,fmode);
  
  DEXIT;
  return;
  
}

/*********************************************************/
void dqs_domkdir(path_,owner,group,fmode)
     char    *path_;
     int     owner;
     int     group;
     mode_t  fmode;
     
{
  
  struct stat buf;
  
  DENTER_EXT((DQS_EVENT,"dqs_domkdir"));
  
  if (stat(path_,&buf)) 
    {
      DPRINTF((DQS_EVENT,">%s< not found -- making",path_));
      if (mkdir(path_,(mode_t)fmode))
	{
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0502 unable to mkdir(%s,%d)",
		    path_,fmode));
	  DEXITE;
	  abort();
	}
      
      if (me.uid==0)
	{
	  if (chown(path_,(uid_t)owner,(gid_t)group))
	    {
	      CRITICAL((DQS_EVENT,"DQS_ERROR_0503 unable to chownr(%d,%d)",
			owner,group));
	      DEXITE;
	      abort();
	    }
	}
    }
  
  DEXIT;
  return;
  
}

