#! /bin/sh
# Installer bash script for Cult3D Netscape-plugin on Linux.
# fix: portable?

echo
echo Cult3D 5.2 installation script.
echo
echo Note: For the choices of type '[Y/n]', just pressing return
echo will accept the default \(recommended\) installation procedure.
echo
echo For more information, release notes, and trouble shooting 
echo please read the supplied README file.
echo
echo   /The Cult3D Team -- http://www.cult3d.com/
echo

id=$UID
if [ "$id" = "" ]; then id=$uid; fi
if [ "$id" = "" ]; then id=`id | cut -f 2 -d = | cut -f 1 -d \(`; fi

if [ "$MOZILLA_HOME" != "" -a -d "$MOZILLA_HOME" -a -w "$MOZILLA_HOME" ]
then
    echo \$MOZILLA_HOME is set to $MOZILLA_HOME. 
    echo Would you like to install the plug-in in $MOZILLA_HOME? '[Y/n] '
    read reply
    if [ "$reply" != "n" -a "$reply" != "N" ]
    then
	plugindir=$MOZILLA_HOME/plugins
    fi
fi

if [ "$plugindir" = "" -a "$NPX_PLUGIN_PATH" != "" -a -d "$NPX_PLUGIN_PATH" -a -w "$NPX_PLUGIN_PATH" ]
then
    echo \$NPX_PLUGIN_PATH is set to $NPX_PLUGIN_PATH.
    echo Would you like to install the plug-in in $NPX_PLUGIN_PATH? '[Y/n] '
    read reply
    if [ "$reply" != "n" -a "$reply" != "N" ]
    then
        plugindir=$NPX_PLUGIN_PATH
    fi
fi

if [ "$plugindir" = "" -a $id != 0 ]
then
    echo Would you like to install the plug-in in $HOME/.netscape/plugins? '[Y/n] '
    read reply
    if [ "$reply" != "n" -a "$reply" != "N" ]
    then
	plugindir=$HOME/.netscape/plugins
    fi
fi

if [ "$plugindir" = "" ]
then
    if [ $id = 0 ]
    then
	echo You\'re installing as super user but MOZILLA_HOME is not set. To install 
	echo the plugin system-wide, enter the directory where Netscape was installed
	echo \(usually something like /usr/lib/netscape or /usr/local/netscape\), or
	echo return to skip. '[none] '
	read reply
	if [ "$reply" != "" ]
	then 
	    if [ -d "$reply" -a -w "$reply" ]
	    then
		plugindir=$reply/plugins
	    else
		echo Directory doesn\'t exist or is read-only.
		echo
	    fi
	fi
    else
	echo Don\'t know where to install. Please enter a directory to install the plugin
	echo in, or return to skip. '[none] '
	read reply
	if [ "$reply" != "" ]
	then 
	    if [ -d "$reply" -a -w "$reply" ]
	    then
		plugindir=$reply
	    else
		echo Directory doesn\'t exist or is read-only.
		echo
	    fi
	fi
    fi
fi

if [ "$plugindir" = "" ]
then
    echo "Nowhere to install. Plugin not installed."
    echo
else
    mkdir -p $plugindir
    oldfiles="`cd $plugindir; find . -name \*[cC]ult3[dD]\* -print | egrep '\.so|\.class|\.jar' | cut -c 3-`"
    if [ "$oldfiles" != "" ]
    then
	echo There seems to be an old Cult3D installation in $plugindir.
	echo
	echo Remove the files \($oldfiles\)? '[Y/n] '
	read reply
	if [ "$reply" != "n" -a "$reply" != "N" ]
	then
	    echo "Removing old files..."
	    rm -f `find $plugindir -name \*[cC]ult3[dD]\* -print | egrep '\.so|\.class|\.jar'`
	    echo done.
	    echo
	fi
    fi

    echo "Trying to install plugin in $plugindir ..."
    nowdir=`pwd`
    cd $plugindir
    tar -xf ${nowdir}/cult3d.tar 
    echo done.
    echo
    echo "Ok! Now you should restart Netscape and try it out!"
    echo "For instance surf to: http://www.cult3d.com/gallery/"
    echo
fi

