# AssaultCube Pragmatic Governance Model (ACPGM) 

## Purpose

AssaultCube is an open-source project maintained by various people around the globe. These people invest their free time and consider their involvement as a hobby. 
Because people come and go, there is an inherent risk that ownership of the project will be lost and a power vacuum will bog the project down.

ACPGM is a lightweight governance model that supports the continuity and longevity of the project. It is designed to support the people involved in moving the project forward. 
It is simple enough to be practically useful and complex enough to prevent ambiguity. After all, it should be fun to engage in the project - nobody wants bureaucracy.
ACPGM is not legally binding and does not constitute a legal entity.

## Fellows

- The number of fellow members must be at lest twenty. The fellows decides with relative majority vote.
- Rights
  - The fellows own AssaultCube. 
  - The fellows elect the members of the oversight committee. This election is held once a year in February in the AC forum.
  - If the oversight committee excludes a fellow member, the fellow members can reject this decision.
  - The fellows decide on proposed changes to this governance model.
- Applications for joining shall be addressed to the oversight committee which shall decide upon acceptance or non-acceptance.

## Oversight Committee

- The number of oversight committee members must be at least three. The committee decides with relative majority vote.
- The goal of the oversight committee is to
  -  Ensure the longevity of the project.
  -  Balance tradition with innovation.
  -  Promotion of young talents.
- Rights
  - The oversight committee approves the Strategy of the project.
  - The oversight committee may veto any feature that is being added to AC.
  - The oversight committee decides the fund allocation for the project.
  - The oversight committee may invite people to become a fellow any time or remove them any time.
  - The oversight committee may invite people to the platform team any time any time or remove them any time.
  - The oversight committee may invite people to the dev team any time any time or remove them any time.
  - The oversight committee has full authority of the project if not stated otherwise in this governance model.
  - The oversight committee decides which of the oversight committee member has the role of the _Chairman_. The Chairman represents the oversight committee towards others to simplify communication.

## Platform Team

- The number of platform team members is at least three. The platform team is self-organizing.
- The goal of the platform team is to
  - Keep up the game infrastructure and protect the game from attacks and abuse.
  - Present the game through means of marketing and social media.
  - Provide the service of fair and transparent moderation and game jurisidication (e.g. bans).
  - Establish welcoming culture and support civil/non-violent discussions.
- Rights
  - The platform team operates the infrastructure of AssaultCube and governs all administrative rights/permissions also including domains and social media accounts.
  - The platform team represents the highest decision authority in terms of community moderation and game jurisidication.
  - The platform team decides which of the platform team member has the role of the team lead. The team lead represents the platform team towards others to simplify communication.
- The platform team publishes its own policies regarding community moderation and game jurisidication.

## Dev Team

- The number of dev team members is at least three. The dev team is self-organizing.
- The goal of the dev team is to
  - Conceptualize and execute a Strategy for AC [1].
  - Publish an AC release at least once a year [2].
  - Actively acquire new talents for the project and provide mentorship.
- Rights
  - The dev team decides on development priorites, inclusion of features and bugfixes.
  - The dev team may change minor gameplay-relevant aspects of the game, major aspects require approval by the oversight committee [3].
  - The development team decides how contributions to the project are received and processed [4].
  - The dev team decides which of the dev team member has the role of the team lead. The team lead represents the dev team towards others to simplify communication.

## More

- Experience shows that people find it difficult to have multiple roles (different "hats") and to apply the right role depending on the context. Therefore, a person can *formally* belong to only one of these three groups: oversight committee, dev team, platform team. In practice however, people can support the project in different areas.

## Remarks

[1] The people that want to put their time into improving and advancing AC to the next level should be provided a lot of freedom. This makes the project attractive for talents. The people that have the ideas should be the same people that build the stuff. Therefore it is better to give the dev team the task to come up with vision/strategy instead of giving this task to the oversight committee. The oversight committee can still influence the direction of the project by setting up the dev team accordingly and by approving/disapproving the Strategy or to veto.

[2] This ensure the knowledge of publishing a release remains active. A release could potentially only contain new maps/media worst-case.

[3] Example: Minor gameplay change would be making the physics of nades more realistic; major gameplay change would be tweaking gun damage. 

[4] Example: Inclusion of new maps, inclusion of pull-requests.
