/* $Id$ */
/* Copyright (c) 2011-2012 Pierre Pronchery <khorben@defora.org> */
/* This file is part of DeforaOS Devel Asm */
/* This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. */



#ifndef ASM_COMMON_H
# define ASM_COMMON_H

# include <Devel/CPP.h>


/* protected */
/* types */
typedef enum _ASCode
{
	AS_CODE_NULL			= CPP_CODE_NULL,
	AS_CODE_COMMA			= CPP_CODE_COMMA,
	AS_CODE_DQUOTE			= CPP_CODE_DQUOTE,
	AS_CODE_META_DATA		= CPP_CODE_META_DATA,
	AS_CODE_META_DEFINE		= CPP_CODE_META_DEFINE,
	AS_CODE_META_ELIF		= CPP_CODE_META_ELIF,
	AS_CODE_META_ELSE		= CPP_CODE_META_ELSE,
	AS_CODE_META_ENDIF		= CPP_CODE_META_ENDIF,
	AS_CODE_META_ERROR		= CPP_CODE_META_ERROR,
	AS_CODE_META_IF			= CPP_CODE_META_IF,
	AS_CODE_META_IFDEF		= CPP_CODE_META_IFDEF,
	AS_CODE_META_IFNDEF		= CPP_CODE_META_IFNDEF,
	AS_CODE_META_INCLUDE		= CPP_CODE_META_INCLUDE,
	AS_CODE_META_PRAGMA		= CPP_CODE_META_PRAGMA,
	AS_CODE_META_UNDEF		= CPP_CODE_META_UNDEF,
	AS_CODE_META_WARNING		= CPP_CODE_META_WARNING,
	AS_CODE_OPERATOR_AEQUALS	= CPP_CODE_OPERATOR_AEQUALS,
	AS_CODE_OPERATOR_AMPERSAND	= CPP_CODE_OPERATOR_AMPERSAND,
	AS_CODE_OPERATOR_BAR		= CPP_CODE_OPERATOR_BAR,
	AS_CODE_OPERATOR_BEQUALS	= CPP_CODE_OPERATOR_BEQUALS,
	AS_CODE_OPERATOR_COLON		= CPP_CODE_OPERATOR_COLON,
	AS_CODE_OPERATOR_DAMPERSAND	= CPP_CODE_OPERATOR_DAMPERSAND,
	AS_CODE_OPERATOR_DBAR		= CPP_CODE_OPERATOR_DBAR,
	AS_CODE_OPERATOR_DEQUALS	= CPP_CODE_OPERATOR_DEQUALS,
	AS_CODE_OPERATOR_DGEQUALS	= CPP_CODE_OPERATOR_DGEQUALS,
	AS_CODE_OPERATOR_DGREATER	= CPP_CODE_OPERATOR_DGREATER,
	AS_CODE_OPERATOR_DHASH		= CPP_CODE_OPERATOR_DHASH,
	AS_CODE_OPERATOR_DIVEQUALS	= CPP_CODE_OPERATOR_DIVEQUALS,
	AS_CODE_OPERATOR_DIVIDE		= CPP_CODE_OPERATOR_DIVIDE,
	AS_CODE_OPERATOR_DLEQUALS	= CPP_CODE_OPERATOR_DLEQUALS,
	AS_CODE_OPERATOR_DLESS		= CPP_CODE_OPERATOR_DLESS,
	AS_CODE_OPERATOR_DMINUS		= CPP_CODE_OPERATOR_DMINUS,
	AS_CODE_OPERATOR_DOT		= CPP_CODE_OPERATOR_DOT,
	AS_CODE_OPERATOR_DOTDOTDOT	= CPP_CODE_OPERATOR_DOTDOTDOT,
	AS_CODE_OPERATOR_DPLUS		= CPP_CODE_OPERATOR_DPLUS,
	AS_CODE_OPERATOR_EQUALS		= CPP_CODE_OPERATOR_EQUALS,
	AS_CODE_OPERATOR_GEQUALS	= CPP_CODE_OPERATOR_GEQUALS,
	AS_CODE_OPERATOR_GREATER	= CPP_CODE_OPERATOR_GREATER,
	AS_CODE_OPERATOR_HASH		= CPP_CODE_OPERATOR_HASH,
	AS_CODE_OPERATOR_LBRACE		= CPP_CODE_OPERATOR_LBRACE,
	AS_CODE_OPERATOR_LBRACKET	= CPP_CODE_OPERATOR_LBRACKET,
	AS_CODE_OPERATOR_LEQUALS	= CPP_CODE_OPERATOR_LEQUALS,
	AS_CODE_OPERATOR_LESS		= CPP_CODE_OPERATOR_LESS,
	AS_CODE_OPERATOR_LPAREN		= CPP_CODE_OPERATOR_LPAREN,
	AS_CODE_OPERATOR_MEQUALS	= CPP_CODE_OPERATOR_MEQUALS,
	AS_CODE_OPERATOR_MGREATER	= CPP_CODE_OPERATOR_MGREATER,
	AS_CODE_OPERATOR_MINUS		= CPP_CODE_OPERATOR_MINUS,
	AS_CODE_OPERATOR_MODEQUALS	= CPP_CODE_OPERATOR_MODEQUALS,
	AS_CODE_OPERATOR_MODULO		= CPP_CODE_OPERATOR_MODULO,
	AS_CODE_OPERATOR_NEQUALS	= CPP_CODE_OPERATOR_NEQUALS,
	AS_CODE_OPERATOR_NOT		= CPP_CODE_OPERATOR_NOT,
	AS_CODE_OPERATOR_PEQUALS	= CPP_CODE_OPERATOR_PEQUALS,
	AS_CODE_OPERATOR_PLUS		= CPP_CODE_OPERATOR_PLUS,
	AS_CODE_OPERATOR_QUESTION	= CPP_CODE_OPERATOR_QUESTION,
	AS_CODE_OPERATOR_RBRACE		= CPP_CODE_OPERATOR_RBRACE,
	AS_CODE_OPERATOR_RBRACKET	= CPP_CODE_OPERATOR_RBRACKET,
	AS_CODE_OPERATOR_RPAREN		= CPP_CODE_OPERATOR_RPAREN,
	AS_CODE_OPERATOR_SEMICOLON	= CPP_CODE_OPERATOR_SEMICOLON,
	AS_CODE_OPERATOR_TEQUALS	= CPP_CODE_OPERATOR_TEQUALS,
	AS_CODE_OPERATOR_TILDE		= CPP_CODE_OPERATOR_TILDE,
	AS_CODE_OPERATOR_TIMES		= CPP_CODE_OPERATOR_TIMES,
	AS_CODE_OPERATOR_XEQUALS	= CPP_CODE_OPERATOR_XEQUALS,
	AS_CODE_OPERATOR_XOR		= CPP_CODE_OPERATOR_XOR,
	AS_CODE_SQUOTE			= CPP_CODE_SQUOTE,
	AS_CODE_WHITESPACE		= CPP_CODE_WHITESPACE,
	AS_CODE_NEWLINE			= CPP_CODE_NEWLINE,
	AS_CODE_WORD			= CPP_CODE_WORD,
	AS_CODE_REGISTER,
	AS_CODE_NUMBER,			/* XXX really necessary? */
	AS_CODE_IMMEDIATE		/* XXX really necessary? */
} ASCode;
# define AS_CODE_META_FIRST CPP_CODE_META_FIRST
# define AS_CODE_META_LAST CPP_CODE_META_LAST
# define AS_CODE_KEYWORD_FIRST AS_CODE_KEYWORD_AUTO
# define AS_CODE_KEYWORD_LAST AS_CODE_IMMEDIATE

#endif /* !ASM_COMMON_H */
