/*
   Copyright (C) 2006-2011 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* prefgeneral.h
 */
#ifndef koverartist_prefgeneral_h
#define koverartist_prefgeneral_h

#include <qframe.h>

class QCheckBox;
class QLineEdit;

namespace KoverArtist { class Settings; }



/** Preferences tab for general settings.
 */
class KoverArtistPrefGeneral : public QFrame
{
   Q_OBJECT
public:
   KoverArtistPrefGeneral(QWidget *parent = 0);

   virtual void fromConfig(const KoverArtist::Settings* stg);
   virtual void toConfig(KoverArtist::Settings* stg) const;
   virtual bool isValid() const;

protected:
   QCheckBox *mCbxLocalImages, *mCbxRemoveImageBorders;
   QLineEdit *mEdtCoverImageSearchUrl;
};


#endif /*koverartist_prefgeneral_h*/
