/* $NetBSD: amdgpioreg.h,v 1.1 2025/02/26 15:18:46 ryoon Exp $ */

/*      $OpenBSD: amdgpio.c,v 1.10 2022/10/20 20:40:57 kettenis Exp $   */
/*
 * Copyright (c) 2016 Mark Kettenis
 * Copyright (c) 2019 James Hastings
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _AMDGPIOREG_H
#define _AMDGPIOREG_H

#define AMDGPIO_NPINS			184
#define AMDGPIO_PIN_REG(pin)		((pin) * 4)

#define AMDGPIO_CONF_LEVEL		0x00000100
#define AMDGPIO_CONF_ACTLO		0x00000200
#define AMDGPIO_CONF_ACTBOTH		0x00000400
#define AMDGPIO_CONF_MASK		0x00000600
#define AMDGPIO_CONF_INTR_EN		0x00000800
#define AMDGPIO_CONF_INTR_MASK_EN	0x00001000
#define AMDGPIO_CONF_GPIORXSTATE	0x00010000
#define AMDGPIO_CONF_GPIOTXSTATE	0x00400000
#define AMDGPIO_CONF_GPIOTXSTATE_EN	0x00800000
#define AMDGPIO_CONF_INTR_STATUS	0x10000000

/* n should be 0 or 1. */
#define AMDGPIO_INTR_STATUS(n)		(0x2f8 + (n) * 4)

#define	AMDGPIO_INTR_MASTER		0xfc
#define AMDGPIO_INTR_MASTER_EIO		0x20000000
#define AMDGPIO_INTR_STATUS_NBITS	46
#define AMDGPIO_INTR_NPINS		4

#endif /* _AMDGPIOREG_H */
