/*	$NetBSD: disklabel.c,v 1.12 2021/05/26 04:28:15 mrg Exp $	*/

/*-
 * Copyright (c) 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)disklabel.c	8.1 (Berkeley) 6/11/93
 */

#include <sys/param.h>
#include <sys/disklabel.h>
#include <lib/libkern/libkern.h>
#include "stand.h"


#if defined(LIBSA_NO_DISKLABEL_MSGS)
#define nolabel (char *)1
#define corruptedlabel (char *)1
#else
static char nolabel[] = "no disk label";
static char corruptedlabel[] = "disk label corrupted";
#endif

char *
getdisklabel(const char *buf, struct disklabel *lp)
{
	const struct disklabel *dlp, *elp;
	char *msg = NULL;

	elp = (const void *)(buf + DEV_BSIZE - sizeof(*dlp));
	for (dlp = (const void *)buf; dlp <= elp;
	    dlp = (const void *)((const char *)dlp + sizeof(long))) {
#if defined(LIBSA_DISKLABEL_EI)
		if (dlp->d_magic == bswap32(DISKMAGIC) &&
		    dlp->d_magic2 == bswap32(DISKMAGIC)) {
			disklabel_swap(__UNCONST(dlp), __UNCONST(dlp));
		}
#endif
		if (dlp->d_magic != DISKMAGIC || dlp->d_magic2 != DISKMAGIC) {
			if (msg == NULL)
				msg = nolabel;
		} else if (dlp->d_npartitions > MAXPARTITIONS ||
			   dkcksum(dlp) != 0) {
			msg = corruptedlabel;
		} else {
			(void)memcpy(lp, dlp, sizeof *lp);
			msg = NULL;
			break;
		}
	}
	return msg;
}
