/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;
import jde.debugger.spec.EventRequestSpecList;
import jde.debugger.spec.WatchpointSpec;

public class Watch
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.args.size() < 3) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = this.args.remove(0).toString();
        String methodName = this.args.remove(0).toString();
        String typeString = this.args.remove(0).toString().toLowerCase();
        EventRequestSpecList eventRequests = this.proc.getEventRequestSpecs();
        WatchpointSpec er = null;
        if (typeString.equals("for_access")) {
            if (!this.proc.getVM().canWatchFieldAccess()) {
                throw new JDEException("This VM implementation cannot watch field accesses");
            }
            er = eventRequests.createAccessWatchpoint(classPattern, methodName);
        } else if (typeString.equals("for_modification")) {
            if (!this.proc.getVM().canWatchFieldModification()) {
                throw new JDEException("This VM implementation cannot watch field modifications");
            }
            er = eventRequests.createModificationWatchpoint(classPattern, methodName);
        } else {
            throw new JDEException("'" + typeString + "' not understood: use either 'for_access' or 'for_modification'");
        }
        er.setThread(Etc.getThreadFromArgs(this.args));
        er.setExpression(Etc.getExprFromArgs(this.args));
        er.setObjectID(Etc.getObjectIDFromArgs(this.args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.args));
        er.setClassFilters(Etc.getClassFiltersFromArgs(this.args));
        er.setClassExFilters(Etc.getClassExFiltersFromArgs(this.args));
        eventRequests.install(er);
        this.jde.signalCommandResult(this.procID, this.cmdID, er.getID());
    }

    public Object clone() {
        return new Watch();
    }
}

