/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLMetaElement.h"

#include <wtf/GetPtr.h>

#include "HTMLMetaElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLMetaElement)

/* Hash table */

static const HashTableValue JSHTMLMetaElementTableValues[6] =
{
    { "content", DontDelete, (intptr_t)jsHTMLMetaElementContent, (intptr_t)setJSHTMLMetaElementContent },
    { "httpEquiv", DontDelete, (intptr_t)jsHTMLMetaElementHttpEquiv, (intptr_t)setJSHTMLMetaElementHttpEquiv },
    { "name", DontDelete, (intptr_t)jsHTMLMetaElementName, (intptr_t)setJSHTMLMetaElementName },
    { "scheme", DontDelete, (intptr_t)jsHTMLMetaElementScheme, (intptr_t)setJSHTMLMetaElementScheme },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLMetaElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMetaElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLMetaElementTableValues, 0 };
#else
    { 17, 15, JSHTMLMetaElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLMetaElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMetaElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLMetaElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLMetaElementConstructorTableValues, 0 };
#endif

class JSHTMLMetaElementConstructor : public DOMObject {
public:
    JSHTMLMetaElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLMetaElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLMetaElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLMetaElementConstructor::s_info = { "HTMLMetaElementConstructor", 0, &JSHTMLMetaElementConstructorTable, 0 };

bool JSHTMLMetaElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMetaElementConstructor, DOMObject>(exec, &JSHTMLMetaElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMetaElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLMetaElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLMetaElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLMetaElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLMetaElementPrototype::s_info = { "HTMLMetaElementPrototype", 0, &JSHTMLMetaElementPrototypeTable, 0 };

JSObject* JSHTMLMetaElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLMetaElement>(exec);
}

const ClassInfo JSHTMLMetaElement::s_info = { "HTMLMetaElement", &JSHTMLElement::s_info, &JSHTMLMetaElementTable, 0 };

JSHTMLMetaElement::JSHTMLMetaElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLMetaElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLMetaElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLMetaElementPrototype(JSHTMLMetaElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLMetaElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMetaElement, Base>(exec, &JSHTMLMetaElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLMetaElementContent(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(static_cast<JSHTMLMetaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->content());
}

JSValuePtr jsHTMLMetaElementHttpEquiv(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(static_cast<JSHTMLMetaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->httpEquiv());
}

JSValuePtr jsHTMLMetaElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(static_cast<JSHTMLMetaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->name());
}

JSValuePtr jsHTMLMetaElementScheme(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(static_cast<JSHTMLMetaElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->scheme());
}

JSValuePtr jsHTMLMetaElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLMetaElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLMetaElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLMetaElement, Base>(exec, propertyName, value, &JSHTMLMetaElementTable, this, slot);
}

void setJSHTMLMetaElementContent(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(static_cast<JSHTMLMetaElement*>(thisObject)->impl());
    imp->setContent(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLMetaElementHttpEquiv(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(static_cast<JSHTMLMetaElement*>(thisObject)->impl());
    imp->setHttpEquiv(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLMetaElementName(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(static_cast<JSHTMLMetaElement*>(thisObject)->impl());
    imp->setName(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLMetaElementScheme(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLMetaElement* imp = static_cast<HTMLMetaElement*>(static_cast<JSHTMLMetaElement*>(thisObject)->impl());
    imp->setScheme(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLMetaElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLMetaElementConstructor>(exec);
}


}
