/****************************************************************************
**
** Copyright (C) 1992-2008 Trolltech ASA. All rights reserved.
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License versions 2.0 or 3.0 as published by the Free Software
** Foundation and appearing in the files LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file.  Alternatively you may (at
** your option) use any later version of the GNU General Public
** License if such license has been publicly approved by Trolltech ASA
** (or its successors, if any) and the KDE Free Qt Foundation. In
** addition, as a special exception, Trolltech gives you certain
** additional rights. These rights are described in the Trolltech GPL
** Exception version 1.2, which can be found at
** http://www.trolltech.com/products/qt/gplexception/ and in the file
** GPL_EXCEPTION.txt in this package.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/. If
** you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** In addition, as a special exception, Trolltech, as the sole
** copyright holder for Qt Designer, grants users of the Qt/Eclipse
** Integration plug-in the right for the Qt/Eclipse Integration to
** link to functionality provided by Qt Designer and its related
** libraries.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not expressly
** granted herein.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

// This file is auto-generated, do not edit!

static struct {
    const char *layout;
    const char *variant; // 0 means any variant
    Qt::LayoutDirection direction;
    QLocale::Language language;
    QLocale::Country country;
} xkbLayoutData[] = {
    // name = us, description = U.S. English
    { "us", "", Qt::LeftToRight, QLocale::English, QLocale::UnitedStates },
    // name = us:intl, description = U.S. English
    { "us", "intl", Qt::LeftToRight, QLocale::English, QLocale::UnitedStates },
    // name = us:alt-intl, description = U.S. English
    { "us", "alt-intl", Qt::LeftToRight, QLocale::English, QLocale::UnitedStates },
    // name = us:dvorak, description = U.S. English
    { "us", "dvorak", Qt::LeftToRight, QLocale::English, QLocale::UnitedStates },
    // name = us:rus, description = U.S. English
    { "us", "rus", Qt::LeftToRight, QLocale::Russian, QLocale::UnitedStates },
    // name = ara, description = Arabic
    { "ara", "", Qt::RightToLeft, QLocale::Arabic, QLocale::UnitedArabEmirates },
    // name = ara:azerty, description = Arabic
    { "ara", "azerty", Qt::RightToLeft, QLocale::Arabic, QLocale::UnitedArabEmirates },
    // name = ara:azerty_digits, description = Arabic
    { "ara", "azerty_digits", Qt::RightToLeft, QLocale::Arabic, QLocale::UnitedArabEmirates },
    // name = ara:digits, description = Arabic
    { "ara", "digits", Qt::RightToLeft, QLocale::Arabic, QLocale::UnitedArabEmirates },
    // name = ara:qwerty, description = Arabic
    { "ara", "qwerty", Qt::RightToLeft, QLocale::Arabic, QLocale::UnitedArabEmirates },
    // name = ara:qwerty_digits, description = Arabic
    { "ara", "qwerty_digits", Qt::RightToLeft, QLocale::Arabic, QLocale::UnitedArabEmirates },
    // name = al, description = Albania
    { "al", "", Qt::LeftToRight, QLocale::Albanian, QLocale::Albania },
    // name = am, description = Armenia
    { "am", "", Qt::LeftToRight, QLocale::Armenian, QLocale::Armenia },
    // name = am:phonetic, description = Armenia
    { "am", "phonetic", Qt::LeftToRight, QLocale::Armenian, QLocale::Armenia },
    // name = az, description = Azerbaijan
    { "az", "", Qt::LeftToRight, QLocale::Azerbaijani, QLocale::Azerbaijan },
    // name = az:cyrillic, description = Azerbaijan
    { "az", "cyrillic", Qt::LeftToRight, QLocale::Azerbaijani, QLocale::Azerbaijan },
    // name = by, description = Belarus
    { "by", "", Qt::LeftToRight, QLocale::Byelorussian, QLocale::Belarus },
    // name = by:winkeys, description = Belarus
    { "by", "winkeys", Qt::LeftToRight, QLocale::Byelorussian, QLocale::Belarus },
    // name = be, description = Belgium
    { "be", "", Qt::LeftToRight, QLocale::Dutch, QLocale::Belgium },
    // name = be:iso-alternate, description = Belgium
    { "be", "iso-alternate", Qt::LeftToRight, QLocale::Dutch, QLocale::Belgium },
    // name = be:nodeadkeys, description = Belgium
    { "be", "nodeadkeys", Qt::LeftToRight, QLocale::Dutch, QLocale::Belgium },
    // name = be:sundeadkeys, description = Belgium
    { "be", "sundeadkeys", Qt::LeftToRight, QLocale::Dutch, QLocale::Belgium },
    // name = bd, description = Bangladesh
    { "bd", "", Qt::LeftToRight, QLocale::Bengali, QLocale::Bangladesh },
    // name = bd:probhat, description = Bangladesh
    { "bd", "probhat", Qt::LeftToRight, QLocale::Bengali, QLocale::Bangladesh },
    // name = in, description = India
    { "in", "", Qt::LeftToRight, QLocale::Hindi, QLocale::India },
    // name = in:ben, description = India
    { "in", "ben", Qt::LeftToRight, QLocale::Bengali, QLocale::India },
    // name = in:ben_probhat, description = India
    { "in", "ben_probhat", Qt::LeftToRight, QLocale::Bengali, QLocale::India },
    // name = in:guj, description = India
    { "in", "guj", Qt::LeftToRight, QLocale::Gujarati, QLocale::India },
    // name = in:guru, description = India
    { "in", "guru", Qt::LeftToRight, QLocale::Punjabi, QLocale::India },
    // name = in:kan, description = India
    { "in", "kan", Qt::LeftToRight, QLocale::Kannada, QLocale::India },
    // name = in:mal, description = India
    { "in", "mal", Qt::LeftToRight, QLocale::Malayalam, QLocale::India },
    // name = in:ori, description = India
    { "in", "ori", Qt::LeftToRight, QLocale::Oriya, QLocale::India },
    // name = in:tam_unicode, description = India
    { "in", "tam_unicode", Qt::LeftToRight, QLocale::Tamil, QLocale::India },
    // name = in:tam_TAB, description = India
    { "in", "tam_TAB", Qt::LeftToRight, QLocale::Tamil, QLocale::India },
    // name = in:tam_TSCII, description = India
    { "in", "tam_TSCII", Qt::LeftToRight, QLocale::Tamil, QLocale::India },
    // name = in:tam, description = India
    { "in", "tam", Qt::LeftToRight, QLocale::Tamil, QLocale::India },
    // name = in:tel, description = India
    { "in", "tel", Qt::LeftToRight, QLocale::Telugu, QLocale::India },
    // name = in:urd, description = India
    { "in", "urd", Qt::RightToLeft, QLocale::Urdu, QLocale::India },
    // name = ba, description = Bosnia and Herzegovina
    { "ba", "", Qt::LeftToRight, QLocale::Bosnian, QLocale::BosniaAndHerzegowina },
    // name = br, description = Brazil
    { "br", "", Qt::LeftToRight, QLocale::Portuguese, QLocale::Brazil },
    // name = br:nodeadkeys, description = Brazil
    { "br", "nodeadkeys", Qt::LeftToRight, QLocale::Portuguese, QLocale::Brazil },
    // name = bg, description = Bulgaria
    { "bg", "", Qt::LeftToRight, QLocale::Bulgarian, QLocale::Bulgaria },
    // name = bg:phonetic, description = Bulgaria
    { "bg", "phonetic", Qt::LeftToRight, QLocale::Bulgarian, QLocale::Bulgaria },
    // name = mm, description = Myanmar
    { "mm", "", Qt::LeftToRight, QLocale::Burmese, QLocale::Myanmar },
    // name = ca, description = Canada
    { "ca", "", Qt::LeftToRight, QLocale::English, QLocale::Canada },
    // name = ca:fr-dvorak, description = Canada
    { "ca", "fr-dvorak", Qt::LeftToRight, QLocale::French, QLocale::Canada },
    // name = ca:fr-legacy, description = Canada
    { "ca", "fr-legacy", Qt::LeftToRight, QLocale::French, QLocale::Canada },
    // name = ca:multi, description = Canada
    { "ca", "multi", Qt::LeftToRight, QLocale::English, QLocale::Canada },
    // name = ca:multi-2gr, description = Canada
    { "ca", "multi-2gr", Qt::LeftToRight, QLocale::English, QLocale::Canada },
    // name = ca:ike, description = Canada
    { "ca", "ike", Qt::LeftToRight, QLocale::Inuktitut, QLocale::Canada },
    // name = hr, description = Croatia
    { "hr", "", Qt::LeftToRight, QLocale::Croatian, QLocale::Croatia },
    // name = hr:us, description = Croatia
    { "hr", "us", Qt::LeftToRight, QLocale::Croatian, QLocale::Croatia },
    // name = cz, description = Czechia
    { "cz", "", Qt::LeftToRight, QLocale::Czech, QLocale::CzechRepublic },
    // name = cz:bksl, description = Czechia
    { "cz", "bksl", Qt::LeftToRight, QLocale::Czech, QLocale::CzechRepublic },
    // name = cz:qwerty, description = Czechia
    { "cz", "qwerty", Qt::LeftToRight, QLocale::Czech, QLocale::CzechRepublic },
    // name = cz:qwerty_bksl, description = Czechia
    { "cz", "qwerty_bksl", Qt::LeftToRight, QLocale::Czech, QLocale::CzechRepublic },
    // name = dk, description = Denmark
    { "dk", "", Qt::LeftToRight, QLocale::Danish, QLocale::Denmark },
    // name = dk:nodeadkeys, description = Denmark
    { "dk", "nodeadkeys", Qt::LeftToRight, QLocale::Danish, QLocale::Denmark },
    // name = nl, description = Netherlands
    { "nl", "", Qt::LeftToRight, QLocale::Dutch, QLocale::Netherlands },
    // name = bt, description = Bhutan
    { "bt", "", Qt::LeftToRight, QLocale::Bhutani, QLocale::Bhutan },
    // name = ee, description = Estonia
    { "ee", "", Qt::LeftToRight, QLocale::Estonian, QLocale::Estonia },
    // name = ee:nodeadkeys, description = Estonia
    { "ee", "nodeadkeys", Qt::LeftToRight, QLocale::Estonian, QLocale::Estonia },
    // name = ir, description = Iran
    { "ir", "", Qt::RightToLeft, QLocale::Persian, QLocale::Iran },
    // name = fo, description = Faroe Islands
    { "fo", "", Qt::LeftToRight, QLocale::Faroese, QLocale::FaroeIslands },
    // name = fo:nodeadkeys, description = Faroe Islands
    { "fo", "nodeadkeys", Qt::LeftToRight, QLocale::Faroese, QLocale::FaroeIslands },
    // name = fi, description = Finland
    { "fi", "", Qt::LeftToRight, QLocale::Finnish, QLocale::Finland },
    // name = fi:nodeadkeys, description = Finland
    { "fi", "nodeadkeys", Qt::LeftToRight, QLocale::Finnish, QLocale::Finland },
    // name = fi:smi, description = Finland
    { "fi", "smi", Qt::LeftToRight, QLocale::Finnish, QLocale::Finland },
    // name = fr, description = France
    { "fr", "", Qt::LeftToRight, QLocale::French, QLocale::France },
    // name = fr:nodeadkeys, description = France
    { "fr", "nodeadkeys", Qt::LeftToRight, QLocale::French, QLocale::France },
    // name = fr:sundeadkeys, description = France
    { "fr", "sundeadkeys", Qt::LeftToRight, QLocale::French, QLocale::France },
    // name = fr:latin9, description = France
    { "fr", "latin9", Qt::LeftToRight, QLocale::French, QLocale::France },
    // name = fr:latin9_nodeadkeys, description = France
    { "fr", "latin9_nodeadkeys", Qt::LeftToRight, QLocale::French, QLocale::France },
    // name = fr:latin9_sundeadkeys, description = France
    { "fr", "latin9_sundeadkeys", Qt::LeftToRight, QLocale::French, QLocale::France },
    // name = fr:dvorak, description = France
    { "fr", "dvorak", Qt::LeftToRight, QLocale::French, QLocale::France },
    // name = ge, description = Georgia
    { "ge", "", Qt::LeftToRight, QLocale::Georgian, QLocale::Georgia },
    // name = ge:ru, description = Georgia
    { "ge", "ru", Qt::LeftToRight, QLocale::Russian, QLocale::Georgia },
    // name = de, description = Germany
    { "de", "", Qt::LeftToRight, QLocale::German, QLocale::Germany },
    // name = de:deadacute, description = Germany
    { "de", "deadacute", Qt::LeftToRight, QLocale::German, QLocale::Germany },
    // name = de:deadgraveacute, description = Germany
    { "de", "deadgraveacute", Qt::LeftToRight, QLocale::German, QLocale::Germany },
    // name = de:nodeadkeys, description = Germany
    { "de", "nodeadkeys", Qt::LeftToRight, QLocale::German, QLocale::Germany },
    // name = de:ro, description = Germany
    { "de", "ro", Qt::LeftToRight, QLocale::Romanian, QLocale::Germany },
    // name = de:ro_nodeadkeys, description = Germany
    { "de", "ro_nodeadkeys", Qt::LeftToRight, QLocale::Romanian, QLocale::Germany },
    // name = de:dvorak, description = Germany
    { "de", "dvorak", Qt::LeftToRight, QLocale::German, QLocale::Germany },
    // name = gr, description = Greece
    { "gr", "", Qt::LeftToRight, QLocale::Greek, QLocale::Greece },
    // name = gr:extended, description = Greece
    { "gr", "extended", Qt::LeftToRight, QLocale::Greek, QLocale::Greece },
    // name = gr:nodeadkeys, description = Greece
    { "gr", "nodeadkeys", Qt::LeftToRight, QLocale::Greek, QLocale::Greece },
    // name = gr:polytonic, description = Greece
    { "gr", "polytonic", Qt::LeftToRight, QLocale::Greek, QLocale::Greece },
    // name = hu, description = Hungary
    { "hu", "", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:standard, description = Hungary
    { "hu", "standard", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:nodeadkeys, description = Hungary
    { "hu", "nodeadkeys", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:qwerty, description = Hungary
    { "hu", "qwerty", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:101_qwertz_comma_dead, description = Hungary
    { "hu", "101_qwertz_comma_dead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:101_qwertz_comma_nodead, description = Hungary
    { "hu", "101_qwertz_comma_nodead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:101_qwertz_dot_dead, description = Hungary
    { "hu", "101_qwertz_dot_dead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:101_qwertz_dot_nodead, description = Hungary
    { "hu", "101_qwertz_dot_nodead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:101_qwerty_comma_dead, description = Hungary
    { "hu", "101_qwerty_comma_dead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:101_qwerty_comma_nodead, description = Hungary
    { "hu", "101_qwerty_comma_nodead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:101_qwerty_dot_dead, description = Hungary
    { "hu", "101_qwerty_dot_dead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:101_qwerty_dot_nodead, description = Hungary
    { "hu", "101_qwerty_dot_nodead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:102_qwertz_comma_dead, description = Hungary
    { "hu", "102_qwertz_comma_dead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:102_qwertz_comma_nodead, description = Hungary
    { "hu", "102_qwertz_comma_nodead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:102_qwertz_dot_dead, description = Hungary
    { "hu", "102_qwertz_dot_dead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:102_qwertz_dot_nodead, description = Hungary
    { "hu", "102_qwertz_dot_nodead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:102_qwerty_comma_dead, description = Hungary
    { "hu", "102_qwerty_comma_dead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:102_qwerty_comma_nodead, description = Hungary
    { "hu", "102_qwerty_comma_nodead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:102_qwerty_dot_dead, description = Hungary
    { "hu", "102_qwerty_dot_dead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = hu:102_qwerty_dot_nodead, description = Hungary
    { "hu", "102_qwerty_dot_nodead", Qt::LeftToRight, QLocale::Hungarian, QLocale::Hungary },
    // name = is, description = Iceland
    { "is", "", Qt::LeftToRight, QLocale::Icelandic, QLocale::Iceland },
    // name = is:Sundeadkeys, description = Iceland
    { "is", "Sundeadkeys", Qt::LeftToRight, QLocale::Icelandic, QLocale::Iceland },
    // name = is:nodeadkeys, description = Iceland
    { "is", "nodeadkeys", Qt::LeftToRight, QLocale::Icelandic, QLocale::Iceland },
    // name = il, description = Israel
    { "il", "", Qt::LeftToRight, QLocale::Hebrew, QLocale::Israel },
    // name = il:lyx, description = Israel
    { "il", "lyx", Qt::LeftToRight, QLocale::Hebrew, QLocale::Israel },
    // name = il:si1452, description = Israel
    { "il", "si1452", Qt::LeftToRight, QLocale::Hebrew, QLocale::Israel },
    // name = il:phonetic, description = Israel
    { "il", "phonetic", Qt::LeftToRight, QLocale::Hebrew, QLocale::Israel },
    // name = it, description = Italy
    { "it", "", Qt::LeftToRight, QLocale::Italian, QLocale::Italy },
    // name = it:nodeadkeys, description = Italy
    { "it", "nodeadkeys", Qt::LeftToRight, QLocale::Italian, QLocale::Italy },
    // name = jp, description = Japan
    { "jp", "", Qt::LeftToRight, QLocale::Japanese, QLocale::Japan },
    // name = kg, description = Kyrgyzstan
    { "kg", "", Qt::LeftToRight, QLocale::Kirghiz, QLocale::Kyrgyzstan },
    // name = la, description = Laos
    { "la", "", Qt::LeftToRight, QLocale::Laothian, QLocale::Lao },
    // name = latam, description = Latin American
    { "latam", "", Qt::LeftToRight, QLocale::Spanish, QLocale::Mexico },
    // name = latam:nodeadkeys, description = Latin American
    { "latam", "nodeadkeys", Qt::LeftToRight, QLocale::Spanish, QLocale::Mexico },
    // name = latam:sundeadkeys, description = Latin American
    { "latam", "sundeadkeys", Qt::LeftToRight, QLocale::Spanish, QLocale::Mexico },
    // name = lt, description = Lithuania
    { "lt", "", Qt::LeftToRight, QLocale::Lithuanian, QLocale::Lithuania },
    // name = lt:std, description = Lithuania
    { "lt", "std", Qt::LeftToRight, QLocale::Lithuanian, QLocale::Lithuania },
    // name = lt:us, description = Lithuania
    { "lt", "us", Qt::LeftToRight, QLocale::Lithuanian, QLocale::Lithuania },
    // name = lv, description = Latvia
    { "lv", "", Qt::LeftToRight, QLocale::Latvian, QLocale::Latvia },
    // name = lv:apostrophe, description = Latvia
    { "lv", "apostrophe", Qt::LeftToRight, QLocale::Latvian, QLocale::Latvia },
    // name = lv:tilde, description = Latvia
    { "lv", "tilde", Qt::LeftToRight, QLocale::Latvian, QLocale::Latvia },
    // name = lv:fkey, description = Latvia
    { "lv", "fkey", Qt::LeftToRight, QLocale::Latvian, QLocale::Latvia },
    // name = mao, description = Maori
    { "mao", "", Qt::LeftToRight, QLocale::Maori, QLocale::NewZealand },
    // name = mkd, description = Macedonian
    { "mkd", "", Qt::LeftToRight, QLocale::Macedonian, QLocale::Macedonia },
    // name = mkd:nodeadkeys, description = Macedonian
    { "mkd", "nodeadkeys", Qt::LeftToRight, QLocale::Macedonian, QLocale::Macedonia },
    // name = mt, description = Malta
    { "mt", "", Qt::LeftToRight, QLocale::Maltese, QLocale::Malta },
    // name = mt:us, description = Malta
    { "mt", "us", Qt::LeftToRight, QLocale::Maltese, QLocale::Malta },
    // name = mn, description = Mongolia
    { "mn", "", Qt::LeftToRight, QLocale::Mongolian, QLocale::Mongolia },
    // name = no, description = Norway
    { "no", "", Qt::LeftToRight, QLocale::Norwegian, QLocale::Norway },
    // name = no:nodeadkeys, description = Norway
    { "no", "nodeadkeys", Qt::LeftToRight, QLocale::Norwegian, QLocale::Norway },
    // name = no:dvorak, description = Norway
    { "no", "dvorak", Qt::LeftToRight, QLocale::Norwegian, QLocale::Norway },
    // name = no:smi, description = Norway
    { "no", "smi", Qt::LeftToRight, QLocale::Norwegian, QLocale::Norway },
    // name = no:smi_nodeadkeys, description = Norway
    { "no", "smi_nodeadkeys", Qt::LeftToRight, QLocale::Norwegian, QLocale::Norway },
    // name = pl, description = Poland
    { "pl", "", Qt::LeftToRight, QLocale::Polish, QLocale::Poland },
    // name = pl:qwertz, description = Poland
    { "pl", "qwertz", Qt::LeftToRight, QLocale::Polish, QLocale::Poland },
    // name = pl:dvorak, description = Poland
    { "pl", "dvorak", Qt::LeftToRight, QLocale::Polish, QLocale::Poland },
    // name = pl:dvorak_quotes, description = Poland
    { "pl", "dvorak_quotes", Qt::LeftToRight, QLocale::Polish, QLocale::Poland },
    // name = pl:dvorak_altquotes, description = Poland
    { "pl", "dvorak_altquotes", Qt::LeftToRight, QLocale::Polish, QLocale::Poland },
    // name = pt, description = Portugal
    { "pt", "", Qt::LeftToRight, QLocale::Portuguese, QLocale::Portugal },
    // name = pt:nodeadkeys, description = Portugal
    { "pt", "nodeadkeys", Qt::LeftToRight, QLocale::Portuguese, QLocale::Portugal },
    // name = pt:sundeadkeys, description = Portugal
    { "pt", "sundeadkeys", Qt::LeftToRight, QLocale::Portuguese, QLocale::Portugal },
    // name = ro, description = Romania
    { "ro", "", Qt::LeftToRight, QLocale::Romanian, QLocale::Romania },
    // name = ro:us, description = Romania
    { "ro", "us", Qt::LeftToRight, QLocale::English, QLocale::Romania },
    // name = ro:de, description = Romania
    { "ro", "de", Qt::LeftToRight, QLocale::German, QLocale::Romania },
    // name = ru, description = Russia
    { "ru", "", Qt::LeftToRight, QLocale::Russian, QLocale::RussianFederation },
    // name = ru:phonetic, description = Russia
    { "ru", "phonetic", Qt::LeftToRight, QLocale::Russian, QLocale::RussianFederation },
    // name = ru:typewriter, description = Russia
    { "ru", "typewriter", Qt::LeftToRight, QLocale::Russian, QLocale::RussianFederation },
    // name = ru:winkeys, description = Russia
    { "ru", "winkeys", Qt::LeftToRight, QLocale::Russian, QLocale::RussianFederation },
    // name = srp, description = Serbian
    { "srp", "", Qt::LeftToRight, QLocale::Serbian, QLocale::SerbiaAndMontenegro },
    // name = srp:yz, description = Serbian
    { "srp", "yz", Qt::LeftToRight, QLocale::Serbian, QLocale::SerbiaAndMontenegro },
    // name = srp:latin, description = Serbian
    { "srp", "latin", Qt::LeftToRight, QLocale::Serbian, QLocale::SerbiaAndMontenegro },
    // name = srp:latinunicode, description = Serbian
    { "srp", "latinunicode", Qt::LeftToRight, QLocale::Serbian, QLocale::SerbiaAndMontenegro },
    // name = srp:latinyz, description = Serbian
    { "srp", "latinyz", Qt::LeftToRight, QLocale::Serbian, QLocale::SerbiaAndMontenegro },
    // name = srp:latinunicodeyz, description = Serbian
    { "srp", "latinunicodeyz", Qt::LeftToRight, QLocale::Serbian, QLocale::SerbiaAndMontenegro },
    // name = srp:alternatequotes, description = Serbian
    { "srp", "alternatequotes", Qt::LeftToRight, QLocale::Serbian, QLocale::SerbiaAndMontenegro },
    // name = srp:latinalternatequotes, description = Serbian
    { "srp", "latinalternatequotes", Qt::LeftToRight, QLocale::Serbian, QLocale::SerbiaAndMontenegro },
    // name = si, description = Slovenia
    { "si", "", Qt::LeftToRight, QLocale::Slovenian, QLocale::Slovenia },
    // name = sk, description = Slovakia
    { "sk", "", Qt::LeftToRight, QLocale::Slovak, QLocale::Slovakia },
    // name = sk:bksl, description = Slovakia
    { "sk", "bksl", Qt::LeftToRight, QLocale::Slovak, QLocale::Slovakia },
    // name = sk:qwerty, description = Slovakia
    { "sk", "qwerty", Qt::LeftToRight, QLocale::Slovak, QLocale::Slovakia },
    // name = sk:qwerty_bksl, description = Slovakia
    { "sk", "qwerty_bksl", Qt::LeftToRight, QLocale::Slovak, QLocale::Slovakia },
    // name = es, description = Spain
    { "es", "", Qt::LeftToRight, QLocale::Spanish, QLocale::Spain },
    // name = es:nodeadkeys, description = Spain
    { "es", "nodeadkeys", Qt::LeftToRight, QLocale::Spanish, QLocale::Spain },
    // name = es:sundeadkeys, description = Spain
    { "es", "sundeadkeys", Qt::LeftToRight, QLocale::Spanish, QLocale::Spain },
    // name = es:dvorak, description = Spain
    { "es", "dvorak", Qt::LeftToRight, QLocale::Spanish, QLocale::Spain },
    // name = se, description = Sweden
    { "se", "", Qt::LeftToRight, QLocale::Swedish, QLocale::Sweden },
    // name = se:nodeadkeys, description = Sweden
    { "se", "nodeadkeys", Qt::LeftToRight, QLocale::Swedish, QLocale::Sweden },
    // name = se:dvorak, description = Sweden
    { "se", "dvorak", Qt::LeftToRight, QLocale::Swedish, QLocale::Sweden },
    // name = se:rus, description = Sweden
    { "se", "rus", Qt::LeftToRight, QLocale::Russian, QLocale::Sweden },
    // name = se:rus_nodeadkeys, description = Sweden
    { "se", "rus_nodeadkeys", Qt::LeftToRight, QLocale::Russian, QLocale::Sweden },
    // name = se:smi, description = Sweden
    { "se", "smi", Qt::LeftToRight, QLocale::Swedish, QLocale::Sweden },
    // name = ch, description = Switzerland
    { "ch", "", Qt::LeftToRight, QLocale::German, QLocale::Switzerland },
    // name = ch:de_nodeadkeys, description = Switzerland
    { "ch", "de_nodeadkeys", Qt::LeftToRight, QLocale::German, QLocale::Switzerland },
    // name = ch:de_sundeadkeys, description = Switzerland
    { "ch", "de_sundeadkeys", Qt::LeftToRight, QLocale::German, QLocale::Switzerland },
    // name = ch:fr, description = Switzerland
    { "ch", "fr", Qt::LeftToRight, QLocale::French, QLocale::Switzerland },
    // name = ch:fr_nodeadkeys, description = Switzerland
    { "ch", "fr_nodeadkeys", Qt::LeftToRight, QLocale::French, QLocale::Switzerland },
    // name = ch:fr_sundeadkeys, description = Switzerland
    { "ch", "fr_sundeadkeys", Qt::LeftToRight, QLocale::French, QLocale::Switzerland },
    // name = sy, description = Syria
    { "sy", "", Qt::RightToLeft, QLocale::Arabic, QLocale::SyrianArabRepublic },
    // name = sy:syc, description = Syria
    { "sy", "syc", Qt::RightToLeft, QLocale::Arabic, QLocale::SyrianArabRepublic },
    // name = sy:syc_phonetic, description = Syria
    { "sy", "syc_phonetic", Qt::RightToLeft, QLocale::Arabic, QLocale::SyrianArabRepublic },
    // name = tj, description = Tajikistan
    { "tj", "", Qt::LeftToRight, QLocale::Tajik, QLocale::Tajikistan },
    // name = lk, description = Sri Lanka
    { "lk", "", Qt::LeftToRight, QLocale::Singhalese, QLocale::SriLanka },
    // name = lk:tam_unicode, description = Sri Lanka
    { "lk", "tam_unicode", Qt::LeftToRight, QLocale::Tamil, QLocale::SriLanka },
    // name = lk:tam_TAB, description = Sri Lanka
    { "lk", "tam_TAB", Qt::LeftToRight, QLocale::Tamil, QLocale::SriLanka },
    // name = lk:tam_TSCII, description = Sri Lanka
    { "lk", "tam_TSCII", Qt::LeftToRight, QLocale::Tamil, QLocale::SriLanka },
    // name = lk:sin_phonetic, description = Sri Lanka
    { "lk", "sin_phonetic", Qt::LeftToRight, QLocale::Singhalese, QLocale::SriLanka },
    // name = th, description = Thailand
    { "th", "", Qt::LeftToRight, QLocale::Thai, QLocale::Thailand },
    // name = th:tis, description = Thailand
    { "th", "tis", Qt::LeftToRight, QLocale::Thai, QLocale::Thailand },
    // name = th:pat, description = Thailand
    { "th", "pat", Qt::LeftToRight, QLocale::Thai, QLocale::Thailand },
    // name = tr, description = Turkish 
    { "tr", "", Qt::LeftToRight, QLocale::Turkish, QLocale::Turkey },
    // name = tr:f, description = Turkish 
    { "tr", "f", Qt::LeftToRight, QLocale::Turkish, QLocale::Turkey },
    // name = tr:alt, description = Turkish 
    { "tr", "alt", Qt::LeftToRight, QLocale::Turkish, QLocale::Turkey },
    // name = ua, description = Ukraine
    { "ua", "", Qt::LeftToRight, QLocale::Ukrainian, QLocale::Ukraine },
    // name = ua:phonetic, description = Ukraine
    { "ua", "phonetic", Qt::LeftToRight, QLocale::Ukrainian, QLocale::Ukraine },
    // name = ua:typewriter, description = Ukraine
    { "ua", "typewriter", Qt::LeftToRight, QLocale::Ukrainian, QLocale::Ukraine },
    // name = ua:winkeys, description = Ukraine
    { "ua", "winkeys", Qt::LeftToRight, QLocale::Ukrainian, QLocale::Ukraine },
    // name = ua:rstu, description = Ukraine
    { "ua", "rstu", Qt::LeftToRight, QLocale::Ukrainian, QLocale::Ukraine },
    // name = ua:rstu_ru, description = Ukraine
    { "ua", "rstu_ru", Qt::LeftToRight, QLocale::Ukrainian, QLocale::Ukraine },
    // name = gb, description = United Kingdom
    { "gb", "", Qt::LeftToRight, QLocale::English, QLocale::UnitedKingdom },
    // name = gb:intl, description = United Kingdom
    { "gb", "intl", Qt::LeftToRight, QLocale::English, QLocale::UnitedKingdom },
    // name = gb:dvorak, description = United Kingdom
    { "gb", "dvorak", Qt::LeftToRight, QLocale::English, QLocale::UnitedKingdom },
    // name = uz, description = Uzbekistan
    { "uz", "", Qt::LeftToRight, QLocale::Uzbek, QLocale::Uzbekistan },
    // name = vn, description = Vietnam
    { "vn", "", Qt::LeftToRight, QLocale::Vietnamese, QLocale::VietNam },
    // name = nec_vndr/jp, description = PC-98xx Series
    { "nec_vndr/jp", "", Qt::LeftToRight, QLocale::Japanese, QLocale::Japan },
    // name = ie, description = Ireland
    { "ie", "", Qt::LeftToRight, QLocale::Irish, QLocale::Ireland },
    // name = ie:CloGaelach, description = Ireland
    { "ie", "CloGaelach", Qt::LeftToRight, QLocale::Gaelic, QLocale::Ireland },
    // name = ie:UnicodeExpert, description = Ireland
    { "ie", "UnicodeExpert", Qt::LeftToRight, QLocale::Irish, QLocale::Ireland },
    // name = ie:ogam, description = Ireland
    { "ie", "ogam", Qt::LeftToRight, QLocale::Gaelic, QLocale::Ireland },
    // name = ie:ogam_is434, description = Ireland
    { "ie", "ogam_is434", Qt::LeftToRight, QLocale::Gaelic, QLocale::Ireland },
    // name = pk, description = Pakistan
    { "pk", "", Qt::RightToLeft, QLocale::Urdu, QLocale::Pakistan },
    { 0, 0, Qt::LeftToRight, QLocale::C, QLocale::AnyCountry }
};
