/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock.normalizer;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.HeaderRxBlock;
import com.monstarmike.tlmreader.datablock.RxBlock;
import com.monstarmike.tlmreader.datablock.normalizer.DataNormalizer;
import com.monstarmike.tlmreader.datablock.normalizer.processor.DebugOutputProcessor;
import com.monstarmike.tlmreader.datablock.normalizer.processor.DiscountinuousBlocksProcessor;
import com.monstarmike.tlmreader.datablock.normalizer.processor.InvalidCountsProcessor;
import com.monstarmike.tlmreader.datablock.normalizer.processor.InvalidDataBlocksProcessor;
import com.monstarmike.tlmreader.datablock.normalizer.processor.ProcessorEvaluator;
import com.monstarmike.tlmreader.datablock.normalizer.processor.SpectrumTelemetryDetector;
import java.util.List;

public class SignalNormalizer
implements DataNormalizer {
    private final HeaderRxBlock headerRxBlock;

    public SignalNormalizer(HeaderRxBlock headerRxBlock) {
        this.headerRxBlock = headerRxBlock;
    }

    @Override
    public void normalize(List<DataBlock> dataBlocks) {
        ProcessorEvaluator<RxBlock> evaluator = new ProcessorEvaluator<RxBlock>();
        evaluator.registerProcessor(new DebugOutputProcessor());
        evaluator.registerProcessor(new InvalidDataBlocksProcessor());
        evaluator.registerProcessor(new DiscountinuousBlocksProcessor());
        evaluator.registerProcessor(new InvalidCountsProcessor());
        SpectrumTelemetryDetector detectSpectrumTelemetry = new SpectrumTelemetryDetector();
        evaluator.registerProcessor(detectSpectrumTelemetry);
        evaluator.process(dataBlocks);
        this.headerRxBlock.setSpectrumTelemetrySystem(detectSpectrumTelemetry.isSpectrumTelemetry());
    }
}

