/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCHITTESTINFO;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;
    static final long TabFolderProc;
    static final TCHAR TabFolderClass;
    boolean createdAsRTL;
    static final int ID_UPDOWN = 1;

    static {
        TabFolderClass = new TCHAR(0, "SysTabControl32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, TabFolderClass, lpWndClass);
        TabFolderProc = lpWndClass.lpfnWndProc;
        lpWndClass.hInstance = OS.GetModuleHandle(null);
        lpWndClass.style &= 0xFFFFBFFC;
        OS.RegisterClass(TabFolderClass, lpWndClass);
    }

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.CallWindowProc(TabFolderProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        Point size = super.computeSizeInPixels(wHint, hHint, changed2);
        RECT insetRect = new RECT();
        RECT itemRect = new RECT();
        OS.SendMessage(this.handle, 4904, 0L, insetRect);
        int width = insetRect.left - insetRect.right;
        int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        if (count != 0) {
            OS.SendMessage(this.handle, 4874, (long)(count - 1), itemRect);
            width = Math.max(width, itemRect.right - insetRect.right);
        }
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, width, size.y);
        OS.SendMessage(this.handle, 4904, 1L, rect);
        int border = this.getBorderWidthInPixels();
        rect.left -= border;
        rect.right += border;
        width = rect.right - rect.left;
        size.x = Math.max(width, size.x);
        return size;
    }

    @Override
    Rectangle computeTrimInPixels(int x2, int y2, int width, int height) {
        this.checkWidget();
        RECT rect = new RECT();
        OS.SetRect(rect, x2, y2, x2 + width, y2 + height);
        OS.SendMessage(this.handle, 4904, 1L, rect);
        int border = this.getBorderWidthInPixels();
        rect.left -= border;
        rect.right += border;
        rect.top -= border;
        rect.bottom += border;
        int newWidth = rect.right - rect.left;
        int newHeight = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, newWidth, newHeight);
    }

    void createItem(TabItem item2, int index) {
        TCITEM tcItem;
        int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        if (OS.SendMessage(this.handle, 4926, (long)index, tcItem = new TCITEM()) == -1L) {
            this.error(14);
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item2;
        if (count == 0) {
            Event event = new Event();
            event.item = this.items[0];
            this.sendSelectionEvent(13, event, true);
        }
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        long hwndToolTip = OS.SendMessage(this.handle, 4909, 0L, 0L);
        OS.SendMessage(hwndToolTip, 1048, 0L, 32767L);
        this.createdAsRTL = (this.style & 0x4000000) != 0;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem item2) {
        int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        int index = 0;
        while (index < count) {
            if (this.items[index] == item2) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        int selectionIndex = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (OS.SendMessage(this.handle, 4872, (long)index, 0L) == 0L) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4867, 0L, 0L);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.items = new TabItem[4];
        }
        if (count > 0 && index == selectionIndex) {
            this.setSelection(Math.max(0, selectionIndex - 1), true);
        }
    }

    @Override
    void drawThemeBackground(long hDC, long hwnd, RECT rect) {
        RECT rect2 = new RECT();
        OS.GetClientRect(this.handle, rect2);
        OS.MapWindowPoints(this.handle, hwnd, rect2, 2);
        if (OS.IntersectRect(new RECT(), rect2, rect)) {
            OS.DrawThemeBackground(this.display.hTabTheme(), hDC, 10, 0, rect2, null);
        }
    }

    @Override
    Control findThemeControl() {
        return this;
    }

    @Override
    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        OS.GetClientRect(this.handle, rect);
        OS.SendMessage(this.handle, 4904, 0L, rect);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, width, height);
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TCHITTESTINFO pinfo = new TCHITTESTINFO();
        pinfo.x = point.x;
        pinfo.y = point.y;
        int index = (int)OS.SendMessage(this.handle, 4877, 0L, pinfo);
        if (index == -1) {
            return null;
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        TabItem[] result2 = new TabItem[count];
        System.arraycopy(this.items, 0, result2, 0, count);
        return result2;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -1;
        }
        if (this.imageList == null) {
            Rectangle bounds = image.getBoundsInPixels();
            this.imageList = this.display.getImageList(this.style & 0x4000000, bounds.width, bounds.height);
            int index = this.imageList.add(image);
            long hImageList = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0L, hImageList);
            return index;
        }
        int index = this.imageList.indexOf(image);
        if (index == -1) {
            index = this.imageList.add(image);
        } else {
            this.imageList.put(index, image);
        }
        return index;
    }

    public int indexOf(TabItem item2) {
        this.checkWidget();
        if (item2 == null) {
            this.error(4);
        }
        int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        int i2 = 0;
        while (i2 < count) {
            if (this.items[i2] == item2) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    @Override
    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i2 = 0;
        while (i2 < children.length) {
            Control child = children[i2];
            int index = 0;
            int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = DPIUtil.autoScaleUp(child.getBounds());
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = DPIUtil.autoScaleUp(child.computeSize(DPIUtil.autoScaleDown(wHint), DPIUtil.autoScaleDown(hHint), flushCache));
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i2;
        }
        return new Point(width, height);
    }

    @Override
    boolean mnemonicHit(char key2) {
        int i2 = 0;
        while (i2 < this.items.length) {
            TabItem item2 = this.items[i2];
            if (item2 != null) {
                char ch = this.findMnemonic(item2.getText());
                if (Character.toUpperCase(key2) == Character.toUpperCase(ch) && this.forceFocus()) {
                    if (i2 != this.getSelectionIndex()) {
                        this.setSelection(i2, true);
                    }
                    return true;
                }
            }
            ++i2;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key2) {
        int i2 = 0;
        while (i2 < this.items.length) {
            TabItem item2 = this.items[i2];
            if (item2 != null) {
                char ch = this.findMnemonic(item2.getText());
                if (Character.toUpperCase(key2) == Character.toUpperCase(ch)) {
                    return true;
                }
            }
            ++i2;
        }
        return false;
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
            int i2 = 0;
            while (i2 < count) {
                TabItem item2 = this.items[i2];
                if (item2 != null && !item2.isDisposed()) {
                    item2.release(false);
                }
                ++i2;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4867, 0L, 0L);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        int i2 = 0;
        while (i2 < count) {
            TabItem item2 = this.items[i2];
            if (item2.control == control) {
                item2.setControl(null);
            }
            ++i2;
        }
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
            int i2 = 0;
            while (i2 < count) {
                TabItem item2 = this.items[i2];
                if (item2 != null) {
                    item2.reskin(flags);
                }
                ++i2;
            }
        }
        super.reskinChildren(flags);
    }

    public void setSelection(TabItem item2) {
        this.checkWidget();
        if (item2 == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item2});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i2 = items.length - 1;
            while (i2 >= 0) {
                int index = this.indexOf(items[i2]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i2;
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        Rectangle oldRect = this.getClientAreaInPixels();
        super.setFont(font);
        Rectangle newRect = this.getClientAreaInPixels();
        if (!oldRect.equals(newRect)) {
            this.sendResize();
            int index = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
            if (index != -1) {
                TabItem item2 = this.items[index];
                Control control = item2.control;
                if (control != null && !control.isDisposed()) {
                    control.setBoundsInPixels(this.getClientAreaInPixels());
                }
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        int count = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        if (index < 0 || index >= count) {
            return;
        }
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        int oldIndex = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (oldIndex == index) {
            return;
        }
        if (oldIndex != -1) {
            TabItem item2 = this.items[oldIndex];
            Control control = item2.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        OS.SendMessage(this.handle, 4876, (long)index, 0L);
        int newIndex = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (newIndex != -1) {
            TabItem item3 = this.items[newIndex];
            Control control = item3.control;
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item3;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        if (super.updateTextDirection(textDirection)) {
            if (textDirection != 0x6000000) {
                textDirection = this.style & Integer.MIN_VALUE;
            }
            int i2 = 0;
            int n2 = this.items.length;
            while (i2 < n2 && this.items[i2] != null) {
                this.items[i2].updateTextDirection(textDirection);
                ++i2;
            }
            return true;
        }
        return false;
    }

    @Override
    String toolTipText(NMTTDISPINFO hdr) {
        if ((hdr.uFlags & 1) != 0) {
            return null;
        }
        int index = (int)hdr.idFrom;
        long hwndToolTip = OS.SendMessage(this.handle, 4909, 0L, 0L);
        if (hwndToolTip == hdr.hwndFrom) {
            TabItem item2;
            int flags = -2080374784;
            hdr.uFlags = (this.style & flags) != 0 && (this.style & flags) != flags ? (hdr.uFlags |= 4) : (hdr.uFlags &= 0xFFFFFFFB);
            if (this.toolTipText != null) {
                return "";
            }
            if (index >= 0 && index < this.items.length && (item2 = this.items[index]) != null) {
                return item2.toolTipText;
            }
        }
        return super.toolTipText(hdr);
    }

    @Override
    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count <= 1) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true);
        if (index == this.getSelectionIndex()) {
            OS.SendMessage(this.handle, 295, 3L, 0L);
            return true;
        }
        return false;
    }

    @Override
    void updateOrientation() {
        super.updateOrientation();
        long hwndChild = OS.GetWindow(this.handle, 5);
        while (hwndChild != 0L) {
            char[] buffer = new char[128];
            int length = OS.GetClassName(hwndChild, buffer, buffer.length);
            String className = new String(buffer, 0, length);
            if (className.equals("msctls_updown32")) {
                int bits = OS.GetWindowLong(hwndChild, -20);
                bits = (this.style & 0x4000000) != 0 ? (bits |= 0x400000) : (bits &= 0xFFBFFFFF);
                OS.SetWindowLong(hwndChild, -20, bits &= 0xFFFFDFFF);
                OS.InvalidateRect(hwndChild, null, true);
                break;
            }
            hwndChild = OS.GetWindow(hwndChild, 2);
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        OS.SetWindowPos(this.handle, 0L, 0, 0, width - 1, height - 1, 6);
        OS.SetWindowPos(this.handle, 0L, 0, 0, width, height, 6);
        if (this.imageList != null) {
            Point size = this.imageList.getImageSize();
            this.display.releaseImageList(this.imageList);
            this.imageList = this.display.getImageList(this.style & 0x4000000, size.x, size.y);
            long hImageList = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0L, hImageList);
            TCITEM tcItem = new TCITEM();
            tcItem.mask = 2;
            int i2 = 0;
            while (i2 < this.items.length) {
                TabItem item2 = this.items[i2];
                if (item2 == null) break;
                Image image = item2.image;
                if (image != null) {
                    tcItem.iImage = this.imageIndex(image);
                    OS.SendMessage(this.handle, 4925, (long)i2, tcItem);
                }
                ++i2;
            }
        }
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle() | 0x2000000;
        if ((this.style & 0x80000) != 0) {
            bits |= 0x8000;
        }
        if ((this.style & 0x400) != 0) {
            bits |= 2;
        }
        return bits | 0x4000;
    }

    @Override
    TCHAR windowClass() {
        return TabFolderClass;
    }

    @Override
    long windowProc() {
        return TabFolderProc;
    }

    @Override
    LRESULT WM_GETDLGCODE(long wParam, long lParam) {
        LRESULT result2 = super.WM_GETDLGCODE(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        return new LRESULT(8193L);
    }

    @Override
    LRESULT WM_GETOBJECT(long wParam, long lParam) {
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    @Override
    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        LRESULT result2 = super.WM_KEYDOWN(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        switch ((int)wParam) {
            case 37: 
            case 39: {
                boolean isRTL;
                boolean bl = isRTL = (this.style & 0x4000000) != 0;
                if (isRTL == this.createdAsRTL) break;
                long code = this.callWindowProc(this.handle, 256, wParam == 39L ? 37 : 39, lParam);
                return new LRESULT(code);
            }
        }
        return result2;
    }

    @Override
    LRESULT WM_MOUSELEAVE(long wParam, long lParam) {
        LRESULT result2 = super.WM_MOUSELEAVE(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        TOOLINFO lpti = new TOOLINFO();
        lpti.cbSize = TOOLINFO.sizeof;
        long hwndToolTip = OS.SendMessage(this.handle, 4909, 0L, 0L);
        if (OS.SendMessage(hwndToolTip, 1083, 0L, lpti) != 0L && (lpti.uFlags & 1) == 0) {
            OS.SendMessage(hwndToolTip, 1075, 0L, lpti);
            OS.SendMessage(hwndToolTip, 1074, 0L, lpti);
        }
        return result2;
    }

    @Override
    LRESULT WM_NCHITTEST(long wParam, long lParam) {
        LRESULT result2 = super.WM_NCHITTEST(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        long hittest = OS.DefWindowProc(this.handle, 132, wParam, lParam);
        return new LRESULT(hittest);
    }

    @Override
    LRESULT WM_NOTIFY(long wParam, long lParam) {
        LRESULT result2 = super.WM_NOTIFY(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PARENTNOTIFY(long wParam, long lParam) {
        LRESULT result2 = super.WM_PARENTNOTIFY(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        if ((this.style & 0x4000000) != 0) {
            int code = OS.LOWORD(wParam);
            switch (code) {
                case 1: {
                    int id = OS.HIWORD(wParam);
                    long hwnd = lParam;
                    if (id != 1) break;
                    int bits = OS.GetWindowLong(hwnd, -20);
                    OS.SetWindowLong(hwnd, -20, bits | 0x400000);
                }
            }
        }
        return result2;
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        LRESULT result2 = super.WM_SIZE(wParam, lParam);
        if (this.isDisposed()) {
            return result2;
        }
        int index = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (index != -1) {
            TabItem item2 = this.items[index];
            Control control = item2.control;
            if (control != null && !control.isDisposed()) {
                control.setBoundsInPixels(this.getClientAreaInPixels());
            }
        }
        return result2;
    }

    @Override
    LRESULT WM_WINDOWPOSCHANGING(long wParam, long lParam) {
        LRESULT result2 = super.WM_WINDOWPOSCHANGING(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return result2;
        }
        WINDOWPOS lpwp = new WINDOWPOS();
        OS.MoveMemory(lpwp, lParam, WINDOWPOS.sizeof);
        if ((lpwp.flags & 9) != 0) {
            return result2;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0x200) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return result2;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, lpwp.cx, lpwp.cy);
        OS.SendMessage(this.handle, 131, 0L, rect);
        int newWidth = rect.right - rect.left;
        int newHeight = rect.bottom - rect.top;
        OS.GetClientRect(this.handle, rect);
        int oldWidth = rect.right - rect.left;
        int oldHeight = rect.bottom - rect.top;
        if (newWidth == oldWidth && newHeight == oldHeight) {
            return result2;
        }
        RECT inset = new RECT();
        OS.SendMessage(this.handle, 4904, 0L, inset);
        int marginX = -inset.right;
        int marginY = -inset.bottom;
        if (newWidth != oldWidth) {
            int left2 = oldWidth;
            if (newWidth < oldWidth) {
                left2 = newWidth;
            }
            OS.SetRect(rect, left2 - marginX, 0, newWidth, newHeight);
            OS.InvalidateRect(this.handle, rect, true);
        }
        if (newHeight != oldHeight) {
            int bottom2 = oldHeight;
            if (newHeight < oldHeight) {
                bottom2 = newHeight;
            }
            if (newWidth < oldWidth) {
                oldWidth -= marginX;
            }
            OS.SetRect(rect, 0, bottom2 - marginY, oldWidth, newHeight);
            OS.InvalidateRect(this.handle, rect, true);
        }
        return result2;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        int code = hdr.code;
        switch (code) {
            case -552: 
            case -551: {
                Control control;
                TabItem item2 = null;
                int index = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
                if (index != -1) {
                    item2 = this.items[index];
                }
                if (item2 != null && (control = item2.control) != null && !control.isDisposed()) {
                    if (code == -551) {
                        control.setBoundsInPixels(this.getClientAreaInPixels());
                    }
                    control.setVisible(code == -551);
                }
                if (code != -551) break;
                Event event = new Event();
                event.item = item2;
                this.sendSelectionEvent(13, event, false);
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }
}

