/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.win32.LITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLINK;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    int linkForeground = -1;
    String[] ids;
    char[] mnemonics;
    static final long LinkProc;
    static final TCHAR LinkClass;

    static {
        LinkClass = new TCHAR(0, "SysLink", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, LinkClass, lpWndClass);
        LinkProc = lpWndClass.lpfnWndProc;
        lpWndClass.hInstance = OS.GetModuleHandle(null);
        lpWndClass.style &= 0xFFFFBFFF;
        lpWndClass.style |= 8;
        OS.RegisterClass(LinkClass, lpWndClass);
    }

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        switch (msg) {
            case 15: {
                if (wParam == 0L) break;
                OS.SendMessage(hwnd, 792, wParam, 0L);
                return 0L;
            }
        }
        return OS.CallWindowProc(LinkProc, hwnd, msg, wParam, lParam);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed2) {
        int height;
        int width;
        this.checkWidget();
        if (this.text.isEmpty()) {
            long hDC = OS.GetDC(this.handle);
            long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            long oldFont = OS.SelectObject(hDC, newFont);
            TEXTMETRIC lptm = new TEXTMETRIC();
            OS.GetTextMetrics(hDC, lptm);
            width = 0;
            height = lptm.tmHeight;
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        } else {
            SIZE size = new SIZE();
            int maxWidth = wHint == -1 ? Integer.MAX_VALUE : wHint;
            OS.SendMessage(this.handle, 1793, (long)maxWidth, size);
            width = size.cx;
            height = size.cy;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidthInPixels();
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.text = "";
        this.ids = new String[0];
        this.mnemonics = new char[0];
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        OS.InvalidateRect(this.handle, null, true);
    }

    int getFocusItem() {
        LITEM item2 = new LITEM();
        item2.mask = 3;
        item2.stateMask = 1;
        while (OS.SendMessage(this.handle, 1795, 0L, item2) != 0L) {
            if ((item2.state & 1) != 0) {
                return item2.iLink;
            }
            ++item2.iLink;
        }
        return -1;
    }

    public Color getLinkForeground() {
        this.checkWidget();
        if (this.linkForeground != -1) {
            return Color.win32_new(this.display, this.linkForeground);
        }
        return Color.win32_new(this.display, OS.GetSysColor(26));
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    boolean mnemonicHit(char key2) {
        char uckey = Character.toUpperCase(key2);
        int i2 = 0;
        while (i2 < this.mnemonics.length) {
            if (uckey == this.mnemonics[i2]) {
                return this.setFocus() && this.setFocusItem(i2);
            }
            ++i2;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key2) {
        char uckey = Character.toUpperCase(key2);
        int i2 = 0;
        while (i2 < this.mnemonics.length) {
            if (uckey == this.mnemonics[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    void parse(String string2) {
        int length = string2.length();
        this.ids = new String[length / 7];
        this.mnemonics = new char[length / 7];
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int linkStart = 0;
        int linkEnd = 0;
        int refStart = 0;
        int refEnd = 0;
        char mnemonic = '\u0000';
        while (index < length) {
            char c2 = Character.toLowerCase(string2.charAt(index));
            block0 : switch (state) {
                case 0: {
                    if (c2 == '<') {
                        ++state;
                        break;
                    }
                    if (c2 != '&') break;
                    state = 16;
                    break;
                }
                case 1: {
                    if (c2 != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c2) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c2)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c2 != '<') break;
                    linkEnd = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c2 == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c2 == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c2 == '>') {
                        if (refStart == 0) {
                            refStart = linkStart;
                            refEnd = linkEnd;
                        }
                        this.ids[linkIndex] = string2.substring(refStart, refEnd);
                        if (mnemonic != '\u0000') {
                            this.mnemonics[linkIndex] = mnemonic;
                        }
                        ++linkIndex;
                        mnemonic = '\u0000';
                        refEnd = '\u0000';
                        refStart = '\u0000';
                        linkEnd = '\u0000';
                        linkStart = '\u0000';
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c2 == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c2 == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c2 == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c2 == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c2 == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c2 != '\"') break;
                    refEnd = index;
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c2)) {
                        state = 0;
                        break;
                    }
                    if (c2 != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c2 == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c2 != '\"') break;
                    state = 2;
                    break;
                }
                case 16: {
                    if (c2 == '<') {
                        state = 1;
                        break;
                    }
                    state = 0;
                    if (c2 == '&') break;
                    mnemonic = Character.toUpperCase(c2);
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        this.ids = Arrays.copyOf(this.ids, linkIndex);
        this.mnemonics = Arrays.copyOf(this.mnemonics, linkIndex);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    boolean setFocusItem(int index) {
        int bits = OS.GetWindowLong(this.handle, -16);
        LITEM item2 = new LITEM();
        item2.mask = 3;
        item2.stateMask = 1;
        while (item2.iLink < this.ids.length) {
            if (item2.iLink != index) {
                OS.SendMessage(this.handle, 1794, 0L, item2);
            }
            ++item2.iLink;
        }
        item2.iLink = index;
        item2.state = 1;
        long result2 = OS.SendMessage(this.handle, 1794, 0L, item2);
        OS.SetWindowLong(this.handle, -16, bits);
        return result2 != 0L;
    }

    public void setLinkForeground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.linkForeground) {
            return;
        }
        this.linkForeground = pixel;
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setText(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        if (string2.equals(this.text)) {
            return;
        }
        this.text = string2;
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string2, true);
        OS.SetWindowText(this.handle, buffer);
        this.parse(string2);
    }

    @Override
    int resolveTextDirection() {
        return BidiUtil.resolveTextDirection(this.text);
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        if (super.updateTextDirection(textDirection)) {
            int flags = 0x6000000;
            this.style &= 0xF7FFFFFF;
            this.style &= ~flags;
            this.style |= textDirection & flags;
            this.updateOrientation();
            this.checkMirrored();
            return true;
        }
        return false;
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle();
        return bits | 0x10000;
    }

    @Override
    TCHAR windowClass() {
        return LinkClass;
    }

    @Override
    long windowProc() {
        return LinkProc;
    }

    @Override
    LRESULT WM_CHAR(long wParam, long lParam) {
        LRESULT result2 = super.WM_CHAR(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        switch ((int)wParam) {
            case 9: 
            case 13: 
            case 32: {
                long code = this.callWindowProc(this.handle, 256, wParam, lParam);
                return new LRESULT(code);
            }
        }
        return result2;
    }

    @Override
    LRESULT WM_GETDLGCODE(long wParam, long lParam) {
        long code = this.callWindowProc(this.handle, 135, wParam, lParam);
        int count = this.ids.length;
        if (count == 0) {
            code |= 0x100L;
        } else if (count > 1) {
            int limit;
            int n2 = limit = OS.GetKeyState(16) < 0 ? 0 : count - 1;
            if (this.getFocusItem() != limit) {
                code |= 2L;
            }
        }
        return new LRESULT(code);
    }

    @Override
    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        LRESULT result2 = super.WM_KEYDOWN(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        switch ((int)wParam) {
            case 9: 
            case 13: 
            case 32: {
                return LRESULT.ZERO;
            }
        }
        return result2;
    }

    @Override
    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        int focusItem = this.getFocusItem();
        LRESULT result2 = super.WM_KILLFOCUS(wParam, lParam);
        if (focusItem != -1) {
            this.setFocusItem(focusItem);
        }
        return result2;
    }

    @Override
    LRESULT WM_NCHITTEST(long wParam, long lParam) {
        LRESULT result2 = super.WM_NCHITTEST(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        return new LRESULT(1L);
    }

    @Override
    LRESULT WM_SETCURSOR(long wParam, long lParam) {
        LRESULT result2 = super.WM_SETCURSOR(wParam, lParam);
        if (result2 != null) {
            return result2;
        }
        long fDone = this.callWindowProc(this.handle, 32, wParam, lParam);
        if (fDone == 0L) {
            OS.DefWindowProc(this.handle, 32, wParam, lParam);
        }
        return LRESULT.ONE;
    }

    @Override
    LRESULT WM_SETFOCUS(long wParam, long lParam) {
        if (this.ids.length > 1 && OS.GetKeyState(9) < 0) {
            boolean shift = OS.GetKeyState(16) < 0;
            this.setFocusItem(shift ? this.ids.length - 1 : 0);
        }
        return super.WM_SETFOCUS(wParam, lParam);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        block0 : switch (hdr.code) {
            case -4: 
            case -2: {
                NMLINK item2 = new NMLINK();
                OS.MoveMemory(item2, lParam, NMLINK.sizeof);
                Event event = new Event();
                event.text = this.ids[item2.iLink];
                this.sendSelectionEvent(13, event, true);
                return super.wmNotifyChild(hdr, wParam, lParam);
            }
            case -12: {
                NMCUSTOMDRAW nmcd = new NMCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        if (OS.IsWindowEnabled(this.handle) && this.linkForeground == -1) return super.wmNotifyChild(hdr, wParam, lParam);
                        return new LRESULT(32L);
                    }
                    case 65537: {
                        if (!OS.IsWindowEnabled(this.handle)) {
                            OS.SetTextColor(nmcd.hdc, OS.GetSysColor(17));
                            break block0;
                        }
                        if (this.linkForeground == -1 || nmcd.dwItemSpec == -1L) return super.wmNotifyChild(hdr, wParam, lParam);
                        OS.SetTextColor(nmcd.hdc, this.linkForeground);
                    }
                }
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }
}

